/*M!999999\- enable the sandbox mode */ 

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_acc_trans_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_acc_trans_mappings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `ref_no` varchar(100) NOT NULL,
  `type` varchar(100) NOT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_acc_trans_mappings` WRITE;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` DISABLE KEYS */;
INSERT INTO `accounting_acc_trans_mappings` VALUES (1,8,'#1545454454','transfer',13,'2025-02-25 22:10:00',NULL,'2025-02-25 16:40:26','2025-02-25 16:40:26');
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_account_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_type` varchar(191) DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `show_balance` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=155 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_account_types` WRITE;
/*!40000 ALTER TABLE `accounting_account_types` DISABLE KEYS */;
INSERT INTO `accounting_account_types` VALUES (1,'accounts_receivable',NULL,NULL,'asset','sub_type',NULL,NULL,0,NULL,NULL),(2,'current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(3,'cash_and_cash_equivalents',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(4,'fixed_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(5,'non_current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(6,'accounts_payable',NULL,NULL,'liability','sub_type',NULL,NULL,0,NULL,NULL),(7,'credit_card',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),(8,'current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),(9,'non_current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),(10,'owners_equity',NULL,NULL,'equity','sub_type',NULL,NULL,1,NULL,NULL),(11,'income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),(12,'other_income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),(13,'cost_of_sale',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),(14,'expenses',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),(15,'other_expense',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),(16,'accounts_receivable',NULL,NULL,NULL,'detail_type',1,'',1,NULL,NULL),(17,'allowance_for_bad_debts',NULL,NULL,NULL,'detail_type',2,'allowance_for_bad_debts_desc',1,NULL,NULL),(18,'assets_available_for_sale',NULL,NULL,NULL,'detail_type',2,'assets_available_for_sale_desc',1,NULL,NULL),(19,'development_costs',NULL,NULL,NULL,'detail_type',2,'development_costs_desc',1,NULL,NULL),(20,'employee_cash_advances',NULL,NULL,NULL,'detail_type',2,'employee_cash_advances_desc',1,NULL,NULL),(21,'inventory',NULL,NULL,NULL,'detail_type',2,'inventory_desc',1,NULL,NULL),(22,'investments_-_other',NULL,NULL,NULL,'detail_type',2,'investments_-_other_desc',1,NULL,NULL),(23,'loans_to_officers',NULL,NULL,NULL,'detail_type',2,'loans_to_officers_desc',1,NULL,NULL),(24,'loans_to_others',NULL,NULL,NULL,'detail_type',2,'loans_to_others_desc',1,NULL,NULL),(25,'loans_to_shareholders',NULL,NULL,NULL,'detail_type',2,'loans_to_shareholders_desc',1,NULL,NULL),(26,'other_current_assets',NULL,NULL,NULL,'detail_type',2,'other_current_assets_desc',1,NULL,NULL),(27,'prepaid_expenses',NULL,NULL,NULL,'detail_type',2,'prepaid_expenses_desc',1,NULL,NULL),(28,'retainage',NULL,NULL,NULL,'detail_type',2,'retainage_desc',1,NULL,NULL),(29,'undeposited_funds',NULL,NULL,NULL,'detail_type',2,'undeposited_funds_desc',1,NULL,NULL),(30,'bank',NULL,NULL,NULL,'detail_type',3,'bank_desc',1,NULL,NULL),(31,'cash_and_cash_equivalents',NULL,NULL,NULL,'detail_type',3,'cash_and_cash_equivalents_desc',1,NULL,NULL),(32,'cash_on_hand',NULL,NULL,NULL,'detail_type',3,'cash_on_hand_desc',1,NULL,NULL),(33,'client_trust_account',NULL,NULL,NULL,'detail_type',3,'client_trust_account_desc',1,NULL,NULL),(34,'money_market',NULL,NULL,NULL,'detail_type',3,'money_market_desc',1,NULL,NULL),(35,'rents_held_in_trust',NULL,NULL,NULL,'detail_type',3,'rents_held_in_trust_desc',1,NULL,NULL),(36,'savings',NULL,NULL,NULL,'detail_type',3,'savings_desc',1,NULL,NULL),(37,'accumulated_depletion',NULL,NULL,NULL,'detail_type',4,'accumulated_depletion_desc',1,NULL,NULL),(38,'accumulated_depreciation_on_property,_plant_and_equipment',NULL,NULL,NULL,'detail_type',4,'accumulated_depreciation_on_property,_plant_and_equipment_desc',1,NULL,NULL),(39,'buildings',NULL,NULL,NULL,'detail_type',4,'buildings_desc',1,NULL,NULL),(40,'depletable_assets',NULL,NULL,NULL,'detail_type',4,'depletable_assets_desc',1,NULL,NULL),(41,'furniture_and_fixtures',NULL,NULL,NULL,'detail_type',4,'furniture_and_fixtures_desc',1,NULL,NULL),(42,'land',NULL,NULL,NULL,'detail_type',4,'land_desc',1,NULL,NULL),(43,'leasehold_improvements',NULL,NULL,NULL,'detail_type',4,'leasehold_improvements_desc',1,NULL,NULL),(44,'machinery_and_equipment',NULL,NULL,NULL,'detail_type',4,'machinery_and_equipment_desc',1,NULL,NULL),(45,'other_fixed_assets',NULL,NULL,NULL,'detail_type',4,'other_fixed_assets_desc',1,NULL,NULL),(46,'vehicles',NULL,NULL,NULL,'detail_type',4,'vehicles_desc',1,NULL,NULL),(47,'accumulated_amortisation_of_non-current_assets',NULL,NULL,NULL,'detail_type',5,'accumulated_amortisation_of_non-current_assets_desc',1,NULL,NULL),(48,'assets_held_for_sale',NULL,NULL,NULL,'detail_type',5,'assets_held_for_sale_desc',1,NULL,NULL),(49,'deferred_tax',NULL,NULL,NULL,'detail_type',5,'deferred_tax_desc',1,NULL,NULL),(50,'goodwill',NULL,NULL,NULL,'detail_type',5,'goodwill_desc',1,NULL,NULL),(51,'intangible_assets',NULL,NULL,NULL,'detail_type',5,'intangible_assets_desc',1,NULL,NULL),(52,'lease_buyout',NULL,NULL,NULL,'detail_type',5,'lease_buyout_desc',1,NULL,NULL),(53,'licences',NULL,NULL,NULL,'detail_type',5,'licences_desc',1,NULL,NULL),(54,'long-term_investments',NULL,NULL,NULL,'detail_type',5,'long-term_investments_desc',1,NULL,NULL),(55,'organisational_costs',NULL,NULL,NULL,'detail_type',5,'organisational_costs_desc',1,NULL,NULL),(56,'other_non-current_assets',NULL,NULL,NULL,'detail_type',5,'other_non-current_assets_desc',1,NULL,NULL),(57,'security_deposits',NULL,NULL,NULL,'detail_type',5,'security_deposits_desc',1,NULL,NULL),(58,'accounts_payable_(a/p)',NULL,NULL,NULL,'detail_type',6,'accounts_payable_(a/p)_desc',1,NULL,NULL),(59,'credit_card',NULL,NULL,NULL,'detail_type',7,'credit_card_desc',1,NULL,NULL),(60,'accrued_liabilities',NULL,NULL,NULL,'detail_type',8,'accrued_liabilities_desc',1,NULL,NULL),(61,'client_trust_accounts_-_liabilities',NULL,NULL,NULL,'detail_type',8,'client_trust_accounts_-_liabilities_desc',1,NULL,NULL),(62,'current_tax_liability',NULL,NULL,NULL,'detail_type',8,'current_tax_liability_desc',1,NULL,NULL),(63,'current_portion_of_obligations_under_finance_leases',NULL,NULL,NULL,'detail_type',8,'current_portion_of_obligations_under_finance_leases_desc',1,NULL,NULL),(64,'dividends_payable',NULL,NULL,NULL,'detail_type',8,'dividends_payable_desc',1,NULL,NULL),(65,'income_tax_payable',NULL,NULL,NULL,'detail_type',8,'income_tax_payable_desc',1,NULL,NULL),(66,'insurance_payable',NULL,NULL,NULL,'detail_type',8,'insurance_payable_desc',1,NULL,NULL),(67,'line_of_credit',NULL,NULL,NULL,'detail_type',8,'line_of_credit_desc',1,NULL,NULL),(68,'loan_payable',NULL,NULL,NULL,'detail_type',8,'loan_payable_desc',1,NULL,NULL),(69,'other_current_liabilities',NULL,NULL,NULL,'detail_type',8,'other_current_liabilities_desc',1,NULL,NULL),(70,'payroll_clearing',NULL,NULL,NULL,'detail_type',8,'payroll_clearing_desc',1,NULL,NULL),(71,'payroll_liabilities',NULL,NULL,NULL,'detail_type',8,'payroll_liabilities_desc',1,NULL,NULL),(72,'prepaid_expenses_payable',NULL,NULL,NULL,'detail_type',8,'prepaid_expenses_payable_desc',1,NULL,NULL),(73,'rents_in_trust_-_liability',NULL,NULL,NULL,'detail_type',8,'rents_in_trust_-_liability_desc',1,NULL,NULL),(74,'sales_and_service_tax_payable',NULL,NULL,NULL,'detail_type',8,'sales_and_service_tax_payable_desc',1,NULL,NULL),(75,'accrued_holiday_payable',NULL,NULL,NULL,'detail_type',9,'accrued_holiday_payable_desc',1,NULL,NULL),(76,'accrued_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'accrued_non-current_liabilities_desc',1,NULL,NULL),(77,'liabilities_related_to_assets_held_for_sale',NULL,NULL,NULL,'detail_type',9,'liabilities_related_to_assets_held_for_sale_desc',1,NULL,NULL),(78,'long-term_debt',NULL,NULL,NULL,'detail_type',9,'long-term_debt_desc',1,NULL,NULL),(79,'notes_payable',NULL,NULL,NULL,'detail_type',9,'notes_payable_desc',1,NULL,NULL),(80,'other_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'other_non-current_liabilities_desc',1,NULL,NULL),(81,'shareholder_notes_payable',NULL,NULL,NULL,'detail_type',9,'shareholder_notes_payable_desc',1,NULL,NULL),(82,'accumulated_adjustment',NULL,NULL,NULL,'detail_type',10,'accumulated_adjustment_desc',1,NULL,NULL),(83,'dividend_disbursed',NULL,NULL,NULL,'detail_type',10,'dividend_disbursed_desc',1,NULL,NULL),(84,'equity_in_earnings_of_subsidiaries',NULL,NULL,NULL,'detail_type',10,'equity_in_earnings_of_subsidiaries_desc',1,NULL,NULL),(85,'opening_balance_equity',NULL,NULL,NULL,'detail_type',10,'opening_balance_equity_desc',1,NULL,NULL),(86,'ordinary_shares',NULL,NULL,NULL,'detail_type',10,'ordinary_shares_desc',1,NULL,NULL),(87,'other_comprehensive_income',NULL,NULL,NULL,'detail_type',10,'other_comprehensive_income_desc',1,NULL,NULL),(88,'owner\'s_equity',NULL,NULL,NULL,'detail_type',10,'owner\'s_equity_desc',1,NULL,NULL),(89,'paid-in_capital_or_surplus',NULL,NULL,NULL,'detail_type',10,'paid-in_capital_or_surplus_desc',1,NULL,NULL),(90,'partner_contributions',NULL,NULL,NULL,'detail_type',10,'partner_contributions_desc',1,NULL,NULL),(91,'partner_distributions',NULL,NULL,NULL,'detail_type',10,'partner_distributions_desc',1,NULL,NULL),(92,'partner\'s_equity',NULL,NULL,NULL,'detail_type',10,'partner\'s_equity_desc',1,NULL,NULL),(93,'preferred_shares',NULL,NULL,NULL,'detail_type',10,'preferred_shares_desc',1,NULL,NULL),(94,'retained_earnings',NULL,NULL,NULL,'detail_type',10,'retained_earnings_desc',1,NULL,NULL),(95,'share_capital',NULL,NULL,NULL,'detail_type',10,'share_capital_desc',1,NULL,NULL),(96,'treasury_shares',NULL,NULL,NULL,'detail_type',10,'treasury_shares_desc',1,NULL,NULL),(97,'discounts/refunds_given',NULL,NULL,NULL,'detail_type',11,'discounts/refunds_given_desc',1,NULL,NULL),(98,'non-profit_income',NULL,NULL,NULL,'detail_type',11,'non-profit_income_desc',1,NULL,NULL),(99,'other_primary_income',NULL,NULL,NULL,'detail_type',11,'other_primary_income_desc',1,NULL,NULL),(100,'revenue_-_general',NULL,NULL,NULL,'detail_type',11,'revenue_-_general_desc',1,NULL,NULL),(101,'sales_-_retail',NULL,NULL,NULL,'detail_type',11,'sales_-_retail_desc',1,NULL,NULL),(102,'sales_-_wholesale',NULL,NULL,NULL,'detail_type',11,'sales_-_wholesale_desc',1,NULL,NULL),(103,'sales_of_product_income',NULL,NULL,NULL,'detail_type',11,'sales_of_product_income_desc',1,NULL,NULL),(104,'service/fee_income',NULL,NULL,NULL,'detail_type',11,'service/fee_income_desc',1,NULL,NULL),(105,'unapplied_cash_payment_income',NULL,NULL,NULL,'detail_type',11,'unapplied_cash_payment_income_desc',1,NULL,NULL),(106,'dividend_income',NULL,NULL,NULL,'detail_type',12,'dividend_income_desc',1,NULL,NULL),(107,'interest_earned',NULL,NULL,NULL,'detail_type',12,'interest_earned_desc',1,NULL,NULL),(108,'loss_on_disposal_of_assets',NULL,NULL,NULL,'detail_type',12,'loss_on_disposal_of_assets_desc',1,NULL,NULL),(109,'other_investment_income',NULL,NULL,NULL,'detail_type',12,'other_investment_income_desc',1,NULL,NULL),(110,'other_miscellaneous_income',NULL,NULL,NULL,'detail_type',12,'other_miscellaneous_income_desc',1,NULL,NULL),(111,'other_operating_income',NULL,NULL,NULL,'detail_type',12,'other_operating_income_desc',1,NULL,NULL),(112,'tax-exempt_interest',NULL,NULL,NULL,'detail_type',12,'tax-exempt_interest_desc',1,NULL,NULL),(113,'unrealised_loss_on_securities,_net_of_tax',NULL,NULL,NULL,'detail_type',12,'unrealised_loss_on_securities,_net_of_tax_desc',1,NULL,NULL),(114,'cost_of_labour_-_cos',NULL,NULL,NULL,'detail_type',13,'cost_of_labour_-_cos_desc',1,NULL,NULL),(115,'equipment_rental_-_cos',NULL,NULL,NULL,'detail_type',13,'equipment_rental_-_cos_desc',1,NULL,NULL),(116,'freight_and_delivery_-_cos',NULL,NULL,NULL,'detail_type',13,'freight_and_delivery_-_cos_desc',1,NULL,NULL),(117,'other_costs_of_sales_-_cos',NULL,NULL,NULL,'detail_type',13,'other_costs_of_sales_-_cos_desc',1,NULL,NULL),(118,'supplies_and_materials_-_cos',NULL,NULL,NULL,'detail_type',13,'supplies_and_materials_-_cos_desc',1,NULL,NULL),(119,'advertising/promotional',NULL,NULL,NULL,'detail_type',14,'advertising/promotional_desc',1,NULL,NULL),(120,'amortisation_expense',NULL,NULL,NULL,'detail_type',14,'amortisation_expense_desc',1,NULL,NULL),(121,'auto',NULL,NULL,NULL,'detail_type',14,'auto_desc',1,NULL,NULL),(122,'bad_debts',NULL,NULL,NULL,'detail_type',14,'bad_debts_desc',1,NULL,NULL),(123,'bank_charges',NULL,NULL,NULL,'detail_type',14,'bank_charges_desc',1,NULL,NULL),(124,'charitable_contributions',NULL,NULL,NULL,'detail_type',14,'charitable_contributions_desc',1,NULL,NULL),(125,'commissions_and_fees',NULL,NULL,NULL,'detail_type',14,'commissions_and_fees_desc',1,NULL,NULL),(126,'cost_of_labour',NULL,NULL,NULL,'detail_type',14,'cost_of_labour_desc',1,NULL,NULL),(127,'dues_and_subscriptions',NULL,NULL,NULL,'detail_type',14,'dues_and_subscriptions_desc',1,NULL,NULL),(128,'equipment_rental',NULL,NULL,NULL,'detail_type',14,'equipment_rental_desc',1,NULL,NULL),(129,'finance_costs',NULL,NULL,NULL,'detail_type',14,'finance_costs_desc',1,NULL,NULL),(130,'income_tax_expense',NULL,NULL,NULL,'detail_type',14,'income_tax_expense_desc',1,NULL,NULL),(131,'insurance',NULL,NULL,NULL,'detail_type',14,'insurance_desc',1,NULL,NULL),(132,'interest_paid',NULL,NULL,NULL,'detail_type',14,'interest_paid_desc',1,NULL,NULL),(133,'legal_and_professional_fees',NULL,NULL,NULL,'detail_type',14,'legal_and_professional_fees_desc',1,NULL,NULL),(134,'loss_on_discontinued_operations,_net_of_tax',NULL,NULL,NULL,'detail_type',14,'loss_on_discontinued_operations,_net_of_tax_desc',1,NULL,NULL),(135,'management_compensation',NULL,NULL,NULL,'detail_type',14,'management_compensation_desc',1,NULL,NULL),(136,'meals_and_entertainment',NULL,NULL,NULL,'detail_type',14,'meals_and_entertainment_desc',1,NULL,NULL),(137,'office/general_administrative_expenses',NULL,NULL,NULL,'detail_type',14,'office/general_administrative_expenses_desc',1,NULL,NULL),(138,'other_miscellaneous_service_cost',NULL,NULL,NULL,'detail_type',14,'other_miscellaneous_service_cost_desc',1,NULL,NULL),(139,'other_selling_expenses',NULL,NULL,NULL,'detail_type',14,'other_selling_expenses_desc',1,NULL,NULL),(140,'payroll_expenses',NULL,NULL,NULL,'detail_type',14,'payroll_expenses_desc',1,NULL,NULL),(141,'rent_or_lease_of_buildings',NULL,NULL,NULL,'detail_type',14,'rent_or_lease_of_buildings_desc',1,NULL,NULL),(142,'repair_and_maintenance',NULL,NULL,NULL,'detail_type',14,'repair_and_maintenance_desc',1,NULL,NULL),(143,'shipping_and_delivery_expense',NULL,NULL,NULL,'detail_type',14,'shipping_and_delivery_expense_desc',1,NULL,NULL),(144,'supplies_and_materials',NULL,NULL,NULL,'detail_type',14,'supplies_and_materials_desc',1,NULL,NULL),(145,'taxes_paid',NULL,NULL,NULL,'detail_type',14,'taxes_paid_desc',1,NULL,NULL),(146,'travel_expenses_-_general_and_admin_expenses',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_general_and_admin_expenses_desc',1,NULL,NULL),(147,'travel_expenses_-_selling_expense',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_selling_expense_desc',1,NULL,NULL),(148,'unapplied_cash_bill_payment_expense',NULL,NULL,NULL,'detail_type',14,'unapplied_cash_bill_payment_expense_desc',1,NULL,NULL),(149,'utilities',NULL,NULL,NULL,'detail_type',14,'utilities_desc',1,NULL,NULL),(150,'amortisation',NULL,NULL,NULL,'detail_type',15,'amortisation_desc',1,NULL,NULL),(151,'depreciation',NULL,NULL,NULL,'detail_type',15,'depreciation_desc',1,NULL,NULL),(152,'exchange_gain_or_loss',NULL,NULL,NULL,'detail_type',15,'exchange_gain_or_loss_desc',1,NULL,NULL),(153,'other_expense',NULL,NULL,NULL,'detail_type',15,'other_expense_desc',1,NULL,NULL),(154,'penalties_and_settlements',NULL,NULL,NULL,'detail_type',15,'penalties_and_settlements_desc',1,NULL,NULL);
/*!40000 ALTER TABLE `accounting_account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_accounts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `gl_code` varchar(191) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `account_primary_type` varchar(191) DEFAULT NULL,
  `account_sub_type_id` bigint(20) DEFAULT NULL,
  `detail_type_id` bigint(20) DEFAULT NULL,
  `parent_account_id` bigint(20) DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts` WRITE;
/*!40000 ALTER TABLE `accounting_accounts` DISABLE KEYS */;
INSERT INTO `accounting_accounts` VALUES (1,'Accounts Payable (A/P)',NULL,8,'liability',6,58,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(2,'Credit Card',NULL,8,'liability',7,59,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(3,'Wage expenses',NULL,8,'expenses',14,140,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(4,'Utilities',NULL,8,'expenses',14,149,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(5,'Unrealised loss on securities, net of tax',NULL,8,'income',12,113,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(6,'Undeposited Funds',NULL,8,'asset',2,29,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(7,'Uncategorised Income',NULL,8,'income',11,103,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(8,'Uncategorised Expense',NULL,8,'expenses',14,138,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(9,'Uncategorised Asset',NULL,8,'asset',2,26,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(10,'Unapplied Cash Payment Income',NULL,8,'income',11,105,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(11,'Travel expenses - selling expense',NULL,8,'expenses',14,147,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(12,'Travel expenses - general and admin expenses',NULL,8,'expenses',14,146,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(13,'Supplies',NULL,8,'expenses',14,145,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(14,'Subcontractors - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(15,'Stationery and printing',NULL,8,'expenses',14,137,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(16,'Short-term debit',NULL,8,'liability',8,69,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(17,'Shipping and delivery expense',NULL,8,'expenses',14,143,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(18,'Share capital',NULL,8,'equity',10,95,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(19,'Sales of Product Income',NULL,8,'income',11,103,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(20,'Sales - wholesale',NULL,8,'income',11,102,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(21,'Sales - retail',NULL,8,'income',11,101,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(22,'Sales',NULL,8,'income',11,103,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(23,'Revenue - General',NULL,8,'income',11,100,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(24,'Retained Earnings',NULL,8,'equity',10,94,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(25,'Repair and maintenance',NULL,8,'expenses',14,142,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(26,'Rent or lease payments',NULL,8,'expenses',14,141,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(27,'Reconciliation Discrepancies',NULL,8,'expenses',15,153,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(28,'Purchases',NULL,8,'expenses',14,144,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(29,'Property, plant and equipment',NULL,8,'asset',4,42,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(30,'Prepaid Expenses',NULL,8,'asset',2,27,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(31,'Payroll liabilities',NULL,8,'liability',8,71,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(32,'Payroll Expenses',NULL,8,'expenses',14,140,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(33,'Payroll Clearing',NULL,8,'liability',8,70,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(34,'Overhead - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(35,'Other Types of Expenses-Advertising Expenses',NULL,8,'expenses',14,119,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(36,'Other selling expenses',NULL,8,'expenses',14,139,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(37,'Other operating income (expenses)',NULL,8,'income',12,111,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(38,'Other general and administrative expenses',NULL,8,'expenses',14,137,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(39,'Other comprehensive income',NULL,8,'equity',10,87,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(40,'Other - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(41,'Office expenses',NULL,8,'expenses',14,137,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(42,'Meals and entertainment',NULL,8,'expenses',14,137,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(43,'Materials - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(44,'Management compensation',NULL,8,'expenses',14,135,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(45,'Loss on disposal of assets',NULL,8,'income',12,108,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(46,'Loss on discontinued operations, net of tax',NULL,8,'expenses',14,134,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(47,'Long-term investments',NULL,8,'asset',5,54,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(48,'Long-term debt',NULL,8,'liability',9,78,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(49,'Liabilities related to assets held for sale',NULL,8,'liability',9,77,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(50,'Legal and professional fees',NULL,8,'expenses',14,133,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(51,'Inventory Asset',NULL,8,'asset',2,21,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(52,'Inventory',NULL,8,'asset',2,21,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(53,'Interest income',NULL,8,'income',12,107,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(54,'Interest expense',NULL,8,'expenses',14,132,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(55,'Intangibles',NULL,8,'asset',5,51,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(56,'Insurance - Liability',NULL,8,'expenses',14,131,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(57,'Insurance - General',NULL,8,'expenses',14,131,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(58,'Insurance - Disability',NULL,8,'expenses',14,131,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(59,'Income tax payable',NULL,8,'liability',8,65,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(60,'Income tax expense',NULL,8,'expenses',14,130,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(61,'Goodwill',NULL,8,'asset',5,50,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(62,'Freight and delivery - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(63,'Equity in earnings of subsidiaries',NULL,8,'equity',10,84,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(64,'Equipment rental',NULL,8,'expenses',14,128,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(65,'Dues and Subscriptions',NULL,8,'expenses',14,127,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(66,'Dividends payable',NULL,8,'liability',8,64,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(67,'Dividend income',NULL,8,'income',12,106,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(68,'Dividend disbursed',NULL,8,'equity',10,83,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(69,'Discounts given - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(70,'Direct labour - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(71,'Deferred tax assets',NULL,8,'asset',5,49,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(72,'Cost of sales',NULL,8,'expenses',13,118,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(73,'Commissions and fees',NULL,8,'expenses',14,125,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(74,'Change in inventory - COS',NULL,8,'expenses',13,114,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(75,'Cash and cash equivalents',NULL,8,'asset',3,31,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(76,'Billable Expense Income',NULL,8,'income',11,103,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(77,'Bank charges',NULL,8,'expenses',14,123,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(78,'Bad debts',NULL,8,'expenses',14,122,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(79,'Available for sale assets (short-term)',NULL,8,'asset',2,18,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(80,'Assets held for sale',NULL,8,'asset',5,48,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(81,'Amortisation expense',NULL,8,'expenses',14,120,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(82,'Allowance for bad debts',NULL,8,'asset',2,17,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(83,'Accumulated depreciation on property, plant and equipment',NULL,8,'asset',4,38,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(84,'Accrued non-current liabilities',NULL,8,'liability',9,76,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(85,'Accrued liabilities',NULL,8,'liability',8,60,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(86,'Accrued holiday payable',NULL,8,'liability',9,75,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(87,'Accounts Receivable (A/R)',NULL,8,'asset',1,16,NULL,NULL,'active',13,'2025-02-25 16:22:30','2025-02-25 16:22:30'),(88,'SAMPATH BANK',NULL,8,'income',11,101,NULL,NULL,'active',13,'2025-02-25 16:38:21','2025-02-25 16:38:21');
/*!40000 ALTER TABLE `accounting_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_accounts_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `acc_trans_mapping_id` int(11) DEFAULT NULL COMMENT 'id form accounting_acc_trans_mapping table',
  `transaction_id` int(11) DEFAULT NULL COMMENT 'id form transactions table',
  `transaction_payment_id` int(11) DEFAULT NULL COMMENT 'id form transaction_payments table',
  `amount` decimal(22,4) NOT NULL,
  `type` varchar(100) NOT NULL COMMENT 'debit, credit etc',
  `sub_type` varchar(100) NOT NULL,
  `map_type` varchar(100) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounting_accounts_transactions` DISABLE KEYS */;
INSERT INTO `accounting_accounts_transactions` VALUES (1,88,1,NULL,NULL,10000.0000,'debit','transfer',NULL,13,'2025-02-25 22:10:00',NULL,'2025-02-25 16:40:26','2025-02-25 16:40:26'),(2,13,1,NULL,NULL,10000.0000,'credit','transfer',NULL,13,'2025-02-25 22:10:00',NULL,'2025-02-25 16:40:26','2025-02-25 16:40:26');
/*!40000 ALTER TABLE `accounting_accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_budgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_budgets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint(20) unsigned NOT NULL,
  `financial_year` int(11) NOT NULL,
  `jan` decimal(22,4) DEFAULT NULL,
  `feb` decimal(22,4) DEFAULT NULL,
  `mar` decimal(22,4) DEFAULT NULL,
  `apr` decimal(22,4) DEFAULT NULL,
  `may` decimal(22,4) DEFAULT NULL,
  `jun` decimal(22,4) DEFAULT NULL,
  `jul` decimal(22,4) DEFAULT NULL,
  `aug` decimal(22,4) DEFAULT NULL,
  `sep` decimal(22,4) DEFAULT NULL,
  `oct` decimal(22,4) DEFAULT NULL,
  `nov` decimal(22,4) DEFAULT NULL,
  `dec` decimal(22,4) DEFAULT NULL,
  `quarter_1` decimal(22,4) DEFAULT NULL,
  `quarter_2` decimal(22,4) DEFAULT NULL,
  `quarter_3` decimal(22,4) DEFAULT NULL,
  `quarter_4` decimal(22,4) DEFAULT NULL,
  `yearly` decimal(22,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_budgets` WRITE;
/*!40000 ALTER TABLE `accounting_budgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_budgets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `account_number` varchar(191) NOT NULL,
  `account_details` text DEFAULT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) DEFAULT NULL,
  `event` varchar(191) DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) DEFAULT NULL,
  `properties` text DEFAULT NULL,
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=499 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-29 10:46:56','2025-01-29 10:46:56'),(2,'default','added',2,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":180}}',NULL,'2025-01-29 10:55:41','2025-01-29 10:55:41'),(3,'default','added',3,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":580}}',NULL,'2025-01-29 11:00:27','2025-01-29 11:00:27'),(4,'default','added',4,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-01-29 11:03:26','2025-01-29 11:03:26'),(5,'default','added',5,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":720}}',NULL,'2025-01-29 11:11:57','2025-01-29 11:11:57'),(6,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-29 11:29:04','2025-01-29 11:29:04'),(7,'default','added',7,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1290}}',NULL,'2025-01-29 11:33:22','2025-01-29 11:33:22'),(8,'default','added',8,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":830}}',NULL,'2025-01-29 11:35:35','2025-01-29 11:35:35'),(9,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-01-31 14:40:13','2025-01-31 14:40:13'),(10,'default','edited',1,'App\\User',NULL,1,1,'App\\User','{\"name\":\"mr shop admin\"}',NULL,'2025-01-31 14:41:13','2025-01-31 14:41:13'),(11,'default','added',9,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2025-01-31 14:47:49','2025-01-31 14:47:49'),(12,'default','added',10,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":430}}',NULL,'2025-01-31 14:48:37','2025-01-31 14:48:37'),(13,'default','added',11,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":430}}',NULL,'2025-01-31 14:49:21','2025-01-31 14:49:21'),(14,'default','added',12,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":430}}',NULL,'2025-01-31 14:50:09','2025-01-31 14:50:09'),(15,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-02 14:41:47','2025-02-02 14:41:47'),(16,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-02 17:37:04','2025-02-02 17:37:04'),(17,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-02 17:37:24','2025-02-02 17:37:24'),(18,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-02 17:37:47','2025-02-02 17:37:47'),(19,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-02 17:40:05','2025-02-02 17:40:05'),(20,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-02 17:40:55','2025-02-02 17:40:55'),(21,'default','logout',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-02 17:42:30','2025-02-02 17:42:30'),(22,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-02 17:44:45','2025-02-02 17:44:45'),(23,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-02 17:57:46','2025-02-02 17:57:46'),(24,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-02 19:33:33','2025-02-02 19:33:33'),(25,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-02 22:25:53','2025-02-02 22:25:53'),(26,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-03 03:11:01','2025-02-03 03:11:01'),(27,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-03 03:24:02','2025-02-03 03:24:02'),(28,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-03 08:03:01','2025-02-03 08:03:01'),(29,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-03 08:32:52','2025-02-03 08:32:52'),(30,'default','added',4,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2025-02-03 08:59:47','2025-02-03 08:59:47'),(31,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-03 14:08:03','2025-02-03 14:08:03'),(32,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-03 14:08:31','2025-02-03 14:08:31'),(33,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-04 03:50:35','2025-02-04 03:50:35'),(34,'default','login',2,'App\\User',NULL,2,2,'App\\User','[]',NULL,'2025-02-04 12:17:54','2025-02-04 12:17:54'),(35,'default','added',5,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2025-02-04 12:24:06','2025-02-04 12:24:06'),(36,'default','payment_edited',14,'App\\Transaction',NULL,2,2,'App\\User','[]',NULL,'2025-02-04 12:25:31','2025-02-04 12:25:31'),(37,'default','added',6,'App\\Contact',NULL,2,2,'App\\User','[]',NULL,'2025-02-04 12:28:34','2025-02-04 12:28:34'),(38,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-05 13:03:59','2025-02-05 13:03:59'),(39,'default','added',4,'App\\User',NULL,3,3,'App\\User','{\"name\":\" ceo \"}',NULL,'2025-02-05 13:06:43','2025-02-05 13:06:43'),(40,'default','added',5,'App\\User',NULL,3,3,'App\\User','{\"name\":\" sumudu \"}',NULL,'2025-02-05 13:09:26','2025-02-05 13:09:26'),(41,'default','edited',3,'App\\User',NULL,3,3,'App\\User','{\"name\":\"demo demo a ccount\"}',NULL,'2025-02-05 13:10:00','2025-02-05 13:10:00'),(42,'default','login',4,'App\\User',NULL,3,4,'App\\User','[]',NULL,'2025-02-05 13:10:54','2025-02-05 13:10:54'),(43,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-05 14:28:53','2025-02-05 14:28:53'),(44,'default','added',15,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":430}}',NULL,'2025-02-05 15:13:45','2025-02-05 15:13:45'),(45,'default','added',17,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2025-02-05 15:18:52','2025-02-05 15:18:52'),(46,'default','login',4,'App\\User',NULL,3,4,'App\\User','[]',NULL,'2025-02-05 15:24:18','2025-02-05 15:24:18'),(47,'default','added',18,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":840}}',NULL,'2025-02-05 15:29:06','2025-02-05 15:29:06'),(48,'default','added',19,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":430}}',NULL,'2025-02-05 15:44:45','2025-02-05 15:44:45'),(49,'default','added',20,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":430}}',NULL,'2025-02-05 16:01:57','2025-02-05 16:01:57'),(50,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-06 02:55:56','2025-02-06 02:55:56'),(51,'default','login',4,'App\\User',NULL,3,4,'App\\User','[]',NULL,'2025-02-06 02:56:30','2025-02-06 02:56:30'),(52,'default','added',21,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":760}}',NULL,'2025-02-06 04:38:06','2025-02-06 04:38:06'),(53,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-06 08:22:13','2025-02-06 08:22:13'),(54,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-06 10:44:59','2025-02-06 10:44:59'),(55,'default','added',23,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":580}}',NULL,'2025-02-06 11:07:17','2025-02-06 11:07:17'),(56,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-07 05:37:42','2025-02-07 05:37:42'),(57,'default','added',122,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-02-07 06:08:38','2025-02-07 06:08:38'),(58,'default','added',123,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-02-07 06:10:11','2025-02-07 06:10:11'),(59,'default','added',124,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-02-07 06:11:07','2025-02-07 06:11:07'),(60,'default','added',125,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-02-07 06:12:52','2025-02-07 06:12:52'),(61,'default','added',126,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-02-07 06:13:16','2025-02-07 06:13:16'),(62,'default','added',127,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-02-07 06:13:58','2025-02-07 06:13:58'),(63,'default','added',128,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-02-07 06:14:08','2025-02-07 06:14:08'),(64,'default','added',129,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":980}}',NULL,'2025-02-07 06:18:36','2025-02-07 06:18:36'),(65,'default','added',130,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2025-02-07 07:59:05','2025-02-07 07:59:05'),(66,'default','added',131,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2025-02-07 09:56:02','2025-02-07 09:56:02'),(67,'default','added',132,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2025-02-07 10:11:44','2025-02-07 10:11:44'),(68,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-07 10:28:07','2025-02-07 10:28:07'),(69,'default','added',133,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2025-02-07 10:29:38','2025-02-07 10:29:38'),(70,'default','sell_deleted',133,'App\\Transaction',NULL,3,3,'App\\User','{\"id\":133,\"invoice_no\":\"0013\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"}}',NULL,'2025-02-07 10:30:58','2025-02-07 10:30:58'),(71,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-07 16:25:19','2025-02-07 16:25:19'),(72,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-07 16:39:56','2025-02-07 16:39:56'),(73,'default','added',134,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-02-07 16:57:16','2025-02-07 16:57:16'),(74,'default','added',135,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-02-07 16:59:34','2025-02-07 16:59:34'),(75,'default','login',6,'App\\User',NULL,4,6,'App\\User','[]',NULL,'2025-02-10 12:16:43','2025-02-10 12:16:43'),(76,'default','added',137,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":625}}',NULL,'2025-02-10 12:19:20','2025-02-10 12:19:20'),(77,'default','added',138,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2025-02-10 12:24:30','2025-02-10 12:24:30'),(78,'default','added',139,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":875}}',NULL,'2025-02-10 12:28:02','2025-02-10 12:28:02'),(79,'default','added',140,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":875}}',NULL,'2025-02-10 12:30:33','2025-02-10 12:30:33'),(80,'default','added',141,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":375}}',NULL,'2025-02-10 12:32:31','2025-02-10 12:32:31'),(81,'default','logout',6,'App\\User',NULL,4,6,'App\\User','[]',NULL,'2025-02-10 13:24:50','2025-02-10 13:24:50'),(82,'default','login',6,'App\\User',NULL,4,6,'App\\User','[]',NULL,'2025-02-10 13:25:16','2025-02-10 13:25:16'),(83,'default','edited',6,'App\\User',NULL,4,6,'App\\User','{\"name\":\" Owner \"}',NULL,'2025-02-10 13:25:56','2025-02-10 13:25:56'),(84,'default','added',143,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2025-02-10 13:36:14','2025-02-10 13:36:14'),(85,'default','added',144,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2025-02-10 13:45:58','2025-02-10 13:45:58'),(86,'default','added',145,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2025-02-10 13:52:47','2025-02-10 13:52:47'),(87,'default','added',146,'App\\Transaction',NULL,4,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2025-02-10 13:56:29','2025-02-10 13:56:29'),(88,'default','login',6,'App\\User',NULL,4,6,'App\\User','[]',NULL,'2025-02-10 14:00:37','2025-02-10 14:00:37'),(89,'default','added',7,'App\\User',NULL,4,6,'App\\User','{\"name\":\" Cashier \"}',NULL,'2025-02-10 14:08:01','2025-02-10 14:08:01'),(90,'default','logout',6,'App\\User',NULL,4,6,'App\\User','[]',NULL,'2025-02-10 14:08:08','2025-02-10 14:08:08'),(91,'default','login',7,'App\\User',NULL,4,7,'App\\User','[]',NULL,'2025-02-10 14:08:17','2025-02-10 14:08:17'),(92,'default','added',147,'App\\Transaction',NULL,4,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":50}}',NULL,'2025-02-10 14:09:26','2025-02-10 14:09:26'),(93,'default','added',148,'App\\Transaction',NULL,4,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":125}}',NULL,'2025-02-10 14:09:38','2025-02-10 14:09:38'),(94,'default','logout',7,'App\\User',NULL,4,7,'App\\User','[]',NULL,'2025-02-10 14:09:49','2025-02-10 14:09:49'),(95,'default','login',6,'App\\User',NULL,4,6,'App\\User','[]',NULL,'2025-02-10 14:10:01','2025-02-10 14:10:01'),(96,'default','logout',6,'App\\User',NULL,4,6,'App\\User','[]',NULL,'2025-02-10 14:11:49','2025-02-10 14:11:49'),(97,'default','login',7,'App\\User',NULL,4,7,'App\\User','[]',NULL,'2025-02-10 14:12:01','2025-02-10 14:12:01'),(98,'default','added',149,'App\\Transaction',NULL,4,7,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2025-02-10 14:12:11','2025-02-10 14:12:11'),(99,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-10 16:44:35','2025-02-10 16:44:35'),(100,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-10 16:45:30','2025-02-10 16:45:30'),(101,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-12 11:51:09','2025-02-12 11:51:09'),(102,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-12 12:03:45','2025-02-12 12:03:45'),(103,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-12 19:37:36','2025-02-12 19:37:36'),(104,'default','added',150,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":200}}',NULL,'2025-02-12 20:03:52','2025-02-12 20:03:52'),(105,'default','added',151,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":600}}',NULL,'2025-02-12 20:04:07','2025-02-12 20:04:07'),(106,'default','added',152,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2025-02-12 20:04:38','2025-02-12 20:04:38'),(107,'default','edited',152,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2025-02-12 20:06:37','2025-02-12 20:06:37'),(108,'default','added',153,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}',NULL,'2025-02-12 20:07:32','2025-02-12 20:07:32'),(109,'default','added',154,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"shipped\",\"payment_status\":\"due\",\"final_total\":2100}}',NULL,'2025-02-12 20:09:04','2025-02-12 20:09:04'),(110,'default','added',155,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2025-02-12 20:09:30','2025-02-12 20:09:30'),(111,'default','added',156,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2025-02-12 20:09:44','2025-02-12 20:09:44'),(112,'default','added',9,'App\\Contact',NULL,3,3,'App\\User','[]',NULL,'2025-02-12 20:12:05','2025-02-12 20:12:05'),(113,'default','edited',156,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2025-02-12 20:13:21','2025-02-12 20:13:21'),(114,'default','added',157,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2025-02-12 20:19:34','2025-02-12 20:19:34'),(115,'default','edited',157,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"600.0000\"}}',NULL,'2025-02-12 20:19:56','2025-02-12 20:19:56'),(116,'default','edited',155,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2025-02-12 20:20:08','2025-02-12 20:20:08'),(117,'default','edited',154,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"shipped\",\"payment_status\":\"paid\",\"final_total\":2100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"shipping_status\":\"shipped\",\"payment_status\":\"due\",\"final_total\":\"2100.0000\"}}',NULL,'2025-02-12 20:20:22','2025-02-12 20:20:22'),(118,'default','added',158,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":400}}',NULL,'2025-02-12 20:22:15','2025-02-12 20:22:15'),(119,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-13 01:40:24','2025-02-13 01:40:24'),(120,'default','added',1857,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2025-02-13 02:36:53','2025-02-13 02:36:53'),(121,'default','added',1858,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3135}}',NULL,'2025-02-13 09:26:48','2025-02-13 09:26:48'),(122,'default','login',9,'App\\User',NULL,6,9,'App\\User','[]',NULL,'2025-02-13 09:36:30','2025-02-13 09:36:30'),(123,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-13 10:41:28','2025-02-13 10:41:28'),(124,'default','added',1859,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2025-02-13 10:49:42','2025-02-13 10:49:42'),(125,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-13 10:57:58','2025-02-13 10:57:58'),(126,'default','added',1860,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2025-02-13 11:03:20','2025-02-13 11:03:20'),(127,'default','added',1861,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":395}}',NULL,'2025-02-13 11:08:55','2025-02-13 11:08:55'),(128,'default','added',1862,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2025-02-13 11:09:34','2025-02-13 11:09:34'),(129,'default','added',1863,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":395}}',NULL,'2025-02-13 11:10:02','2025-02-13 11:10:02'),(130,'default','added',1864,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2025-02-13 11:10:37','2025-02-13 11:10:37'),(131,'default','added',1865,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":395}}',NULL,'2025-02-13 11:12:19','2025-02-13 11:12:19'),(132,'default','added',1866,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":80}}',NULL,'2025-02-13 11:12:33','2025-02-13 11:12:33'),(133,'default','sell_deleted',1866,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1866,\"invoice_no\":\"0010\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80.0000\"}}',NULL,'2025-02-13 11:18:57','2025-02-13 11:18:57'),(134,'default','sell_deleted',1865,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1865,\"invoice_no\":\"0009\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"395.0000\"}}',NULL,'2025-02-13 11:19:08','2025-02-13 11:19:08'),(135,'default','sell_deleted',1864,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1864,\"invoice_no\":\"0008\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"650.0000\"}}',NULL,'2025-02-13 11:19:14','2025-02-13 11:19:14'),(136,'default','sell_deleted',1863,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1863,\"invoice_no\":\"0007\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"395.0000\"}}',NULL,'2025-02-13 11:19:25','2025-02-13 11:19:25'),(137,'default','sell_deleted',1862,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1862,\"invoice_no\":\"0006\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80.0000\"}}',NULL,'2025-02-13 11:19:31','2025-02-13 11:19:31'),(138,'default','sell_deleted',1861,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1861,\"invoice_no\":\"0005\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"395.0000\"}}',NULL,'2025-02-13 11:19:35','2025-02-13 11:19:35'),(139,'default','sell_deleted',1860,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1860,\"invoice_no\":\"0004\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"650.0000\"}}',NULL,'2025-02-13 11:19:40','2025-02-13 11:19:40'),(140,'default','sell_deleted',1858,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1858,\"invoice_no\":\"0002\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3135.0000\"}}',NULL,'2025-02-13 11:19:44','2025-02-13 11:19:44'),(141,'default','sell_deleted',1859,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1859,\"invoice_no\":\"0003\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"250.0000\"}}',NULL,'2025-02-13 11:19:50','2025-02-13 11:19:50'),(142,'default','sell_deleted',1857,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1857,\"invoice_no\":\"0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"80.0000\"}}',NULL,'2025-02-13 11:19:54','2025-02-13 11:19:54'),(143,'default','added',1867,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2025-02-13 11:33:52','2025-02-13 11:33:52'),(144,'default','added',1868,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2025-02-13 11:34:29','2025-02-13 11:34:29'),(145,'default','added',1869,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2025-02-13 11:34:51','2025-02-13 11:34:51'),(146,'default','added',1870,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2025-02-13 11:37:07','2025-02-13 11:37:07'),(147,'default','added',1871,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2025-02-13 11:40:21','2025-02-13 11:40:21'),(148,'default','added',1872,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":135}}',NULL,'2025-02-13 11:54:49','2025-02-13 11:54:49'),(149,'default','added',1873,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2025-02-13 11:56:11','2025-02-13 11:56:11'),(150,'default','sell_deleted',1873,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1873,\"invoice_no\":\"0017\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"250.0000\"}}',NULL,'2025-02-13 11:58:45','2025-02-13 11:58:45'),(151,'default','sell_deleted',1872,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1872,\"invoice_no\":\"0016\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"135.0000\"}}',NULL,'2025-02-13 11:58:54','2025-02-13 11:58:54'),(152,'default','sell_deleted',1871,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1871,\"invoice_no\":\"0015\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"}}',NULL,'2025-02-13 11:59:03','2025-02-13 11:59:03'),(153,'default','sell_deleted',1870,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1870,\"invoice_no\":\"0014\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"}}',NULL,'2025-02-13 11:59:12','2025-02-13 11:59:12'),(154,'default','sell_deleted',1869,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1869,\"invoice_no\":\"0013\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"}}',NULL,'2025-02-13 11:59:24','2025-02-13 11:59:24'),(155,'default','sell_deleted',1868,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1868,\"invoice_no\":\"0012\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"}}',NULL,'2025-02-13 11:59:32','2025-02-13 11:59:32'),(156,'default','sell_deleted',1867,'App\\Transaction',NULL,5,8,'App\\User','{\"id\":1867,\"invoice_no\":\"0011\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"150.0000\"}}',NULL,'2025-02-13 11:59:42','2025-02-13 11:59:42'),(157,'default','login',9,'App\\User',NULL,6,9,'App\\User','[]',NULL,'2025-02-13 13:44:23','2025-02-13 13:44:23'),(158,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-13 14:11:22','2025-02-13 14:11:22'),(159,'default','added',1874,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":135}}',NULL,'2025-02-13 14:26:03','2025-02-13 14:26:03'),(160,'default','added',1875,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":135}}',NULL,'2025-02-13 14:33:03','2025-02-13 14:33:03'),(161,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-14 02:14:37','2025-02-14 02:14:37'),(162,'default','added',1876,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":160}}',NULL,'2025-02-14 02:26:30','2025-02-14 02:26:30'),(163,'default','added',1877,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-02-14 02:29:57','2025-02-14 02:29:57'),(164,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-02-14 05:49:40','2025-02-14 05:49:40'),(165,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-14 06:29:56','2025-02-14 06:29:56'),(166,'default','added',1878,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":385}}',NULL,'2025-02-14 13:10:37','2025-02-14 13:10:37'),(167,'default','added',1879,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1135}}',NULL,'2025-02-14 13:23:52','2025-02-14 13:23:52'),(168,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-14 14:40:25','2025-02-14 14:40:25'),(169,'default','added',1880,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":1600}}',NULL,'2025-02-14 14:43:47','2025-02-14 14:43:47'),(170,'default','added',1881,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":545}}',NULL,'2025-02-14 14:49:58','2025-02-14 14:49:58'),(171,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-14 18:27:05','2025-02-14 18:27:05'),(172,'default','added',1882,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2025-02-14 18:32:00','2025-02-14 18:32:00'),(173,'default','added',1883,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":425}}',NULL,'2025-02-14 18:33:48','2025-02-14 18:33:48'),(174,'default','added',1884,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":340}}',NULL,'2025-02-14 18:35:14','2025-02-14 18:35:14'),(175,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-14 19:27:52','2025-02-14 19:27:52'),(176,'default','added',1885,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2025-02-14 19:41:28','2025-02-14 19:41:28'),(177,'default','added',1886,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2025-02-14 20:03:59','2025-02-14 20:03:59'),(178,'default','added',1887,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":340}}',NULL,'2025-02-14 20:04:23','2025-02-14 20:04:23'),(179,'default','added',1888,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":316}}',NULL,'2025-02-14 20:05:23','2025-02-14 20:05:23'),(180,'default','added',1889,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10}}',NULL,'2025-02-14 20:09:25','2025-02-14 20:09:25'),(181,'default','added',1890,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":68}}',NULL,'2025-02-14 20:17:30','2025-02-14 20:17:30'),(182,'default','added',1891,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":385}}',NULL,'2025-02-14 20:18:40','2025-02-14 20:18:40'),(183,'default','added',1892,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":79}}',NULL,'2025-02-14 20:19:55','2025-02-14 20:19:55'),(184,'default','added',1893,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":391}}',NULL,'2025-02-14 20:20:32','2025-02-14 20:20:32'),(185,'default','added',1894,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":69}}',NULL,'2025-02-14 20:21:36','2025-02-14 20:21:36'),(186,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-15 03:50:32','2025-02-15 03:50:32'),(187,'default','added',1895,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1170}}',NULL,'2025-02-15 04:00:55','2025-02-15 04:00:55'),(188,'default','added',1896,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":56}}',NULL,'2025-02-15 04:33:09','2025-02-15 04:33:09'),(189,'default','added',1897,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":113}}',NULL,'2025-02-15 04:38:28','2025-02-15 04:38:28'),(190,'default','added',1899,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2025-02-15 05:59:03','2025-02-15 05:59:03'),(191,'default','added',1900,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":135}}',NULL,'2025-02-15 06:02:44','2025-02-15 06:02:44'),(192,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-15 06:52:15','2025-02-15 06:52:15'),(193,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-15 10:06:25','2025-02-15 10:06:25'),(194,'default','added',1901,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":225}}',NULL,'2025-02-16 03:34:18','2025-02-16 03:34:18'),(195,'default','added',1903,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":635}}',NULL,'2025-02-16 05:23:07','2025-02-16 05:23:07'),(196,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-16 08:58:42','2025-02-16 08:58:42'),(197,'default','added',1904,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":40}}',NULL,'2025-02-17 13:25:31','2025-02-17 13:25:31'),(198,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-18 05:51:01','2025-02-18 05:51:01'),(199,'default','added',1905,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2025-02-18 05:55:45','2025-02-18 05:55:45'),(200,'default','added',1906,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2025-02-18 05:56:31','2025-02-18 05:56:31'),(201,'default','added',1907,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2025-02-18 06:13:39','2025-02-18 06:13:39'),(202,'default','added',1908,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2025-02-18 06:22:19','2025-02-18 06:22:19'),(203,'default','added',11,'App\\Contact',NULL,5,8,'App\\User','[]',NULL,'2025-02-18 06:32:28','2025-02-18 06:32:28'),(204,'default','added',1909,'App\\Transaction',NULL,5,8,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2025-02-18 06:38:25','2025-02-18 06:38:25'),(205,'default','login',9,'App\\User',NULL,6,9,'App\\User','[]',NULL,'2025-02-19 11:05:43','2025-02-19 11:05:43'),(206,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-22 04:38:36','2025-02-22 04:38:36'),(207,'default','added',1910,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-02-22 04:39:32','2025-02-22 04:39:32'),(208,'default','added',1911,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2025-02-22 04:53:18','2025-02-22 04:53:18'),(209,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-22 07:45:51','2025-02-22 07:45:51'),(210,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-22 08:02:30','2025-02-22 08:02:30'),(211,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-22 14:51:44','2025-02-22 14:51:44'),(212,'default','added',1912,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-02-22 14:55:14','2025-02-22 14:55:14'),(213,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-22 16:38:35','2025-02-22 16:38:35'),(214,'default','added',1913,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2025-02-22 16:45:17','2025-02-22 16:45:17'),(215,'default','added',1914,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":400}}',NULL,'2025-02-22 16:46:03','2025-02-22 16:46:03'),(216,'default','added',1915,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-02-22 16:47:39','2025-02-22 16:47:39'),(217,'default','added',1916,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":245}}',NULL,'2025-02-22 16:49:18','2025-02-22 16:49:18'),(218,'default','added',1917,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2025-02-22 16:49:55','2025-02-22 16:49:55'),(219,'default','added',1918,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2025-02-22 17:24:22','2025-02-22 17:24:22'),(220,'default','added',1919,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2025-02-22 17:24:31','2025-02-22 17:24:31'),(221,'default','added',1920,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":400}}',NULL,'2025-02-22 17:25:50','2025-02-22 17:25:50'),(222,'default','added',1921,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2025-02-22 17:26:59','2025-02-22 17:26:59'),(223,'default','added',1922,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"payment_status\":\"due\"}}',NULL,'2025-02-22 17:28:30','2025-02-22 17:28:30'),(224,'default','added',1923,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-02-23 10:04:21','2025-02-23 10:04:21'),(225,'default','added',1924,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}',NULL,'2025-02-23 10:05:05','2025-02-23 10:05:05'),(226,'default','added',1925,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-02-23 13:54:17','2025-02-23 13:54:17'),(227,'default','added',1926,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-02-23 14:20:34','2025-02-23 14:20:34'),(228,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-24 10:29:50','2025-02-24 10:29:50'),(229,'default','added',1927,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-02-24 10:34:48','2025-02-24 10:34:48'),(230,'default','login',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-24 12:39:43','2025-02-24 12:39:43'),(231,'default','added',11,'App\\User',NULL,7,10,'App\\User','{\"name\":\" Staff \"}',NULL,'2025-02-24 12:42:32','2025-02-24 12:42:32'),(232,'default','logout',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-24 12:47:02','2025-02-24 12:47:02'),(233,'default','login',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-24 13:53:30','2025-02-24 13:53:30'),(234,'default','login',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-24 16:53:39','2025-02-24 16:53:39'),(235,'default','added',12,'App\\User',NULL,7,10,'App\\User','{\"name\":\" deskaw Kavindu\"}',NULL,'2025-02-24 17:25:23','2025-02-24 17:25:23'),(236,'default','logout',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-24 17:25:40','2025-02-24 17:25:40'),(237,'default','login',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-02-24 17:25:43','2025-02-24 17:25:43'),(238,'default','login',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-02-24 19:03:30','2025-02-24 19:03:30'),(239,'default','login',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-02-25 04:22:39','2025-02-25 04:22:39'),(240,'default','login',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-02-25 05:19:38','2025-02-25 05:19:38'),(241,'default','login',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-02-25 05:22:58','2025-02-25 05:22:58'),(242,'default','login',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-25 06:54:02','2025-02-25 06:54:02'),(243,'default','logout',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-25 06:57:19','2025-02-25 06:57:19'),(244,'default','login',11,'App\\User',NULL,7,11,'App\\User','[]',NULL,'2025-02-25 07:02:16','2025-02-25 07:02:16'),(245,'default','login',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-25 11:18:38','2025-02-25 11:18:38'),(246,'default','logout',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-25 11:18:40','2025-02-25 11:18:40'),(247,'default','login',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-25 11:18:54','2025-02-25 11:18:54'),(248,'default','logout',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-25 11:21:02','2025-02-25 11:21:02'),(249,'default','login',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-25 11:22:36','2025-02-25 11:22:36'),(250,'default','added',1928,'App\\Transaction',NULL,7,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2025-02-25 11:32:19','2025-02-25 11:32:19'),(251,'default','added',1929,'App\\Transaction',NULL,7,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2025-02-25 11:36:34','2025-02-25 11:36:34'),(252,'default','added',1930,'App\\Transaction',NULL,7,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2025-02-25 11:52:00','2025-02-25 11:52:00'),(253,'default','logout',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-02-25 12:23:51','2025-02-25 12:23:51'),(254,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-25 16:07:46','2025-02-25 16:07:46'),(255,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-25 16:15:53','2025-02-25 16:15:53'),(256,'default','logout',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-25 16:29:18','2025-02-25 16:29:18'),(257,'default','login',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-02-25 16:29:57','2025-02-25 16:29:57'),(258,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-02-25 16:50:27','2025-02-25 16:50:27'),(259,'default','logout',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-02-25 17:53:58','2025-02-25 17:53:59'),(260,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-25 17:54:03','2025-02-25 17:54:03'),(261,'default','logout',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-25 18:22:07','2025-02-25 18:22:07'),(262,'default','login',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-02-25 18:22:22','2025-02-25 18:22:22'),(263,'default','added',14,'App\\Contact',NULL,8,13,'App\\User','[]',NULL,'2025-02-25 18:22:29','2025-02-25 18:22:29'),(264,'default','added',1967,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":157}}',NULL,'2025-02-25 18:22:33','2025-02-25 18:22:33'),(265,'default','logout',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-02-25 18:28:53','2025-02-25 18:28:53'),(266,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-25 18:29:07','2025-02-25 18:29:07'),(267,'default','added',1968,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59}}',NULL,'2025-02-25 18:34:56','2025-02-25 18:34:56'),(268,'default','added',1970,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":177}}',NULL,'2025-02-25 19:07:28','2025-02-25 19:07:28'),(269,'default','added',1971,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":374}}',NULL,'2025-02-25 19:23:12','2025-02-25 19:23:12'),(270,'default','added',1972,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":237}}',NULL,'2025-02-25 19:24:28','2025-02-25 19:24:28'),(271,'default','added',1973,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59}}',NULL,'2025-02-25 19:26:29','2025-02-25 19:26:29'),(272,'default','login',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-02-26 06:27:59','2025-02-26 06:27:59'),(273,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-26 07:53:43','2025-02-26 07:53:43'),(274,'default','added',1974,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":236}}',NULL,'2025-02-26 08:00:45','2025-02-26 08:00:45'),(275,'default','added',1975,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":594}}',NULL,'2025-02-26 08:17:07','2025-02-26 08:17:07'),(276,'default','added',1976,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2025-02-26 08:42:09','2025-02-26 08:42:09'),(277,'default','added',1977,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":177}}',NULL,'2025-02-26 09:21:49','2025-02-26 09:21:49'),(278,'default','added',1978,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":177}}',NULL,'2025-02-26 09:24:10','2025-02-26 09:24:10'),(279,'default','added',1979,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":118}}',NULL,'2025-02-26 09:28:42','2025-02-26 09:28:42'),(280,'default','added',1980,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":177}}',NULL,'2025-02-26 09:33:59','2025-02-26 09:33:59'),(281,'default','added',1981,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":196}}',NULL,'2025-02-26 09:36:28','2025-02-26 09:36:28'),(282,'default','added',1982,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":118}}',NULL,'2025-02-26 09:37:07','2025-02-26 09:37:07'),(283,'default','added',1983,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":118}}',NULL,'2025-02-26 09:38:49','2025-02-26 09:38:49'),(284,'default','added',1984,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":118}}',NULL,'2025-02-26 09:40:44','2025-02-26 09:40:44'),(285,'default','added',1985,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":118}}',NULL,'2025-02-26 09:42:21','2025-02-26 09:42:21'),(286,'default','added',1986,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":374}}',NULL,'2025-02-26 09:44:40','2025-02-26 09:44:40'),(287,'default','added',1987,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":374}}',NULL,'2025-02-26 09:44:49','2025-02-26 09:44:49'),(288,'default','added',1988,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":561}}',NULL,'2025-02-26 09:48:42','2025-02-26 09:48:42'),(289,'default','added',1989,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":374}}',NULL,'2025-02-26 09:50:18','2025-02-26 09:50:18'),(290,'default','added',1990,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":374}}',NULL,'2025-02-26 09:53:41','2025-02-26 09:53:41'),(291,'default','added',1991,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":374}}',NULL,'2025-02-26 09:54:28','2025-02-26 09:54:28'),(292,'default','added',1992,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":187}}',NULL,'2025-02-26 09:57:10','2025-02-26 09:57:10'),(293,'default','added',1993,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3261}}',NULL,'2025-02-26 10:07:31','2025-02-26 10:07:31'),(294,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-26 10:25:08','2025-02-26 10:25:08'),(295,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-26 10:29:37','2025-02-26 10:29:37'),(296,'default','added',1994,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":177}}',NULL,'2025-02-26 10:40:51','2025-02-26 10:40:51'),(297,'default','added',1995,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":118}}',NULL,'2025-02-26 11:22:40','2025-02-26 11:22:40'),(298,'default','added',1996,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59}}',NULL,'2025-02-26 11:24:29','2025-02-26 11:24:29'),(299,'default','added',1997,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59}}',NULL,'2025-02-26 11:26:17','2025-02-26 11:26:17'),(300,'default','added',1998,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59}}',NULL,'2025-02-26 11:27:06','2025-02-26 11:27:06'),(301,'default','added',1999,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":157}}',NULL,'2025-02-26 11:31:03','2025-02-26 11:31:03'),(302,'default','added',2000,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59}}',NULL,'2025-02-26 11:32:06','2025-02-26 11:32:06'),(303,'default','added',2001,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":187}}',NULL,'2025-02-26 11:33:21','2025-02-26 11:33:21'),(304,'default','added',2002,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":118}}',NULL,'2025-02-26 11:38:10','2025-02-26 11:38:10'),(305,'default','added',2003,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":118}}',NULL,'2025-02-26 11:40:14','2025-02-26 11:40:14'),(306,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-26 11:44:25','2025-02-26 11:44:25'),(307,'default','added',2004,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":374}}',NULL,'2025-02-26 11:44:41','2025-02-26 11:44:41'),(308,'default','added',2005,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":935}}',NULL,'2025-02-26 11:48:23','2025-02-26 11:48:23'),(309,'default','added',15,'App\\Contact',NULL,8,13,'App\\User','[]',NULL,'2025-02-26 11:49:17','2025-02-26 11:49:17'),(310,'default','added',2006,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1980}}',NULL,'2025-02-26 11:49:22','2025-02-26 11:49:22'),(311,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-26 12:20:28','2025-02-26 12:20:28'),(312,'default','added',2007,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":564}}',NULL,'2025-02-26 12:21:05','2025-02-26 12:21:05'),(313,'default','added',2008,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59}}',NULL,'2025-02-26 12:21:06','2025-02-26 12:21:06'),(314,'default','added',2009,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59}}',NULL,'2025-02-26 12:28:29','2025-02-26 12:28:29'),(315,'default','added',2010,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":187}}',NULL,'2025-02-26 12:28:47','2025-02-26 12:28:47'),(316,'default','added',2011,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":237}}',NULL,'2025-02-26 12:28:50','2025-02-26 12:28:50'),(317,'default','added',2012,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":59}}',NULL,'2025-02-26 12:34:13','2025-02-26 12:34:13'),(318,'default','added',2013,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":187}}',NULL,'2025-02-26 12:39:41','2025-02-26 12:39:41'),(319,'default','added',2014,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":187}}',NULL,'2025-02-26 12:40:37','2025-02-26 12:40:37'),(320,'default','added',2015,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":990}}',NULL,'2025-02-26 12:54:33','2025-02-26 12:54:33'),(321,'default','added',2016,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":396}}',NULL,'2025-02-26 12:55:32','2025-02-26 12:55:32'),(322,'default','added',2017,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 12:56:21','2025-02-26 12:56:21'),(323,'default','added',2018,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":282}}',NULL,'2025-02-26 13:03:03','2025-02-26 13:03:03'),(324,'default','added',2019,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:04:35','2025-02-26 13:04:35'),(325,'default','added',2020,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:05:18','2025-02-26 13:05:18'),(326,'default','added',2021,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":396}}',NULL,'2025-02-26 13:15:24','2025-02-26 13:15:24'),(327,'default','added',2022,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:15:53','2025-02-26 13:15:53'),(328,'default','added',2023,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:28:57','2025-02-26 13:28:57'),(329,'default','added',2024,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:30:32','2025-02-26 13:30:32'),(330,'default','added',2025,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:30:33','2025-02-26 13:30:33'),(331,'default','added',2026,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:30:35','2025-02-26 13:30:35'),(332,'default','added',2027,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:30:35','2025-02-26 13:30:35'),(333,'default','added',2028,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:30:35','2025-02-26 13:30:35'),(334,'default','added',2029,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:30:35','2025-02-26 13:30:35'),(335,'default','added',2030,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:30:35','2025-02-26 13:30:35'),(336,'default','added',2031,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:30:36','2025-02-26 13:30:36'),(337,'default','sell_deleted',2026,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2026,\"invoice_no\":\"0059\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 13:32:26','2025-02-26 13:32:26'),(338,'default','added',2032,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7.5}}',NULL,'2025-02-26 13:49:05','2025-02-26 13:49:05'),(339,'default','added',2033,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":198}}',NULL,'2025-02-26 13:50:18','2025-02-26 13:50:18'),(340,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-26 16:37:53','2025-02-26 16:37:53'),(341,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-26 18:15:08','2025-02-26 18:15:08'),(342,'default','logout',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-02-26 18:34:52','2025-02-26 18:34:52'),(343,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-26 18:34:59','2025-02-26 18:34:59'),(344,'default','sell_deleted',2033,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2033,\"invoice_no\":\"0062\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:36:06','2025-02-26 18:36:06'),(345,'default','sell_deleted',2032,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2032,\"invoice_no\":\"0061\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7.5000\"}}',NULL,'2025-02-26 18:36:12','2025-02-26 18:36:12'),(346,'default','sell_deleted',2027,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2027,\"invoice_no\":\"0059\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:36:18','2025-02-26 18:36:18'),(347,'default','sell_deleted',2028,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2028,\"invoice_no\":\"0060\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:36:27','2025-02-26 18:36:27'),(348,'default','sell_deleted',2029,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2029,\"invoice_no\":\"0060\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:36:32','2025-02-26 18:36:32'),(349,'default','sell_deleted',2030,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2030,\"invoice_no\":\"0060\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:36:38','2025-02-26 18:36:38'),(350,'default','sell_deleted',2011,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2011,\"invoice_no\":\"0044\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"237.0000\"}}',NULL,'2025-02-26 18:36:55','2025-02-26 18:36:55'),(351,'default','sell_deleted',2025,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2025,\"invoice_no\":\"0058\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:37:00','2025-02-26 18:37:00'),(352,'default','sell_deleted',2031,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2031,\"invoice_no\":\"0060\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:37:03','2025-02-26 18:37:03'),(353,'default','sell_deleted',2024,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2024,\"invoice_no\":\"0057\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:37:08','2025-02-26 18:37:08'),(354,'default','sell_deleted',2022,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2022,\"invoice_no\":\"0055\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:37:15','2025-02-26 18:37:15'),(355,'default','sell_deleted',2023,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2023,\"invoice_no\":\"0056\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:37:24','2025-02-26 18:37:24'),(356,'default','sell_deleted',2021,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2021,\"invoice_no\":\"0054\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"396.0000\"}}',NULL,'2025-02-26 18:37:31','2025-02-26 18:37:31'),(357,'default','sell_deleted',2020,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2020,\"invoice_no\":\"0053\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:37:39','2025-02-26 18:37:39'),(358,'default','sell_deleted',2018,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2018,\"invoice_no\":\"0051\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"282.0000\"}}',NULL,'2025-02-26 18:37:44','2025-02-26 18:37:44'),(359,'default','sell_deleted',2019,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2019,\"invoice_no\":\"0052\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:37:47','2025-02-26 18:37:47'),(360,'default','sell_deleted',2017,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2017,\"invoice_no\":\"0050\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"198.0000\"}}',NULL,'2025-02-26 18:37:52','2025-02-26 18:37:52'),(361,'default','sell_deleted',2016,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2016,\"invoice_no\":\"0049\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"396.0000\"}}',NULL,'2025-02-26 18:37:59','2025-02-26 18:37:59'),(362,'default','sell_deleted',2014,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2014,\"invoice_no\":\"0047\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"187.0000\"}}',NULL,'2025-02-26 18:38:05','2025-02-26 18:38:05'),(363,'default','sell_deleted',2015,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2015,\"invoice_no\":\"0048\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"990.0000\"}}',NULL,'2025-02-26 18:38:18','2025-02-26 18:38:18'),(364,'default','sell_deleted',2013,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2013,\"invoice_no\":\"0046\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"187.0000\"}}',NULL,'2025-02-26 18:38:43','2025-02-26 18:38:43'),(365,'default','sell_deleted',2012,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2012,\"invoice_no\":\"0045\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"59.0000\"}}',NULL,'2025-02-26 18:39:02','2025-02-26 18:39:02'),(366,'default','sell_deleted',2010,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2010,\"invoice_no\":\"0043\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"187.0000\"}}',NULL,'2025-02-26 18:39:13','2025-02-26 18:39:13'),(367,'default','sell_deleted',2008,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2008,\"invoice_no\":\"0041\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"59.0000\"}}',NULL,'2025-02-26 18:39:21','2025-02-26 18:39:21'),(368,'default','sell_deleted',1984,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1984,\"invoice_no\":\"0017\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"118.0000\"}}',NULL,'2025-02-26 18:39:40','2025-02-26 18:39:40'),(369,'default','sell_deleted',1985,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1985,\"invoice_no\":\"0018\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"118.0000\"}}',NULL,'2025-02-26 18:39:44','2025-02-26 18:39:44'),(370,'default','sell_deleted',2000,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2000,\"invoice_no\":\"0033\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"59.0000\"}}',NULL,'2025-02-26 18:39:49','2025-02-26 18:39:49'),(371,'default','sell_deleted',2003,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2003,\"invoice_no\":\"0036\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"118.0000\"}}',NULL,'2025-02-26 18:39:57','2025-02-26 18:39:57'),(372,'default','sell_deleted',2004,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2004,\"invoice_no\":\"0037\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"374.0000\"}}',NULL,'2025-02-26 18:40:03','2025-02-26 18:40:03'),(373,'default','sell_deleted',2005,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2005,\"invoice_no\":\"0038\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"935.0000\"}}',NULL,'2025-02-26 18:40:14','2025-02-26 18:40:14'),(374,'default','sell_deleted',2006,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2006,\"invoice_no\":\"0039\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1980.0000\"}}',NULL,'2025-02-26 18:40:17','2025-02-26 18:40:17'),(375,'default','sell_deleted',2009,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2009,\"invoice_no\":\"0042\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"59.0000\"}}',NULL,'2025-02-26 18:40:33','2025-02-26 18:40:33'),(376,'default','sell_deleted',2007,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2007,\"invoice_no\":\"0040\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"564.0000\"}}',NULL,'2025-02-26 18:40:38','2025-02-26 18:40:38'),(377,'default','sell_deleted',2002,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2002,\"invoice_no\":\"0035\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"118.0000\"}}',NULL,'2025-02-26 18:40:43','2025-02-26 18:40:43'),(378,'default','sell_deleted',2001,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":2001,\"invoice_no\":\"0034\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"187.0000\"}}',NULL,'2025-02-26 18:40:55','2025-02-26 18:40:55'),(379,'default','sell_deleted',1999,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1999,\"invoice_no\":\"0032\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"157.0000\"}}',NULL,'2025-02-26 18:41:04','2025-02-26 18:41:04'),(380,'default','sell_deleted',1998,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1998,\"invoice_no\":\"0031\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"59.0000\"}}',NULL,'2025-02-26 18:41:12','2025-02-26 18:41:12'),(381,'default','sell_deleted',1997,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1997,\"invoice_no\":\"0030\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"59.0000\"}}',NULL,'2025-02-26 18:41:15','2025-02-26 18:41:15'),(382,'default','sell_deleted',1995,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1995,\"invoice_no\":\"0028\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"118.0000\"}}',NULL,'2025-02-26 18:41:28','2025-02-26 18:41:28'),(383,'default','sell_deleted',1992,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1992,\"invoice_no\":\"0025\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"187.0000\"}}',NULL,'2025-02-26 18:41:34','2025-02-26 18:41:34'),(384,'default','sell_deleted',1990,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1990,\"invoice_no\":\"0023\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"374.0000\"}}',NULL,'2025-02-26 18:41:37','2025-02-26 18:41:37'),(385,'default','sell_deleted',1991,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1991,\"invoice_no\":\"0024\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"374.0000\"}}',NULL,'2025-02-26 18:41:47','2025-02-26 18:41:47'),(386,'default','sell_deleted',1987,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1987,\"invoice_no\":\"0020\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"374.0000\"}}',NULL,'2025-02-26 18:41:50','2025-02-26 18:41:50'),(387,'default','sell_deleted',1983,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1983,\"invoice_no\":\"0016\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"118.0000\"}}',NULL,'2025-02-26 18:41:55','2025-02-26 18:41:55'),(388,'default','sell_deleted',1981,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1981,\"invoice_no\":\"0014\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"196.0000\"}}',NULL,'2025-02-26 18:41:59','2025-02-26 18:41:59'),(389,'default','sell_deleted',1982,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1982,\"invoice_no\":\"0015\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"118.0000\"}}',NULL,'2025-02-26 18:42:05','2025-02-26 18:42:05'),(390,'default','sell_deleted',1996,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1996,\"invoice_no\":\"0029\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"59.0000\"}}',NULL,'2025-02-26 18:42:20','2025-02-26 18:42:20'),(391,'default','sell_deleted',1993,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1993,\"invoice_no\":\"0026\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3261.0000\"}}',NULL,'2025-02-26 18:42:26','2025-02-26 18:42:26'),(392,'default','sell_deleted',1980,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1980,\"invoice_no\":\"0013\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"177.0000\"}}',NULL,'2025-02-26 18:42:37','2025-02-26 18:42:37'),(393,'default','sell_deleted',1978,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1978,\"invoice_no\":\"0011\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"177.0000\"}}',NULL,'2025-02-26 18:42:40','2025-02-26 18:42:40'),(394,'default','sell_deleted',1972,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1972,\"invoice_no\":\"0005\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"237.0000\"}}',NULL,'2025-02-26 18:42:57','2025-02-26 18:42:57'),(395,'default','sell_deleted',1975,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1975,\"invoice_no\":\"0008\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"594.0000\"}}',NULL,'2025-02-26 18:42:57','2025-02-26 18:42:57'),(396,'default','sell_deleted',1970,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1970,\"invoice_no\":\"0003\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"177.0000\"}}',NULL,'2025-02-26 18:42:59','2025-02-26 18:42:59'),(397,'default','sell_deleted',1994,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1994,\"invoice_no\":\"0027\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"177.0000\"}}',NULL,'2025-02-26 18:43:10','2025-02-26 18:43:10'),(398,'default','sell_deleted',1989,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1989,\"invoice_no\":\"0022\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"374.0000\"}}',NULL,'2025-02-26 18:43:12','2025-02-26 18:43:12'),(399,'default','sell_deleted',1988,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1988,\"invoice_no\":\"0021\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"561.0000\"}}',NULL,'2025-02-26 18:43:24','2025-02-26 18:43:24'),(400,'default','sell_deleted',1986,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1986,\"invoice_no\":\"0019\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"374.0000\"}}',NULL,'2025-02-26 18:43:30','2025-02-26 18:43:30'),(401,'default','sell_deleted',1979,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1979,\"invoice_no\":\"0012\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"118.0000\"}}',NULL,'2025-02-26 18:43:40','2025-02-26 18:43:40'),(402,'default','sell_deleted',1977,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1977,\"invoice_no\":\"0010\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"177.0000\"}}',NULL,'2025-02-26 18:43:56','2025-02-26 18:43:56'),(403,'default','sell_deleted',1976,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1976,\"invoice_no\":\"0009\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"650.0000\"}}',NULL,'2025-02-26 18:44:03','2025-02-26 18:44:03'),(404,'default','sell_deleted',1974,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1974,\"invoice_no\":\"0007\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"236.0000\"}}',NULL,'2025-02-26 18:44:05','2025-02-26 18:44:05'),(405,'default','sell_deleted',1968,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1968,\"invoice_no\":\"0002\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"59.0000\"}}',NULL,'2025-02-26 18:44:10','2025-02-26 18:44:10'),(406,'default','sell_deleted',1971,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1971,\"invoice_no\":\"0004\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"374.0000\"}}',NULL,'2025-02-26 18:44:15','2025-02-26 18:44:15'),(407,'default','sell_deleted',1973,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1973,\"invoice_no\":\"0006\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"59.0000\"}}',NULL,'2025-02-26 18:44:19','2025-02-26 18:44:19'),(408,'default','sell_deleted',1967,'App\\Transaction',NULL,8,13,'App\\User','{\"id\":1967,\"invoice_no\":\"0001\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"157.0000\"}}',NULL,'2025-02-26 18:44:24','2025-02-26 18:44:24'),(409,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-27 03:00:12','2025-02-27 03:00:12'),(410,'default','added',3731,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1020}}',NULL,'2025-02-27 03:12:42','2025-02-27 03:12:42'),(411,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-27 03:16:19','2025-02-27 03:16:19'),(412,'default','added',3732,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1020}}',NULL,'2025-02-27 03:37:48','2025-02-27 03:37:48'),(413,'default','added',3733,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1020}}',NULL,'2025-02-27 03:39:19','2025-02-27 03:39:19'),(414,'default','added',3734,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2179}}',NULL,'2025-02-27 03:45:09','2025-02-27 03:45:09'),(415,'default','added',3735,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:10','2025-02-27 03:47:10'),(416,'default','added',3736,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:11','2025-02-27 03:47:11'),(417,'default','added',3737,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:11','2025-02-27 03:47:11'),(418,'default','added',3738,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:12','2025-02-27 03:47:12'),(419,'default','added',3739,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:13','2025-02-27 03:47:13'),(420,'default','added',3740,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:13','2025-02-27 03:47:13'),(421,'default','added',3741,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:13','2025-02-27 03:47:13'),(422,'default','added',3742,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:13','2025-02-27 03:47:13'),(423,'default','added',3743,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:14','2025-02-27 03:47:14'),(424,'default','added',3744,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:14','2025-02-27 03:47:14'),(425,'default','added',3745,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:15','2025-02-27 03:47:15'),(426,'default','added',3746,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:15','2025-02-27 03:47:15'),(427,'default','added',3747,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:16','2025-02-27 03:47:16'),(428,'default','added',3748,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:16','2025-02-27 03:47:16'),(429,'default','added',3749,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:16','2025-02-27 03:47:16'),(430,'default','added',3750,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:17','2025-02-27 03:47:17'),(431,'default','added',3751,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:17','2025-02-27 03:47:17'),(432,'default','added',3752,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:18','2025-02-27 03:47:18'),(433,'default','added',3753,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:18','2025-02-27 03:47:18'),(434,'default','added',3754,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:18','2025-02-27 03:47:18'),(435,'default','added',3755,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:19','2025-02-27 03:47:19'),(436,'default','added',3756,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:19','2025-02-27 03:47:19'),(437,'default','added',3757,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:19','2025-02-27 03:47:19'),(438,'default','added',3758,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:20','2025-02-27 03:47:20'),(439,'default','added',3759,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:20','2025-02-27 03:47:20'),(440,'default','added',3760,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:21','2025-02-27 03:47:21'),(441,'default','added',3761,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:21','2025-02-27 03:47:21'),(442,'default','added',3762,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:22','2025-02-27 03:47:22'),(443,'default','added',3763,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:22','2025-02-27 03:47:22'),(444,'default','added',3764,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:22','2025-02-27 03:47:22'),(445,'default','added',3765,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:23','2025-02-27 03:47:23'),(446,'default','added',3766,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:23','2025-02-27 03:47:23'),(447,'default','added',3767,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:24','2025-02-27 03:47:24'),(448,'default','added',3768,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:24','2025-02-27 03:47:24'),(449,'default','added',3769,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:24','2025-02-27 03:47:24'),(450,'default','added',3770,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:25','2025-02-27 03:47:25'),(451,'default','added',3771,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:25','2025-02-27 03:47:25'),(452,'default','added',3772,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:25','2025-02-27 03:47:25'),(453,'default','added',3773,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:26','2025-02-27 03:47:26'),(454,'default','added',3774,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:26','2025-02-27 03:47:26'),(455,'default','added',3775,'App\\Transaction',NULL,8,13,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2025-02-27 03:47:26','2025-02-27 03:47:26'),(456,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-27 03:59:42','2025-02-27 03:59:42'),(457,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-02-28 04:11:04','2025-02-28 04:11:04'),(458,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-01 08:37:34','2025-03-01 08:37:34'),(459,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-03-01 15:21:05','2025-03-01 15:21:05'),(460,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-01 16:39:43','2025-03-01 16:39:43'),(461,'default','added',3776,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":190}}',NULL,'2025-03-01 16:46:01','2025-03-01 16:46:01'),(462,'default','login',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-03-02 05:59:06','2025-03-02 05:59:06'),(463,'default','logout',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-03-02 05:59:06','2025-03-02 05:59:06'),(464,'default','login',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-03-02 05:59:18','2025-03-02 05:59:18'),(465,'default','login',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-03-02 06:00:19','2025-03-02 06:00:19'),(466,'default','added',3777,'App\\Transaction',NULL,7,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16000}}',NULL,'2025-03-02 06:05:50','2025-03-02 06:05:50'),(467,'default','added',3778,'App\\Transaction',NULL,7,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19500}}',NULL,'2025-03-02 06:06:28','2025-03-02 06:06:28'),(468,'default','added',3779,'App\\Transaction',NULL,7,10,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2025-03-02 06:07:19','2025-03-02 06:07:19'),(469,'default','logout',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-03-02 06:13:06','2025-03-02 06:13:06'),(470,'default','login',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-03-02 06:13:18','2025-03-02 06:13:18'),(471,'default','added',3781,'App\\Transaction',NULL,7,12,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17940}}',NULL,'2025-03-02 06:27:20','2025-03-02 06:27:20'),(472,'default','logout',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-03-02 06:31:42','2025-03-02 06:31:42'),(473,'default','login',11,'App\\User',NULL,7,11,'App\\User','[]',NULL,'2025-03-02 06:32:26','2025-03-02 06:32:26'),(474,'default','logout',11,'App\\User',NULL,7,11,'App\\User','[]',NULL,'2025-03-02 06:32:54','2025-03-02 06:32:54'),(475,'default','login',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-03-02 06:33:09','2025-03-02 06:33:09'),(476,'default','logout',10,'App\\User',NULL,7,10,'App\\User','[]',NULL,'2025-03-02 06:39:34','2025-03-02 06:39:34'),(477,'default','login',11,'App\\User',NULL,7,11,'App\\User','[]',NULL,'2025-03-02 06:39:45','2025-03-02 06:39:45'),(478,'default','login',8,'App\\User',NULL,5,8,'App\\User','[]',NULL,'2025-03-02 08:01:14','2025-03-02 08:01:14'),(479,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-03 00:29:26','2025-03-03 00:29:26'),(480,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-03 05:12:09','2025-03-03 05:12:09'),(481,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-03-03 05:44:41','2025-03-03 05:44:41'),(482,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-03 06:18:15','2025-03-03 06:18:15'),(483,'default','login',13,'App\\User',NULL,8,13,'App\\User','[]',NULL,'2025-03-03 06:20:53','2025-03-03 06:20:53'),(484,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-03 07:24:26','2025-03-03 07:24:26'),(485,'default','added',3782,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-03-03 07:25:11','2025-03-03 07:25:11'),(486,'default','added',3783,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-03-03 07:25:54','2025-03-03 07:25:54'),(487,'default','added',3784,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-03-03 08:22:52','2025-03-03 08:22:52'),(488,'default','added',3785,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":200}}',NULL,'2025-03-03 09:18:37','2025-03-03 09:18:37'),(489,'default','added',3786,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2025-03-03 09:20:15','2025-03-03 09:20:15'),(490,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-03 11:40:39','2025-03-03 11:40:39'),(491,'default','logout',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-03 11:47:54','2025-03-03 11:47:54'),(492,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-03 12:26:00','2025-03-03 12:26:00'),(493,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-03 13:52:18','2025-03-03 13:52:18'),(494,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-03 16:55:17','2025-03-03 16:55:17'),(495,'default','added',3787,'App\\Transaction',NULL,3,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2025-03-03 16:56:48','2025-03-03 16:56:48'),(496,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-03 18:18:26','2025-03-03 18:18:26'),(497,'default','login',3,'App\\User',NULL,3,3,'App\\User','[]',NULL,'2025-03-04 07:54:26','2025-03-04 07:54:26'),(498,'default','login',12,'App\\User',NULL,7,12,'App\\User','[]',NULL,'2025-03-04 08:05:56','2025-03-04 08:05:56');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_continuous` tinyint(1) NOT NULL DEFAULT 0,
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES (1,'20 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 4\" x 1\", Labels per sheet: 20',4.0000,1.0000,8.5000,11.0000,0.5000,0.1250,0.0000,0.1875,2,0,0,20,NULL,'2017-12-18 00:43:44','2017-12-18 00:43:44'),(2,'30 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2.625\" x 1\", Labels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.1880,0.0000,0.1250,3,0,0,30,NULL,'2017-12-18 00:34:39','2017-12-18 00:40:40'),(3,'32 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1.25\", Labels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 00:25:40','2017-12-18 00:25:40'),(4,'40 Labels per sheet','Sheet Size: 8.5\" x 11\", Label Size: 2\" x 1\", Labels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 00:28:40','2017-12-18 00:28:40'),(5,'50 Labels per Sheet','Sheet Size: 8.5\" x 11\", Label Size: 1.5\" x 1\", Labels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10'),(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm, Gap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 00:21:10','2017-12-18 00:21:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) NOT NULL,
  `booking_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
INSERT INTO `bookings` VALUES (1,9,NULL,1,3,3,3,'2025-02-13 01:46:00','2025-02-13 01:47:00',3,'booked','f','2025-02-12 20:17:12','2025-02-12 20:17:12');
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `use_for_repair` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'brands to be used on repair module',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES (1,1,'Munchee',NULL,1,1,NULL,'2025-01-29 11:31:10','2025-01-29 11:31:10'),(2,1,'Uniliver','Uni',1,1,NULL,'2025-02-05 15:40:35','2025-02-05 15:40:35'),(3,1,'delma lanka','df',1,1,NULL,'2025-02-05 15:55:40','2025-02-05 15:55:40'),(6,3,'1',NULL,3,1,NULL,'2025-02-07 06:08:06','2025-02-07 06:08:06'),(7,5,'මහවැලි සහල්',NULL,8,1,NULL,'2025-02-15 05:51:56','2025-02-15 05:51:56'),(8,5,'සූර්යා','සූර්යා',8,1,NULL,'2025-02-16 05:09:23','2025-02-16 05:09:23'),(9,5,'සූර්යා','සූර්යා',8,1,NULL,'2025-02-16 05:15:14','2025-02-16 05:15:14'),(10,5,'සූර්යා හදුන් කූරූ','සූර්යා',8,1,NULL,'2025-02-16 05:20:01','2025-02-16 05:20:01'),(11,7,'room',NULL,12,1,NULL,'2025-02-25 09:13:03','2025-02-25 09:13:03'),(12,8,'Anchor',NULL,13,1,NULL,'2025-03-02 03:18:39','2025-03-02 03:18:39'),(13,7,'drink',NULL,12,1,NULL,'2025-03-02 06:25:23','2025-03-02 06:25:23');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) DEFAULT NULL,
  `tax_label_1` varchar(10) DEFAULT NULL,
  `tax_number_2` varchar(100) DEFAULT NULL,
  `tax_label_2` varchar(10) DEFAULT NULL,
  `code_label_1` varchar(191) DEFAULT NULL,
  `code_1` varchar(191) DEFAULT NULL,
  `code_label_2` varchar(191) DEFAULT NULL,
  `code_2` varchar(191) DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT 0.00,
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT 1,
  `accounting_method` enum('fifo','lifo','avco') NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') NOT NULL DEFAULT 'includes',
  `logo` varchar(191) DEFAULT NULL,
  `sku_prefix` varchar(191) DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `expiry_type` enum('add_expiry','add_manufacturing') NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT 1,
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT 30,
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT 30,
  `keyboard_shortcuts` text DEFAULT NULL,
  `pos_settings` text DEFAULT NULL,
  `manufacturing_settings` text DEFAULT NULL,
  `woocommerce_api_settings` text DEFAULT NULL,
  `woocommerce_skipped_orders` text DEFAULT NULL,
  `woocommerce_wh_oc_secret` varchar(191) DEFAULT NULL,
  `woocommerce_wh_ou_secret` varchar(191) DEFAULT NULL,
  `woocommerce_wh_od_secret` varchar(191) DEFAULT NULL,
  `woocommerce_wh_or_secret` varchar(191) DEFAULT NULL,
  `essentials_settings` longtext DEFAULT NULL,
  `weighing_scale_setting` text NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT 1,
  `enable_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT 1,
  `enable_purchase_status` tinyint(1) DEFAULT 1,
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT 0,
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT 0,
  `enable_racks` tinyint(1) NOT NULL DEFAULT 0,
  `enable_row` tinyint(1) NOT NULL DEFAULT 0,
  `enable_position` tinyint(1) NOT NULL DEFAULT 0,
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT 1,
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT 1,
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT 1,
  `currency_symbol_placement` enum('before','after') NOT NULL DEFAULT 'before',
  `enabled_modules` text DEFAULT NULL,
  `date_format` varchar(191) NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') NOT NULL DEFAULT '24',
  `currency_precision` tinyint(4) NOT NULL DEFAULT 2,
  `quantity_precision` tinyint(4) NOT NULL DEFAULT 2,
  `ref_no_prefixes` text DEFAULT NULL,
  `theme_color` char(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `crm_settings` text DEFAULT NULL,
  `repair_settings` text DEFAULT NULL,
  `repair_jobsheet_settings` text DEFAULT NULL,
  `accounting_settings` text DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text DEFAULT NULL,
  `sms_settings` text DEFAULT NULL,
  `custom_labels` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES (1,'SR Traders',111,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,1,'Asia/Kolkata',1,'fifo',NULL,'includes','1738147587_images.png',NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(2,'Shanaka Enterprises',111,'1970-01-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,2,'Asia/Kolkata',1,'fifo',0.00,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":\"Location LINK\",\"custom_field_2\":\"Route LINK\",\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2025-02-02 17:36:47','2025-02-03 08:40:59'),(3,'demo acc',111,'1970-01-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,3,'Asia/Kolkata',1,'fifo',0.00,'includes','1740242647_e media blue white ground logo.png',NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"tables\",\"modifiers\",\"booking\",\"kitchen\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2025-02-02 17:44:33','2025-02-22 16:44:07'),(4,'Saman Mal Bakers',111,'1970-01-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,6,'Asia/Kolkata',1,'fifo',0.00,'includes',NULL,NULL,1,'add_manufacturing','stop_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"types_of_service\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2025-02-10 12:16:25','2025-02-10 13:44:13'),(5,'Derana Super',111,'1970-01-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,8,'Asia/Kolkata',1,'fifo',0.00,'includes','1739363266_IMG_0189.jpeg',NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\",\"modifiers\",\"service_staff\",\"booking\",\"kitchen\",\"subscription\",\"types_of_service\"]','m/d/Y','24',0,0,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2025-02-12 11:50:58','2025-02-13 11:02:47'),(6,'Sanjanni International',59,NULL,'P.IVA : IT07930760637','VAT',NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,9,'Asia/Kolkata',1,'fifo',NULL,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"recent_product_quantity\":\"f2\",\"add_new_product\":\"f4\"}}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"business_location\":\"BL\"}',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year',NULL,NULL,NULL,NULL,1,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(7,'Mithilaa Holiday Resort (pvt) ltd.',111,'1970-01-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,10,'Asia/Kolkata',1,'fifo',0.00,'includes','1740400855_WhatsApp Image 2025-02-24 at 16.09.45.jpeg',NULL,1,'add_manufacturing','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\",\"tables\",\"modifiers\",\"service_staff\",\"booking\",\"kitchen\",\"subscription\",\"types_of_service\"]','m/d/Y','24',2,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}',NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":\"Check In\",\"custom_field_2\":\"Check Out\",\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":\"date\",\"dropdown_options\":null},\"2\":{\"type\":\"date\",\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"enable_product_warranty\":\"1\",\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2025-02-24 12:39:17','2025-03-02 06:16:13'),(8,'Randina Stores',111,'1970-01-01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,25.00,13,'Asia/Kolkata',1,'fifo',0.00,'includes',NULL,NULL,0,'add_expiry','keep_selling',0,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":null,\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"disable_express_checkout\":0,\"hide_product_suggestion\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,NULL,0,0,0,0,1,NULL,1,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\"]','m/d/Y','24',0,2,'{\"purchase\":\"PO\",\"purchase_return\":null,\"purchase_requisition\":null,\"purchase_order\":null,\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":null,\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":null,\"sales_order\":null}','black-light',NULL,NULL,NULL,NULL,NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":null,\"mail_port\":null,\"mail_username\":null,\"mail_password\":null,\"mail_encryption\":null,\"mail_from_address\":null,\"mail_from_name\":null}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":null,\"send_to_param_name\":\"to\",\"msg_param_name\":\"text\",\"request_method\":\"post\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":null,\"param_val_1\":null,\"param_2\":null,\"param_val_2\":null,\"param_3\":null,\"param_val_3\":null,\"param_4\":null,\"param_val_4\":null,\"param_5\":null,\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"default_datatable_page_entries\":\"25\"}',1,'2025-02-25 16:07:36','2025-02-27 03:20:03');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) DEFAULT NULL,
  `name` varchar(256) NOT NULL,
  `landmark` text DEFAULT NULL,
  `country` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `city` varchar(100) NOT NULL,
  `zip_code` char(7) NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `sale_invoice_scheme_id` int(11) DEFAULT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT 1,
  `receipt_printer_type` enum('browser','printer') NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `featured_products` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `default_payment_accounts` text DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `accounting_default_map` text DEFAULT NULL COMMENT 'Default transactions mapping of accounting module',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`),
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`),
  KEY `business_locations_printer_id_index` (`printer_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES (1,1,'BL0001','SR Traders','Madawa Ulpotha','srilanka','central province','matale','21000',1,NULL,1,1,NULL,1,'browser',NULL,'076 770 2496','076 856 5072','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(2,2,'BL0001','Shanaka Enterprises','Godamama, meegoda','srilanka','Godamama','meegoda','60600',2,NULL,2,2,NULL,1,'browser',NULL,'077 634 1333','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(3,3,'BL0001','demo acc','address,city','srilanka','north western','maho','60600',3,NULL,3,3,NULL,1,'browser',NULL,'0123456789','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 17:44:33','2025-02-02 17:44:33'),(4,4,'BL0001','Saman Mal Bakers','312, saragama , Kurunegala','Sri lanka','North Western','Saragama','60000',4,NULL,4,4,NULL,1,'browser',NULL,'077 913 1054','078 5903746','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-10 12:16:25','2025-02-10 12:16:25'),(5,5,'BL0001','Derana Super','ගැමුණුපුර , මහියංගනය','Sri lanka','Ne','Mahiyanganaya','88889',5,5,5,5,NULL,1,'browser',NULL,'0769697134',NULL,NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\",\"account\":null},\"card\":{\"is_enabled\":\"1\",\"account\":null},\"cheque\":{\"is_enabled\":\"1\",\"account\":null},\"bank_transfer\":{\"is_enabled\":\"1\",\"account\":null},\"other\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_1\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_2\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_3\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_4\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_5\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_6\":{\"is_enabled\":\"1\",\"account\":null},\"custom_pay_7\":{\"is_enabled\":\"1\",\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-12 11:50:59','2025-02-15 03:59:28'),(6,6,'BL0001','Sanjanni International','Via Nardones 07, 80132-Napoli (NA)-IT','italy','north western','Via Nardones','21000',6,NULL,6,6,NULL,1,'browser',NULL,'3472913395','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(7,7,'BL0001','Mithilaa Holiday Resort (pvt) ltd.','No: 177,  Puttlam road, Wariyapola','Sri Lanka','north western','Wariyapola','60600',7,NULL,8,8,NULL,1,'browser',NULL,'0705707708','','','',NULL,1,'{\"cash\":{\"is_enabled\":1,\"account\":null},\"card\":{\"is_enabled\":1,\"account\":null},\"cheque\":{\"is_enabled\":1,\"account\":null},\"bank_transfer\":{\"is_enabled\":1,\"account\":null},\"other\":{\"is_enabled\":1,\"account\":null},\"custom_pay_1\":{\"is_enabled\":1,\"account\":null},\"custom_pay_2\":{\"is_enabled\":1,\"account\":null},\"custom_pay_3\":{\"is_enabled\":1,\"account\":null},\"custom_pay_4\":{\"is_enabled\":1,\"account\":null},\"custom_pay_5\":{\"is_enabled\":1,\"account\":null},\"custom_pay_6\":{\"is_enabled\":1,\"account\":null},\"custom_pay_7\":{\"is_enabled\":1,\"account\":null}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-24 12:39:17','2025-02-24 12:39:17'),(8,8,'BL0001','Randina Stores','No.27,Akuramboda Road , Pallepola','Sri Lanka','north western','Pallepola','60600',8,8,9,9,NULL,1,'browser',NULL,'071 748 7441',NULL,NULL,NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\"},\"card\":{\"is_enabled\":\"1\"},\"cheque\":{\"is_enabled\":\"1\"},\"bank_transfer\":{\"is_enabled\":\"1\"},\"other\":{\"is_enabled\":\"1\"},\"custom_pay_1\":{\"is_enabled\":\"1\"},\"custom_pay_2\":{\"is_enabled\":\"1\"},\"custom_pay_3\":{\"is_enabled\":\"1\"},\"custom_pay_4\":{\"is_enabled\":\"1\"},\"custom_pay_5\":{\"is_enabled\":\"1\"},\"custom_pay_6\":{\"is_enabled\":\"1\"},\"custom_pay_7\":{\"is_enabled\":\"1\"}}',NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-25 16:07:36','2025-02-26 10:26:27');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_denominations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_denominations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `total_count` int(11) NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_denominations_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_denominations` WRITE;
/*!40000 ALTER TABLE `cash_denominations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_denominations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pay_method` varchar(191) DEFAULT NULL,
  `type` enum('debit','credit') NOT NULL,
  `transaction_type` varchar(191) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  KEY `cash_register_transactions_type_index` (`type`),
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES (1,1,180.0000,'cash','credit','sell',2,'2025-01-29 10:55:41','2025-01-29 10:55:41'),(2,1,200.0000,'cash','credit','sell',3,'2025-01-29 11:00:27','2025-01-29 11:00:27'),(3,1,380.0000,'card','credit','sell',3,'2025-01-29 11:00:27','2025-01-29 11:00:27'),(4,1,50.0000,'cash','credit','sell',4,'2025-01-29 11:03:26','2025-01-29 11:03:26'),(5,1,150.0000,'card','credit','sell',4,'2025-01-29 11:03:26','2025-01-29 11:03:26'),(6,1,200.0000,'card','credit','sell',5,'2025-01-29 11:11:56','2025-01-29 11:11:56'),(7,1,300.0000,'cash','credit','sell',5,'2025-01-29 11:11:56','2025-01-29 11:11:56'),(8,1,220.0000,'bank_transfer','credit','sell',5,'2025-01-29 11:11:56','2025-01-29 11:11:56'),(9,1,1290.0000,'cash','credit','sell',7,'2025-01-29 11:33:21','2025-01-29 11:33:21'),(10,1,830.0000,'cash','credit','sell',8,'2025-01-29 11:35:35','2025-01-29 11:35:35'),(11,1,1700.0000,'cash','credit','sell',9,'2025-01-31 14:47:49','2025-01-31 14:47:49'),(12,1,430.0000,'cash','credit','sell',10,'2025-01-31 14:48:37','2025-01-31 14:48:37'),(13,1,430.0000,'cash','credit','sell',11,'2025-01-31 14:49:21','2025-01-31 14:49:21'),(14,1,430.0000,'cash','credit','sell',12,'2025-01-31 14:50:09','2025-01-31 14:50:09'),(15,2,5000.0000,'cash','credit','initial',NULL,'2025-02-02 19:33:45','2025-02-02 19:33:45'),(16,1,430.0000,'cash','credit','sell',15,'2025-02-05 15:13:45','2025-02-05 15:13:45'),(17,1,1350.0000,'cash','credit','sell',17,'2025-02-05 15:18:52','2025-02-05 15:18:52'),(18,1,840.0000,'cash','credit','sell',18,'2025-02-05 15:29:06','2025-02-05 15:29:06'),(19,1,430.0000,'cash','credit','sell',19,'2025-02-05 15:44:45','2025-02-05 15:44:45'),(20,1,430.0000,'cash','credit','sell',20,'2025-02-05 16:01:57','2025-02-05 16:01:57'),(21,2,580.0000,'cash','credit','sell',23,'2025-02-06 11:07:17','2025-02-06 11:07:17'),(22,2,400.0000,'cash','credit','sell',122,'2025-02-07 06:08:38','2025-02-07 06:08:38'),(23,2,400.0000,'cash','credit','sell',123,'2025-02-07 06:10:11','2025-02-07 06:10:11'),(24,2,400.0000,'cash','credit','sell',124,'2025-02-07 06:11:07','2025-02-07 06:11:07'),(25,2,400.0000,'cash','credit','sell',125,'2025-02-07 06:12:52','2025-02-07 06:12:52'),(26,2,400.0000,'cash','credit','sell',126,'2025-02-07 06:13:16','2025-02-07 06:13:16'),(27,2,200.0000,'cash','credit','sell',127,'2025-02-07 06:13:58','2025-02-07 06:13:58'),(28,2,200.0000,'cash','credit','sell',128,'2025-02-07 06:14:08','2025-02-07 06:14:08'),(29,2,980.0000,'cash','credit','sell',129,'2025-02-07 06:18:36','2025-02-07 06:18:36'),(30,2,1000.0000,'cash','credit','sell',130,'2025-02-07 07:59:05','2025-02-07 07:59:05'),(31,2,1000.0000,'cash','credit','sell',131,'2025-02-07 09:56:02','2025-02-07 09:56:02'),(32,2,2200.0000,'cash','credit','sell',132,'2025-02-07 10:11:44','2025-02-07 10:11:44'),(35,2,200.0000,'cash','credit','sell',134,'2025-02-07 16:57:16','2025-02-07 16:57:16'),(36,2,200.0000,'cash','credit','sell',135,'2025-02-07 16:59:34','2025-02-07 16:59:34'),(37,4,625.0000,'cash','credit','sell',137,'2025-02-10 12:19:20','2025-02-10 12:19:20'),(38,4,750.0000,'cash','credit','sell',138,'2025-02-10 12:24:30','2025-02-10 12:24:30'),(39,4,875.0000,'cash','credit','sell',139,'2025-02-10 12:28:02','2025-02-10 12:28:02'),(40,4,875.0000,'cash','credit','sell',140,'2025-02-10 12:30:33','2025-02-10 12:30:33'),(41,4,375.0000,'cash','credit','sell',141,'2025-02-10 12:32:31','2025-02-10 12:32:31'),(42,4,600.0000,'cash','credit','sell',143,'2025-02-10 13:36:14','2025-02-10 13:36:14'),(43,4,100.0000,'cash','credit','sell',144,'2025-02-10 13:45:58','2025-02-10 13:45:58'),(44,4,150.0000,'cash','credit','sell',145,'2025-02-10 13:52:47','2025-02-10 13:52:47'),(45,4,100.0000,'cash','credit','sell',146,'2025-02-10 13:56:29','2025-02-10 13:56:29'),(46,5,2000.0000,'cash','credit','initial',NULL,'2025-02-10 14:08:36','2025-02-10 14:08:36'),(47,5,50.0000,'cash','credit','sell',147,'2025-02-10 14:09:26','2025-02-10 14:09:26'),(48,5,125.0000,'cash','credit','sell',148,'2025-02-10 14:09:38','2025-02-10 14:09:38'),(49,5,750.0000,'cash','credit','sell',149,'2025-02-10 14:12:11','2025-02-10 14:12:11'),(50,2,200.0000,'cash','credit','sell',152,'2025-02-12 20:06:37','2025-02-12 20:06:37'),(51,2,200.0000,'custom_pay_1','credit','sell',152,'2025-02-12 20:06:37','2025-02-12 20:06:37'),(52,2,1200.0000,'cash','credit','sell',153,'2025-02-12 20:07:32','2025-02-12 20:07:32'),(53,2,5200.0000,'cash','credit','sell',156,'2025-02-12 20:13:21','2025-02-12 20:13:21'),(54,2,600.0000,'cash','credit','sell',157,'2025-02-12 20:19:56','2025-02-12 20:19:56'),(55,2,1400.0000,'cash','credit','sell',155,'2025-02-12 20:20:08','2025-02-12 20:20:08'),(56,2,2100.0000,'cash','credit','sell',154,'2025-02-12 20:20:22','2025-02-12 20:20:22'),(74,6,135.0000,'cash','credit','sell',1874,'2025-02-13 14:26:03','2025-02-13 14:26:03'),(75,6,135.0000,'cash','credit','sell',1875,'2025-02-13 14:33:03','2025-02-13 14:33:03'),(76,6,160.0000,'cash','credit','sell',1876,'2025-02-14 02:26:30','2025-02-14 02:26:30'),(77,6,400.0000,'cash','credit','sell',1877,'2025-02-14 02:29:57','2025-02-14 02:29:57'),(78,6,385.0000,'cash','credit','sell',1878,'2025-02-14 13:10:37','2025-02-14 13:10:37'),(79,6,1135.0000,'cash','credit','sell',1879,'2025-02-14 13:23:52','2025-02-14 13:23:52'),(80,6,545.0000,'cash','credit','sell',1881,'2025-02-14 14:49:58','2025-02-14 14:49:58'),(81,6,650.0000,'cash','credit','sell',1882,'2025-02-14 18:32:00','2025-02-14 18:32:00'),(82,6,425.0000,'cash','credit','sell',1883,'2025-02-14 18:33:48','2025-02-14 18:33:48'),(83,6,340.0000,'cash','credit','sell',1884,'2025-02-14 18:35:14','2025-02-14 18:35:14'),(84,6,90.0000,'cash','credit','sell',1885,'2025-02-14 19:41:28','2025-02-14 19:41:28'),(85,6,90.0000,'cash','credit','sell',1886,'2025-02-14 20:03:59','2025-02-14 20:03:59'),(86,6,340.0000,'cash','credit','sell',1887,'2025-02-14 20:04:23','2025-02-14 20:04:23'),(87,6,316.0000,'cash','credit','sell',1888,'2025-02-14 20:05:23','2025-02-14 20:05:23'),(88,6,10.0000,'cash','credit','sell',1889,'2025-02-14 20:09:25','2025-02-14 20:09:25'),(89,6,68.0000,'cash','credit','sell',1890,'2025-02-14 20:17:30','2025-02-14 20:17:30'),(90,6,385.0000,'cash','credit','sell',1891,'2025-02-14 20:18:40','2025-02-14 20:18:40'),(91,6,79.0000,'cash','credit','sell',1892,'2025-02-14 20:19:55','2025-02-14 20:19:55'),(92,6,391.0000,'cash','credit','sell',1893,'2025-02-14 20:20:32','2025-02-14 20:20:32'),(93,6,69.0000,'cash','credit','sell',1894,'2025-02-14 20:21:36','2025-02-14 20:21:36'),(94,6,1170.0000,'cash','credit','sell',1895,'2025-02-15 04:00:55','2025-02-15 04:00:55'),(95,6,56.0000,'cash','credit','sell',1896,'2025-02-15 04:33:09','2025-02-15 04:33:09'),(96,6,113.0000,'cash','credit','sell',1897,'2025-02-15 04:38:28','2025-02-15 04:38:28'),(97,6,220.0000,'cash','credit','sell',1899,'2025-02-15 05:59:03','2025-02-15 05:59:03'),(98,6,135.0000,'cash','credit','sell',1900,'2025-02-15 06:02:44','2025-02-15 06:02:44'),(99,6,225.0000,'cash','credit','sell',1901,'2025-02-16 03:34:18','2025-02-16 03:34:18'),(100,6,635.0000,'cash','credit','sell',1903,'2025-02-16 05:23:07','2025-02-16 05:23:07'),(101,6,40.0000,'cash','credit','sell',1904,'2025-02-17 13:25:31','2025-02-17 13:25:31'),(102,6,220.0000,'cash','credit','sell',1905,'2025-02-18 05:55:45','2025-02-18 05:55:45'),(103,6,2200.0000,'cash','credit','sell',1906,'2025-02-18 05:56:31','2025-02-18 05:56:31'),(104,6,5000.0000,'cash','credit','sell',1907,'2025-02-18 06:13:39','2025-02-18 06:13:39'),(105,6,-2800.0000,'cash','credit','sell',1907,'2025-02-18 06:13:39','2025-02-18 06:13:39'),(106,6,5000.0000,'cash','credit','sell',1908,'2025-02-18 06:22:19','2025-02-18 06:22:19'),(107,6,-2800.0000,'cash','credit','sell',1908,'2025-02-18 06:22:19','2025-02-18 06:22:19'),(108,6,2200.0000,'cash','credit','sell',1909,'2025-02-18 06:38:25','2025-02-18 06:38:25'),(109,2,400.0000,'cash','credit','sell',1910,'2025-02-22 04:39:32','2025-02-22 04:39:32'),(110,2,1000.0000,'cash','credit','sell',1911,'2025-02-22 04:53:18','2025-02-22 04:53:18'),(111,2,200.0000,'cash','credit','sell',1912,'2025-02-22 14:55:14','2025-02-22 14:55:14'),(112,2,1000.0000,'cash','credit','sell',1913,'2025-02-22 16:45:17','2025-02-22 16:45:17'),(113,2,200.0000,'cash','credit','sell',1915,'2025-02-22 16:47:39','2025-02-22 16:47:39'),(114,2,245.0000,'cash','credit','sell',1916,'2025-02-22 16:49:18','2025-02-22 16:49:18'),(115,2,1600.0000,'cash','credit','sell',1917,'2025-02-22 16:49:55','2025-02-22 16:49:55'),(116,2,600.0000,'cash','credit','sell',1918,'2025-02-22 17:24:22','2025-02-22 17:24:22'),(117,2,800.0000,'cash','credit','sell',1919,'2025-02-22 17:24:31','2025-02-22 17:24:31'),(118,2,20000.0000,'cash','debit','expense',1922,'2025-02-22 17:28:30','2025-02-22 17:28:30'),(119,2,400.0000,'cash','credit','sell',1923,'2025-02-23 10:04:21','2025-02-23 10:04:21'),(120,2,950.0000,'card','credit','sell',1924,'2025-02-23 10:05:05','2025-02-23 10:05:05'),(121,2,400.0000,'cash','credit','sell',1925,'2025-02-23 13:54:17','2025-02-23 13:54:17'),(122,2,400.0000,'cash','credit','sell',1926,'2025-02-23 14:20:34','2025-02-23 14:20:34'),(123,2,400.0000,'cash','credit','sell',1927,'2025-02-24 10:34:48','2025-02-24 10:34:48'),(124,8,5000.0000,'cash','credit','initial',NULL,'2025-02-25 11:29:51','2025-02-25 11:29:51'),(125,8,2000.0000,'cash','credit','sell',1928,'2025-02-25 11:32:19','2025-02-25 11:32:19'),(126,8,3000.0000,'cash','credit','sell',1929,'2025-02-25 11:36:34','2025-02-25 11:36:34'),(127,8,3500.0000,'cash','credit','sell',1930,'2025-02-25 11:52:00','2025-02-25 11:52:00'),(196,9,1020.0000,'cash','credit','sell',3731,'2025-02-27 03:12:42','2025-02-27 03:12:42'),(197,9,1020.0000,'cash','credit','sell',3732,'2025-02-27 03:37:48','2025-02-27 03:37:48'),(198,9,1020.0000,'cash','credit','sell',3733,'2025-02-27 03:39:19','2025-02-27 03:39:19'),(199,9,2179.0000,'cash','credit','sell',3734,'2025-02-27 03:45:09','2025-02-27 03:45:09'),(200,9,2360.0000,'cash','credit','sell',3735,'2025-02-27 03:47:10','2025-02-27 03:47:10'),(201,9,2360.0000,'cash','credit','sell',3736,'2025-02-27 03:47:11','2025-02-27 03:47:11'),(202,9,2360.0000,'cash','credit','sell',3737,'2025-02-27 03:47:11','2025-02-27 03:47:11'),(203,9,2360.0000,'cash','credit','sell',3738,'2025-02-27 03:47:12','2025-02-27 03:47:12'),(204,9,2360.0000,'cash','credit','sell',3739,'2025-02-27 03:47:12','2025-02-27 03:47:12'),(205,9,2360.0000,'cash','credit','sell',3740,'2025-02-27 03:47:13','2025-02-27 03:47:13'),(206,9,2360.0000,'cash','credit','sell',3741,'2025-02-27 03:47:13','2025-02-27 03:47:13'),(207,9,2360.0000,'cash','credit','sell',3742,'2025-02-27 03:47:13','2025-02-27 03:47:13'),(208,9,2360.0000,'cash','credit','sell',3743,'2025-02-27 03:47:13','2025-02-27 03:47:13'),(209,9,2360.0000,'cash','credit','sell',3744,'2025-02-27 03:47:14','2025-02-27 03:47:14'),(210,9,2360.0000,'cash','credit','sell',3745,'2025-02-27 03:47:15','2025-02-27 03:47:15'),(211,9,2360.0000,'cash','credit','sell',3746,'2025-02-27 03:47:15','2025-02-27 03:47:15'),(212,9,2360.0000,'cash','credit','sell',3747,'2025-02-27 03:47:15','2025-02-27 03:47:15'),(213,9,2360.0000,'cash','credit','sell',3748,'2025-02-27 03:47:16','2025-02-27 03:47:16'),(214,9,2360.0000,'cash','credit','sell',3749,'2025-02-27 03:47:16','2025-02-27 03:47:16'),(215,9,2360.0000,'cash','credit','sell',3750,'2025-02-27 03:47:16','2025-02-27 03:47:16'),(216,9,2360.0000,'cash','credit','sell',3751,'2025-02-27 03:47:17','2025-02-27 03:47:17'),(217,9,2360.0000,'cash','credit','sell',3752,'2025-02-27 03:47:18','2025-02-27 03:47:18'),(218,9,2360.0000,'cash','credit','sell',3753,'2025-02-27 03:47:18','2025-02-27 03:47:18'),(219,9,2360.0000,'cash','credit','sell',3754,'2025-02-27 03:47:18','2025-02-27 03:47:18'),(220,9,2360.0000,'cash','credit','sell',3755,'2025-02-27 03:47:18','2025-02-27 03:47:18'),(221,9,2360.0000,'cash','credit','sell',3756,'2025-02-27 03:47:19','2025-02-27 03:47:19'),(222,9,2360.0000,'cash','credit','sell',3757,'2025-02-27 03:47:19','2025-02-27 03:47:19'),(223,9,2360.0000,'cash','credit','sell',3758,'2025-02-27 03:47:19','2025-02-27 03:47:19'),(224,9,2360.0000,'cash','credit','sell',3759,'2025-02-27 03:47:20','2025-02-27 03:47:20'),(225,9,2360.0000,'cash','credit','sell',3760,'2025-02-27 03:47:21','2025-02-27 03:47:21'),(226,9,2360.0000,'cash','credit','sell',3761,'2025-02-27 03:47:21','2025-02-27 03:47:21'),(227,9,2360.0000,'cash','credit','sell',3762,'2025-02-27 03:47:21','2025-02-27 03:47:21'),(228,9,2360.0000,'cash','credit','sell',3763,'2025-02-27 03:47:22','2025-02-27 03:47:22'),(229,9,2360.0000,'cash','credit','sell',3764,'2025-02-27 03:47:22','2025-02-27 03:47:22'),(230,9,2360.0000,'cash','credit','sell',3765,'2025-02-27 03:47:23','2025-02-27 03:47:23'),(231,9,2360.0000,'cash','credit','sell',3766,'2025-02-27 03:47:23','2025-02-27 03:47:23'),(232,9,2360.0000,'cash','credit','sell',3767,'2025-02-27 03:47:23','2025-02-27 03:47:23'),(233,9,2360.0000,'cash','credit','sell',3768,'2025-02-27 03:47:24','2025-02-27 03:47:24'),(234,9,2360.0000,'cash','credit','sell',3769,'2025-02-27 03:47:24','2025-02-27 03:47:24'),(235,9,2360.0000,'cash','credit','sell',3770,'2025-02-27 03:47:25','2025-02-27 03:47:25'),(236,9,2360.0000,'cash','credit','sell',3771,'2025-02-27 03:47:25','2025-02-27 03:47:25'),(237,9,2360.0000,'cash','credit','sell',3772,'2025-02-27 03:47:25','2025-02-27 03:47:25'),(238,9,2360.0000,'cash','credit','sell',3773,'2025-02-27 03:47:26','2025-02-27 03:47:26'),(239,9,2360.0000,'cash','credit','sell',3774,'2025-02-27 03:47:26','2025-02-27 03:47:26'),(240,9,2360.0000,'cash','credit','sell',3775,'2025-02-27 03:47:26','2025-02-27 03:47:26'),(241,2,200.0000,'cash','credit','sell',3776,'2025-03-01 16:46:01','2025-03-01 16:46:01'),(242,2,-10.0000,'cash','credit','sell',3776,'2025-03-01 16:46:01','2025-03-01 16:46:01'),(243,8,16000.0000,'cash','credit','sell',3777,'2025-03-02 06:05:50','2025-03-02 06:05:50'),(244,8,19500.0000,'cash','credit','sell',3778,'2025-03-02 06:06:28','2025-03-02 06:06:28'),(245,8,6500.0000,'cash','credit','sell',3779,'2025-03-02 06:07:19','2025-03-02 06:07:19'),(246,7,17940.0000,'cash','credit','sell',3781,'2025-03-02 06:27:20','2025-03-02 06:27:20'),(247,2,200.0000,'cash','credit','sell',3782,'2025-03-03 07:25:11','2025-03-03 07:25:11'),(248,2,1000.0000,'cash','credit','sell',3783,'2025-03-03 07:25:54','2025-03-03 07:25:54'),(249,2,-800.0000,'cash','credit','sell',3783,'2025-03-03 07:25:54','2025-03-03 07:25:54'),(250,2,200.0000,'cash','credit','sell',3784,'2025-03-03 08:22:52','2025-03-03 08:22:52'),(251,2,200.0000,'cash','credit','sell',3785,'2025-03-03 09:18:37','2025-03-03 09:18:37'),(252,2,100.0000,'cash','credit','sell',3786,'2025-03-03 09:20:15','2025-03-03 09:20:15'),(253,2,400.0000,'cash','credit','sell',3787,'2025-03-03 16:56:48','2025-03-03 16:56:48');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_card_slips` int(11) NOT NULL DEFAULT 0,
  `total_cheques` int(11) NOT NULL DEFAULT 0,
  `denominations` text DEFAULT NULL,
  `closing_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES (1,1,1,1,'open',NULL,0.0000,0,0,NULL,NULL,'2025-01-29 10:55:00','2025-01-29 10:55:23'),(2,3,3,3,'open',NULL,0.0000,0,0,NULL,NULL,'2025-02-02 19:33:00','2025-02-02 19:33:45'),(3,2,2,2,'open',NULL,0.0000,0,0,NULL,NULL,'2025-02-03 14:35:00','2025-02-03 14:35:18'),(4,4,4,6,'open',NULL,0.0000,0,0,NULL,NULL,'2025-02-10 12:19:00','2025-02-10 12:19:10'),(5,4,4,7,'open',NULL,0.0000,0,0,NULL,NULL,'2025-02-10 14:08:00','2025-02-10 14:08:36'),(6,5,5,8,'open',NULL,0.0000,0,0,NULL,NULL,'2025-02-13 02:36:00','2025-02-13 02:36:39'),(7,7,7,12,'open',NULL,0.0000,0,0,NULL,NULL,'2025-02-25 09:13:00','2025-02-25 09:13:59'),(8,7,7,10,'open',NULL,0.0000,0,0,NULL,NULL,'2025-02-25 11:29:00','2025-02-25 11:29:51'),(9,8,8,13,'open',NULL,0.0000,0,0,NULL,NULL,'2025-02-25 16:29:00','2025-02-25 16:29:02'),(10,7,7,11,'open',NULL,0.0000,0,0,NULL,NULL,'2025-03-02 06:40:00','2025-03-02 06:40:50');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_cat_id` int(11) DEFAULT NULL,
  `category_type` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `slug` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_woocommerce_cat_id_index` (`woocommerce_cat_id`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (3,'22',3,NULL,0,3,NULL,'product',NULL,NULL,NULL,'2025-02-07 06:08:06','2025-02-07 06:08:06'),(4,'room',7,NULL,0,12,NULL,'product',NULL,NULL,NULL,'2025-02-25 09:13:03','2025-02-25 09:13:03'),(11,'Short time',7,NULL,0,12,NULL,'product',NULL,NULL,NULL,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(12,'Day time',7,NULL,0,12,NULL,'product',NULL,NULL,NULL,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(13,'Night time',7,NULL,0,12,NULL,'product',NULL,NULL,NULL,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(14,'Full day time',7,NULL,0,12,NULL,'product',NULL,NULL,NULL,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(15,'FAMILY ROOM',7,NULL,0,12,NULL,'product',NULL,NULL,NULL,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(16,'VIP ROOM',7,NULL,0,12,NULL,'product',NULL,NULL,NULL,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(17,'SALE',8,'122',0,13,NULL,'hrm_department',NULL,NULL,NULL,'2025-02-25 17:07:18','2025-02-25 17:07:18'),(18,'85A',3,'toner compatible',0,3,NULL,'product',NULL,NULL,NULL,'2025-03-03 12:40:56','2025-03-03 12:40:56');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cms_page_metas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_page_metas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cms_page_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(191) NOT NULL,
  `meta_value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cms_page_metas_cms_page_id_foreign` (`cms_page_id`),
  CONSTRAINT `cms_page_metas_cms_page_id_foreign` FOREIGN KEY (`cms_page_id`) REFERENCES `cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cms_page_metas` WRITE;
/*!40000 ALTER TABLE `cms_page_metas` DISABLE KEYS */;
INSERT INTO `cms_page_metas` VALUES (1,3,'industry','{\"id\":\"1\",\"title\":\"We\'re Ready For Your Business!\",\"description\":\"<p>If you\'re in need of business management software, you\'ve come to the right place.&nbsp;<\\/p>\\r\\n<p>We have a clean, modern modular design that is sure to fit your business!<\\/p>\",\"content\":[{\"icon\":\"fas fa-store-alt\",\"title\":\"Departmental Store\",\"description\":\"Looking for a software solution that can help you manage and sell all of your essential items in one place? Look no further than our one-stop departmental store software. Whether you need to sell clothes, shoes, bags, or any other type of item, our software has you covered. Plus, our easy-to-use interface makes it simple to get started selling right away. So why wait? Get started today!\"},{\"icon\":\"fas fa-store\",\"title\":\"Retail & Wholesale\",\"description\":\"A complete suite of features to manage both retail & wholesales stores. Set multiple prices for different customer segments or different business locations.\"},{\"icon\":\"fas fa-notes-medical\",\"title\":\"Pharmacy\",\"description\":\"Our software is perfect for any pharmaceutical company. You can set product expiration dates and lot numbers, and sell in different units of measure. Stop selling expired & to-be-expired items to customers. Check details reports on stock expiry by lot numbers\"},{\"icon\":\"fas fa-prescription-bottle\",\"title\":\"Liquor\",\"description\":\"Easy to use for every liquor shop. Sell in ml of simple sell the bottle, you can easily manage them.\"},{\"icon\":\"fas fa-mobile-alt\",\"title\":\"Mobile & Electronics\",\"description\":\"Record inventory serial number, sell items with particular serial number,\"},{\"icon\":\"fas fa-wrench\",\"title\":\"Repair Shop\",\"description\":\"A complete suite of features to manage repair business, create job sheet, assign job sheet to technician, repair status, convert job sheet to invoices. Self link for customers to check repair progress\"},{\"icon\":\"fas fa-home\",\"title\":null,\"description\":null},{\"icon\":\"fas fa-home\",\"title\":null,\"description\":null}]}',NULL,'2022-10-20 11:00:15'),(2,3,'feature','{\"id\":\"2\",\"title\":\"Features to skyrocket \\ud83d\\ude80 your business growth\",\"description\":\"<p>The pace of business growth has never been faster.<\\/p>\\r\\n<p>That\'s why we&rsquo;ve designed our cloud-based POS software to help you get ahead.<\\/p>\\r\\n<p>The easiest, most reliable way to grow and manage your business is right at your fingertips with our cloud-based POS and inventory management system.<\\/p>\\r\\n<p>Right software can be a lifesaver for your business, and with it, you can revolutionize your business\'s growth<\\/p>\",\"content\":[{\"icon\":\"fas fa-cloud\",\"title\":\"Access Anywhere!\",\"description\":\"Check your business data from anywhere, anytime. \\r\\nSee live updates in realtime\"},{\"icon\":\"fas fa-check-double\",\"title\":\"No Installation\",\"description\":\"No software to install, No hardware dependency. Just open browser & start using.\"},{\"icon\":\"fas fa-sitemap\",\"title\":\"MultiBranches & Warehouse\",\"description\":\"Manage stock of multiple branches  in one place effortlessly & real-time.\"},{\"icon\":\"fas fa-user-lock\",\"title\":\"User access limit\",\"description\":\"Powerful user Role & Permission management to limit employees  access to business data\"},{\"icon\":\"fas fa-cubes\",\"title\":\"Stock Management\",\"description\":\"Manage stocks with from multiple locations, stock expiry, lot number, stock history & much more.\"},{\"icon\":\"fas fa-wrench\",\"title\":\"Service Management\",\"description\":\"Manage & easily invoice for services. Also dedicated repair service management features to schedule & deliver services on time\"},{\"icon\":\"fas fa-users\",\"title\":\"HR Management\",\"description\":\"With HR management easily track daily attendance, shift management, leaves, payroll, Holidays, Departments,  & Designations\"},{\"icon\":\"fas fa-handshake\",\"title\":\"Customer Management\",\"description\":\"CRM module help you to track leads lifecycle, followup with leads, sources, followup, launch campaigns, proposals and lot more\"},{\"icon\":\"fas fa-hand-peace\",\"title\":\"Simplified Interface\",\"description\":\"Simple to use interface to get work done in few clicks. Save your time & make it easy for staffs to use.\"},{\"icon\":\"fas fa-chart-line\",\"title\":\"Reports\",\"description\":\"Comes inbuilt with lot of report to help business owners analyse every revenue, inventory, payments & human resource.\"}]}','2022-09-15 10:04:41','2022-10-20 10:09:11');
/*!40000 ALTER TABLE `cms_page_metas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cms_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) NOT NULL,
  `layout` varchar(191) DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `content` longtext DEFAULT NULL,
  `meta_description` text DEFAULT NULL,
  `tags` varchar(191) DEFAULT NULL,
  `feature_image` varchar(191) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cms_pages` WRITE;
/*!40000 ALTER TABLE `cms_pages` DISABLE KEYS */;
INSERT INTO `cms_pages` VALUES (1,'testimonial',NULL,'David Parr','<p class=\"testimonial-card-1__paragraph mb-3\">This software has become one of the backbones of our business. It helped us streamline the data of all our warehouses &amp; shops on one platform. I am not much of a techy guy but the admin panel also allows you to customize every aspect of the application.</p>\r\n          <p class=\"testimonial-card-1__paragraph mb-3\">All the reports help me to give an overview of different aspects of our business.</p>\r\n          <p class=\"testimonial-card-1__paragraph mb-3\">It is very powerful!</p>',NULL,NULL,NULL,3,9,1,'2022-08-19 05:55:05','2022-10-20 12:18:29'),(2,'testimonial',NULL,'Tim Johnson','<p>It is truly designed to help my business run more smoothly and efficiently. I can now track and manage inventory, customer information, and sales easily. The installation was quick and easy, and the interface is very user-friendly. I can now manage almost every business operation with one single software!</p>',NULL,NULL,NULL,NULL,1,1,'2022-09-10 10:37:17','2022-10-20 11:53:39'),(3,'page','home','Automate your business management at very-Low cost','<p>Best POS, Invoicing, Inventory &amp; Service management application for your growing business!</p>',NULL,NULL,NULL,1,0,1,'2022-09-10 10:56:24','2022-10-20 11:00:15'),(4,'page','contact','Contact Us','<p>We\'re happy to receive your message. Ask us anything, we\'ll respond as soon as possible.</p>',NULL,NULL,NULL,NULL,0,1,'2022-09-10 10:56:24','2022-09-16 06:34:20'),(5,'testimonial',NULL,'Krishna Watt','<p>We have used this for 9 months now. It has helped our business grow by leaps and bounds. The interface and its simplicity have made it easy for us to learn and get familiar with. The best thing about this software is that it is cloud-based and we can use it from our shop, warehouse, or mobile while traveling. I can also see its potential as we continue to grow. Highly Satisfied!</p>',NULL,NULL,NULL,NULL,1,1,'2022-09-16 06:37:25','2022-10-20 11:57:31');
/*!40000 ALTER TABLE `cms_pages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cms_site_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cms_site_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `site_key` varchar(191) NOT NULL,
  `site_value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cms_site_details` WRITE;
/*!40000 ALTER TABLE `cms_site_details` DISABLE KEYS */;
INSERT INTO `cms_site_details` VALUES (1,'faqs','[{\"question\":\"Why should we switch to cloud-based business management software compared to traditional desktop software?\",\"answer\":\"Cloud-based software provides you a low-cost, secure & mobile software solutions. Compared to traditional software that requires it to install on a computer - cloud-based can be accessed from anywhere without any hardware dependency.\"},{\"question\":\"How secure is my business data?\",\"answer\":\"All data are stored in our centralized database which is highly protected with multi-layers of privileges. We takes regular frequency interval automated backup to protect from any unwanted consequences.\"},{\"question\":\"Whom should I reach out to in case of any problems?\",\"answer\":\"Please contact our support, write us in the contact section or call to the number mentioned. You\'re assured to receive a response in a maximum of 24 hours.\"},{\"question\":\"Is this POS application Free?\",\"answer\":\"We do provide a free tier for very small business or business that is about to start. To take more advantage of this POS software we recommend that you upgrade to a better plan that unlocks more features.\"},{\"question\":\"Do you provide consultancy or implementation solutions for using this POS software?\",\"answer\":\"Yes, with a pro plan you can connect with one of our experts who will help you with implementing the solution for your business.\"},{\"question\":\"Are there any additional hardware required or subscription charges?\",\"answer\":\"This is cloud-based software. You\'ll only need a device with an internet connection & chrome browser. It runs within the browser. No additional hardware is required. But you can use some hardware like barcode scanners, and printers for your convenience to speed up work.\"}]','2022-09-13 13:14:10','2022-10-20 11:46:28'),(2,'statistics','{\"tagline\":\"POS\'s Stats & Numbers\",\"description\":\"More & More businesses are adopting our cloud-based business management solution\",\"content\":[{\"stats\":\"75\",\"title\":\"REGISTERED BUSINESSES\"},{\"stats\":\"400+\",\"title\":\"DAILY USERS\"},{\"stats\":\"50K\",\"title\":\"INVOICES CREATED\"},{\"stats\":\"126+\",\"title\":\"ONLINE RESOURCES\"}]}','2022-09-13 13:14:10','2022-10-20 11:38:07'),(3,'google_analytics','null','2022-09-14 05:44:40','2022-09-16 06:19:09'),(4,'fb_pixel','null','2022-09-14 05:44:40','2022-09-16 06:19:09'),(5,'custom_js','null','2022-09-14 05:44:40','2022-09-16 06:19:09'),(6,'custom_css','null','2022-09-14 05:44:40','2022-09-16 06:19:09'),(7,'meta_tags','null','2022-09-14 05:44:40','2022-09-16 06:19:09'),(8,'chat_widget','null','2022-09-14 05:57:14','2022-09-16 06:19:09'),(9,'contact_us','[{\"label\":\"Call\",\"num\":\"0000000000\"},{\"label\":\"Support\",\"num\":\"0000000000\"},{\"label\":\"Enquiry\",\"num\":\"0000000000\"}]','2022-09-14 06:54:38','2022-09-16 06:19:09'),(10,'mail_us','[{\"label\":\"Contact\",\"email\":\"contact@example.com\"},{\"label\":\"Support\",\"email\":\"support@example.com\"}]','2022-09-14 06:54:38','2022-09-16 06:19:09'),(11,'follow_us','{\"facebook\":\"https:\\/\\/www.facebook.com\\/test\",\"instagram\":\"https:\\/\\/www.instagram.com\\/test\",\"twitter\":\"https:\\/\\/twitter.com\\/test\",\"linkedin\":\"https:\\/\\/in.linkedin.com\\/company\\/test\",\"youtube\":\"https:\\/\\/www.youtube.com\\/c\\/test\"}','2022-09-14 07:05:39','2022-10-20 11:38:07'),(12,'logo','null','2022-09-14 08:08:53','2022-09-16 06:19:09'),(13,'notifiable_email','\"notifyme@example.com\"','2022-09-14 08:08:53','2022-09-16 06:19:09');
/*!40000 ALTER TABLE `cms_site_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) NOT NULL,
  `supplier_business_name` varchar(191) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `prefix` varchar(191) DEFAULT NULL,
  `first_name` varchar(191) DEFAULT NULL,
  `middle_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `contact_id` varchar(191) DEFAULT NULL,
  `contact_status` varchar(191) NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `address_line_1` text DEFAULT NULL,
  `address_line_2` text DEFAULT NULL,
  `zip_code` varchar(191) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) NOT NULL,
  `landline` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `converted_by` int(11) DEFAULT NULL,
  `converted_on` datetime DEFAULT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_rp` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `shipping_address` text DEFAULT NULL,
  `shipping_custom_field_details` longtext DEFAULT NULL,
  `is_export` tinyint(1) NOT NULL DEFAULT 0,
  `export_custom_field_1` varchar(191) DEFAULT NULL,
  `export_custom_field_2` varchar(191) DEFAULT NULL,
  `export_custom_field_3` varchar(191) DEFAULT NULL,
  `export_custom_field_4` varchar(191) DEFAULT NULL,
  `export_custom_field_5` varchar(191) DEFAULT NULL,
  `export_custom_field_6` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `crm_source` varchar(191) DEFAULT NULL,
  `crm_life_stage` varchar(191) DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `custom_field5` varchar(191) DEFAULT NULL,
  `custom_field6` varchar(191) DEFAULT NULL,
  `custom_field7` varchar(191) DEFAULT NULL,
  `custom_field8` varchar(191) DEFAULT NULL,
  `custom_field9` varchar(191) DEFAULT NULL,
  `custom_field10` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`),
  KEY `contacts_crm_source_index` (`crm_source`),
  KEY `contacts_crm_life_stage_index` (`crm_life_stage`),
  KEY `contacts_converted_by_index` (`converted_by`),
  CONSTRAINT `contacts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contacts_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,1,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(2,2,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,2,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(3,3,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,3,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-02 17:44:33','2025-02-02 17:44:33'),(4,2,'customer',NULL,'deshan kavindu',NULL,'deshan','kavindu',NULL,NULL,'10','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0726779895',NULL,NULL,NULL,NULL,100000.0000,2,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'https://maps.app.goo.gl/rhdf4UskjuS5x94D9','https://www.google.com/maps/dir/7.521693,80.657737/7.524697,80.665376/7.52199,80.66786/7.522001,80.680826/7.519246,80.676738/@7.5215888,80.6614034,15.75z?entry=ttu&g_ep=EgoyMDI1MDEyOS4xIKXMDS',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-03 08:59:47','2025-02-03 08:59:47'),(5,2,'customer',NULL,'',NULL,NULL,NULL,NULL,NULL,'820202317v','active',NULL,'Godagama',NULL,NULL,NULL,NULL,NULL,NULL,'0776341333',NULL,NULL,NULL,'days',5.0000,2,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-04 12:24:06','2025-02-04 12:24:06'),(6,2,'customer',NULL,'Shanaka Thalangama T A',NULL,'Shanaka','Thalangama','T A',NULL,'CO0004','active',NULL,'Godagama',NULL,NULL,NULL,NULL,NULL,NULL,'0776341333',NULL,NULL,NULL,'days',NULL,2,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-04 12:28:34','2025-02-04 12:28:34'),(7,4,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,6,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-10 12:16:25','2025-02-10 12:16:25'),(8,5,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,8,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-12 11:50:59','2025-02-12 11:50:59'),(9,3,'customer',NULL,'Oshan Mihira',NULL,'Oshan',NULL,'Mihira','firstofsolutions@gmail.com','CO0002','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0775652000',NULL,NULL,NULL,NULL,5000.0000,3,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-12 20:12:05','2025-02-12 20:12:05'),(10,6,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,9,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(11,5,'customer',NULL,'Miss ශ්‍රියානී','Miss','ශ්‍රියානී',NULL,NULL,NULL,'CO0002','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0702317608',NULL,NULL,NULL,NULL,NULL,8,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-18 06:32:28','2025-02-18 06:32:28'),(12,7,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,10,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-24 12:39:17','2025-02-24 12:39:17'),(13,8,'customer',NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,13,NULL,NULL,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-25 16:07:36','2025-02-25 16:07:36'),(14,8,'customer',NULL,'aa aa','aa','aa',NULL,NULL,NULL,'00340','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'07777777',NULL,NULL,NULL,NULL,NULL,13,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-25 18:22:29','2025-02-25 18:22:29'),(15,8,'customer',NULL,'nkjhkkj',NULL,'nkjhkkj',NULL,NULL,NULL,'CO0003','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2123251',NULL,NULL,NULL,NULL,NULL,13,NULL,NULL,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-02-26 11:49:17','2025-02-26 11:49:17');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_call_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_call_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `call_type` varchar(191) DEFAULT NULL,
  `mobile_number` varchar(191) NOT NULL,
  `mobile_name` varchar(191) DEFAULT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `start_time` datetime DEFAULT NULL,
  `end_time` datetime DEFAULT NULL,
  `duration` int(11) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_call_logs_business_id_index` (`business_id`),
  KEY `crm_call_logs_user_id_index` (`user_id`),
  KEY `crm_call_logs_contact_id_index` (`contact_id`),
  KEY `crm_call_logs_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_call_logs` WRITE;
/*!40000 ALTER TABLE `crm_call_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_call_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_campaigns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_campaigns` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `campaign_type` enum('sms','email') NOT NULL DEFAULT 'email',
  `subject` varchar(191) DEFAULT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `sent_on` datetime DEFAULT NULL,
  `contact_ids` text NOT NULL,
  `additional_info` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_campaigns_business_id_foreign` (`business_id`),
  KEY `crm_campaigns_created_by_index` (`created_by`),
  CONSTRAINT `crm_campaigns_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_campaigns` WRITE;
/*!40000 ALTER TABLE `crm_campaigns` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_campaigns` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_contact_person_commissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_contact_person_commissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_person_id` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `commission_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_contact_person_commissions` WRITE;
/*!40000 ALTER TABLE `crm_contact_person_commissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_contact_person_commissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_followup_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_followup_invoices` (
  `follow_up_id` int(11) NOT NULL,
  `transaction_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_followup_invoices` WRITE;
/*!40000 ALTER TABLE `crm_followup_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_followup_invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_lead_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_lead_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_lead_users_user_id_index` (`user_id`),
  KEY `crm_lead_users_contact_id_index` (`contact_id`),
  CONSTRAINT `crm_lead_users_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_lead_users` WRITE;
/*!40000 ALTER TABLE `crm_lead_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_lead_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_marketplaces`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_marketplaces` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `marketplace` varchar(191) DEFAULT NULL,
  `site_key` varchar(191) DEFAULT NULL,
  `site_id` varchar(191) DEFAULT NULL,
  `assigned_users` text DEFAULT NULL,
  `crm_source_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_marketplaces` WRITE;
/*!40000 ALTER TABLE `crm_marketplaces` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_marketplaces` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_proposal_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_proposal_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `subject` text NOT NULL,
  `body` longtext NOT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_proposal_templates_business_id_foreign` (`business_id`),
  KEY `crm_proposal_templates_created_by_index` (`created_by`),
  CONSTRAINT `crm_proposal_templates_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_proposal_templates` WRITE;
/*!40000 ALTER TABLE `crm_proposal_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_proposal_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_proposals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_proposals` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) unsigned NOT NULL,
  `subject` text NOT NULL,
  `body` longtext NOT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `sent_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_proposals_business_id_foreign` (`business_id`),
  KEY `crm_proposals_contact_id_foreign` (`contact_id`),
  KEY `crm_proposals_sent_by_index` (`sent_by`),
  CONSTRAINT `crm_proposals_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `crm_proposals_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_proposals` WRITE;
/*!40000 ALTER TABLE `crm_proposals` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_proposals` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedule_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_schedule_logs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` bigint(20) unsigned NOT NULL,
  `log_type` enum('call','sms','meeting','email') NOT NULL DEFAULT 'email',
  `start_datetime` datetime NOT NULL,
  `end_datetime` datetime NOT NULL,
  `subject` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedule_logs_schedule_id_foreign` (`schedule_id`),
  KEY `crm_schedule_logs_created_by_index` (`created_by`),
  CONSTRAINT `crm_schedule_logs_schedule_id_foreign` FOREIGN KEY (`schedule_id`) REFERENCES `crm_schedules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedule_logs` WRITE;
/*!40000 ALTER TABLE `crm_schedule_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedule_logs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedule_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_schedule_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `schedule_id` bigint(20) unsigned NOT NULL,
  `user_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedule_users_schedule_id_foreign` (`schedule_id`),
  KEY `crm_schedule_users_user_id_index` (`user_id`),
  CONSTRAINT `crm_schedule_users_schedule_id_foreign` FOREIGN KEY (`schedule_id`) REFERENCES `crm_schedules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedule_users` WRITE;
/*!40000 ALTER TABLE `crm_schedule_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedule_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `crm_schedules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `crm_schedules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `contact_id` int(10) DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `status` varchar(191) DEFAULT NULL,
  `start_datetime` datetime DEFAULT NULL,
  `end_datetime` datetime DEFAULT NULL,
  `description` text DEFAULT NULL,
  `schedule_type` enum('call','sms','meeting','email') NOT NULL DEFAULT 'email',
  `followup_category_id` int(11) DEFAULT NULL,
  `allow_notification` tinyint(1) NOT NULL DEFAULT 1,
  `notify_via` text DEFAULT NULL,
  `notify_before` int(11) DEFAULT NULL,
  `notify_type` enum('minute','hour','day') NOT NULL DEFAULT 'hour',
  `created_by` int(11) NOT NULL,
  `is_recursive` tinyint(1) NOT NULL DEFAULT 0,
  `recursion_days` int(11) DEFAULT NULL,
  `followup_additional_info` text DEFAULT NULL,
  `follow_up_by` varchar(191) DEFAULT NULL,
  `follow_up_by_value` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `crm_schedules_created_by_index` (`created_by`),
  KEY `crm_schedules_business_id_index` (`business_id`),
  KEY `crm_schedules_contact_id_index` (`contact_id`),
  KEY `crm_schedules_schedule_type_index` (`schedule_type`),
  KEY `crm_schedules_notify_type_index` (`notify_type`),
  CONSTRAINT `crm_schedules_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `crm_schedules` WRITE;
/*!40000 ALTER TABLE `crm_schedules` DISABLE KEYS */;
/*!40000 ALTER TABLE `crm_schedules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `code` varchar(25) NOT NULL,
  `symbol` varchar(25) NOT NULL,
  `thousand_separator` varchar(10) NOT NULL,
  `decimal_separator` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),(2,'America','Dollars','USD','$',',','.',NULL,NULL),(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),(41,'France','Euro','EUR','€','.',',',NULL,NULL),(42,'Ghana','Cedis','GHS','¢',',','.',NULL,NULL),(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),(53,'India','Rupees','INR','₹',',','.',NULL,NULL),(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),(87,'Nigeria','Nairas','NGN','₦',',','.',NULL,NULL),(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL),(141,'Bahrain','Bahraini dinar','BHD','BD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  KEY `customer_groups_created_by_index` (`created_by`),
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`),
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `color` varchar(191) NOT NULL,
  `configuration` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`),
  CONSTRAINT `dashboard_configurations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`),
  KEY `discount_variations_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
INSERT INTO `discount_variations` VALUES (1,496),(2,2434);
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `spg` varchar(100) DEFAULT NULL COMMENT 'Applicable in specified selling price group only. Use of applicable_in_spg column is discontinued',
  `applicable_in_cg` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`),
  KEY `discounts_spg_index` (`spg`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
INSERT INTO `discounts` VALUES (1,'D1',5,NULL,NULL,5,1,'fixed',15.0000,'2025-02-13 17:23:00','2025-02-28 17:23:00',1,NULL,0,'2025-02-13 11:54:00','2025-02-13 11:54:00'),(2,'20',8,NULL,17,8,1,'fixed',20.0000,'2025-02-27 08:39:00','2025-06-27 08:39:00',1,'0',0,'2025-02-27 03:10:28','2025-02-27 03:10:28');
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) NOT NULL,
  `heading` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_allowances_and_deductions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_allowances_and_deductions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `description` varchar(191) NOT NULL,
  `type` enum('allowance','deduction') NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `amount_type` enum('fixed','percent') NOT NULL,
  `applicable_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_allowances_and_deductions_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_allowances_and_deductions` WRITE;
/*!40000 ALTER TABLE `essentials_allowances_and_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_allowances_and_deductions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `clock_in_time` datetime DEFAULT NULL,
  `clock_out_time` datetime DEFAULT NULL,
  `essentials_shift_id` int(11) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `clock_in_note` text DEFAULT NULL,
  `clock_out_note` text DEFAULT NULL,
  `clock_in_location` text DEFAULT NULL,
  `clock_out_location` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_attendances_user_id_index` (`user_id`),
  KEY `essentials_attendances_business_id_index` (`business_id`),
  KEY `essentials_attendances_essentials_shift_id_index` (`essentials_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_attendances` WRITE;
/*!40000 ALTER TABLE `essentials_attendances` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_attendances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_document_shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_document_shares` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(11) NOT NULL,
  `value_type` enum('user','role') NOT NULL,
  `value` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_document_shares_document_id_index` (`document_id`),
  KEY `essentials_document_shares_value_type_index` (`value_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_document_shares` WRITE;
/*!40000 ALTER TABLE `essentials_document_shares` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_document_shares` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `type` varchar(191) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `description` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_documents` WRITE;
/*!40000 ALTER TABLE `essentials_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_documents` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_holidays` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `business_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_holidays_business_id_index` (`business_id`),
  KEY `essentials_holidays_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_holidays` WRITE;
/*!40000 ALTER TABLE `essentials_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_holidays` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_kb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_kb` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` bigint(20) unsigned NOT NULL,
  `title` varchar(191) NOT NULL,
  `content` longtext DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `kb_type` varchar(191) NOT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL COMMENT 'id from essentials_kb table',
  `share_with` varchar(191) DEFAULT NULL COMMENT 'public, private, only_with',
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_kb_business_id_index` (`business_id`),
  KEY `essentials_kb_parent_id_index` (`parent_id`),
  KEY `essentials_kb_created_by_index` (`created_by`),
  CONSTRAINT `essentials_kb_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `essentials_kb` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_kb` WRITE;
/*!40000 ALTER TABLE `essentials_kb` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_kb` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_kb_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_kb_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `kb_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_kb_users_kb_id_index` (`kb_id`),
  KEY `essentials_kb_users_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_kb_users` WRITE;
/*!40000 ALTER TABLE `essentials_kb_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_kb_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_leave_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_leave_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leave_type` varchar(191) NOT NULL,
  `max_leave_count` int(11) DEFAULT NULL,
  `leave_count_interval` enum('month','year') DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_leave_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_leave_types` WRITE;
/*!40000 ALTER TABLE `essentials_leave_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_leave_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_leaves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_leaves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `essentials_leave_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `ref_no` varchar(191) DEFAULT NULL,
  `status` enum('pending','approved','cancelled') DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `status_note` text DEFAULT NULL,
  `is_additional` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_leaves_essentials_leave_type_id_index` (`essentials_leave_type_id`),
  KEY `essentials_leaves_business_id_index` (`business_id`),
  KEY `essentials_leaves_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_leaves` WRITE;
/*!40000 ALTER TABLE `essentials_leaves` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_leaves` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_messages_business_id_index` (`business_id`),
  KEY `essentials_messages_user_id_index` (`user_id`),
  KEY `essentials_messages_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_messages` WRITE;
/*!40000 ALTER TABLE `essentials_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_messages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_payroll_group_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_payroll_group_transactions` (
  `payroll_group_id` bigint(20) unsigned NOT NULL,
  `transaction_id` int(11) NOT NULL,
  KEY `essentials_payroll_group_transactions_payroll_group_id_foreign` (`payroll_group_id`),
  CONSTRAINT `essentials_payroll_group_transactions_payroll_group_id_foreign` FOREIGN KEY (`payroll_group_id`) REFERENCES `essentials_payroll_groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_payroll_group_transactions` WRITE;
/*!40000 ALTER TABLE `essentials_payroll_group_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_payroll_group_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_payroll_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_payroll_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL COMMENT 'payroll for work location',
  `name` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL,
  `payment_status` varchar(191) NOT NULL DEFAULT 'due',
  `gross_total` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_payroll_groups` WRITE;
/*!40000 ALTER TABLE `essentials_payroll_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_payroll_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_reminders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_reminders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `date` date NOT NULL,
  `time` time NOT NULL,
  `end_time` time DEFAULT NULL,
  `repeat` enum('one_time','every_day','every_week','every_month') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_reminders_business_id_index` (`business_id`),
  KEY `essentials_reminders_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_reminders` WRITE;
/*!40000 ALTER TABLE `essentials_reminders` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_reminders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_shifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `type` enum('fixed_shift','flexible_shift') NOT NULL DEFAULT 'fixed_shift',
  `business_id` int(11) NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `is_allowed_auto_clockout` tinyint(1) NOT NULL DEFAULT 0,
  `auto_clockout_time` time DEFAULT NULL,
  `holidays` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_shifts_type_index` (`type`),
  KEY `essentials_shifts_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_shifts` WRITE;
/*!40000 ALTER TABLE `essentials_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_to_dos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_to_dos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `task` text NOT NULL,
  `date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `task_id` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `estimated_hours` varchar(191) DEFAULT NULL,
  `priority` varchar(191) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_to_dos_status_index` (`status`),
  KEY `essentials_to_dos_priority_index` (`priority`),
  KEY `essentials_to_dos_created_by_index` (`created_by`),
  KEY `essentials_to_dos_business_id_index` (`business_id`),
  KEY `essentials_to_dos_task_id_index` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_to_dos` WRITE;
/*!40000 ALTER TABLE `essentials_to_dos` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_to_dos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_todo_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_todo_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comment` text NOT NULL,
  `task_id` int(11) NOT NULL,
  `comment_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_todo_comments_task_id_index` (`task_id`),
  KEY `essentials_todo_comments_comment_by_index` (`comment_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_todo_comments` WRITE;
/*!40000 ALTER TABLE `essentials_todo_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_todo_comments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_todos_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_todos_users` (
  `todo_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_todos_users` WRITE;
/*!40000 ALTER TABLE `essentials_todos_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_todos_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_allowance_and_deductions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_user_allowance_and_deductions` (
  `user_id` int(11) NOT NULL,
  `allowance_deduction_id` int(11) NOT NULL,
  KEY `essentials_user_allowance_and_deductions_user_id_index` (`user_id`),
  KEY `allow_deduct_index` (`allowance_deduction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_allowance_and_deductions` WRITE;
/*!40000 ALTER TABLE `essentials_user_allowance_and_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_allowance_and_deductions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_sales_targets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_user_sales_targets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `target_start` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `target_end` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `commission_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_sales_targets` WRITE;
/*!40000 ALTER TABLE `essentials_user_sales_targets` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_sales_targets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_user_shifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `essentials_shift_id` int(11) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_user_shifts_user_id_index` (`user_id`),
  KEY `essentials_user_shifts_essentials_shift_id_index` (`essentials_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_shifts` WRITE;
/*!40000 ALTER TABLE `essentials_user_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`),
  CONSTRAINT `expense_categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`),
  CONSTRAINT `group_sub_taxes_group_tax_id_foreign` FOREIGN KEY (`group_tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `group_sub_taxes_tax_id_foreign` FOREIGN KEY (`tax_id`) REFERENCES `tax_rates` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `header_text` text DEFAULT NULL,
  `invoice_no_prefix` varchar(191) DEFAULT NULL,
  `quotation_no_prefix` varchar(191) DEFAULT NULL,
  `invoice_heading` varchar(191) DEFAULT NULL,
  `sub_heading_line1` varchar(191) DEFAULT NULL,
  `sub_heading_line2` varchar(191) DEFAULT NULL,
  `sub_heading_line3` varchar(191) DEFAULT NULL,
  `sub_heading_line4` varchar(191) DEFAULT NULL,
  `sub_heading_line5` varchar(191) DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) DEFAULT NULL,
  `invoice_heading_paid` varchar(191) DEFAULT NULL,
  `quotation_heading` varchar(191) DEFAULT NULL,
  `sub_total_label` varchar(191) DEFAULT NULL,
  `discount_label` varchar(191) DEFAULT NULL,
  `tax_label` varchar(191) DEFAULT NULL,
  `total_label` varchar(191) DEFAULT NULL,
  `round_off_label` varchar(191) DEFAULT NULL,
  `total_due_label` varchar(191) DEFAULT NULL,
  `paid_label` varchar(191) DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT 0,
  `client_id_label` varchar(191) DEFAULT NULL,
  `client_tax_label` varchar(191) DEFAULT NULL,
  `date_label` varchar(191) DEFAULT NULL,
  `date_time_format` varchar(191) DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT 1,
  `show_brand` tinyint(1) NOT NULL DEFAULT 0,
  `show_sku` tinyint(1) NOT NULL DEFAULT 1,
  `show_cat_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `show_lot` tinyint(1) NOT NULL DEFAULT 0,
  `show_image` tinyint(1) NOT NULL DEFAULT 0,
  `show_sale_description` tinyint(1) NOT NULL DEFAULT 0,
  `sales_person_label` varchar(191) DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT 0,
  `table_product_label` varchar(191) DEFAULT NULL,
  `table_qty_label` varchar(191) DEFAULT NULL,
  `table_unit_price_label` varchar(191) DEFAULT NULL,
  `table_subtotal_label` varchar(191) DEFAULT NULL,
  `cat_code_label` varchar(191) DEFAULT NULL,
  `logo` varchar(191) DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT 0,
  `show_business_name` tinyint(1) NOT NULL DEFAULT 0,
  `show_location_name` tinyint(1) NOT NULL DEFAULT 1,
  `show_landmark` tinyint(1) NOT NULL DEFAULT 1,
  `show_city` tinyint(1) NOT NULL DEFAULT 1,
  `show_state` tinyint(1) NOT NULL DEFAULT 1,
  `show_zip_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_country` tinyint(1) NOT NULL DEFAULT 1,
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT 1,
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT 0,
  `show_email` tinyint(1) NOT NULL DEFAULT 0,
  `show_tax_1` tinyint(1) NOT NULL DEFAULT 1,
  `show_tax_2` tinyint(1) NOT NULL DEFAULT 0,
  `show_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `show_payments` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer` tinyint(1) NOT NULL DEFAULT 0,
  `customer_label` varchar(191) DEFAULT NULL,
  `commission_agent_label` varchar(191) DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT 0,
  `show_reward_point` tinyint(1) NOT NULL DEFAULT 0,
  `highlight_color` varchar(10) DEFAULT NULL,
  `footer_text` text DEFAULT NULL,
  `module_info` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `business_id` int(10) unsigned NOT NULL,
  `show_letter_head` tinyint(1) NOT NULL DEFAULT 0,
  `letter_head` varchar(191) DEFAULT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT 0,
  `qr_code_fields` text DEFAULT NULL,
  `design` varchar(190) DEFAULT 'classic',
  `cn_heading` varchar(191) DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) DEFAULT NULL,
  `cn_amount_label` varchar(191) DEFAULT NULL,
  `table_tax_headings` text DEFAULT NULL,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT 0,
  `prev_bal_label` varchar(191) DEFAULT NULL,
  `change_return_label` varchar(191) DEFAULT NULL,
  `product_custom_fields` text DEFAULT NULL,
  `contact_custom_fields` text DEFAULT NULL,
  `location_custom_fields` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`),
  CONSTRAINT `invoice_layouts_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES (1,'Default','<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRBgYyrs97SnEBSUngb496dbBwvcZfc8Yr5YA&amp;s\" alt=\"\" width=\"194\" height=\"191\" /></p>','Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','ඔබ ලබාගත් ලාබය','Tax','මුළු මුදල',NULL,'හිග මුදල','ගෙවූ මුදල',0,NULL,NULL,'Date',NULL,1,0,0,0,0,0,0,0,NULL,0,'භාණ්ඩය','ප්‍රමාණය','ඒ.මිළ','මුළු මුදල',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,1,1,1,'Customer',NULL,0,0,'#000000','<p style=\"text-align: center;\">Thank You Come Again !</p>',NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":null,\"total_quantity_label\":null,\"item_discount_label\":null,\"discounted_unit_price_label\":null,\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null}',1,1,0,NULL,0,NULL,'slim',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-01-29 10:46:29','2025-01-29 10:59:39'),(2,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,2,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(3,'Default','<p><img style=\"display: block; margin-left: auto; margin-right: auto;\" src=\"https://encrypted-tbn0.gstatic.com/images?q=tbn:ANd9GcRAHXPluq6GtTRPDIHRv5kJPy86uFjp5sO7hg&amp;s\" alt=\"\" width=\"225\" height=\"225\" /></p>','Invoice No.',NULL,'බිල් පත',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'මුලු එකතුව','ඔබේ ඉතිරිය',NULL,'එකතුව',NULL,'හිග මුදල','ගෙවූ මුදල',0,NULL,NULL,'දිනය',NULL,1,0,0,0,0,0,0,0,NULL,0,'භාණ්ඩය','ප්‍රමාණය','වෙලද මිළ','සම්පූර්ණ මිළ',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000',NULL,NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":null,\"total_quantity_label\":null,\"item_discount_label\":null,\"discounted_unit_price_label\":\"\\u0d85\\u0db4\\u0dda \\u0db8\\u0dd2\\u0dc5\",\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null}',1,3,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-02-02 17:44:33','2025-02-07 06:13:53'),(4,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,0,0,0,0,0,0,NULL,0,'Product','Qua.','Unit Price','Subtotal',NULL,'1739190237_IMG-20241017-WA0039.jpg',1,0,1,1,0,0,0,0,1,0,0,0,0,0,1,0,'Customer',NULL,0,0,'#000000',NULL,NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":null,\"total_quantity_label\":null,\"item_discount_label\":null,\"discounted_unit_price_label\":null,\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null}',1,4,0,NULL,0,NULL,'slim',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-02-10 12:16:25','2025-02-10 12:31:49'),(5,'Default',NULL,'බිල්පත් අංකය',NULL,'බිල්පත',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'මුළු එකතුව','♦ ♦ ඔබ ලැබූ ලාබය ♦♦',NULL,'සම්පූර්ණ එකතුව',NULL,'හිග මුදල','ඔබ ගෙවූ මුදල',0,NULL,NULL,'දිනය',NULL,1,0,0,0,0,0,0,0,'අයකැමි',0,'භාණ්ඩය','ප්‍රමානය','සදහන් මිල','එකතුව',NULL,'1739415003_WhatsApp Image 2025-02-12 at 17.56.08.jpeg',1,0,1,1,0,0,0,0,1,0,0,1,0,0,1,1,NULL,NULL,0,0,'#000000','<hr />\r\n<p style=\"text-align: center;\">ස්තූතීයි. ඔබට සුභ දවසක්.</p>\r\n<hr />\r\n<p style=\"text-align: center;\"><a id=\"discount_label\"></a></p>','{\"types_of_service\":{\"types_of_service_label\":null},\"service_staff\":{\"service_staff_label\":null}}','{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":null,\"total_quantity_label\":null,\"item_discount_label\":null,\"discounted_unit_price_label\":\"\\u0d85\\u0db4\\u0dda \\u0db8\\u0dd2\\u0dbd\",\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null}',1,5,0,NULL,0,NULL,'classic',NULL,NULL,NULL,'[\".\",null,null,null]',0,NULL,NULL,NULL,NULL,NULL,'2025-02-12 11:50:59','2025-02-18 05:59:22'),(6,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,'','',NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,1,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,0,0,1,1,1,1,1,1,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','',NULL,NULL,1,6,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(7,'qq',NULL,'Invoice No.','Quotation number','Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Quotation','Subtotal','Discount','Tax','Total','Round Off','Due','Total paid',0,NULL,NULL,'Date',NULL,1,0,0,0,0,0,0,0,NULL,0,'Product','Quantity','Unit Price','Subtotal','HSN',NULL,1,0,1,1,1,1,1,1,1,0,0,1,0,0,0,1,'Customer','Commission Agent',0,0,'#000000',NULL,'{\"types_of_service\":{\"types_of_service_label\":null},\"service_staff\":{\"show_service_staff\":\"1\",\"service_staff_label\":\"Service staff\"}}','{\"proforma_heading\":\"Proforma invoice\",\"sales_order_heading\":\"Sales Order\",\"due_date_label\":\"Due Date\",\"total_quantity_label\":\"Total Quantity\",\"item_discount_label\":\"Discount\",\"discounted_unit_price_label\":\"Price after discount\",\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null}',0,5,0,NULL,0,NULL,'elegant','Credit Note','Reference No','Credit Amount',NULL,0,NULL,'Change Return',NULL,NULL,NULL,'2025-02-14 20:15:00','2025-02-14 20:15:00'),(8,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,0,0,0,0,0,0,NULL,0,'Service','Quantity','Price','Subtotal',NULL,NULL,1,0,1,1,0,0,0,0,1,0,0,0,0,0,1,1,'Customer',NULL,0,0,'#000000',NULL,'{\"types_of_service\":{\"types_of_service_label\":\"Additional\",\"show_types_of_service\":\"1\"},\"tables\":{\"show_table\":\"1\",\"table_label\":\"Room No.\"},\"service_staff\":{\"service_staff_label\":null}}','{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":null,\"total_quantity_label\":null,\"item_discount_label\":null,\"discounted_unit_price_label\":null,\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null}',1,7,0,NULL,0,NULL,'slim',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-02-24 12:39:17','2025-03-02 06:03:08'),(9,'Default',NULL,'බිල්පත් අංකය',NULL,'බිල්පත',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'මුළු එකතුව','♦ ♦ ඔබ ලැබූ ලාබය ♦♦','Tax','සම්පූර්ණ එකතුව',NULL,'හිග මුදල','ඔබ ගෙවූ මුදල',0,NULL,NULL,'දිනය',NULL,1,0,0,0,0,0,0,0,'අයකැමි',0,'භාණ්ඩය','ප්‍රමානය','සදහන් මිල','එකතුව',NULL,'1740565132_WhatsApp Image 2025-02-26 at 15.30.08_93482678.jpg',1,0,1,1,0,0,0,0,1,0,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000','<p style=\"text-align: center;\">ස්තූතීයි. ඔබට සුභ දවසක්.</p>\r\n<p style=\"text-align: center;\">බිල්පතෙහි යම් ගැටලුවක් වෙතොත් දින දෙකක් තුල අපව සම්බන්ද කරගන්න</p>',NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":null,\"total_quantity_label\":null,\"item_discount_label\":null,\"discounted_unit_price_label\":\"\\u0d85\\u0db4\\u0dda \\u0db8\\u0dd2\\u0dbd\",\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null}',1,8,0,NULL,0,NULL,'classic',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2025-02-25 16:07:36','2025-02-26 10:18:52');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `scheme_type` enum('blank','year') NOT NULL,
  `number_type` varchar(100) NOT NULL DEFAULT 'sequential',
  `prefix` varchar(191) DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT 0,
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`),
  KEY `invoice_schemes_number_type_index` (`number_type`),
  CONSTRAINT `invoice_schemes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES (1,1,'Default','blank','sequential','',1,16,4,1,'2025-01-29 10:46:29','2025-02-06 04:38:06'),(2,2,'Default','blank','sequential','',1,0,4,1,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(3,3,'Default','blank','sequential','',1,43,4,1,'2025-02-02 17:44:33','2025-03-03 16:56:48'),(4,4,'Default','blank','sequential','',1,12,4,1,'2025-02-10 12:16:25','2025-02-10 14:12:11'),(5,5,'Default','blank','sequential','',1,50,4,1,'2025-02-12 11:50:59','2025-02-18 06:38:24'),(6,6,'Default','blank','sequential','',1,0,4,1,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(7,7,'Default','blank','sequential','',1,7,4,1,'2025-02-24 12:39:17','2025-03-02 06:27:20'),(8,8,'Default','blank','sequential','',1,99,4,1,'2025-02-25 16:07:36','2025-02-27 03:47:26');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) NOT NULL,
  `woocommerce_media_id` int(11) DEFAULT NULL,
  `model_media_type` varchar(191) DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `media_business_id_index` (`business_id`),
  KEY `media_uploaded_by_index` (`uploaded_by`),
  KEY `media_woocommerce_media_id_index` (`woocommerce_media_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_ingredient_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mfg_ingredient_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_ingredient_groups` WRITE;
/*!40000 ALTER TABLE `mfg_ingredient_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_ingredient_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_recipe_ingredients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mfg_recipe_ingredients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `mfg_recipe_id` int(10) unsigned NOT NULL,
  `variation_id` int(11) NOT NULL,
  `mfg_ingredient_group_id` int(11) DEFAULT NULL,
  `quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `waste_percent` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `sub_unit_id` int(11) DEFAULT NULL,
  `sort_order` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mfg_recipe_ingredients_mfg_recipe_id_index` (`mfg_recipe_id`),
  KEY `mfg_recipe_ingredients_variation_id_index` (`variation_id`),
  KEY `mfg_recipe_ingredients_sub_unit_id_index` (`sub_unit_id`),
  CONSTRAINT `mfg_recipe_ingredients_mfg_recipe_id_foreign` FOREIGN KEY (`mfg_recipe_id`) REFERENCES `mfg_recipes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_recipe_ingredients` WRITE;
/*!40000 ALTER TABLE `mfg_recipe_ingredients` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_recipe_ingredients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `mfg_recipes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mfg_recipes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  `instructions` text DEFAULT NULL,
  `waste_percent` decimal(10,2) NOT NULL DEFAULT 0.00,
  `ingredients_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `extra_cost` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `production_cost_type` varchar(191) DEFAULT 'percentage',
  `total_quantity` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `final_price` decimal(22,4) NOT NULL,
  `sub_unit_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mfg_recipes_product_id_index` (`product_id`),
  KEY `mfg_recipes_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `mfg_recipes` WRITE;
/*!40000 ALTER TABLE `mfg_recipes` DISABLE KEYS */;
/*!40000 ALTER TABLE `mfg_recipes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=429 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(6,'2016_06_01_000004_create_oauth_clients_table',1),(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(8,'2017_07_05_071953_create_currencies_table',1),(9,'2017_07_05_073658_create_business_table',1),(10,'2017_07_22_075923_add_business_id_users_table',1),(11,'2017_07_23_113209_create_brands_table',1),(12,'2017_07_26_083429_create_permission_tables',1),(13,'2017_07_26_110000_create_tax_rates_table',1),(14,'2017_07_26_122313_create_units_table',1),(15,'2017_07_27_075706_create_contacts_table',1),(16,'2017_08_04_071038_create_categories_table',1),(17,'2017_08_08_115903_create_products_table',1),(18,'2017_08_09_061616_create_variation_templates_table',1),(19,'2017_08_09_061638_create_variation_value_templates_table',1),(20,'2017_08_10_061146_create_product_variations_table',1),(21,'2017_08_10_061216_create_variations_table',1),(22,'2017_08_19_054827_create_transactions_table',1),(23,'2017_08_31_073533_create_purchase_lines_table',1),(24,'2017_10_15_064638_create_transaction_payments_table',1),(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),(26,'2017_11_20_051930_create_table_group_sub_taxes',1),(27,'2017_11_20_063603_create_transaction_sell_lines',1),(28,'2017_11_21_064540_create_barcodes_table',1),(29,'2017_11_23_181237_create_invoice_schemes_table',1),(30,'2017_12_25_122822_create_business_locations_table',1),(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),(32,'2017_12_25_163227_create_variation_location_details_table',1),(33,'2018_01_04_115627_create_sessions_table',1),(34,'2018_01_05_112817_create_invoice_layouts_table',1),(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),(36,'2018_01_08_104124_create_expense_categories_table',1),(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),(41,'2018_01_27_184322_create_printers_table',1),(42,'2018_01_30_181442_create_cash_registers_table',1),(43,'2018_01_31_125836_create_cash_register_transactions_table',1),(44,'2018_02_07_173326_modify_business_table',1),(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),(52,'2018_02_13_183323_alter_decimal_fields_size',1),(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),(59,'2018_02_21_105329_create_system_table',1),(60,'2018_02_23_100549_version_1_2',1),(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),(68,'2018_03_06_210206_modify_product_barcode_types',1),(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),(70,'2018_03_16_113446_product_expiry_setting_for_business',1),(71,'2018_03_19_113601_add_business_settings_options',1),(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),(73,'2018_03_26_165350_create_customer_groups_table',1),(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),(82,'2018_04_17_123122_add_lot_number_to_business',1),(83,'2018_04_17_160845_add_product_racks_table',1),(84,'2018_04_20_182015_create_res_tables_table',1),(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),(86,'2018_04_24_114149_add_enabled_modules_business_table',1),(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),(88,'2018_04_27_132653_quotation_related_change',1),(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),(91,'2018_05_14_114027_add_rows_positions_for_products',1),(92,'2018_05_14_125223_add_weight_to_products_table',1),(93,'2018_05_14_164754_add_opening_stock_permission',1),(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),(100,'2018_05_22_123527_create_reference_counts_table',1),(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),(104,'2018_05_25_180603_create_modifiers_related_table',1),(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),(111,'2018_06_07_182258_add_image_field_to_products_table',1),(112,'2018_06_13_133705_create_bookings_table',1),(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),(127,'2018_09_04_155900_create_accounts_table',1),(128,'2018_09_06_114438_create_selling_price_groups_table',1),(129,'2018_09_06_154057_create_variation_group_prices_table',1),(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),(133,'2018_09_10_152703_create_account_transactions_table',1),(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),(135,'2018_09_19_123914_create_notification_templates_table',1),(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),(147,'2018_10_22_134428_modify_variable_product_data',1),(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),(152,'2018_10_31_175627_add_user_contact_access',1),(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),(155,'2018_11_08_105621_add_role_permissions',1),(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),(159,'2018_11_29_115918_add_primary_key_in_system_table',1),(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),(161,'2018_12_06_114937_modify_system_table_and_users_table',1),(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),(163,'2018_12_14_103307_modify_system_table',1),(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),(168,'2018_12_24_154933_create_notifications_table',1),(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),(170,'2019_01_10_124645_add_account_permission',1),(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),(174,'2019_02_19_103118_create_discounts_table',1),(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),(176,'2019_02_21_134324_add_permission_for_discount',1),(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),(180,'2019_03_12_120336_create_activity_log_table',1),(181,'2019_03_15_132925_create_media_table',1),(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),(183,'2019_05_10_132311_add_missing_column_indexing',1),(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),(185,'2019_05_25_104922_add_view_purchase_price_permission',1),(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),(191,'2019_07_15_165136_add_fields_for_combo_product',1),(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),(195,'2019_08_08_162302_add_sub_units_related_fields',1),(196,'2019_08_26_133419_update_price_fields_decimal_point',1),(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),(198,'2019_09_03_185259_add_permission_for_pos_screen',1),(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),(200,'2019_09_04_184008_create_types_of_services_table',1),(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),(203,'2019_09_12_105616_create_product_locations_table',1),(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),(206,'2019_09_19_170927_close_all_active_registers',1),(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),(208,'2019_10_18_155633_create_account_types_table',1),(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),(210,'2019_10_29_132521_add_update_purchase_status_permission',1),(211,'2019_11_09_110522_add_indexing_to_lot_number',1),(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),(215,'2019_12_02_105025_create_warranties_table',1),(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),(217,'2019_12_05_183955_add_more_fields_to_users_table',1),(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),(222,'2019_12_25_173413_create_dashboard_configurations_table',1),(223,'2020_01_08_133506_create_document_and_notes_table',1),(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),(232,'2020_04_15_151802_add_user_type_to_users_table',1),(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),(236,'2020_06_12_162245_modify_contacts_table',1),(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),(242,'2020_09_22_121639_create_discount_variations_table',1),(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),(245,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',1),(246,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',1),(247,'2020_11_10_152841_add_cash_register_permissions',1),(248,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',1),(249,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',1),(250,'2020_12_22_164303_add_sub_status_column_to_transactions_table',1),(251,'2020_12_24_153050_add_custom_fields_to_transactions_table',1),(252,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',1),(253,'2020_12_29_165925_add_model_document_type_to_media_table',1),(254,'2021_02_08_175632_add_contact_number_fields_to_users_table',1),(255,'2021_02_11_172217_add_indexing_for_multiple_columns',1),(256,'2021_02_23_122043_add_more_columns_to_customer_groups_table',1),(257,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',1),(258,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',1),(259,'2021_03_11_120229_add_sales_order_columns',1),(260,'2021_03_16_120705_add_business_id_to_activity_log_table',1),(261,'2021_03_16_153427_add_code_columns_to_business_table',1),(262,'2021_03_18_173308_add_account_details_column_to_accounts_table',1),(263,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',1),(264,'2021_03_22_120810_add_more_types_of_service_custom_fields',1),(265,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',1),(266,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',1),(267,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',1),(268,'2021_05_22_083426_add_indexing_to_account_transactions_table',1),(269,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',1),(270,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',1),(271,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',1),(272,'2021_08_13_105549_add_crm_contact_id_to_users_table',1),(273,'2021_08_25_114932_add_payment_link_fields_to_transaction_payments_table',1),(274,'2021_09_01_063110_add_spg_column_to_discounts_table',1),(275,'2021_09_03_061528_modify_cash_register_transactions_table',1),(276,'2021_10_05_061658_add_source_column_to_transactions_table',1),(277,'2021_12_16_121851_add_parent_id_column_to_expense_categories_table',1),(278,'2022_04_14_075120_add_payment_type_column_to_transaction_payments_table',1),(279,'2022_04_21_083327_create_cash_denominations_table',1),(280,'2022_05_10_055307_add_delivery_date_column_to_transactions_table',1),(281,'2022_06_13_123135_add_currency_precision_and_quantity_precision_fields_to_business_table',1),(282,'2022_06_28_133342_add_secondary_unit_columns_to_products_sell_line_purchase_lines_tables',1),(283,'2022_07_13_114307_create_purchase_requisition_related_columns',1),(284,'2022_08_25_132707_add_service_staff_timer_fields_to_products_and_users_table',1),(285,'2023_01_28_114255_add_letter_head_column_to_invoice_layouts_table',1),(286,'2023_02_11_161510_add_event_column_to_activity_log_table',1),(287,'2023_02_11_161511_add_batch_uuid_column_to_activity_log_table',1),(288,'2023_03_02_170312_add_provider_to_oauth_clients_table',1),(289,'2023_03_21_122731_add_sale_invoice_scheme_id_business_table',1),(290,'2023_03_21_170446_add_number_type_to_invoice_scheme',1),(291,'2023_04_17_155216_add_custom_fields_to_products',1),(292,'2023_04_28_130247_add_price_type_to_group_price_table',1),(293,'2023_06_21_033923_add_delivery_person_in_transactions',1),(294,'2018_10_01_151252_create_documents_table',2),(295,'2018_10_02_151803_create_document_shares_table',2),(296,'2018_10_09_134558_create_reminders_table',2),(297,'2018_11_16_170756_create_to_dos_table',2),(298,'2019_02_22_120329_essentials_messages',2),(299,'2019_02_22_161513_add_message_permissions',2),(300,'2019_03_29_164339_add_essentials_version_to_system_table',2),(301,'2019_05_17_153306_create_essentials_leave_types_table',2),(302,'2019_05_17_175921_create_essentials_leaves_table',2),(303,'2019_05_21_154517_add_essentials_settings_columns_to_business_table',2),(304,'2019_05_21_181653_create_table_essentials_attendance',2),(305,'2019_05_30_110049_create_essentials_payrolls_table',2),(306,'2019_06_04_105723_create_essentials_holidays_table',2),(307,'2019_06_28_134217_add_payroll_columns_to_transactions_table',2),(308,'2019_08_26_103520_add_approve_leave_permission',2),(309,'2019_08_27_103724_create_essentials_allowance_and_deduction_table',2),(310,'2019_08_27_105236_create_essentials_user_allowances_and_deductions',2),(311,'2019_09_20_115906_add_more_columns_to_essentials_to_dos_table',2),(312,'2019_09_23_120439_create_essentials_todo_comments_table',2),(313,'2019_12_05_170724_add_hrm_columns_to_users_table',2),(314,'2019_12_09_105809_add_allowance_and_deductions_permission',2),(315,'2020_03_28_152838_create_essentials_shift_table',2),(316,'2020_03_30_162029_create_user_shifts_table',2),(317,'2020_03_31_134558_add_shift_id_to_attendance_table',2),(318,'2020_11_05_105157_modify_todos_date_column_type',2),(319,'2020_11_11_174852_add_end_time_column_to_essentials_reminders_table',2),(320,'2020_11_26_170527_create_essentials_kb_table',2),(321,'2020_11_30_112615_create_essentials_kb_users_table',2),(322,'2021_02_12_185514_add_clock_in_location_to_essentials_attendances_table',2),(323,'2021_02_16_190203_add_essentials_module_indexing',2),(324,'2021_02_27_133448_add_columns_to_users_table',2),(325,'2021_03_04_174857_create_payroll_groups_table',2),(326,'2021_03_04_175025_create_payroll_group_transactions_table',2),(327,'2021_03_09_123914_add_auto_clockout_to_essentials_shifts',2),(328,'2021_06_17_121451_add_location_id_to_table',2),(329,'2021_09_28_091541_create_essentials_user_sales_targets_table',2),(330,'2024_11_01_105811_add_is_addition_in_leave_table',2),(331,'2022_08_04_143146_create_cms_pages_table',3),(332,'2022_09_10_161849_add_layout_column_to_cms_pages_table',3),(333,'2022_09_10_163209_create_cms_site_details_table',3),(334,'2022_09_15_122547_create_cms_page_metas_table',3),(335,'2022_09_16_130337_create_default_data_for_cms',3),(336,'2018_06_27_185405_create_packages_table',4),(337,'2018_06_28_182803_create_subscriptions_table',4),(338,'2018_07_17_182021_add_rows_to_system_table',4),(339,'2018_07_19_131721_add_options_to_packages_table',4),(340,'2018_08_17_155534_add_min_termination_alert_days',4),(341,'2018_08_28_105945_add_business_based_username_settings_to_system_table',4),(342,'2018_08_30_105906_add_superadmin_communicator_logs_table',4),(343,'2018_11_02_130636_add_custom_permissions_to_packages_table',4),(344,'2018_11_05_161848_add_more_fields_to_packages_table',4),(345,'2018_12_10_124621_modify_system_table_values_null_default',4),(346,'2019_05_10_135434_add_missing_database_column_indexes',4),(347,'2019_08_16_115300_create_superadmin_frontend_pages_table',4),(348,'2023_06_10_132121_create_coupons_table',4),(349,'2023_06_16_141928_add_column_in_subscriptions',4),(350,'2023_06_29_183442_add_mark_package_as_popular',4),(351,'2023_07_04_151432_add_column_business',4),(352,'2023_07_13_191306_add_businesses_column_in_coupons',4),(353,'2022_10_31_115725_create_accounting_account_types_table',5),(354,'2022_11_01_104108_create_accounting_accounts_table',5),(355,'2022_11_10_135427_create_accounts_transactions_table',5),(356,'2022_11_14_171948_create_accounting_acc_trans_mapping',5),(357,'2022_12_02_133536_create_accounting_budgets_table',5),(358,'2022_12_19_124743_add_accounting_settings_column_to_business_table',5),(359,'2022_12_26_182821_AddAccountingModuleVersionToSystemTable',5),(360,'2023_05_25_131005_add_default_map_transactions_fields',5),(361,'2018_10_10_110400_add_module_version_to_system_table',6),(362,'2018_10_10_122845_add_woocommerce_api_settings_to_business_table',6),(363,'2018_10_10_162041_add_woocommerce_category_id_to_categories_table',6),(364,'2018_10_11_173839_create_woocommerce_sync_logs_table',6),(365,'2018_10_16_123522_add_woocommerce_tax_rate_id_column_to_tax_rates_table',6),(366,'2018_10_23_111555_add_woocommerce_attr_id_column_to_variation_templates_table',6),(367,'2018_12_03_163945_add_woocommerce_permissions',6),(368,'2019_02_18_154414_change_woocommerce_sync_logs_table',6),(369,'2019_04_19_174129_add_disable_woocommerce_sync_column_to_products_table',6),(370,'2019_06_08_132440_add_woocommerce_wh_oc_secret_column_to_business_table',6),(371,'2019_10_01_171828_add_woocommerce_media_id_columns',6),(372,'2020_09_07_124952_add_woocommerce_skipped_orders_fields_to_business_table',6),(373,'2021_02_16_190608_add_woocommerce_module_indexing',6),(374,'2019_07_15_114211_add_manufacturing_module_version_to_system_table',7),(375,'2019_07_15_114403_create_mfg_recipes_table',7),(376,'2019_07_18_180217_add_production_columns_to_transactions_table',7),(377,'2019_07_26_110753_add_manufacturing_settings_column_to_business_table',7),(378,'2019_07_26_170450_add_manufacturing_permissions',7),(379,'2019_08_08_110035_create_mfg_recipe_ingredients_table',7),(380,'2019_08_08_172837_add_recipe_add_edit_permissions',7),(381,'2019_08_12_114610_add_ingredient_waste_percent_columns',7),(382,'2019_11_05_115136_create_ingredient_groups_table',7),(383,'2020_02_22_120303_add_column_to_mfg_recipe_ingredients_table',7),(384,'2020_08_19_103831_add_production_cost_type_to_recipe_and_transaction_table',7),(385,'2021_02_16_190302_add_manufacturing_module_indexing',7),(386,'2021_04_07_154331_add_mfg_ingredient_group_id_to_transaction_sell_lines_table',7),(387,'2019_03_07_155813_make_repair_statuses_table',8),(388,'2019_03_08_120634_add_repair_columns_to_transactions_table',8),(389,'2019_03_14_182704_add_repair_permissions',8),(390,'2019_03_29_110241_add_repair_version_column_to_system_table',8),(391,'2019_04_12_113901_add_repair_settings_column_to_business_table',8),(392,'2020_05_05_125008_create_device_models_table',8),(393,'2020_05_06_103135_add_repair_model_id_column_to_products_table',8),(394,'2020_07_11_120308_add_columns_to_repair_statuses_table',8),(395,'2020_07_31_130737_create_job_sheets_table',8),(396,'2020_08_07_124241_add_job_sheet_id_to_transactions_table',8),(397,'2020_08_22_104640_add_email_template_field_to_repair_status_table',8),(398,'2020_10_19_131934_add_job_sheet_custom_fields_to_repair_job_sheets_table',8),(399,'2020_11_25_111050_add_parts_column_to_repair_job_sheets_table',8),(400,'2020_12_30_101842_add_use_for_repair_column_to_brands_table',8),(401,'2021_02_16_190423_add_repair_module_indexing',8),(402,'2022_12_23_162847_add_repair_jobsheet_settings_column_to_business_table',8),(403,'2020_03_19_130231_add_contact_id_to_users_table',9),(404,'2020_03_27_133605_create_schedules_table',9),(405,'2020_03_27_133628_create_schedule_users_table',9),(406,'2020_03_30_112834_create_schedule_logs_table',9),(407,'2020_04_02_182331_add_crm_module_version_to_system_table',9),(408,'2020_04_08_153231_modify_cloumn_in_contacts_table',9),(409,'2020_04_09_101052_create_lead_users_table',9),(410,'2020_04_16_114747_create_crm_campaigns_table',9),(411,'2021_01_07_155757_add_followup_additional_info_column_to_crm_schedules_table',9),(412,'2021_02_02_140021_add_additional_info_to_crm_campaigns_table',9),(413,'2021_02_02_173651_add_new_columns_to_contacts_table',9),(414,'2021_02_04_120439_create_call_logs_table',9),(415,'2021_02_08_172047_add_mobile_name_column_to_crm_call_logs_table',9),(416,'2021_02_16_190038_add_crm_module_indexing',9),(417,'2021_02_19_120846_create_crm_followup_invoices',9),(418,'2021_02_22_132125_add_follow_up_by_to_crm_schedules_table',9),(419,'2021_03_24_160736_add_department_and_designation_to_users_table',9),(420,'2021_06_15_152924_create_proposal_templates_table',9),(421,'2021_06_16_114448_add_recursive_fields_to_crm_schedules_table',9),(422,'2021_06_16_125740_create_proposals_table',9),(423,'2021_09_24_065738_add_crm_settings_column_to_business_table',9),(424,'2022_02_09_055012_create_crm_marketplaces_table',9),(425,'2022_02_17_113045_add_source_id_to_marketplace',9),(426,'2022_03_02_180929_add_followup_category_id',9),(427,'2022_05_26_061553_create_crm_contact_person_commissions_table',9),(428,'2022_06_06_073006_add_cc_and_bcc_columns_to_crm_proposals_table',9);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
INSERT INTO `model_has_permissions` VALUES (80,'App\\User',1),(80,'App\\User',3),(80,'App\\User',4),(80,'App\\User',5),(80,'App\\User',6),(80,'App\\User',7),(80,'App\\User',11),(80,'App\\User',12);
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES (1,'App\\User',1),(3,'App\\User',2),(5,'App\\User',3),(5,'App\\User',4),(5,'App\\User',5),(7,'App\\User',6),(8,'App\\User',7),(9,'App\\User',8),(11,'App\\User',9),(13,'App\\User',10),(13,'App\\User',12),(14,'App\\User',11),(15,'App\\User',13);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) NOT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `whatsapp_text` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `cc` varchar(191) DEFAULT NULL,
  `bcc` varchar(191) DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES (1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(10,1,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-01-29 10:46:29','2025-01-29 10:46:29'),(11,2,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(12,2,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(13,2,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(14,2,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(15,2,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(16,2,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(17,2,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(18,2,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(19,2,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(20,2,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:36:47','2025-02-02 17:36:47'),(21,3,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:44:33','2025-02-02 17:44:33'),(22,3,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:44:33','2025-02-02 17:44:33'),(23,3,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:44:33','2025-02-02 17:44:33'),(24,3,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:44:33','2025-02-02 17:44:33'),(25,3,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:44:33','2025-02-02 17:44:33'),(26,3,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:44:33','2025-02-02 17:44:33'),(27,3,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:44:33','2025-02-02 17:44:33'),(28,3,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:44:33','2025-02-02 17:44:33'),(29,3,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:44:33','2025-02-02 17:44:33'),(30,3,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-02 17:44:33','2025-02-02 17:44:33'),(31,4,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-10 12:16:25','2025-02-10 12:16:25'),(32,4,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-02-10 12:16:25','2025-02-10 12:16:25'),(33,4,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-02-10 12:16:25','2025-02-10 12:16:25'),(34,4,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-02-10 12:16:25','2025-02-10 12:16:25'),(35,4,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-10 12:16:25','2025-02-10 12:16:25'),(36,4,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-02-10 12:16:25','2025-02-10 12:16:25'),(37,4,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-02-10 12:16:25','2025-02-10 12:16:25'),(38,4,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-02-10 12:16:25','2025-02-10 12:16:25'),(39,4,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-10 12:16:25','2025-02-10 12:16:25'),(40,4,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-10 12:16:25','2025-02-10 12:16:25'),(41,5,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-12 11:50:59','2025-02-12 11:50:59'),(42,5,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-02-12 11:50:59','2025-02-12 11:50:59'),(43,5,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-02-12 11:50:59','2025-02-12 11:50:59'),(44,5,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-02-12 11:50:59','2025-02-12 11:50:59'),(45,5,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-12 11:50:59','2025-02-12 11:50:59'),(46,5,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-02-12 11:50:59','2025-02-12 11:50:59'),(47,5,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-02-12 11:50:59','2025-02-12 11:50:59'),(48,5,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-02-12 11:50:59','2025-02-12 11:50:59'),(49,5,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-12 11:50:59','2025-02-12 11:50:59'),(50,5,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-12 11:50:59','2025-02-12 11:50:59'),(51,6,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(52,6,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(53,6,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(54,6,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(55,6,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(56,6,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(57,6,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(58,6,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(59,6,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(60,6,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-13 09:32:44','2025-02-13 09:32:44'),(61,7,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-24 12:39:17','2025-02-24 12:39:17'),(62,7,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-02-24 12:39:17','2025-02-24 12:39:17'),(63,7,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-02-24 12:39:17','2025-02-24 12:39:17'),(64,7,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-02-24 12:39:17','2025-02-24 12:39:17'),(65,7,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-24 12:39:17','2025-02-24 12:39:17'),(66,7,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-02-24 12:39:17','2025-02-24 12:39:17'),(67,7,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-02-24 12:39:17','2025-02-24 12:39:17'),(68,7,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-02-24 12:39:17','2025-02-24 12:39:17'),(69,7,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-24 12:39:17','2025-02-24 12:39:17'),(70,7,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-24 12:39:17','2025-02-24 12:39:17'),(71,8,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-25 16:07:36','2025-02-25 16:07:36'),(72,8,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2025-02-25 16:07:36','2025-02-25 16:07:36'),(73,8,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2025-02-25 16:07:36','2025-02-25 16:07:36'),(74,8,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2025-02-25 16:07:36','2025-02-25 16:07:36'),(75,8,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-25 16:07:36','2025-02-25 16:07:36'),(76,8,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2025-02-25 16:07:36','2025-02-25 16:07:36'),(77,8,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2025-02-25 16:07:36','2025-02-25 16:07:36'),(78,8,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2025-02-25 16:07:36','2025-02-25 16:07:36'),(79,8,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2025-02-25 16:07:36','2025-02-25 16:07:36'),(80,8,'purchase_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new purchase order with reference number {order_ref_number}. The respective invoice is attached here with.</p>\n\n                    <p>{business_logo}</p>','We have a new purchase order with reference number {order_ref_number}. {business_name}',NULL,'New Purchase Order, from {business_name}',NULL,NULL,0,0,0,'2025-02-25 16:07:36','2025-02-25 16:07:36');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `secret` varchar(100) NOT NULL,
  `provider` varchar(191) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
INSERT INTO `oauth_clients` VALUES (1,NULL,'Smart POS Personal Access Client','3Ut04O32zyBpXEJQc2MXn6K5E8ogWqIl58FUCN57',NULL,'http://localhost',1,0,0,'2025-02-24 17:27:49','2025-02-24 17:27:49'),(2,NULL,'Smart POS Password Grant Client','0pBHuS5GZcLWKRmOJXN1jjydarGMJzGw9jCxRE0D','users','http://localhost',0,1,0,'2025-02-24 17:27:49','2025-02-24 17:27:49'),(3,NULL,'Smart POS Personal Access Client','e5u4Q8THUqtfhAiX0yO74oFvpGBCg4vN9h7pEhmm',NULL,'http://localhost',1,0,0,'2025-02-25 04:23:32','2025-02-25 04:23:32'),(4,NULL,'Smart POS Password Grant Client','wRm9xIJZCa8WpJBpKMOkARoKMCvSAZnrjrDttwd4','users','http://localhost',0,1,0,'2025-02-25 04:23:32','2025-02-25 04:23:32');
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
INSERT INTO `oauth_personal_access_clients` VALUES (1,1,'2025-02-24 17:27:49','2025-02-24 17:27:49'),(2,3,'2025-02-25 04:23:32','2025-02-25 04:23:32');
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `packages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text NOT NULL,
  `location_count` int(11) NOT NULL COMMENT 'No. of Business Locations, 0 = infinite option.',
  `user_count` int(11) NOT NULL,
  `product_count` int(11) NOT NULL,
  `bookings` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable bookings',
  `kitchen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable kitchen',
  `order_screen` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable order_screen',
  `tables` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Enable/Disable tables',
  `invoice_count` int(11) NOT NULL,
  `interval` enum('days','months','years') NOT NULL,
  `interval_count` int(11) NOT NULL,
  `trial_days` int(11) NOT NULL,
  `price` decimal(22,4) NOT NULL,
  `custom_permissions` longtext NOT NULL,
  `created_by` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL,
  `mark_package_as_popular` tinyint(1) NOT NULL,
  `businesses` longtext DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `is_one_time` tinyint(1) NOT NULL DEFAULT 0,
  `enable_custom_link` tinyint(1) NOT NULL DEFAULT 0,
  `custom_link` varchar(191) DEFAULT NULL,
  `custom_link_text` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `packages` WRITE;
/*!40000 ALTER TABLE `packages` DISABLE KEYS */;
/*!40000 ALTER TABLE `packages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,'profit_loss_report.view','web','2025-01-29 10:04:43',NULL),(2,'direct_sell.access','web','2025-01-29 10:04:43',NULL),(3,'product.opening_stock','web','2025-01-29 10:04:44','2025-01-29 10:04:44'),(4,'crud_all_bookings','web','2025-01-29 10:04:44','2025-01-29 10:04:44'),(5,'crud_own_bookings','web','2025-01-29 10:04:44','2025-01-29 10:04:44'),(6,'access_default_selling_price','web','2025-01-29 10:04:45','2025-01-29 10:04:45'),(7,'purchase.payments','web','2025-01-29 10:04:45','2025-01-29 10:04:45'),(8,'sell.payments','web','2025-01-29 10:04:45','2025-01-29 10:04:45'),(9,'edit_product_price_from_sale_screen','web','2025-01-29 10:04:45','2025-01-29 10:04:45'),(10,'edit_product_discount_from_sale_screen','web','2025-01-29 10:04:45','2025-01-29 10:04:45'),(11,'roles.view','web','2025-01-29 10:04:45','2025-01-29 10:04:45'),(12,'roles.create','web','2025-01-29 10:04:45','2025-01-29 10:04:45'),(13,'roles.update','web','2025-01-29 10:04:45','2025-01-29 10:04:45'),(14,'roles.delete','web','2025-01-29 10:04:45','2025-01-29 10:04:45'),(15,'account.access','web','2025-01-29 10:04:46','2025-01-29 10:04:46'),(16,'discount.access','web','2025-01-29 10:04:46','2025-01-29 10:04:46'),(17,'view_purchase_price','web','2025-01-29 10:04:46','2025-01-29 10:04:46'),(18,'view_own_sell_only','web','2025-01-29 10:04:46','2025-01-29 10:04:46'),(19,'edit_product_discount_from_pos_screen','web','2025-01-29 10:04:47','2025-01-29 10:04:47'),(20,'edit_product_price_from_pos_screen','web','2025-01-29 10:04:47','2025-01-29 10:04:47'),(21,'access_shipping','web','2025-01-29 10:04:47','2025-01-29 10:04:47'),(22,'purchase.update_status','web','2025-01-29 10:04:47','2025-01-29 10:04:47'),(23,'list_drafts','web','2025-01-29 10:04:47','2025-01-29 10:04:47'),(24,'list_quotations','web','2025-01-29 10:04:47','2025-01-29 10:04:47'),(25,'view_cash_register','web','2025-01-29 10:04:48','2025-01-29 10:04:48'),(26,'close_cash_register','web','2025-01-29 10:04:48','2025-01-29 10:04:48'),(27,'print_invoice','web','2025-01-29 10:04:49','2025-01-29 10:04:49'),(28,'user.view','web','2025-01-29 10:04:50',NULL),(29,'user.create','web','2025-01-29 10:04:50',NULL),(30,'user.update','web','2025-01-29 10:04:50',NULL),(31,'user.delete','web','2025-01-29 10:04:50',NULL),(32,'supplier.view','web','2025-01-29 10:04:50',NULL),(33,'supplier.create','web','2025-01-29 10:04:50',NULL),(34,'supplier.update','web','2025-01-29 10:04:50',NULL),(35,'supplier.delete','web','2025-01-29 10:04:50',NULL),(36,'customer.view','web','2025-01-29 10:04:50',NULL),(37,'customer.create','web','2025-01-29 10:04:50',NULL),(38,'customer.update','web','2025-01-29 10:04:50',NULL),(39,'customer.delete','web','2025-01-29 10:04:50',NULL),(40,'product.view','web','2025-01-29 10:04:50',NULL),(41,'product.create','web','2025-01-29 10:04:50',NULL),(42,'product.update','web','2025-01-29 10:04:50',NULL),(43,'product.delete','web','2025-01-29 10:04:50',NULL),(44,'purchase.view','web','2025-01-29 10:04:50',NULL),(45,'purchase.create','web','2025-01-29 10:04:50',NULL),(46,'purchase.update','web','2025-01-29 10:04:50',NULL),(47,'purchase.delete','web','2025-01-29 10:04:50',NULL),(48,'sell.view','web','2025-01-29 10:04:50',NULL),(49,'sell.create','web','2025-01-29 10:04:50',NULL),(50,'sell.update','web','2025-01-29 10:04:50',NULL),(51,'sell.delete','web','2025-01-29 10:04:50',NULL),(52,'purchase_n_sell_report.view','web','2025-01-29 10:04:50',NULL),(53,'contacts_report.view','web','2025-01-29 10:04:50',NULL),(54,'stock_report.view','web','2025-01-29 10:04:50',NULL),(55,'tax_report.view','web','2025-01-29 10:04:50',NULL),(56,'trending_product_report.view','web','2025-01-29 10:04:50',NULL),(57,'register_report.view','web','2025-01-29 10:04:50',NULL),(58,'sales_representative.view','web','2025-01-29 10:04:50',NULL),(59,'expense_report.view','web','2025-01-29 10:04:50',NULL),(60,'business_settings.access','web','2025-01-29 10:04:50',NULL),(61,'barcode_settings.access','web','2025-01-29 10:04:50',NULL),(62,'invoice_settings.access','web','2025-01-29 10:04:50',NULL),(63,'brand.view','web','2025-01-29 10:04:50',NULL),(64,'brand.create','web','2025-01-29 10:04:50',NULL),(65,'brand.update','web','2025-01-29 10:04:50',NULL),(66,'brand.delete','web','2025-01-29 10:04:50',NULL),(67,'tax_rate.view','web','2025-01-29 10:04:50',NULL),(68,'tax_rate.create','web','2025-01-29 10:04:50',NULL),(69,'tax_rate.update','web','2025-01-29 10:04:50',NULL),(70,'tax_rate.delete','web','2025-01-29 10:04:50',NULL),(71,'unit.view','web','2025-01-29 10:04:50',NULL),(72,'unit.create','web','2025-01-29 10:04:50',NULL),(73,'unit.update','web','2025-01-29 10:04:50',NULL),(74,'unit.delete','web','2025-01-29 10:04:50',NULL),(75,'category.view','web','2025-01-29 10:04:50',NULL),(76,'category.create','web','2025-01-29 10:04:50',NULL),(77,'category.update','web','2025-01-29 10:04:50',NULL),(78,'category.delete','web','2025-01-29 10:04:50',NULL),(79,'expense.access','web','2025-01-29 10:04:50',NULL),(80,'access_all_locations','web','2025-01-29 10:04:50',NULL),(81,'dashboard.data','web','2025-01-29 10:04:50',NULL),(82,'location.1','web','2025-01-29 10:46:29','2025-01-29 10:46:29'),(83,'location.2','web','2025-02-02 17:36:47','2025-02-02 17:36:47'),(84,'location.3','web','2025-02-02 17:44:33','2025-02-02 17:44:33'),(85,'location.4','web','2025-02-10 12:16:25','2025-02-10 12:16:25'),(86,'edit_pos_payment','web','2025-02-10 14:11:42','2025-02-10 14:11:42'),(87,'location.5','web','2025-02-12 11:50:59','2025-02-12 11:50:59'),(88,'location.6','web','2025-02-13 09:32:44','2025-02-13 09:32:44'),(89,'location.7','web','2025-02-24 12:39:17','2025-02-24 12:39:17'),(90,'essentials.create_message','web','2025-02-25 05:26:20','2025-02-25 05:26:20'),(91,'essentials.view_message','web','2025-02-25 05:26:20','2025-02-25 05:26:20'),(92,'essentials.approve_leave','web','2025-02-25 05:26:20','2025-02-25 05:26:20'),(93,'essentials.assign_todos','web','2025-02-25 05:26:21','2025-02-25 05:26:21'),(94,'essentials.add_allowance_and_deduction','web','2025-02-25 05:26:21','2025-02-25 05:26:21'),(95,'woocommerce.syc_categories','web','2025-02-25 07:03:13','2025-02-25 07:03:13'),(96,'woocommerce.sync_products','web','2025-02-25 07:03:13','2025-02-25 07:03:13'),(97,'woocommerce.sync_orders','web','2025-02-25 07:03:13','2025-02-25 07:03:13'),(98,'woocommerce.map_tax_rates','web','2025-02-25 07:03:13','2025-02-25 07:03:13'),(99,'woocommerce.access_woocommerce_api_settings','web','2025-02-25 07:03:13','2025-02-25 07:03:13'),(100,'manufacturing.access_recipe','web','2025-02-25 07:30:58','2025-02-25 07:30:58'),(101,'manufacturing.access_production','web','2025-02-25 07:30:58','2025-02-25 07:30:58'),(102,'manufacturing.add_recipe','web','2025-02-25 07:30:58','2025-02-25 07:30:58'),(103,'manufacturing.edit_recipe','web','2025-02-25 07:30:58','2025-02-25 07:30:58'),(104,'repair.create','web','2025-02-25 07:57:16','2025-02-25 07:57:16'),(105,'repair.update','web','2025-02-25 07:57:16','2025-02-25 07:57:16'),(106,'repair.view','web','2025-02-25 07:57:16','2025-02-25 07:57:16'),(107,'repair.delete','web','2025-02-25 07:57:16','2025-02-25 07:57:16'),(108,'repair_status.update','web','2025-02-25 07:57:16','2025-02-25 07:57:16'),(109,'repair_status.access','web','2025-02-25 07:57:16','2025-02-25 07:57:16'),(110,'location.8','web','2025-02-25 16:07:36','2025-02-25 16:07:36'),(111,'direct_sell.update','web','2025-03-02 06:39:24','2025-03-02 06:39:24'),(112,'edit_sell_payment','web','2025-03-02 06:39:24','2025-03-02 06:39:24'),(113,'access_types_of_service','web','2025-03-02 06:39:24','2025-03-02 06:39:24'),(114,'access_sell_return','web','2025-03-02 06:39:24','2025-03-02 06:39:24'),(115,'access_own_sell_return','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(116,'draft.update','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(117,'draft.delete','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(118,'quotation.update','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(119,'quotation.delete','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(120,'access_pending_shipments_only','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(121,'access_commission_agent_shipping','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(122,'view_product_stock_value','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(123,'access_printers','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(124,'expense.add','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(125,'expense.edit','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(126,'expense.delete','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(127,'accounting.access_accounting_module','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(128,'accounting.manage_accounts','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(129,'accounting.view_journal','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(130,'accounting.add_journal','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(131,'accounting.edit_journal','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(132,'accounting.map_transactions','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(133,'accounting.view_transfer','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(134,'accounting.add_transfer','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(135,'accounting.edit_transfer','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(136,'accounting.manage_budget','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(137,'essentials.crud_leave_type','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(138,'direct_sell.view','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(139,'draft.view_own','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(140,'quotation.view_own','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(141,'access_own_shipping','web','2025-03-02 06:39:25','2025-03-02 06:39:25'),(142,'view_own_expense','web','2025-03-02 06:39:25','2025-03-02 06:39:25');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `connection_type` enum('network','windows','linux') NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `port` varchar(191) DEFAULT NULL,
  `path` varchar(191) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`),
  CONSTRAINT `printers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES (1,1),(2,1),(3,3),(4,2),(5,1),(6,1),(7,1),(8,1),(9,1),(10,3),(11,3),(12,3),(13,3),(14,3),(15,3),(16,3),(17,3),(18,3),(19,3),(20,3),(21,3),(22,3),(23,3),(24,3),(25,3),(26,3),(27,3),(28,3),(29,3),(30,3),(31,3),(32,3),(33,3),(34,3),(35,3),(36,3),(37,3),(38,3),(39,3),(40,3),(41,3),(42,3),(43,3),(44,3),(45,3),(46,3),(47,3),(48,3),(49,3),(50,3),(51,3),(52,3),(53,3),(54,3),(55,3),(56,3),(57,3),(58,3),(59,3),(60,3),(61,3),(62,3),(63,3),(64,3),(65,3),(66,3),(67,3),(68,3),(69,3),(70,3),(71,3),(72,3),(73,3),(74,3),(75,3),(76,3),(77,3),(78,3),(79,3),(80,3),(81,3),(82,3),(83,3),(84,3),(85,3),(86,3),(87,3),(88,3),(89,3),(90,3),(91,3),(92,3),(93,3),(94,3),(95,3),(96,3),(97,3),(98,3),(99,3),(100,3),(101,3),(102,3),(103,3),(104,3),(105,3),(106,3),(107,3),(108,3),(109,3),(110,3),(111,4),(112,4),(113,3),(114,5),(115,5),(116,5),(117,5),(118,5),(119,5),(120,5),(121,5),(122,5),(123,5),(124,5),(125,5),(126,5),(127,5),(128,5),(129,5),(130,5),(131,5),(132,5),(133,5),(134,5),(135,5),(136,5),(137,5),(138,5),(139,5),(140,5),(141,5),(142,5),(143,5),(144,5),(145,5),(146,5),(147,5),(148,5),(149,5),(150,5),(151,5),(152,5),(153,5),(154,5),(155,5),(156,5),(157,5),(158,5),(159,5),(160,5),(161,5),(162,5),(163,5),(164,5),(165,5),(166,5),(167,5),(168,5),(169,5),(170,5),(171,5),(172,5),(173,5),(174,5),(175,5),(176,5),(177,5),(178,5),(179,5),(180,5),(181,5),(182,5),(183,5),(184,5),(185,5),(186,5),(187,5),(188,5),(189,5),(190,5),(191,5),(192,5),(193,5),(194,5),(195,5),(196,5),(197,5),(198,5),(199,5),(200,5),(201,5),(202,5),(203,5),(204,5),(205,5),(206,5),(207,5),(208,5),(209,5),(210,5),(211,5),(212,5),(213,5),(214,5),(215,5),(216,5),(217,5),(218,5),(219,5),(220,5),(221,5),(222,5),(223,5),(224,5),(225,5),(226,5),(227,5),(228,5),(229,5),(230,5),(231,5),(232,5),(233,5),(234,5),(235,5),(236,5),(237,5),(238,5),(239,5),(240,5),(241,5),(242,5),(243,5),(244,5),(245,5),(246,5),(247,5),(248,5),(249,5),(250,5),(251,5),(252,5),(253,5),(254,5),(255,5),(256,5),(257,5),(258,5),(259,5),(260,5),(261,5),(262,5),(263,5),(264,5),(265,5),(266,5),(267,5),(268,5),(269,5),(270,5),(271,5),(272,5),(273,5),(274,5),(275,5),(276,5),(277,5),(278,5),(279,5),(280,5),(281,5),(282,5),(283,5),(284,5),(285,5),(286,5),(287,5),(288,5),(289,5),(290,5),(291,5),(292,5),(293,5),(294,5),(295,5),(296,5),(297,5),(298,5),(299,5),(300,5),(301,5),(302,5),(303,5),(304,5),(305,5),(306,5),(307,5),(308,5),(309,5),(310,5),(311,5),(312,5),(313,5),(314,5),(315,5),(316,5),(317,5),(318,5),(319,5),(320,5),(321,5),(322,5),(323,5),(324,5),(325,5),(326,5),(327,5),(328,5),(329,5),(330,5),(331,5),(332,5),(333,5),(334,5),(335,5),(336,5),(337,5),(338,5),(339,5),(340,5),(341,5),(342,5),(343,5),(344,5),(345,5),(346,5),(347,5),(348,5),(349,5),(350,5),(351,5),(352,5),(353,5),(354,5),(355,5),(356,5),(357,5),(358,5),(359,5),(360,5),(361,5),(362,5),(363,5),(364,5),(365,5),(366,5),(367,5),(368,5),(369,5),(370,5),(371,5),(372,5),(373,5),(374,5),(375,5),(376,5),(377,5),(378,5),(379,5),(380,5),(381,5),(382,5),(383,5),(384,5),(385,5),(386,5),(387,5),(388,5),(389,5),(390,5),(391,5),(392,5),(393,5),(394,5),(395,5),(396,5),(397,5),(398,5),(399,5),(400,5),(401,5),(402,5),(403,5),(404,5),(405,5),(406,5),(407,5),(408,5),(409,5),(410,5),(411,5),(412,5),(413,5),(414,5),(415,5),(416,5),(417,5),(418,5),(419,5),(420,5),(421,5),(422,5),(423,5),(424,5),(425,5),(426,5),(427,5),(428,5),(429,5),(430,5),(431,5),(432,5),(433,5),(434,5),(435,5),(436,5),(437,5),(438,5),(439,5),(440,5),(441,5),(442,5),(443,5),(444,5),(445,5),(446,5),(447,5),(448,5),(449,5),(450,5),(451,5),(452,5),(453,5),(454,5),(455,5),(456,5),(457,5),(458,5),(459,5),(460,5),(461,5),(462,5),(463,5),(464,5),(465,5),(466,5),(467,5),(468,5),(469,5),(470,5),(471,5),(472,5),(473,5),(474,5),(475,5),(476,5),(477,5),(478,5),(479,5),(480,5),(481,5),(482,5),(483,5),(484,5),(485,5),(486,5),(487,5),(488,5),(489,5),(490,5),(491,5),(492,5),(493,5),(494,5),(495,5),(496,5),(497,5),(498,5),(499,5),(500,5),(501,5),(502,5),(503,5),(504,5),(505,5),(506,5),(507,5),(508,5),(509,5),(510,5),(511,5),(512,5),(513,5),(514,5),(515,5),(516,5),(517,5),(518,5),(519,5),(520,5),(521,5),(522,5),(523,5),(524,5),(525,5),(526,5),(527,5),(528,5),(529,5),(530,5),(531,5),(532,5),(533,5),(534,5),(535,5),(536,5),(537,5),(538,5),(539,5),(540,5),(541,5),(542,5),(543,5),(544,5),(545,5),(546,5),(547,5),(548,5),(549,5),(550,5),(551,5),(552,5),(553,5),(554,5),(555,5),(556,5),(557,5),(558,5),(559,5),(560,5),(561,5),(562,5),(563,5),(564,5),(565,5),(566,5),(567,5),(568,5),(569,5),(570,5),(571,5),(572,5),(573,5),(574,5),(575,5),(576,5),(577,5),(578,5),(579,5),(580,5),(581,5),(582,5),(583,5),(584,5),(585,5),(586,5),(587,5),(588,5),(589,5),(590,5),(591,5),(592,5),(593,5),(594,5),(595,5),(596,5),(597,5),(598,5),(599,5),(600,5),(601,5),(602,5),(603,5),(604,5),(605,5),(606,5),(607,5),(608,5),(609,5),(610,5),(611,5),(612,5),(613,5),(614,5),(615,5),(616,5),(617,5),(618,5),(619,5),(620,5),(621,5),(622,5),(623,5),(624,5),(625,5),(626,5),(627,5),(628,5),(629,5),(630,5),(631,5),(632,5),(633,5),(634,5),(635,5),(636,5),(637,5),(638,5),(639,5),(640,5),(641,5),(642,5),(643,5),(644,5),(645,5),(646,5),(647,5),(648,5),(649,5),(650,5),(651,5),(652,5),(653,5),(654,5),(655,5),(656,5),(657,5),(658,5),(659,5),(660,5),(661,5),(662,5),(663,5),(664,5),(665,5),(666,5),(667,5),(668,5),(669,5),(670,5),(671,5),(672,5),(673,5),(674,5),(675,5),(676,5),(677,5),(678,5),(679,5),(680,5),(681,5),(682,5),(683,5),(684,5),(685,5),(686,5),(687,5),(688,5),(689,5),(690,5),(691,5),(692,5),(693,5),(694,5),(695,5),(696,5),(697,5),(698,5),(699,5),(700,5),(701,5),(702,5),(703,5),(704,5),(705,5),(706,5),(707,5),(708,5),(709,5),(710,5),(711,5),(712,5),(713,5),(714,5),(715,5),(716,5),(717,5),(718,5),(719,5),(720,5),(721,5),(722,5),(723,5),(724,5),(725,5),(726,5),(727,5),(728,5),(729,5),(730,5),(731,5),(732,5),(733,5),(734,5),(735,5),(736,5),(737,5),(738,5),(739,5),(740,5),(741,5),(742,5),(743,5),(744,5),(745,5),(746,5),(747,5),(748,5),(749,5),(750,5),(751,5),(752,5),(753,5),(754,5),(755,5),(756,5),(757,5),(758,5),(759,5),(760,5),(761,5),(762,5),(763,5),(764,5),(765,5),(766,5),(767,5),(768,5),(769,5),(770,5),(771,5),(772,5),(773,5),(774,5),(775,5),(776,5),(777,5),(778,5),(779,5),(780,5),(781,5),(782,5),(783,5),(784,5),(785,5),(786,5),(787,5),(788,5),(789,5),(790,5),(791,5),(792,5),(793,5),(794,5),(795,5),(796,5),(797,5),(798,5),(799,5),(800,5),(801,5),(802,5),(803,5),(804,5),(805,5),(806,5),(807,5),(808,5),(809,5),(810,5),(811,5),(812,5),(813,5),(814,5),(815,5),(816,5),(817,5),(818,5),(819,5),(820,5),(821,5),(822,5),(823,5),(824,5),(825,5),(826,5),(827,5),(828,5),(829,5),(830,5),(831,5),(832,5),(833,5),(834,5),(835,5),(836,5),(837,5),(838,5),(839,5),(840,5),(841,5),(842,5),(843,5),(844,5),(845,5),(846,5),(847,5),(848,5),(849,5),(850,5),(851,5),(852,5),(853,5),(854,5),(855,5),(856,5),(857,5),(858,5),(859,5),(860,5),(861,5),(862,5),(863,5),(864,5),(865,5),(866,5),(867,5),(868,5),(869,5),(870,5),(871,5),(872,5),(873,5),(874,5),(875,5),(876,5),(877,5),(878,5),(879,5),(880,5),(881,5),(882,5),(883,5),(884,5),(885,5),(886,5),(887,5),(888,5),(889,5),(890,5),(891,5),(892,5),(893,5),(894,5),(895,5),(896,5),(897,5),(898,5),(899,5),(900,5),(901,5),(902,5),(903,5),(904,5),(905,5),(906,5),(907,5),(908,5),(909,5),(910,5),(911,5),(912,5),(913,5),(914,5),(915,5),(916,5),(917,5),(918,5),(919,5),(920,5),(921,5),(922,5),(923,5),(924,5),(925,5),(926,5),(927,5),(928,5),(929,5),(930,5),(931,5),(932,5),(933,5),(934,5),(935,5),(936,5),(937,5),(938,5),(939,5),(940,5),(941,5),(942,5),(943,5),(944,5),(945,5),(946,5),(947,5),(948,5),(949,5),(950,5),(951,5),(952,5),(953,5),(954,5),(955,5),(956,5),(957,5),(958,5),(959,5),(960,5),(961,5),(962,5),(963,5),(964,5),(965,5),(966,5),(967,5),(968,5),(969,5),(970,5),(971,5),(972,5),(973,5),(974,5),(975,5),(976,5),(977,5),(978,5),(979,5),(980,5),(981,5),(982,5),(983,5),(984,5),(985,5),(986,5),(987,5),(988,5),(989,5),(990,5),(991,5),(992,5),(993,5),(994,5),(995,5),(996,5),(997,5),(998,5),(999,5),(1000,5),(1001,5),(1002,5),(1003,5),(1004,5),(1005,5),(1006,5),(1007,5),(1008,5),(1009,5),(1010,5),(1011,5),(1012,5),(1013,5),(1014,5),(1015,5),(1016,5),(1017,5),(1018,5),(1019,5),(1020,5),(1021,5),(1022,5),(1023,5),(1024,5),(1025,5),(1026,5),(1027,5),(1028,5),(1029,5),(1030,5),(1031,5),(1032,5),(1033,5),(1034,5),(1035,5),(1036,5),(1037,5),(1038,5),(1039,5),(1040,5),(1041,5),(1042,5),(1043,5),(1044,5),(1045,5),(1046,5),(1047,5),(1048,5),(1049,5),(1050,5),(1051,5),(1052,5),(1053,5),(1054,5),(1055,5),(1056,5),(1057,5),(1058,5),(1059,5),(1060,5),(1061,5),(1062,5),(1063,5),(1064,5),(1065,5),(1066,5),(1067,5),(1068,5),(1069,5),(1070,5),(1071,5),(1072,5),(1073,5),(1074,5),(1075,5),(1076,5),(1077,5),(1078,5),(1079,5),(1080,5),(1081,5),(1082,5),(1083,5),(1084,5),(1085,5),(1086,5),(1087,5),(1088,5),(1089,5),(1090,5),(1091,5),(1092,5),(1093,5),(1094,5),(1095,5),(1096,5),(1097,5),(1098,5),(1099,5),(1100,5),(1101,5),(1102,5),(1103,5),(1104,5),(1105,5),(1106,5),(1107,5),(1108,5),(1109,5),(1110,5),(1111,5),(1112,5),(1113,5),(1114,5),(1115,5),(1116,5),(1117,5),(1118,5),(1119,5),(1120,5),(1121,5),(1122,5),(1123,5),(1124,5),(1125,5),(1126,5),(1127,5),(1128,5),(1129,5),(1130,5),(1131,5),(1132,5),(1133,5),(1134,5),(1135,5),(1136,5),(1137,5),(1138,5),(1139,5),(1140,5),(1141,5),(1142,5),(1143,5),(1144,5),(1145,5),(1146,5),(1147,5),(1148,5),(1149,5),(1150,5),(1151,5),(1152,5),(1153,5),(1154,5),(1155,5),(1156,5),(1157,5),(1158,5),(1159,5),(1160,5),(1161,5),(1162,5),(1163,5),(1164,5),(1165,5),(1166,5),(1167,5),(1168,5),(1169,5),(1170,5),(1171,5),(1172,5),(1173,5),(1174,5),(1175,5),(1176,5),(1177,5),(1178,5),(1179,5),(1180,5),(1181,5),(1182,5),(1183,5),(1184,5),(1185,5),(1186,5),(1187,5),(1188,5),(1189,5),(1190,5),(1191,5),(1192,5),(1193,5),(1194,5),(1195,5),(1196,5),(1197,5),(1198,5),(1199,5),(1200,5),(1201,5),(1202,5),(1203,5),(1204,5),(1205,5),(1206,5),(1207,5),(1208,5),(1209,5),(1210,5),(1211,5),(1212,5),(1213,5),(1214,5),(1215,5),(1216,5),(1217,5),(1218,5),(1219,5),(1220,5),(1221,5),(1222,5),(1223,5),(1224,5),(1225,5),(1226,5),(1227,5),(1228,5),(1229,5),(1230,5),(1231,5),(1232,5),(1233,5),(1234,5),(1235,5),(1236,5),(1237,5),(1238,5),(1239,5),(1240,5),(1241,5),(1242,5),(1243,5),(1244,5),(1245,5),(1246,5),(1247,5),(1248,5),(1249,5),(1250,5),(1251,5),(1252,5),(1253,5),(1254,5),(1255,5),(1256,5),(1257,5),(1258,5),(1259,5),(1260,5),(1261,5),(1262,5),(1263,5),(1264,5),(1265,5),(1266,5),(1267,5),(1268,5),(1269,5),(1270,5),(1271,5),(1272,5),(1273,5),(1274,5),(1275,5),(1276,5),(1277,5),(1278,5),(1279,5),(1280,5),(1281,5),(1282,5),(1283,5),(1284,5),(1285,5),(1286,5),(1287,5),(1288,5),(1289,5),(1290,5),(1291,5),(1292,5),(1293,5),(1294,5),(1295,5),(1296,5),(1297,5),(1298,5),(1299,5),(1300,5),(1301,5),(1302,5),(1303,5),(1304,5),(1305,5),(1306,5),(1307,5),(1308,5),(1309,5),(1310,5),(1311,5),(1312,5),(1313,5),(1314,5),(1315,5),(1316,5),(1317,5),(1318,5),(1319,5),(1320,5),(1321,5),(1322,5),(1323,5),(1324,5),(1325,5),(1326,5),(1327,5),(1328,5),(1329,5),(1330,5),(1331,5),(1332,5),(1333,5),(1334,5),(1335,5),(1336,5),(1337,5),(1338,5),(1339,5),(1340,5),(1341,5),(1342,5),(1343,5),(1344,5),(1345,5),(1346,5),(1347,5),(1348,5),(1349,5),(1350,5),(1351,5),(1352,5),(1353,5),(1354,5),(1355,5),(1356,5),(1357,5),(1358,5),(1359,5),(1360,5),(1361,5),(1362,5),(1363,5),(1364,5),(1365,5),(1366,5),(1367,5),(1368,5),(1369,5),(1370,5),(1371,5),(1372,5),(1373,5),(1374,5),(1375,5),(1376,5),(1377,5),(1378,5),(1379,5),(1380,5),(1381,5),(1382,5),(1383,5),(1384,5),(1385,5),(1386,5),(1387,5),(1388,5),(1389,5),(1390,5),(1391,5),(1392,5),(1393,5),(1394,5),(1395,5),(1396,5),(1397,5),(1398,5),(1399,5),(1400,5),(1401,5),(1402,5),(1403,5),(1404,5),(1405,5),(1406,5),(1407,5),(1408,5),(1409,5),(1410,5),(1411,5),(1412,5),(1413,5),(1414,5),(1415,5),(1416,5),(1417,5),(1418,5),(1419,5),(1420,5),(1421,5),(1422,5),(1423,5),(1424,5),(1425,5),(1426,5),(1427,5),(1428,5),(1429,5),(1430,5),(1431,5),(1432,5),(1433,5),(1434,5),(1435,5),(1436,5),(1437,5),(1438,5),(1439,5),(1440,5),(1441,5),(1442,5),(1443,5),(1444,5),(1445,5),(1446,5),(1447,5),(1448,5),(1449,5),(1450,5),(1451,5),(1452,5),(1453,5),(1454,5),(1455,5),(1456,5),(1457,5),(1458,5),(1459,5),(1460,5),(1461,5),(1462,5),(1463,5),(1464,5),(1465,5),(1466,5),(1467,5),(1468,5),(1469,5),(1470,5),(1471,5),(1472,5),(1473,5),(1474,5),(1475,5),(1476,5),(1477,5),(1478,5),(1479,5),(1480,5),(1481,5),(1482,5),(1483,5),(1484,5),(1485,5),(1486,5),(1487,5),(1488,5),(1489,5),(1490,5),(1491,5),(1492,5),(1493,5),(1494,5),(1495,5),(1496,5),(1497,5),(1498,5),(1499,5),(1500,5),(1501,5),(1502,5),(1503,5),(1504,5),(1505,5),(1506,5),(1507,5),(1508,5),(1509,5),(1510,5),(1511,5),(1512,5),(1513,5),(1514,5),(1515,5),(1516,5),(1517,5),(1518,5),(1519,5),(1520,5),(1521,5),(1522,5),(1523,5),(1524,5),(1525,5),(1526,5),(1527,5),(1528,5),(1529,5),(1530,5),(1531,5),(1532,5),(1533,5),(1534,5),(1535,5),(1536,5),(1537,5),(1538,5),(1539,5),(1540,5),(1541,5),(1542,5),(1543,5),(1544,5),(1545,5),(1546,5),(1547,5),(1548,5),(1549,5),(1550,5),(1551,5),(1552,5),(1553,5),(1554,5),(1555,5),(1556,5),(1557,5),(1558,5),(1559,5),(1560,5),(1561,5),(1562,5),(1563,5),(1564,5),(1565,5),(1566,5),(1567,5),(1568,5),(1569,5),(1570,5),(1571,5),(1572,5),(1573,5),(1574,5),(1575,5),(1576,5),(1577,5),(1578,5),(1579,5),(1580,5),(1581,5),(1582,5),(1583,5),(1584,5),(1585,5),(1586,5),(1587,5),(1588,5),(1589,5),(1590,5),(1591,5),(1592,5),(1593,5),(1594,5),(1595,5),(1596,5),(1597,5),(1598,5),(1599,5),(1600,5),(1601,5),(1602,5),(1603,5),(1604,5),(1605,5),(1606,5),(1607,5),(1608,5),(1609,5),(1610,5),(1611,5),(1612,5),(1613,5),(1614,5),(1615,5),(1616,5),(1617,5),(1618,5),(1619,5),(1620,5),(1621,5),(1622,5),(1623,5),(1624,5),(1625,5),(1626,5),(1627,5),(1628,5),(1629,5),(1630,5),(1631,5),(1632,5),(1633,5),(1634,5),(1635,5),(1636,5),(1637,5),(1638,5),(1639,5),(1640,5),(1641,5),(1642,5),(1643,5),(1644,5),(1645,5),(1646,5),(1647,5),(1648,5),(1649,5),(1650,5),(1651,5),(1652,5),(1653,5),(1654,5),(1655,5),(1656,5),(1657,5),(1658,5),(1659,5),(1660,5),(1661,5),(1662,5),(1663,5),(1664,5),(1665,5),(1666,5),(1667,5),(1668,5),(1669,5),(1670,5),(1671,5),(1672,5),(1673,5),(1674,5),(1675,5),(1676,5),(1677,5),(1678,5),(1679,5),(1680,5),(1681,5),(1682,5),(1683,5),(1684,5),(1685,5),(1686,5),(1687,5),(1688,5),(1689,5),(1690,5),(1691,5),(1692,5),(1693,5),(1694,5),(1695,5),(1696,5),(1697,5),(1698,5),(1699,5),(1700,5),(1701,5),(1702,5),(1703,5),(1704,5),(1705,5),(1706,5),(1707,5),(1708,5),(1709,5),(1710,5),(1711,5),(1712,5),(1713,5),(1714,5),(1715,5),(1716,5),(1717,5),(1718,5),(1719,5),(1720,5),(1721,5),(1722,5),(1723,5),(1724,5),(1725,5),(1726,5),(1727,5),(1728,5),(1729,5),(1730,5),(1731,5),(1732,5),(1733,5),(1734,5),(1735,5),(1736,5),(1737,5),(1738,5),(1739,5),(1740,5),(1741,5),(1742,5),(1743,5),(1744,5),(1745,5),(1746,5),(1747,5),(1748,5),(1749,5),(1750,5),(1751,5),(1752,5),(1753,5),(1754,5),(1755,5),(1756,5),(1757,5),(1758,5),(1759,5),(1760,5),(1761,5),(1762,5),(1763,5),(1764,5),(1765,5),(1766,5),(1767,5),(1768,5),(1769,5),(1770,5),(1771,5),(1772,5),(1773,5),(1774,5),(1775,5),(1776,5),(1777,5),(1778,5),(1779,5),(1780,5),(1781,5),(1782,5),(1783,5),(1784,5),(1785,5),(1786,5),(1787,5),(1788,5),(1789,5),(1790,5),(1791,5),(1792,5),(1793,5),(1794,5),(1795,5),(1796,5),(1797,5),(1798,5),(1799,5),(1800,5),(1801,5),(1802,5),(1803,5),(1804,5),(1805,5),(1806,5),(1807,5),(1808,5),(1809,5),(1810,5),(1811,5),(1812,5),(1813,5),(1814,5),(1815,5),(1816,5),(1817,5),(1818,5),(1819,5),(1820,7),(1851,7),(1852,7),(1853,7),(1854,7),(1855,7),(1856,7),(1857,7),(1858,7),(1859,7),(1860,7),(1861,7),(1862,7),(1863,7),(1864,7),(1865,7),(1866,7),(1867,7),(1868,7),(1869,7),(1870,7),(1871,7),(1872,7),(1873,7),(1874,7),(1875,7),(1876,7),(1877,7),(1878,7),(1879,7),(1880,7),(1882,8),(1885,8),(1895,8),(1896,8),(1897,8),(1907,8),(1908,8),(1909,8),(1910,8),(1911,8),(1912,8),(1913,8),(1918,8),(1919,8),(1920,8),(1921,8),(1922,8),(1923,8),(1924,8),(1925,8),(1926,8),(1927,8),(1928,8),(1929,8),(1930,8),(1931,8),(1932,8),(1933,8),(1934,8),(1935,8),(1936,8),(1937,8),(1938,8),(1939,8),(1940,8),(1941,8),(1942,8),(1943,8),(1944,8),(1945,8),(1946,8),(1947,8),(1948,8),(1949,8),(1950,8),(1951,8),(1952,8),(1953,8),(1954,8),(1955,8),(1956,8),(1957,8),(1958,8),(1959,8),(1960,8),(1961,8),(1962,8),(1963,8),(1964,8),(1965,8),(1966,8),(1967,8),(1968,8),(1969,8),(1970,8),(1971,8),(1972,8),(1973,8),(1974,8),(1975,8),(1976,8),(1977,8),(1978,8),(1979,8),(1980,8),(1981,8),(1982,8),(1983,8),(1984,8),(1985,8),(1986,8),(1987,8),(1988,8),(1989,8),(1990,8),(1991,8),(1992,8),(1993,8),(1994,8),(1995,8),(1996,8),(1997,8),(1998,8),(1999,8),(2000,8),(2001,8),(2002,8),(2003,8),(2004,8),(2005,8),(2006,8),(2007,8),(2008,8),(2009,8),(2010,8),(2011,8),(2012,8),(2013,8),(2014,8),(2015,8),(2016,8),(2017,8),(2018,8),(2019,8),(2020,8),(2021,8),(2022,8),(2023,8),(2024,8),(2025,8),(2026,8),(2027,8),(2028,8),(2029,8),(2030,8),(2031,8),(2032,8),(2033,8),(2034,8),(2035,8),(2036,8),(2037,8),(2038,8),(2039,8),(2040,8),(2041,8),(2042,8),(2043,8),(2044,8),(2045,8),(2046,8),(2047,8),(2048,8),(2049,8),(2050,8),(2051,8),(2052,8),(2053,8),(2054,8),(2055,8),(2056,8),(2057,8),(2058,8),(2059,8),(2060,8),(2061,8),(2062,8),(2063,8),(2064,8),(2065,8),(2066,8),(2067,8),(2068,8),(2069,8),(2070,8),(2071,8),(2072,8),(2073,8),(2074,8),(2075,8),(2076,8),(2077,8),(2078,8),(2079,8),(2080,8),(2081,8),(2082,8),(2083,8),(2084,8),(2085,8),(2086,8),(2087,8),(2088,8),(2089,8),(2090,8),(2091,8),(2092,8),(2093,8),(2094,8),(2095,8),(2096,8),(2097,8),(2098,8),(2099,8),(2100,8),(2101,8),(2102,8),(2103,8),(2104,8),(2105,8),(2106,8),(2107,8),(2108,8),(2109,8),(2110,8),(2111,8),(2112,8),(2113,8),(2114,8),(2115,8),(2116,8),(2117,8),(2118,8),(2119,8),(2120,8),(2121,8),(2122,8),(2123,8),(2124,8),(2125,8),(2126,8),(2127,8),(2128,8),(2129,8),(2130,8),(2131,8),(2132,8),(2133,8),(2134,8),(2135,8),(2136,8),(2137,8),(2138,8),(2139,8),(2140,8),(2141,8),(2142,8),(2143,8),(2144,8),(2145,8),(2146,8),(2147,8),(2148,8),(2149,8),(2150,8),(2151,8),(2152,8),(2153,8),(2154,8),(2155,8),(2156,8),(2157,8),(2158,8),(2159,8),(2160,8),(2161,8),(2162,8),(2163,8),(2164,8),(2165,8),(2166,8),(2167,8),(2168,8),(2169,8),(2170,8),(2171,8),(2172,8),(2173,8),(2174,8),(2175,8),(2176,8),(2177,8),(2178,8),(2179,8),(2180,8),(2181,8),(2182,8),(2183,8),(2184,8),(2185,8),(2186,8),(2187,8),(2188,8),(2189,8),(2190,8),(2191,8),(2192,8),(2193,8),(2194,8),(2195,8),(2196,8),(2197,8),(2198,8),(2199,8),(2200,8),(2201,8),(2202,8),(2203,8),(2204,8),(2205,8),(2206,8),(2207,8),(2208,8),(2209,8),(2210,8),(2211,8),(2212,8),(2213,8),(2214,8),(2215,8),(2216,8),(2217,8),(2218,8),(2219,8),(2220,8),(2221,8),(2222,8),(2223,8),(2224,8),(2225,8),(2226,8),(2227,8),(2228,8),(2229,8),(2230,8),(2231,8),(2232,8),(2233,8),(2234,8),(2235,8),(2236,8),(2237,8),(2238,8),(2239,8),(2240,8),(2241,8),(2242,8),(2243,8),(2244,8),(2245,8),(2246,8),(2247,8),(2248,8),(2249,8),(2250,8),(2251,8),(2252,8),(2253,8),(2254,8),(2255,8),(2256,8),(2257,8),(2258,8),(2259,8),(2260,8),(2261,8),(2262,8),(2263,8),(2264,8),(2265,8),(2266,8),(2267,8),(2268,8),(2269,8),(2270,8),(2271,8),(2272,8),(2273,8),(2274,8),(2275,8),(2276,8),(2277,8),(2278,8),(2279,8),(2280,8),(2281,8),(2282,8),(2283,8),(2284,8),(2285,8),(2286,8),(2287,8),(2288,8),(2289,8),(2290,8),(2291,8),(2292,8),(2293,8),(2294,8),(2295,8),(2296,8),(2297,8),(2298,8),(2299,8),(2300,8),(2301,8),(2302,8),(2303,8),(2304,8),(2305,8),(2306,8),(2307,8),(2308,8),(2309,8),(2310,8),(2311,8),(2312,8),(2313,8),(2314,8),(2315,8),(2316,8),(2317,8),(2318,8),(2319,8),(2320,8),(2321,8),(2322,8),(2323,8),(2324,8),(2325,8),(2326,8),(2327,8),(2328,8),(2329,8),(2330,8),(2331,8),(2332,8),(2333,8),(2334,8),(2335,8),(2336,8),(2337,8),(2338,8),(2339,8),(2340,8),(2341,8),(2342,8),(2343,8),(2344,8),(2345,8),(2346,8),(2347,8),(2348,8),(2349,8),(2350,8),(2351,8),(2352,8),(2353,8),(2354,8),(2355,8),(2356,8),(2357,8),(2358,8),(2359,8),(2360,8),(2361,8),(2362,8),(2363,8),(2364,8),(2365,8),(2366,8),(2367,8),(2368,8),(2369,8),(2370,8),(2371,8),(2372,8),(2373,8),(2374,8),(2375,8),(2376,8),(2377,8),(2378,8),(2379,8),(2380,8),(2381,8),(2382,8),(2383,8),(2384,8),(2385,8),(2386,8),(2387,8),(2388,8),(2389,8),(2390,8),(2391,8),(2392,8),(2393,8),(2394,8),(2395,8),(2396,8),(2397,8),(2398,8),(2399,8),(2400,8),(2401,8),(2402,8),(2403,8),(2404,8),(2405,8),(2406,8),(2407,8),(2408,8),(2409,8),(2410,8),(2411,8),(2412,8),(2413,8),(2414,8),(2415,8),(2416,8),(2417,8),(2418,8),(2419,8),(2420,8),(2421,8),(2422,8),(2423,8),(2424,8),(2425,8),(2426,8),(2427,8),(2428,8),(2429,8),(2430,8),(2431,8),(2432,8),(2433,8),(2434,8),(2435,8),(2436,8),(2437,8),(2438,8),(2439,8),(2440,8),(2441,8),(2442,8),(2443,8),(2444,8),(2445,8),(2446,8),(2447,8),(2448,8),(2449,8),(2450,8),(2451,8),(2452,8),(2453,8),(2454,8),(2455,8),(2456,8),(2457,8),(2458,8),(2459,8),(2460,8),(2461,8),(2462,8),(2463,8),(2464,8),(2465,8),(2466,8),(2467,8),(2468,8),(2469,8),(2470,8),(2471,8),(2472,8),(2473,8),(2474,8),(2475,8),(2476,8),(2477,8),(2478,8),(2479,8),(2480,8),(2481,8),(2482,8),(2483,8),(2484,8),(2485,8),(2486,8),(2487,8),(2488,8),(2489,8),(2490,8),(2491,8),(2492,8),(2493,8),(2494,8),(2495,8),(2496,8),(2497,8),(2498,8),(2499,8),(2500,8),(2501,8),(2502,8),(2503,8),(2504,8),(2505,8),(2506,8),(2507,8),(2508,8),(2509,8),(2510,8),(2511,8),(2512,8),(2513,8),(2514,8),(2515,8),(2516,8),(2517,8),(2518,8),(2519,8),(2520,8),(2521,8),(2522,8),(2523,8),(2524,8),(2525,8),(2526,8),(2527,8),(2528,8),(2529,8),(2530,8),(2531,8),(2532,8),(2533,8),(2534,8),(2535,8),(2536,8),(2537,8),(2538,8),(2539,8),(2540,8),(2541,8),(2542,8),(2543,8),(2544,8),(2545,8),(2546,8),(2547,8),(2548,8),(2549,8),(2550,8),(2551,8),(2552,8),(2553,8),(2554,8),(2555,8),(2556,8),(2557,8),(2558,8),(2559,8),(2560,8),(2561,8),(2562,8),(2563,8),(2564,8),(2565,8),(2566,8),(2567,8),(2568,8),(2569,8),(2570,8),(2571,8),(2572,8),(2573,8),(2574,8),(2575,8),(2576,8),(2577,8),(2578,8),(2579,8),(2580,8),(2581,8),(2582,8),(2583,8),(2584,8),(2585,8),(2586,8),(2587,8),(2588,8),(2589,8),(2590,8),(2591,8),(2592,8),(2593,8),(2594,8),(2595,8),(2596,8),(2597,8),(2598,8),(2599,8),(2600,8),(2601,8),(2602,8),(2603,8),(2604,8),(2605,8),(2606,8),(2607,8),(2608,8),(2609,8),(2610,8),(2611,8),(2612,8),(2613,8),(2614,8),(2615,8),(2616,8),(2617,8),(2618,8),(2619,8),(2620,8),(2621,8),(2622,8),(2623,8),(2624,8),(2625,8),(2626,8),(2627,8),(2628,8),(2629,8),(2630,8),(2631,8),(2632,8),(2633,8),(2634,8),(2635,8),(2636,8),(2637,8),(2638,8),(2639,8),(2640,8),(2641,8),(2642,8),(2643,8),(2644,8),(2645,8),(2646,8),(2647,8),(2648,8),(2649,8),(2650,8),(2651,8),(2652,8),(2653,8),(2654,8),(2655,8),(2656,8),(2657,8),(2658,8),(2659,8),(2660,8),(2661,8),(2662,8),(2663,8),(2664,8),(2665,8),(2666,8),(2667,8),(2668,8),(2669,8),(2670,8),(2671,8),(2672,8),(2673,8),(2674,8),(2675,8),(2676,8),(2677,8),(2678,8),(2679,8),(2680,8),(2681,8),(2682,8),(2683,8),(2684,8),(2685,8),(2686,8),(2687,8),(2688,8),(2689,8),(2690,8),(2691,8),(2692,8),(2693,8),(2694,8),(2695,8),(2696,8),(2697,8),(2698,8),(2699,8),(2700,8),(2701,8),(2702,8),(2703,8),(2704,8),(2705,8),(2706,8),(2707,8),(2708,8),(2709,8),(2710,8),(2711,8),(2712,8),(2713,8),(2714,8),(2715,8),(2716,8),(2717,8),(2718,8),(2719,8),(2720,8),(2721,8),(2722,8),(2723,8),(2724,8),(2725,8),(2726,8),(2727,8),(2728,8),(2729,8),(2730,8),(2731,8),(2732,8),(2733,8),(2734,8),(2735,8),(2736,8),(2737,8),(2738,8),(2739,8),(2740,8),(2741,8),(2742,8),(2743,8),(2744,8),(2745,8),(2746,8),(2747,8),(2748,8),(2749,8),(2750,8),(2751,8),(2752,8),(2753,8),(2754,8),(2755,8),(2756,8),(2757,8),(2758,8),(2759,8),(2760,8),(2761,8),(2762,8),(2763,8),(2764,8),(2765,8),(2766,8),(2767,8),(2768,8),(2769,8),(2770,8),(2771,8),(2772,8),(2773,8),(2774,8),(2775,8),(2776,8),(2777,8),(2778,8),(2779,8),(2780,8),(2781,8),(2782,8),(2783,8),(2784,8),(2785,8),(2786,8),(2787,8),(2788,8),(2789,8),(2790,8),(2791,8),(2792,8),(2793,8),(2794,8),(2795,8),(2796,8),(2797,8),(2798,8),(2799,8),(2800,8),(2801,8),(2802,8),(2803,8),(2804,8),(2805,8),(2806,8),(2807,8),(2808,8),(2809,8),(2810,8),(2811,8),(2812,8),(2813,8),(2814,8),(2815,8),(2816,8),(2817,8),(2818,8),(2819,8),(2820,8),(2821,8),(2822,8),(2823,8),(2824,8),(2825,8),(2826,8),(2827,8),(2828,8),(2829,8),(2830,8),(2831,8),(2832,8),(2833,8),(2834,8),(2835,8),(2836,8),(2837,8),(2838,8),(2839,8),(2840,8),(2841,8),(2842,8),(2843,8),(2844,8),(2845,8),(2846,8),(2847,8),(2848,8),(2849,8),(2850,8),(2851,8),(2852,8),(2853,8),(2854,8),(2855,8),(2856,8),(2857,8),(2858,8),(2859,8),(2860,8),(2861,8),(2862,8),(2863,8),(2864,8),(2865,8),(2866,8),(2867,8),(2868,8),(2869,8),(2870,8),(2871,8),(2872,8),(2873,8),(2874,8),(2875,8),(2876,8),(2877,8),(2878,8),(2879,8),(2880,8),(2881,8),(2882,8),(2883,8),(2884,8),(2885,8),(2886,8),(2887,8),(2888,8),(2889,8),(2890,8),(2891,8),(2892,8),(2893,8),(2894,8),(2895,8),(2896,8),(2897,8),(2898,8),(2899,8),(2900,8),(2901,8),(2902,8),(2903,8),(2904,8),(2905,8),(2906,8),(2907,8),(2908,8),(2909,8),(2910,8),(2911,8),(2912,8),(2913,8),(2914,8),(2915,8),(2916,8),(2917,8),(2918,8),(2919,8),(2920,8),(2921,8),(2922,8),(2923,8),(2924,8),(2925,8),(2926,8),(2927,8),(2928,8),(2929,8),(2930,8),(2931,8),(2932,8),(2933,8),(2934,8),(2935,8),(2936,8),(2937,8),(2938,8),(2939,8),(2940,8),(2941,8),(2942,8),(2943,8),(2944,8),(2945,8),(2946,8),(2947,8),(2948,8),(2949,8),(2950,8),(2951,8),(2952,8),(2953,8),(2954,8),(2955,8),(2956,8),(2957,8),(2958,8),(2959,8),(2960,8),(2961,8),(2962,8),(2963,8),(2964,8),(2965,8),(2966,8),(2967,8),(2968,8),(2969,8),(2970,8),(2971,8),(2972,8),(2973,8),(2974,8),(2975,8),(2976,8),(2977,8),(2978,8),(2979,8),(2980,8),(2981,8),(2982,8),(2983,8),(2984,8),(2985,8),(2986,8),(2987,8),(2988,8),(2989,8),(2990,8),(2991,8),(2992,8),(2993,8),(2994,8),(2995,8),(2996,8),(2997,8),(2998,8),(2999,8),(3000,8),(3001,8),(3002,8),(3003,8),(3004,8),(3005,8),(3006,8),(3007,8),(3008,8),(3009,8),(3010,8),(3011,8),(3012,8),(3013,8),(3014,8),(3015,8),(3016,8),(3017,8),(3018,8),(3019,8),(3020,8),(3021,8),(3022,8),(3023,8),(3024,8),(3025,8),(3026,8),(3027,8),(3028,8),(3029,8),(3030,8),(3031,8),(3032,8),(3033,8),(3034,8),(3035,8),(3036,8),(3037,8),(3038,8),(3039,8),(3040,8),(3041,8),(3042,8),(3043,8),(3044,8),(3045,8),(3046,8),(3047,8),(3048,8),(3049,8),(3050,8),(3051,8),(3052,8),(3053,8),(3054,8),(3055,8),(3056,8),(3057,8),(3058,8),(3059,8),(3060,8),(3061,8),(3062,8),(3063,8),(3064,8),(3065,8),(3066,8),(3067,8),(3068,8),(3069,8),(3070,8),(3071,8),(3072,8),(3073,8),(3074,8),(3075,8),(3076,8),(3077,8),(3078,8),(3079,8),(3080,8),(3081,8),(3082,8),(3083,8),(3084,8),(3085,8),(3086,8),(3087,8),(3088,8),(3089,8),(3090,8),(3091,8),(3092,8),(3093,8),(3094,8),(3095,8),(3096,8),(3097,8),(3098,8),(3099,8),(3100,8),(3101,8),(3102,8),(3103,8),(3104,8),(3105,8),(3106,8),(3107,8),(3108,8),(3109,8),(3110,8),(3111,8),(3112,8),(3113,8),(3114,8),(3115,8),(3116,8),(3117,8),(3118,8),(3119,8),(3120,8),(3121,8),(3122,8),(3123,8),(3124,8),(3125,8),(3126,8),(3127,8),(3128,8),(3129,8),(3130,8),(3131,8),(3132,8),(3133,8),(3134,8),(3135,8),(3136,8),(3137,8),(3138,8),(3139,8),(3140,8),(3141,8),(3142,8),(3143,8),(3144,8),(3145,8),(3146,8),(3147,8),(3148,8),(3149,8),(3150,8),(3151,8),(3152,8),(3153,8),(3154,8),(3155,8),(3156,8),(3157,8),(3158,8),(3159,8),(3160,8),(3161,8),(3162,8),(3163,8),(3164,8),(3165,8),(3166,8),(3167,8),(3168,8),(3169,8),(3170,8),(3171,8),(3172,8),(3173,8),(3174,8),(3175,8),(3176,8),(3177,8),(3178,8),(3179,8),(3180,8),(3181,8),(3182,8),(3183,8),(3184,8),(3185,8),(3186,8),(3187,8),(3188,8),(3189,8),(3190,8),(3191,8),(3192,8),(3193,8),(3194,8),(3195,8),(3196,8),(3197,8),(3198,8),(3199,8),(3200,8),(3201,8),(3202,8),(3203,8),(3204,8),(3205,8),(3206,8),(3207,8),(3208,8),(3209,8),(3210,8),(3211,8),(3212,8),(3213,8),(3214,8),(3215,8),(3216,8),(3217,8),(3218,8),(3219,8),(3220,8),(3221,8),(3222,8),(3223,8),(3224,8),(3225,8),(3226,8),(3227,8),(3228,8),(3229,8),(3230,8),(3231,8),(3232,8),(3233,8),(3234,8),(3235,8),(3236,8),(3237,8),(3238,8),(3239,8),(3240,8),(3241,8),(3242,8),(3243,8),(3244,8),(3245,8),(3246,8),(3247,8),(3248,8),(3249,8),(3250,8),(3251,8),(3252,8),(3253,8),(3254,8),(3255,8),(3256,8),(3257,8),(3258,8),(3259,8),(3260,8),(3261,8),(3262,8),(3263,8),(3264,8),(3265,8),(3266,8),(3267,8),(3268,8),(3269,8),(3270,8),(3271,8),(3272,8),(3273,8),(3274,8),(3275,8),(3276,8),(3277,8),(3278,8),(3279,8),(3280,8),(3281,8),(3282,8),(3283,8),(3284,8),(3285,8),(3286,8),(3287,8),(3288,8),(3289,8),(3290,8),(3291,8),(3292,8),(3293,8),(3294,8),(3295,8),(3296,8),(3297,8),(3298,8),(3299,8),(3300,8),(3301,8),(3302,8),(3303,8),(3304,8),(3305,8),(3306,8),(3307,8),(3308,8),(3309,8),(3310,8),(3311,8),(3312,8),(3313,8),(3314,8),(3315,8),(3316,8),(3317,8),(3318,8),(3319,8),(3320,8),(3321,8),(3322,8),(3323,8),(3324,8),(3325,8),(3326,8),(3327,8),(3328,8),(3329,8),(3330,8),(3331,8),(3332,8),(3333,8),(3334,8),(3335,8),(3336,8),(3337,8),(3338,8),(3339,8),(3340,8),(3341,8),(3342,8),(3343,8),(3344,8),(3345,8),(3346,8),(3347,8),(3348,8),(3349,8),(3350,8),(3351,8),(3352,8),(3353,8),(3354,8),(3355,8),(3356,8),(3357,8),(3358,8),(3359,8),(3360,8),(3361,8),(3362,8),(3363,8),(3364,8),(3365,8),(3366,8),(3367,8),(3368,8),(3369,8),(3370,8),(3371,8),(3372,8),(3373,8),(3374,8),(3375,8),(3376,8),(3377,8),(3378,8),(3379,8),(3380,8),(3381,8),(3382,8),(3383,8),(3384,8),(3385,8),(3386,8),(3387,8),(3388,8),(3389,8),(3390,8),(3391,8),(3392,8),(3393,8),(3394,8),(3395,8),(3396,8),(3397,8),(3398,8),(3399,8),(3400,8),(3401,8),(3402,8),(3403,8),(3404,8),(3405,8),(3406,8),(3407,8),(3408,8),(3409,8),(3410,8),(3411,8),(3412,8),(3413,8),(3414,8),(3415,8),(3416,8),(3417,8),(3418,8),(3419,8),(3420,8),(3421,8),(3422,8),(3423,8),(3424,8),(3425,8),(3426,8),(3427,8),(3428,8),(3429,8),(3430,8),(3431,8),(3432,8),(3433,8),(3434,8),(3435,8),(3436,8),(3437,8),(3438,8),(3439,8),(3440,8),(3441,8),(3442,8),(3443,8),(3444,8),(3445,8),(3446,8),(3447,8),(3448,8),(3449,8),(3450,8),(3451,8),(3452,8),(3453,8),(3454,8),(3455,8),(3456,8),(3457,8),(3458,8),(3459,8),(3460,8),(3461,8),(3462,8),(3463,8),(3464,8),(3465,8),(3466,8),(3467,8),(3468,8),(3469,8),(3470,8),(3471,8),(3472,8),(3473,8),(3474,8),(3475,8),(3476,8),(3477,8),(3478,8),(3479,8),(3480,8),(3481,8),(3482,8),(3483,8),(3484,8),(3485,8),(3486,8),(3487,8),(3488,8),(3489,8),(3490,8),(3491,8),(3492,8),(3493,8),(3494,8),(3495,8),(3496,8),(3497,8),(3498,8),(3499,8),(3500,8),(3501,8),(3502,8),(3503,8),(3504,8),(3505,8),(3506,8),(3507,8),(3508,8),(3509,8),(3510,8),(3511,8),(3512,8),(3513,8),(3514,8),(3515,8),(3516,8),(3517,8),(3518,8),(3519,8),(3520,8),(3521,8),(3522,8),(3523,8),(3524,8),(3525,8),(3526,8),(3527,8),(3528,8),(3529,8),(3530,8),(3531,8),(3532,8),(3533,8),(3534,8),(3535,8),(3536,8),(3537,8),(3538,8),(3539,8),(3540,8),(3541,8),(3542,8),(3543,8),(3544,8),(3545,8),(3546,8),(3547,8),(3548,8),(3549,8),(3550,8),(3551,8),(3552,8),(3553,8),(3554,8),(3555,8),(3556,8),(3557,8),(3558,8),(3559,8),(3560,8),(3561,8),(3562,8),(3563,8),(3564,8),(3565,8),(3566,8),(3567,8),(3568,8),(3569,8),(3570,8),(3571,8),(3572,8),(3573,8),(3574,8),(3575,8),(3576,8),(3577,8),(3578,8),(3579,8),(3580,8),(3581,8),(3582,8),(3583,8),(3584,8),(3585,8),(3586,8),(3587,8),(3588,8),(3589,8),(3590,8),(3591,8),(3592,8),(3593,8),(3594,8),(3595,8),(3596,8),(3597,8),(3598,8),(3599,8),(3600,8),(3601,8),(3602,8),(3603,8),(3604,8),(3605,8),(3606,8),(3607,8),(3608,8),(3609,8),(3610,8),(3611,8),(3612,8),(3613,8),(3614,8),(3615,8),(3616,7);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) DEFAULT NULL,
  `row` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_racks_business_id_index` (`business_id`),
  KEY `product_racks_location_id_index` (`location_id`),
  KEY `product_racks_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`),
  CONSTRAINT `product_variations_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3617 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES (1,NULL,'DUMMY',1,1,'2025-01-29 10:54:03','2025-01-29 10:54:03'),(2,NULL,'DUMMY',2,1,'2025-01-29 11:32:15','2025-01-29 11:32:15'),(3,NULL,'DUMMY',3,1,'2025-02-02 19:35:18','2025-02-02 19:35:18'),(4,NULL,'DUMMY',4,1,'2025-02-03 08:48:31','2025-02-03 08:48:31'),(5,NULL,'DUMMY',5,1,'2025-02-05 15:12:32','2025-02-05 15:12:32'),(6,NULL,'DUMMY',6,1,'2025-02-05 15:17:35','2025-02-05 15:17:35'),(7,NULL,'DUMMY',7,1,'2025-02-05 15:43:01','2025-02-05 15:43:01'),(9,NULL,'DUMMY',9,1,'2025-02-05 15:58:24','2025-02-05 15:58:24'),(10,NULL,'DUMMY',10,1,'2025-02-06 08:25:50','2025-02-06 08:25:50'),(11,NULL,'DUMMY',11,1,'2025-02-06 10:59:16','2025-02-06 10:59:16'),(12,NULL,'DUMMY',12,1,'2025-02-07 06:08:06','2025-02-07 06:08:06'),(13,NULL,'DUMMY',13,1,'2025-02-07 06:08:06','2025-02-07 06:08:06'),(14,NULL,'DUMMY',14,1,'2025-02-07 06:08:06','2025-02-07 06:08:06'),(15,NULL,'DUMMY',15,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(16,NULL,'DUMMY',16,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(17,NULL,'DUMMY',17,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(18,NULL,'DUMMY',18,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(19,NULL,'DUMMY',19,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(20,NULL,'DUMMY',20,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(21,NULL,'DUMMY',21,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(22,NULL,'DUMMY',22,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(23,NULL,'DUMMY',23,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(24,NULL,'DUMMY',24,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(25,NULL,'DUMMY',25,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(26,NULL,'DUMMY',26,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(27,NULL,'DUMMY',27,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(28,NULL,'DUMMY',28,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(29,NULL,'DUMMY',29,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(30,NULL,'DUMMY',30,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(31,NULL,'DUMMY',31,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(32,NULL,'DUMMY',32,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(33,NULL,'DUMMY',33,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(34,NULL,'DUMMY',34,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(35,NULL,'DUMMY',35,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(36,NULL,'DUMMY',36,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(37,NULL,'DUMMY',37,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(38,NULL,'DUMMY',38,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(39,NULL,'DUMMY',39,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(40,NULL,'DUMMY',40,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(41,NULL,'DUMMY',41,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(42,NULL,'DUMMY',42,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(43,NULL,'DUMMY',43,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(44,NULL,'DUMMY',44,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(45,NULL,'DUMMY',45,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(46,NULL,'DUMMY',46,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(47,NULL,'DUMMY',47,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(48,NULL,'DUMMY',48,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(49,NULL,'DUMMY',49,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(50,NULL,'DUMMY',50,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(51,NULL,'DUMMY',51,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(52,NULL,'DUMMY',52,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(53,NULL,'DUMMY',53,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(54,NULL,'DUMMY',54,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(55,NULL,'DUMMY',55,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(56,NULL,'DUMMY',56,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(57,NULL,'DUMMY',57,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(58,NULL,'DUMMY',58,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(59,NULL,'DUMMY',59,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(60,NULL,'DUMMY',60,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(61,NULL,'DUMMY',61,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(62,NULL,'DUMMY',62,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(63,NULL,'DUMMY',63,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(64,NULL,'DUMMY',64,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(65,NULL,'DUMMY',65,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(66,NULL,'DUMMY',66,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(67,NULL,'DUMMY',67,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(68,NULL,'DUMMY',68,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(69,NULL,'DUMMY',69,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(70,NULL,'DUMMY',70,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(71,NULL,'DUMMY',71,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(72,NULL,'DUMMY',72,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(73,NULL,'DUMMY',73,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(74,NULL,'DUMMY',74,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(75,NULL,'DUMMY',75,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(76,NULL,'DUMMY',76,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(77,NULL,'DUMMY',77,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(78,NULL,'DUMMY',78,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(79,NULL,'DUMMY',79,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(80,NULL,'DUMMY',80,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(81,NULL,'DUMMY',81,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(82,NULL,'DUMMY',82,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(83,NULL,'DUMMY',83,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(84,NULL,'DUMMY',84,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(85,NULL,'DUMMY',85,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(86,NULL,'DUMMY',86,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(87,NULL,'DUMMY',87,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(88,NULL,'DUMMY',88,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(89,NULL,'DUMMY',89,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(90,NULL,'DUMMY',90,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(91,NULL,'DUMMY',91,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(92,NULL,'DUMMY',92,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(93,NULL,'DUMMY',93,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(94,NULL,'DUMMY',94,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(95,NULL,'DUMMY',95,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(96,NULL,'DUMMY',96,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(97,NULL,'DUMMY',97,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(98,NULL,'DUMMY',98,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(99,NULL,'DUMMY',99,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(100,NULL,'DUMMY',100,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(101,NULL,'DUMMY',101,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(102,NULL,'DUMMY',102,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(103,NULL,'DUMMY',103,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(104,NULL,'DUMMY',104,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(105,NULL,'DUMMY',105,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(106,NULL,'DUMMY',106,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(107,NULL,'DUMMY',107,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(108,NULL,'DUMMY',108,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(109,NULL,'DUMMY',109,1,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(110,NULL,'DUMMY',110,1,'2025-02-07 16:27:31','2025-02-07 16:27:31'),(111,NULL,'DUMMY',111,1,'2025-02-10 12:18:36','2025-02-10 12:18:36'),(112,NULL,'DUMMY',112,1,'2025-02-10 13:30:45','2025-02-10 13:30:45'),(113,NULL,'DUMMY',113,1,'2025-02-12 20:25:30','2025-02-12 20:25:30'),(114,NULL,'DUMMY',114,1,'2025-02-13 02:34:19','2025-02-13 02:34:19'),(115,NULL,'DUMMY',115,1,'2025-02-13 02:34:19','2025-02-13 02:34:19'),(116,NULL,'DUMMY',116,1,'2025-02-13 02:34:19','2025-02-13 02:34:19'),(117,NULL,'DUMMY',117,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(118,NULL,'DUMMY',118,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(119,NULL,'DUMMY',119,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(120,NULL,'DUMMY',120,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(121,NULL,'DUMMY',121,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(122,NULL,'DUMMY',122,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(123,NULL,'DUMMY',123,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(124,NULL,'DUMMY',124,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(125,NULL,'DUMMY',125,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(126,NULL,'DUMMY',126,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(127,NULL,'DUMMY',127,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(128,NULL,'DUMMY',128,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(129,NULL,'DUMMY',129,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(130,NULL,'DUMMY',130,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(131,NULL,'DUMMY',131,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(132,NULL,'DUMMY',132,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(133,NULL,'DUMMY',133,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(134,NULL,'DUMMY',134,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(135,NULL,'DUMMY',135,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(136,NULL,'DUMMY',136,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(137,NULL,'DUMMY',137,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(138,NULL,'DUMMY',138,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(139,NULL,'DUMMY',139,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(140,NULL,'DUMMY',140,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(141,NULL,'DUMMY',141,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(142,NULL,'DUMMY',142,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(143,NULL,'DUMMY',143,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(144,NULL,'DUMMY',144,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(145,NULL,'DUMMY',145,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(146,NULL,'DUMMY',146,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(147,NULL,'DUMMY',147,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(148,NULL,'DUMMY',148,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(149,NULL,'DUMMY',149,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(150,NULL,'DUMMY',150,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(151,NULL,'DUMMY',151,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(152,NULL,'DUMMY',152,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(153,NULL,'DUMMY',153,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(154,NULL,'DUMMY',154,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(155,NULL,'DUMMY',155,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(156,NULL,'DUMMY',156,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(157,NULL,'DUMMY',157,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(158,NULL,'DUMMY',158,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(159,NULL,'DUMMY',159,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(160,NULL,'DUMMY',160,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(161,NULL,'DUMMY',161,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(162,NULL,'DUMMY',162,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(163,NULL,'DUMMY',163,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(164,NULL,'DUMMY',164,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(165,NULL,'DUMMY',165,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(166,NULL,'DUMMY',166,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(167,NULL,'DUMMY',167,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(168,NULL,'DUMMY',168,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(169,NULL,'DUMMY',169,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(170,NULL,'DUMMY',170,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(171,NULL,'DUMMY',171,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(172,NULL,'DUMMY',172,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(173,NULL,'DUMMY',173,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(174,NULL,'DUMMY',174,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(175,NULL,'DUMMY',175,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(176,NULL,'DUMMY',176,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(177,NULL,'DUMMY',177,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(178,NULL,'DUMMY',178,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(179,NULL,'DUMMY',179,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(180,NULL,'DUMMY',180,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(181,NULL,'DUMMY',181,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(182,NULL,'DUMMY',182,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(183,NULL,'DUMMY',183,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(184,NULL,'DUMMY',184,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(185,NULL,'DUMMY',185,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(186,NULL,'DUMMY',186,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(187,NULL,'DUMMY',187,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(188,NULL,'DUMMY',188,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(189,NULL,'DUMMY',189,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(190,NULL,'DUMMY',190,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(191,NULL,'DUMMY',191,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(192,NULL,'DUMMY',192,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(193,NULL,'DUMMY',193,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(194,NULL,'DUMMY',194,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(195,NULL,'DUMMY',195,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(196,NULL,'DUMMY',196,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(197,NULL,'DUMMY',197,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(198,NULL,'DUMMY',198,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(199,NULL,'DUMMY',199,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(200,NULL,'DUMMY',200,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(201,NULL,'DUMMY',201,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(202,NULL,'DUMMY',202,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(203,NULL,'DUMMY',203,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(204,NULL,'DUMMY',204,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(205,NULL,'DUMMY',205,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(206,NULL,'DUMMY',206,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(207,NULL,'DUMMY',207,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(208,NULL,'DUMMY',208,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(209,NULL,'DUMMY',209,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(210,NULL,'DUMMY',210,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(211,NULL,'DUMMY',211,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(212,NULL,'DUMMY',212,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(213,NULL,'DUMMY',213,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(214,NULL,'DUMMY',214,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(215,NULL,'DUMMY',215,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(216,NULL,'DUMMY',216,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(217,NULL,'DUMMY',217,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(218,NULL,'DUMMY',218,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(219,NULL,'DUMMY',219,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(220,NULL,'DUMMY',220,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(221,NULL,'DUMMY',221,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(222,NULL,'DUMMY',222,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(223,NULL,'DUMMY',223,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(224,NULL,'DUMMY',224,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(225,NULL,'DUMMY',225,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(226,NULL,'DUMMY',226,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(227,NULL,'DUMMY',227,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(228,NULL,'DUMMY',228,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(229,NULL,'DUMMY',229,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(230,NULL,'DUMMY',230,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(231,NULL,'DUMMY',231,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(232,NULL,'DUMMY',232,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(233,NULL,'DUMMY',233,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(234,NULL,'DUMMY',234,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(235,NULL,'DUMMY',235,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(236,NULL,'DUMMY',236,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(237,NULL,'DUMMY',237,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(238,NULL,'DUMMY',238,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(239,NULL,'DUMMY',239,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(240,NULL,'DUMMY',240,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(241,NULL,'DUMMY',241,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(242,NULL,'DUMMY',242,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(243,NULL,'DUMMY',243,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(244,NULL,'DUMMY',244,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(245,NULL,'DUMMY',245,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(246,NULL,'DUMMY',246,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(247,NULL,'DUMMY',247,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(248,NULL,'DUMMY',248,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(249,NULL,'DUMMY',249,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(250,NULL,'DUMMY',250,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(251,NULL,'DUMMY',251,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(252,NULL,'DUMMY',252,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(253,NULL,'DUMMY',253,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(254,NULL,'DUMMY',254,1,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(255,NULL,'DUMMY',255,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(256,NULL,'DUMMY',256,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(257,NULL,'DUMMY',257,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(258,NULL,'DUMMY',258,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(259,NULL,'DUMMY',259,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(260,NULL,'DUMMY',260,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(261,NULL,'DUMMY',261,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(262,NULL,'DUMMY',262,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(263,NULL,'DUMMY',263,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(264,NULL,'DUMMY',264,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(265,NULL,'DUMMY',265,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(266,NULL,'DUMMY',266,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(267,NULL,'DUMMY',267,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(268,NULL,'DUMMY',268,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(269,NULL,'DUMMY',269,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(270,NULL,'DUMMY',270,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(271,NULL,'DUMMY',271,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(272,NULL,'DUMMY',272,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(273,NULL,'DUMMY',273,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(274,NULL,'DUMMY',274,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(275,NULL,'DUMMY',275,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(276,NULL,'DUMMY',276,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(277,NULL,'DUMMY',277,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(278,NULL,'DUMMY',278,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(279,NULL,'DUMMY',279,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(280,NULL,'DUMMY',280,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(281,NULL,'DUMMY',281,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(282,NULL,'DUMMY',282,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(283,NULL,'DUMMY',283,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(284,NULL,'DUMMY',284,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(285,NULL,'DUMMY',285,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(286,NULL,'DUMMY',286,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(287,NULL,'DUMMY',287,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(288,NULL,'DUMMY',288,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(289,NULL,'DUMMY',289,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(290,NULL,'DUMMY',290,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(291,NULL,'DUMMY',291,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(292,NULL,'DUMMY',292,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(293,NULL,'DUMMY',293,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(294,NULL,'DUMMY',294,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(295,NULL,'DUMMY',295,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(296,NULL,'DUMMY',296,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(297,NULL,'DUMMY',297,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(298,NULL,'DUMMY',298,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(299,NULL,'DUMMY',299,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(300,NULL,'DUMMY',300,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(301,NULL,'DUMMY',301,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(302,NULL,'DUMMY',302,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(303,NULL,'DUMMY',303,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(304,NULL,'DUMMY',304,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(305,NULL,'DUMMY',305,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(306,NULL,'DUMMY',306,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(307,NULL,'DUMMY',307,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(308,NULL,'DUMMY',308,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(309,NULL,'DUMMY',309,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(310,NULL,'DUMMY',310,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(311,NULL,'DUMMY',311,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(312,NULL,'DUMMY',312,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(313,NULL,'DUMMY',313,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(314,NULL,'DUMMY',314,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(315,NULL,'DUMMY',315,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(316,NULL,'DUMMY',316,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(317,NULL,'DUMMY',317,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(318,NULL,'DUMMY',318,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(319,NULL,'DUMMY',319,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(320,NULL,'DUMMY',320,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(321,NULL,'DUMMY',321,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(322,NULL,'DUMMY',322,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(323,NULL,'DUMMY',323,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(324,NULL,'DUMMY',324,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(325,NULL,'DUMMY',325,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(326,NULL,'DUMMY',326,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(327,NULL,'DUMMY',327,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(328,NULL,'DUMMY',328,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(329,NULL,'DUMMY',329,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(330,NULL,'DUMMY',330,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(331,NULL,'DUMMY',331,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(332,NULL,'DUMMY',332,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(333,NULL,'DUMMY',333,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(334,NULL,'DUMMY',334,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(335,NULL,'DUMMY',335,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(336,NULL,'DUMMY',336,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(337,NULL,'DUMMY',337,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(338,NULL,'DUMMY',338,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(339,NULL,'DUMMY',339,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(340,NULL,'DUMMY',340,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(341,NULL,'DUMMY',341,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(342,NULL,'DUMMY',342,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(343,NULL,'DUMMY',343,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(344,NULL,'DUMMY',344,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(345,NULL,'DUMMY',345,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(346,NULL,'DUMMY',346,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(347,NULL,'DUMMY',347,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(348,NULL,'DUMMY',348,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(349,NULL,'DUMMY',349,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(350,NULL,'DUMMY',350,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(351,NULL,'DUMMY',351,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(352,NULL,'DUMMY',352,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(353,NULL,'DUMMY',353,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(354,NULL,'DUMMY',354,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(355,NULL,'DUMMY',355,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(356,NULL,'DUMMY',356,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(357,NULL,'DUMMY',357,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(358,NULL,'DUMMY',358,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(359,NULL,'DUMMY',359,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(360,NULL,'DUMMY',360,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(361,NULL,'DUMMY',361,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(362,NULL,'DUMMY',362,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(363,NULL,'DUMMY',363,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(364,NULL,'DUMMY',364,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(365,NULL,'DUMMY',365,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(366,NULL,'DUMMY',366,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(367,NULL,'DUMMY',367,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(368,NULL,'DUMMY',368,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(369,NULL,'DUMMY',369,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(370,NULL,'DUMMY',370,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(371,NULL,'DUMMY',371,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(372,NULL,'DUMMY',372,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(373,NULL,'DUMMY',373,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(374,NULL,'DUMMY',374,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(375,NULL,'DUMMY',375,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(376,NULL,'DUMMY',376,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(377,NULL,'DUMMY',377,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(378,NULL,'DUMMY',378,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(379,NULL,'DUMMY',379,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(380,NULL,'DUMMY',380,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(381,NULL,'DUMMY',381,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(382,NULL,'DUMMY',382,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(383,NULL,'DUMMY',383,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(384,NULL,'DUMMY',384,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(385,NULL,'DUMMY',385,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(386,NULL,'DUMMY',386,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(387,NULL,'DUMMY',387,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(388,NULL,'DUMMY',388,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(389,NULL,'DUMMY',389,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(390,NULL,'DUMMY',390,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(391,NULL,'DUMMY',391,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(392,NULL,'DUMMY',392,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(393,NULL,'DUMMY',393,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(394,NULL,'DUMMY',394,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(395,NULL,'DUMMY',395,1,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(396,NULL,'DUMMY',396,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(397,NULL,'DUMMY',397,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(398,NULL,'DUMMY',398,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(399,NULL,'DUMMY',399,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(400,NULL,'DUMMY',400,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(401,NULL,'DUMMY',401,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(402,NULL,'DUMMY',402,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(403,NULL,'DUMMY',403,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(404,NULL,'DUMMY',404,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(405,NULL,'DUMMY',405,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(406,NULL,'DUMMY',406,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(407,NULL,'DUMMY',407,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(408,NULL,'DUMMY',408,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(409,NULL,'DUMMY',409,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(410,NULL,'DUMMY',410,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(411,NULL,'DUMMY',411,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(412,NULL,'DUMMY',412,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(413,NULL,'DUMMY',413,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(414,NULL,'DUMMY',414,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(415,NULL,'DUMMY',415,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(416,NULL,'DUMMY',416,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(417,NULL,'DUMMY',417,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(418,NULL,'DUMMY',418,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(419,NULL,'DUMMY',419,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(420,NULL,'DUMMY',420,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(421,NULL,'DUMMY',421,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(422,NULL,'DUMMY',422,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(423,NULL,'DUMMY',423,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(424,NULL,'DUMMY',424,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(425,NULL,'DUMMY',425,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(426,NULL,'DUMMY',426,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(427,NULL,'DUMMY',427,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(428,NULL,'DUMMY',428,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(429,NULL,'DUMMY',429,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(430,NULL,'DUMMY',430,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(431,NULL,'DUMMY',431,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(432,NULL,'DUMMY',432,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(433,NULL,'DUMMY',433,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(434,NULL,'DUMMY',434,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(435,NULL,'DUMMY',435,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(436,NULL,'DUMMY',436,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(437,NULL,'DUMMY',437,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(438,NULL,'DUMMY',438,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(439,NULL,'DUMMY',439,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(440,NULL,'DUMMY',440,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(441,NULL,'DUMMY',441,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(442,NULL,'DUMMY',442,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(443,NULL,'DUMMY',443,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(444,NULL,'DUMMY',444,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(445,NULL,'DUMMY',445,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(446,NULL,'DUMMY',446,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(447,NULL,'DUMMY',447,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(448,NULL,'DUMMY',448,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(449,NULL,'DUMMY',449,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(450,NULL,'DUMMY',450,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(451,NULL,'DUMMY',451,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(452,NULL,'DUMMY',452,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(453,NULL,'DUMMY',453,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(454,NULL,'DUMMY',454,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(455,NULL,'DUMMY',455,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(456,NULL,'DUMMY',456,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(457,NULL,'DUMMY',457,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(458,NULL,'DUMMY',458,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(459,NULL,'DUMMY',459,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(460,NULL,'DUMMY',460,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(461,NULL,'DUMMY',461,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(462,NULL,'DUMMY',462,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(463,NULL,'DUMMY',463,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(464,NULL,'DUMMY',464,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(465,NULL,'DUMMY',465,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(466,NULL,'DUMMY',466,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(467,NULL,'DUMMY',467,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(468,NULL,'DUMMY',468,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(469,NULL,'DUMMY',469,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(470,NULL,'DUMMY',470,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(471,NULL,'DUMMY',471,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(472,NULL,'DUMMY',472,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(473,NULL,'DUMMY',473,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(474,NULL,'DUMMY',474,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(475,NULL,'DUMMY',475,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(476,NULL,'DUMMY',476,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(477,NULL,'DUMMY',477,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(478,NULL,'DUMMY',478,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(479,NULL,'DUMMY',479,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(480,NULL,'DUMMY',480,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(481,NULL,'DUMMY',481,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(482,NULL,'DUMMY',482,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(483,NULL,'DUMMY',483,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(484,NULL,'DUMMY',484,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(485,NULL,'DUMMY',485,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(486,NULL,'DUMMY',486,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(487,NULL,'DUMMY',487,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(488,NULL,'DUMMY',488,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(489,NULL,'DUMMY',489,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(490,NULL,'DUMMY',490,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(491,NULL,'DUMMY',491,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(492,NULL,'DUMMY',492,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(493,NULL,'DUMMY',493,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(494,NULL,'DUMMY',494,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(495,NULL,'DUMMY',495,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(496,NULL,'DUMMY',496,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(497,NULL,'DUMMY',497,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(498,NULL,'DUMMY',498,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(499,NULL,'DUMMY',499,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(500,NULL,'DUMMY',500,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(501,NULL,'DUMMY',501,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(502,NULL,'DUMMY',502,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(503,NULL,'DUMMY',503,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(504,NULL,'DUMMY',504,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(505,NULL,'DUMMY',505,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(506,NULL,'DUMMY',506,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(507,NULL,'DUMMY',507,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(508,NULL,'DUMMY',508,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(509,NULL,'DUMMY',509,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(510,NULL,'DUMMY',510,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(511,NULL,'DUMMY',511,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(512,NULL,'DUMMY',512,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(513,NULL,'DUMMY',513,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(514,NULL,'DUMMY',514,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(515,NULL,'DUMMY',515,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(516,NULL,'DUMMY',516,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(517,NULL,'DUMMY',517,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(518,NULL,'DUMMY',518,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(519,NULL,'DUMMY',519,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(520,NULL,'DUMMY',520,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(521,NULL,'DUMMY',521,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(522,NULL,'DUMMY',522,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(523,NULL,'DUMMY',523,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(524,NULL,'DUMMY',524,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(525,NULL,'DUMMY',525,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(526,NULL,'DUMMY',526,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(527,NULL,'DUMMY',527,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(528,NULL,'DUMMY',528,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(529,NULL,'DUMMY',529,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(530,NULL,'DUMMY',530,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(531,NULL,'DUMMY',531,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(532,NULL,'DUMMY',532,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(533,NULL,'DUMMY',533,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(534,NULL,'DUMMY',534,1,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(535,NULL,'DUMMY',535,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(536,NULL,'DUMMY',536,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(537,NULL,'DUMMY',537,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(538,NULL,'DUMMY',538,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(539,NULL,'DUMMY',539,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(540,NULL,'DUMMY',540,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(541,NULL,'DUMMY',541,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(542,NULL,'DUMMY',542,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(543,NULL,'DUMMY',543,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(544,NULL,'DUMMY',544,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(545,NULL,'DUMMY',545,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(546,NULL,'DUMMY',546,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(547,NULL,'DUMMY',547,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(548,NULL,'DUMMY',548,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(549,NULL,'DUMMY',549,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(550,NULL,'DUMMY',550,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(551,NULL,'DUMMY',551,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(552,NULL,'DUMMY',552,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(553,NULL,'DUMMY',553,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(554,NULL,'DUMMY',554,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(555,NULL,'DUMMY',555,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(556,NULL,'DUMMY',556,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(557,NULL,'DUMMY',557,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(558,NULL,'DUMMY',558,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(559,NULL,'DUMMY',559,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(560,NULL,'DUMMY',560,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(561,NULL,'DUMMY',561,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(562,NULL,'DUMMY',562,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(563,NULL,'DUMMY',563,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(564,NULL,'DUMMY',564,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(565,NULL,'DUMMY',565,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(566,NULL,'DUMMY',566,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(567,NULL,'DUMMY',567,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(568,NULL,'DUMMY',568,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(569,NULL,'DUMMY',569,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(570,NULL,'DUMMY',570,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(571,NULL,'DUMMY',571,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(572,NULL,'DUMMY',572,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(573,NULL,'DUMMY',573,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(574,NULL,'DUMMY',574,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(575,NULL,'DUMMY',575,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(576,NULL,'DUMMY',576,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(577,NULL,'DUMMY',577,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(578,NULL,'DUMMY',578,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(579,NULL,'DUMMY',579,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(580,NULL,'DUMMY',580,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(581,NULL,'DUMMY',581,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(582,NULL,'DUMMY',582,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(583,NULL,'DUMMY',583,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(584,NULL,'DUMMY',584,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(585,NULL,'DUMMY',585,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(586,NULL,'DUMMY',586,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(587,NULL,'DUMMY',587,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(588,NULL,'DUMMY',588,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(589,NULL,'DUMMY',589,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(590,NULL,'DUMMY',590,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(591,NULL,'DUMMY',591,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(592,NULL,'DUMMY',592,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(593,NULL,'DUMMY',593,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(594,NULL,'DUMMY',594,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(595,NULL,'DUMMY',595,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(596,NULL,'DUMMY',596,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(597,NULL,'DUMMY',597,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(598,NULL,'DUMMY',598,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(599,NULL,'DUMMY',599,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(600,NULL,'DUMMY',600,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(601,NULL,'DUMMY',601,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(602,NULL,'DUMMY',602,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(603,NULL,'DUMMY',603,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(604,NULL,'DUMMY',604,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(605,NULL,'DUMMY',605,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(606,NULL,'DUMMY',606,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(607,NULL,'DUMMY',607,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(608,NULL,'DUMMY',608,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(609,NULL,'DUMMY',609,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(610,NULL,'DUMMY',610,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(611,NULL,'DUMMY',611,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(612,NULL,'DUMMY',612,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(613,NULL,'DUMMY',613,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(614,NULL,'DUMMY',614,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(615,NULL,'DUMMY',615,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(616,NULL,'DUMMY',616,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(617,NULL,'DUMMY',617,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(618,NULL,'DUMMY',618,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(619,NULL,'DUMMY',619,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(620,NULL,'DUMMY',620,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(621,NULL,'DUMMY',621,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(622,NULL,'DUMMY',622,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(623,NULL,'DUMMY',623,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(624,NULL,'DUMMY',624,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(625,NULL,'DUMMY',625,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(626,NULL,'DUMMY',626,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(627,NULL,'DUMMY',627,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(628,NULL,'DUMMY',628,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(629,NULL,'DUMMY',629,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(630,NULL,'DUMMY',630,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(631,NULL,'DUMMY',631,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(632,NULL,'DUMMY',632,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(633,NULL,'DUMMY',633,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(634,NULL,'DUMMY',634,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(635,NULL,'DUMMY',635,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(636,NULL,'DUMMY',636,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(637,NULL,'DUMMY',637,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(638,NULL,'DUMMY',638,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(639,NULL,'DUMMY',639,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(640,NULL,'DUMMY',640,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(641,NULL,'DUMMY',641,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(642,NULL,'DUMMY',642,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(643,NULL,'DUMMY',643,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(644,NULL,'DUMMY',644,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(645,NULL,'DUMMY',645,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(646,NULL,'DUMMY',646,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(647,NULL,'DUMMY',647,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(648,NULL,'DUMMY',648,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(649,NULL,'DUMMY',649,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(650,NULL,'DUMMY',650,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(651,NULL,'DUMMY',651,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(652,NULL,'DUMMY',652,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(653,NULL,'DUMMY',653,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(654,NULL,'DUMMY',654,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(655,NULL,'DUMMY',655,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(656,NULL,'DUMMY',656,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(657,NULL,'DUMMY',657,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(658,NULL,'DUMMY',658,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(659,NULL,'DUMMY',659,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(660,NULL,'DUMMY',660,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(661,NULL,'DUMMY',661,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(662,NULL,'DUMMY',662,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(663,NULL,'DUMMY',663,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(664,NULL,'DUMMY',664,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(665,NULL,'DUMMY',665,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(666,NULL,'DUMMY',666,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(667,NULL,'DUMMY',667,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(668,NULL,'DUMMY',668,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(669,NULL,'DUMMY',669,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(670,NULL,'DUMMY',670,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(671,NULL,'DUMMY',671,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(672,NULL,'DUMMY',672,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(673,NULL,'DUMMY',673,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(674,NULL,'DUMMY',674,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(675,NULL,'DUMMY',675,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(676,NULL,'DUMMY',676,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(677,NULL,'DUMMY',677,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(678,NULL,'DUMMY',678,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(679,NULL,'DUMMY',679,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(680,NULL,'DUMMY',680,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(681,NULL,'DUMMY',681,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(682,NULL,'DUMMY',682,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(683,NULL,'DUMMY',683,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(684,NULL,'DUMMY',684,1,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(685,NULL,'DUMMY',685,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(686,NULL,'DUMMY',686,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(687,NULL,'DUMMY',687,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(688,NULL,'DUMMY',688,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(689,NULL,'DUMMY',689,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(690,NULL,'DUMMY',690,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(691,NULL,'DUMMY',691,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(692,NULL,'DUMMY',692,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(693,NULL,'DUMMY',693,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(694,NULL,'DUMMY',694,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(695,NULL,'DUMMY',695,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(696,NULL,'DUMMY',696,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(697,NULL,'DUMMY',697,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(698,NULL,'DUMMY',698,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(699,NULL,'DUMMY',699,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(700,NULL,'DUMMY',700,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(701,NULL,'DUMMY',701,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(702,NULL,'DUMMY',702,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(703,NULL,'DUMMY',703,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(704,NULL,'DUMMY',704,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(705,NULL,'DUMMY',705,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(706,NULL,'DUMMY',706,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(707,NULL,'DUMMY',707,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(708,NULL,'DUMMY',708,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(709,NULL,'DUMMY',709,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(710,NULL,'DUMMY',710,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(711,NULL,'DUMMY',711,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(712,NULL,'DUMMY',712,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(713,NULL,'DUMMY',713,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(714,NULL,'DUMMY',714,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(715,NULL,'DUMMY',715,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(716,NULL,'DUMMY',716,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(717,NULL,'DUMMY',717,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(718,NULL,'DUMMY',718,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(719,NULL,'DUMMY',719,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(720,NULL,'DUMMY',720,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(721,NULL,'DUMMY',721,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(722,NULL,'DUMMY',722,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(723,NULL,'DUMMY',723,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(724,NULL,'DUMMY',724,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(725,NULL,'DUMMY',725,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(726,NULL,'DUMMY',726,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(727,NULL,'DUMMY',727,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(728,NULL,'DUMMY',728,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(729,NULL,'DUMMY',729,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(730,NULL,'DUMMY',730,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(731,NULL,'DUMMY',731,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(732,NULL,'DUMMY',732,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(733,NULL,'DUMMY',733,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(734,NULL,'DUMMY',734,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(735,NULL,'DUMMY',735,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(736,NULL,'DUMMY',736,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(737,NULL,'DUMMY',737,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(738,NULL,'DUMMY',738,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(739,NULL,'DUMMY',739,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(740,NULL,'DUMMY',740,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(741,NULL,'DUMMY',741,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(742,NULL,'DUMMY',742,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(743,NULL,'DUMMY',743,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(744,NULL,'DUMMY',744,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(745,NULL,'DUMMY',745,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(746,NULL,'DUMMY',746,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(747,NULL,'DUMMY',747,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(748,NULL,'DUMMY',748,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(749,NULL,'DUMMY',749,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(750,NULL,'DUMMY',750,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(751,NULL,'DUMMY',751,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(752,NULL,'DUMMY',752,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(753,NULL,'DUMMY',753,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(754,NULL,'DUMMY',754,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(755,NULL,'DUMMY',755,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(756,NULL,'DUMMY',756,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(757,NULL,'DUMMY',757,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(758,NULL,'DUMMY',758,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(759,NULL,'DUMMY',759,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(760,NULL,'DUMMY',760,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(761,NULL,'DUMMY',761,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(762,NULL,'DUMMY',762,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(763,NULL,'DUMMY',763,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(764,NULL,'DUMMY',764,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(765,NULL,'DUMMY',765,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(766,NULL,'DUMMY',766,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(767,NULL,'DUMMY',767,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(768,NULL,'DUMMY',768,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(769,NULL,'DUMMY',769,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(770,NULL,'DUMMY',770,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(771,NULL,'DUMMY',771,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(772,NULL,'DUMMY',772,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(773,NULL,'DUMMY',773,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(774,NULL,'DUMMY',774,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(775,NULL,'DUMMY',775,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(776,NULL,'DUMMY',776,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(777,NULL,'DUMMY',777,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(778,NULL,'DUMMY',778,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(779,NULL,'DUMMY',779,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(780,NULL,'DUMMY',780,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(781,NULL,'DUMMY',781,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(782,NULL,'DUMMY',782,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(783,NULL,'DUMMY',783,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(784,NULL,'DUMMY',784,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(785,NULL,'DUMMY',785,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(786,NULL,'DUMMY',786,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(787,NULL,'DUMMY',787,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(788,NULL,'DUMMY',788,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(789,NULL,'DUMMY',789,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(790,NULL,'DUMMY',790,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(791,NULL,'DUMMY',791,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(792,NULL,'DUMMY',792,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(793,NULL,'DUMMY',793,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(794,NULL,'DUMMY',794,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(795,NULL,'DUMMY',795,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(796,NULL,'DUMMY',796,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(797,NULL,'DUMMY',797,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(798,NULL,'DUMMY',798,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(799,NULL,'DUMMY',799,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(800,NULL,'DUMMY',800,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(801,NULL,'DUMMY',801,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(802,NULL,'DUMMY',802,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(803,NULL,'DUMMY',803,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(804,NULL,'DUMMY',804,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(805,NULL,'DUMMY',805,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(806,NULL,'DUMMY',806,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(807,NULL,'DUMMY',807,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(808,NULL,'DUMMY',808,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(809,NULL,'DUMMY',809,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(810,NULL,'DUMMY',810,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(811,NULL,'DUMMY',811,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(812,NULL,'DUMMY',812,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(813,NULL,'DUMMY',813,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(814,NULL,'DUMMY',814,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(815,NULL,'DUMMY',815,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(816,NULL,'DUMMY',816,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(817,NULL,'DUMMY',817,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(818,NULL,'DUMMY',818,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(819,NULL,'DUMMY',819,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(820,NULL,'DUMMY',820,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(821,NULL,'DUMMY',821,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(822,NULL,'DUMMY',822,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(823,NULL,'DUMMY',823,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(824,NULL,'DUMMY',824,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(825,NULL,'DUMMY',825,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(826,NULL,'DUMMY',826,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(827,NULL,'DUMMY',827,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(828,NULL,'DUMMY',828,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(829,NULL,'DUMMY',829,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(830,NULL,'DUMMY',830,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(831,NULL,'DUMMY',831,1,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(832,NULL,'DUMMY',832,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(833,NULL,'DUMMY',833,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(834,NULL,'DUMMY',834,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(835,NULL,'DUMMY',835,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(836,NULL,'DUMMY',836,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(837,NULL,'DUMMY',837,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(838,NULL,'DUMMY',838,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(839,NULL,'DUMMY',839,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(840,NULL,'DUMMY',840,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(841,NULL,'DUMMY',841,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(842,NULL,'DUMMY',842,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(843,NULL,'DUMMY',843,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(844,NULL,'DUMMY',844,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(845,NULL,'DUMMY',845,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(846,NULL,'DUMMY',846,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(847,NULL,'DUMMY',847,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(848,NULL,'DUMMY',848,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(849,NULL,'DUMMY',849,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(850,NULL,'DUMMY',850,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(851,NULL,'DUMMY',851,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(852,NULL,'DUMMY',852,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(853,NULL,'DUMMY',853,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(854,NULL,'DUMMY',854,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(855,NULL,'DUMMY',855,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(856,NULL,'DUMMY',856,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(857,NULL,'DUMMY',857,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(858,NULL,'DUMMY',858,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(859,NULL,'DUMMY',859,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(860,NULL,'DUMMY',860,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(861,NULL,'DUMMY',861,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(862,NULL,'DUMMY',862,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(863,NULL,'DUMMY',863,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(864,NULL,'DUMMY',864,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(865,NULL,'DUMMY',865,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(866,NULL,'DUMMY',866,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(867,NULL,'DUMMY',867,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(868,NULL,'DUMMY',868,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(869,NULL,'DUMMY',869,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(870,NULL,'DUMMY',870,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(871,NULL,'DUMMY',871,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(872,NULL,'DUMMY',872,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(873,NULL,'DUMMY',873,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(874,NULL,'DUMMY',874,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(875,NULL,'DUMMY',875,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(876,NULL,'DUMMY',876,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(877,NULL,'DUMMY',877,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(878,NULL,'DUMMY',878,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(879,NULL,'DUMMY',879,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(880,NULL,'DUMMY',880,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(881,NULL,'DUMMY',881,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(882,NULL,'DUMMY',882,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(883,NULL,'DUMMY',883,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(884,NULL,'DUMMY',884,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(885,NULL,'DUMMY',885,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(886,NULL,'DUMMY',886,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(887,NULL,'DUMMY',887,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(888,NULL,'DUMMY',888,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(889,NULL,'DUMMY',889,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(890,NULL,'DUMMY',890,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(891,NULL,'DUMMY',891,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(892,NULL,'DUMMY',892,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(893,NULL,'DUMMY',893,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(894,NULL,'DUMMY',894,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(895,NULL,'DUMMY',895,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(896,NULL,'DUMMY',896,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(897,NULL,'DUMMY',897,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(898,NULL,'DUMMY',898,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(899,NULL,'DUMMY',899,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(900,NULL,'DUMMY',900,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(901,NULL,'DUMMY',901,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(902,NULL,'DUMMY',902,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(903,NULL,'DUMMY',903,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(904,NULL,'DUMMY',904,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(905,NULL,'DUMMY',905,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(906,NULL,'DUMMY',906,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(907,NULL,'DUMMY',907,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(908,NULL,'DUMMY',908,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(909,NULL,'DUMMY',909,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(910,NULL,'DUMMY',910,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(911,NULL,'DUMMY',911,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(912,NULL,'DUMMY',912,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(913,NULL,'DUMMY',913,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(914,NULL,'DUMMY',914,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(915,NULL,'DUMMY',915,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(916,NULL,'DUMMY',916,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(917,NULL,'DUMMY',917,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(918,NULL,'DUMMY',918,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(919,NULL,'DUMMY',919,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(920,NULL,'DUMMY',920,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(921,NULL,'DUMMY',921,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(922,NULL,'DUMMY',922,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(923,NULL,'DUMMY',923,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(924,NULL,'DUMMY',924,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(925,NULL,'DUMMY',925,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(926,NULL,'DUMMY',926,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(927,NULL,'DUMMY',927,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(928,NULL,'DUMMY',928,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(929,NULL,'DUMMY',929,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(930,NULL,'DUMMY',930,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(931,NULL,'DUMMY',931,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(932,NULL,'DUMMY',932,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(933,NULL,'DUMMY',933,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(934,NULL,'DUMMY',934,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(935,NULL,'DUMMY',935,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(936,NULL,'DUMMY',936,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(937,NULL,'DUMMY',937,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(938,NULL,'DUMMY',938,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(939,NULL,'DUMMY',939,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(940,NULL,'DUMMY',940,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(941,NULL,'DUMMY',941,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(942,NULL,'DUMMY',942,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(943,NULL,'DUMMY',943,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(944,NULL,'DUMMY',944,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(945,NULL,'DUMMY',945,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(946,NULL,'DUMMY',946,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(947,NULL,'DUMMY',947,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(948,NULL,'DUMMY',948,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(949,NULL,'DUMMY',949,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(950,NULL,'DUMMY',950,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(951,NULL,'DUMMY',951,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(952,NULL,'DUMMY',952,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(953,NULL,'DUMMY',953,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(954,NULL,'DUMMY',954,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(955,NULL,'DUMMY',955,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(956,NULL,'DUMMY',956,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(957,NULL,'DUMMY',957,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(958,NULL,'DUMMY',958,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(959,NULL,'DUMMY',959,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(960,NULL,'DUMMY',960,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(961,NULL,'DUMMY',961,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(962,NULL,'DUMMY',962,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(963,NULL,'DUMMY',963,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(964,NULL,'DUMMY',964,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(965,NULL,'DUMMY',965,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(966,NULL,'DUMMY',966,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(967,NULL,'DUMMY',967,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(968,NULL,'DUMMY',968,1,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(969,NULL,'DUMMY',969,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(970,NULL,'DUMMY',970,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(971,NULL,'DUMMY',971,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(972,NULL,'DUMMY',972,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(973,NULL,'DUMMY',973,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(974,NULL,'DUMMY',974,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(975,NULL,'DUMMY',975,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(976,NULL,'DUMMY',976,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(977,NULL,'DUMMY',977,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(978,NULL,'DUMMY',978,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(979,NULL,'DUMMY',979,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(980,NULL,'DUMMY',980,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(981,NULL,'DUMMY',981,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(982,NULL,'DUMMY',982,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(983,NULL,'DUMMY',983,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(984,NULL,'DUMMY',984,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(985,NULL,'DUMMY',985,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(986,NULL,'DUMMY',986,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(987,NULL,'DUMMY',987,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(988,NULL,'DUMMY',988,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(989,NULL,'DUMMY',989,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(990,NULL,'DUMMY',990,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(991,NULL,'DUMMY',991,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(992,NULL,'DUMMY',992,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(993,NULL,'DUMMY',993,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(994,NULL,'DUMMY',994,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(995,NULL,'DUMMY',995,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(996,NULL,'DUMMY',996,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(997,NULL,'DUMMY',997,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(998,NULL,'DUMMY',998,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(999,NULL,'DUMMY',999,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1000,NULL,'DUMMY',1000,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1001,NULL,'DUMMY',1001,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1002,NULL,'DUMMY',1002,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1003,NULL,'DUMMY',1003,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1004,NULL,'DUMMY',1004,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1005,NULL,'DUMMY',1005,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1006,NULL,'DUMMY',1006,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1007,NULL,'DUMMY',1007,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1008,NULL,'DUMMY',1008,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1009,NULL,'DUMMY',1009,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1010,NULL,'DUMMY',1010,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1011,NULL,'DUMMY',1011,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1012,NULL,'DUMMY',1012,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1013,NULL,'DUMMY',1013,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1014,NULL,'DUMMY',1014,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1015,NULL,'DUMMY',1015,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1016,NULL,'DUMMY',1016,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1017,NULL,'DUMMY',1017,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1018,NULL,'DUMMY',1018,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1019,NULL,'DUMMY',1019,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1020,NULL,'DUMMY',1020,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1021,NULL,'DUMMY',1021,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1022,NULL,'DUMMY',1022,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1023,NULL,'DUMMY',1023,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1024,NULL,'DUMMY',1024,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1025,NULL,'DUMMY',1025,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1026,NULL,'DUMMY',1026,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1027,NULL,'DUMMY',1027,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1028,NULL,'DUMMY',1028,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1029,NULL,'DUMMY',1029,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1030,NULL,'DUMMY',1030,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1031,NULL,'DUMMY',1031,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1032,NULL,'DUMMY',1032,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1033,NULL,'DUMMY',1033,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1034,NULL,'DUMMY',1034,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1035,NULL,'DUMMY',1035,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1036,NULL,'DUMMY',1036,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1037,NULL,'DUMMY',1037,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1038,NULL,'DUMMY',1038,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1039,NULL,'DUMMY',1039,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1040,NULL,'DUMMY',1040,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1041,NULL,'DUMMY',1041,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1042,NULL,'DUMMY',1042,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1043,NULL,'DUMMY',1043,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1044,NULL,'DUMMY',1044,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1045,NULL,'DUMMY',1045,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1046,NULL,'DUMMY',1046,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1047,NULL,'DUMMY',1047,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1048,NULL,'DUMMY',1048,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1049,NULL,'DUMMY',1049,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1050,NULL,'DUMMY',1050,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1051,NULL,'DUMMY',1051,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1052,NULL,'DUMMY',1052,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1053,NULL,'DUMMY',1053,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1054,NULL,'DUMMY',1054,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1055,NULL,'DUMMY',1055,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1056,NULL,'DUMMY',1056,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1057,NULL,'DUMMY',1057,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1058,NULL,'DUMMY',1058,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1059,NULL,'DUMMY',1059,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1060,NULL,'DUMMY',1060,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1061,NULL,'DUMMY',1061,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1062,NULL,'DUMMY',1062,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1063,NULL,'DUMMY',1063,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1064,NULL,'DUMMY',1064,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1065,NULL,'DUMMY',1065,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1066,NULL,'DUMMY',1066,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1067,NULL,'DUMMY',1067,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1068,NULL,'DUMMY',1068,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1069,NULL,'DUMMY',1069,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1070,NULL,'DUMMY',1070,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1071,NULL,'DUMMY',1071,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1072,NULL,'DUMMY',1072,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1073,NULL,'DUMMY',1073,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1074,NULL,'DUMMY',1074,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1075,NULL,'DUMMY',1075,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1076,NULL,'DUMMY',1076,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1077,NULL,'DUMMY',1077,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1078,NULL,'DUMMY',1078,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1079,NULL,'DUMMY',1079,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1080,NULL,'DUMMY',1080,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1081,NULL,'DUMMY',1081,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1082,NULL,'DUMMY',1082,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1083,NULL,'DUMMY',1083,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1084,NULL,'DUMMY',1084,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1085,NULL,'DUMMY',1085,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1086,NULL,'DUMMY',1086,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1087,NULL,'DUMMY',1087,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1088,NULL,'DUMMY',1088,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1089,NULL,'DUMMY',1089,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1090,NULL,'DUMMY',1090,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1091,NULL,'DUMMY',1091,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1092,NULL,'DUMMY',1092,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1093,NULL,'DUMMY',1093,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1094,NULL,'DUMMY',1094,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1095,NULL,'DUMMY',1095,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1096,NULL,'DUMMY',1096,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1097,NULL,'DUMMY',1097,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1098,NULL,'DUMMY',1098,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1099,NULL,'DUMMY',1099,1,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1100,NULL,'DUMMY',1100,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1101,NULL,'DUMMY',1101,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1102,NULL,'DUMMY',1102,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1103,NULL,'DUMMY',1103,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1104,NULL,'DUMMY',1104,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1105,NULL,'DUMMY',1105,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1106,NULL,'DUMMY',1106,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1107,NULL,'DUMMY',1107,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1108,NULL,'DUMMY',1108,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1109,NULL,'DUMMY',1109,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1110,NULL,'DUMMY',1110,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1111,NULL,'DUMMY',1111,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1112,NULL,'DUMMY',1112,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1113,NULL,'DUMMY',1113,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1114,NULL,'DUMMY',1114,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1115,NULL,'DUMMY',1115,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1116,NULL,'DUMMY',1116,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1117,NULL,'DUMMY',1117,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1118,NULL,'DUMMY',1118,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1119,NULL,'DUMMY',1119,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1120,NULL,'DUMMY',1120,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1121,NULL,'DUMMY',1121,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1122,NULL,'DUMMY',1122,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1123,NULL,'DUMMY',1123,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1124,NULL,'DUMMY',1124,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1125,NULL,'DUMMY',1125,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1126,NULL,'DUMMY',1126,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1127,NULL,'DUMMY',1127,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1128,NULL,'DUMMY',1128,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1129,NULL,'DUMMY',1129,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1130,NULL,'DUMMY',1130,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1131,NULL,'DUMMY',1131,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1132,NULL,'DUMMY',1132,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1133,NULL,'DUMMY',1133,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1134,NULL,'DUMMY',1134,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1135,NULL,'DUMMY',1135,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1136,NULL,'DUMMY',1136,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1137,NULL,'DUMMY',1137,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1138,NULL,'DUMMY',1138,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1139,NULL,'DUMMY',1139,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1140,NULL,'DUMMY',1140,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1141,NULL,'DUMMY',1141,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1142,NULL,'DUMMY',1142,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1143,NULL,'DUMMY',1143,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1144,NULL,'DUMMY',1144,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1145,NULL,'DUMMY',1145,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1146,NULL,'DUMMY',1146,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1147,NULL,'DUMMY',1147,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1148,NULL,'DUMMY',1148,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1149,NULL,'DUMMY',1149,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1150,NULL,'DUMMY',1150,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1151,NULL,'DUMMY',1151,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1152,NULL,'DUMMY',1152,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1153,NULL,'DUMMY',1153,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1154,NULL,'DUMMY',1154,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1155,NULL,'DUMMY',1155,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1156,NULL,'DUMMY',1156,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1157,NULL,'DUMMY',1157,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1158,NULL,'DUMMY',1158,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1159,NULL,'DUMMY',1159,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1160,NULL,'DUMMY',1160,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1161,NULL,'DUMMY',1161,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1162,NULL,'DUMMY',1162,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1163,NULL,'DUMMY',1163,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1164,NULL,'DUMMY',1164,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1165,NULL,'DUMMY',1165,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1166,NULL,'DUMMY',1166,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1167,NULL,'DUMMY',1167,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1168,NULL,'DUMMY',1168,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1169,NULL,'DUMMY',1169,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1170,NULL,'DUMMY',1170,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1171,NULL,'DUMMY',1171,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1172,NULL,'DUMMY',1172,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1173,NULL,'DUMMY',1173,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1174,NULL,'DUMMY',1174,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1175,NULL,'DUMMY',1175,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1176,NULL,'DUMMY',1176,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1177,NULL,'DUMMY',1177,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1178,NULL,'DUMMY',1178,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1179,NULL,'DUMMY',1179,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1180,NULL,'DUMMY',1180,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1181,NULL,'DUMMY',1181,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1182,NULL,'DUMMY',1182,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1183,NULL,'DUMMY',1183,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1184,NULL,'DUMMY',1184,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1185,NULL,'DUMMY',1185,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1186,NULL,'DUMMY',1186,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1187,NULL,'DUMMY',1187,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1188,NULL,'DUMMY',1188,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1189,NULL,'DUMMY',1189,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1190,NULL,'DUMMY',1190,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1191,NULL,'DUMMY',1191,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1192,NULL,'DUMMY',1192,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1193,NULL,'DUMMY',1193,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1194,NULL,'DUMMY',1194,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1195,NULL,'DUMMY',1195,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1196,NULL,'DUMMY',1196,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1197,NULL,'DUMMY',1197,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1198,NULL,'DUMMY',1198,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1199,NULL,'DUMMY',1199,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1200,NULL,'DUMMY',1200,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1201,NULL,'DUMMY',1201,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1202,NULL,'DUMMY',1202,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1203,NULL,'DUMMY',1203,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1204,NULL,'DUMMY',1204,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1205,NULL,'DUMMY',1205,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1206,NULL,'DUMMY',1206,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1207,NULL,'DUMMY',1207,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1208,NULL,'DUMMY',1208,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1209,NULL,'DUMMY',1209,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1210,NULL,'DUMMY',1210,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1211,NULL,'DUMMY',1211,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1212,NULL,'DUMMY',1212,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1213,NULL,'DUMMY',1213,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1214,NULL,'DUMMY',1214,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1215,NULL,'DUMMY',1215,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1216,NULL,'DUMMY',1216,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1217,NULL,'DUMMY',1217,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1218,NULL,'DUMMY',1218,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1219,NULL,'DUMMY',1219,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1220,NULL,'DUMMY',1220,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1221,NULL,'DUMMY',1221,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1222,NULL,'DUMMY',1222,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1223,NULL,'DUMMY',1223,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1224,NULL,'DUMMY',1224,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1225,NULL,'DUMMY',1225,1,'2025-02-13 02:34:27','2025-02-13 02:34:27'),(1226,NULL,'DUMMY',1226,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1227,NULL,'DUMMY',1227,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1228,NULL,'DUMMY',1228,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1229,NULL,'DUMMY',1229,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1230,NULL,'DUMMY',1230,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1231,NULL,'DUMMY',1231,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1232,NULL,'DUMMY',1232,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1233,NULL,'DUMMY',1233,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1234,NULL,'DUMMY',1234,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1235,NULL,'DUMMY',1235,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1236,NULL,'DUMMY',1236,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1237,NULL,'DUMMY',1237,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1238,NULL,'DUMMY',1238,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1239,NULL,'DUMMY',1239,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1240,NULL,'DUMMY',1240,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1241,NULL,'DUMMY',1241,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1242,NULL,'DUMMY',1242,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1243,NULL,'DUMMY',1243,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1244,NULL,'DUMMY',1244,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1245,NULL,'DUMMY',1245,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1246,NULL,'DUMMY',1246,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1247,NULL,'DUMMY',1247,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1248,NULL,'DUMMY',1248,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1249,NULL,'DUMMY',1249,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1250,NULL,'DUMMY',1250,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1251,NULL,'DUMMY',1251,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1252,NULL,'DUMMY',1252,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1253,NULL,'DUMMY',1253,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1254,NULL,'DUMMY',1254,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1255,NULL,'DUMMY',1255,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1256,NULL,'DUMMY',1256,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1257,NULL,'DUMMY',1257,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1258,NULL,'DUMMY',1258,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1259,NULL,'DUMMY',1259,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1260,NULL,'DUMMY',1260,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1261,NULL,'DUMMY',1261,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1262,NULL,'DUMMY',1262,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1263,NULL,'DUMMY',1263,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1264,NULL,'DUMMY',1264,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1265,NULL,'DUMMY',1265,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1266,NULL,'DUMMY',1266,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1267,NULL,'DUMMY',1267,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1268,NULL,'DUMMY',1268,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1269,NULL,'DUMMY',1269,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1270,NULL,'DUMMY',1270,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1271,NULL,'DUMMY',1271,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1272,NULL,'DUMMY',1272,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1273,NULL,'DUMMY',1273,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1274,NULL,'DUMMY',1274,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1275,NULL,'DUMMY',1275,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1276,NULL,'DUMMY',1276,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1277,NULL,'DUMMY',1277,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1278,NULL,'DUMMY',1278,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1279,NULL,'DUMMY',1279,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1280,NULL,'DUMMY',1280,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1281,NULL,'DUMMY',1281,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1282,NULL,'DUMMY',1282,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1283,NULL,'DUMMY',1283,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1284,NULL,'DUMMY',1284,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1285,NULL,'DUMMY',1285,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1286,NULL,'DUMMY',1286,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1287,NULL,'DUMMY',1287,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1288,NULL,'DUMMY',1288,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1289,NULL,'DUMMY',1289,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1290,NULL,'DUMMY',1290,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1291,NULL,'DUMMY',1291,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1292,NULL,'DUMMY',1292,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1293,NULL,'DUMMY',1293,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1294,NULL,'DUMMY',1294,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1295,NULL,'DUMMY',1295,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1296,NULL,'DUMMY',1296,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1297,NULL,'DUMMY',1297,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1298,NULL,'DUMMY',1298,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1299,NULL,'DUMMY',1299,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1300,NULL,'DUMMY',1300,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1301,NULL,'DUMMY',1301,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1302,NULL,'DUMMY',1302,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1303,NULL,'DUMMY',1303,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1304,NULL,'DUMMY',1304,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1305,NULL,'DUMMY',1305,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1306,NULL,'DUMMY',1306,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1307,NULL,'DUMMY',1307,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1308,NULL,'DUMMY',1308,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1309,NULL,'DUMMY',1309,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1310,NULL,'DUMMY',1310,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1311,NULL,'DUMMY',1311,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1312,NULL,'DUMMY',1312,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1313,NULL,'DUMMY',1313,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1314,NULL,'DUMMY',1314,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1315,NULL,'DUMMY',1315,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1316,NULL,'DUMMY',1316,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1317,NULL,'DUMMY',1317,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1318,NULL,'DUMMY',1318,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1319,NULL,'DUMMY',1319,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1320,NULL,'DUMMY',1320,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1321,NULL,'DUMMY',1321,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1322,NULL,'DUMMY',1322,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1323,NULL,'DUMMY',1323,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1324,NULL,'DUMMY',1324,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1325,NULL,'DUMMY',1325,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1326,NULL,'DUMMY',1326,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1327,NULL,'DUMMY',1327,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1328,NULL,'DUMMY',1328,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1329,NULL,'DUMMY',1329,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1330,NULL,'DUMMY',1330,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1331,NULL,'DUMMY',1331,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1332,NULL,'DUMMY',1332,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1333,NULL,'DUMMY',1333,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1334,NULL,'DUMMY',1334,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1335,NULL,'DUMMY',1335,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1336,NULL,'DUMMY',1336,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1337,NULL,'DUMMY',1337,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1338,NULL,'DUMMY',1338,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1339,NULL,'DUMMY',1339,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1340,NULL,'DUMMY',1340,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1341,NULL,'DUMMY',1341,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1342,NULL,'DUMMY',1342,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1343,NULL,'DUMMY',1343,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1344,NULL,'DUMMY',1344,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1345,NULL,'DUMMY',1345,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1346,NULL,'DUMMY',1346,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1347,NULL,'DUMMY',1347,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1348,NULL,'DUMMY',1348,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1349,NULL,'DUMMY',1349,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1350,NULL,'DUMMY',1350,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1351,NULL,'DUMMY',1351,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1352,NULL,'DUMMY',1352,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1353,NULL,'DUMMY',1353,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1354,NULL,'DUMMY',1354,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1355,NULL,'DUMMY',1355,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1356,NULL,'DUMMY',1356,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1357,NULL,'DUMMY',1357,1,'2025-02-13 02:34:28','2025-02-13 02:34:28'),(1358,NULL,'DUMMY',1358,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1359,NULL,'DUMMY',1359,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1360,NULL,'DUMMY',1360,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1361,NULL,'DUMMY',1361,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1362,NULL,'DUMMY',1362,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1363,NULL,'DUMMY',1363,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1364,NULL,'DUMMY',1364,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1365,NULL,'DUMMY',1365,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1366,NULL,'DUMMY',1366,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1367,NULL,'DUMMY',1367,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1368,NULL,'DUMMY',1368,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1369,NULL,'DUMMY',1369,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1370,NULL,'DUMMY',1370,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1371,NULL,'DUMMY',1371,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1372,NULL,'DUMMY',1372,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1373,NULL,'DUMMY',1373,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1374,NULL,'DUMMY',1374,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1375,NULL,'DUMMY',1375,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1376,NULL,'DUMMY',1376,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1377,NULL,'DUMMY',1377,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1378,NULL,'DUMMY',1378,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1379,NULL,'DUMMY',1379,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1380,NULL,'DUMMY',1380,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1381,NULL,'DUMMY',1381,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1382,NULL,'DUMMY',1382,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1383,NULL,'DUMMY',1383,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1384,NULL,'DUMMY',1384,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1385,NULL,'DUMMY',1385,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1386,NULL,'DUMMY',1386,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1387,NULL,'DUMMY',1387,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1388,NULL,'DUMMY',1388,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1389,NULL,'DUMMY',1389,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1390,NULL,'DUMMY',1390,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1391,NULL,'DUMMY',1391,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1392,NULL,'DUMMY',1392,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1393,NULL,'DUMMY',1393,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1394,NULL,'DUMMY',1394,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1395,NULL,'DUMMY',1395,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1396,NULL,'DUMMY',1396,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1397,NULL,'DUMMY',1397,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1398,NULL,'DUMMY',1398,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1399,NULL,'DUMMY',1399,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1400,NULL,'DUMMY',1400,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1401,NULL,'DUMMY',1401,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1402,NULL,'DUMMY',1402,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1403,NULL,'DUMMY',1403,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1404,NULL,'DUMMY',1404,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1405,NULL,'DUMMY',1405,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1406,NULL,'DUMMY',1406,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1407,NULL,'DUMMY',1407,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1408,NULL,'DUMMY',1408,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1409,NULL,'DUMMY',1409,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1410,NULL,'DUMMY',1410,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1411,NULL,'DUMMY',1411,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1412,NULL,'DUMMY',1412,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1413,NULL,'DUMMY',1413,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1414,NULL,'DUMMY',1414,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1415,NULL,'DUMMY',1415,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1416,NULL,'DUMMY',1416,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1417,NULL,'DUMMY',1417,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1418,NULL,'DUMMY',1418,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1419,NULL,'DUMMY',1419,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1420,NULL,'DUMMY',1420,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1421,NULL,'DUMMY',1421,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1422,NULL,'DUMMY',1422,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1423,NULL,'DUMMY',1423,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1424,NULL,'DUMMY',1424,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1425,NULL,'DUMMY',1425,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1426,NULL,'DUMMY',1426,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1427,NULL,'DUMMY',1427,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1428,NULL,'DUMMY',1428,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1429,NULL,'DUMMY',1429,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1430,NULL,'DUMMY',1430,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1431,NULL,'DUMMY',1431,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1432,NULL,'DUMMY',1432,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1433,NULL,'DUMMY',1433,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1434,NULL,'DUMMY',1434,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1435,NULL,'DUMMY',1435,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1436,NULL,'DUMMY',1436,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1437,NULL,'DUMMY',1437,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1438,NULL,'DUMMY',1438,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1439,NULL,'DUMMY',1439,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1440,NULL,'DUMMY',1440,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1441,NULL,'DUMMY',1441,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1442,NULL,'DUMMY',1442,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1443,NULL,'DUMMY',1443,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1444,NULL,'DUMMY',1444,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1445,NULL,'DUMMY',1445,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1446,NULL,'DUMMY',1446,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1447,NULL,'DUMMY',1447,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1448,NULL,'DUMMY',1448,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1449,NULL,'DUMMY',1449,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1450,NULL,'DUMMY',1450,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1451,NULL,'DUMMY',1451,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1452,NULL,'DUMMY',1452,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1453,NULL,'DUMMY',1453,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1454,NULL,'DUMMY',1454,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1455,NULL,'DUMMY',1455,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1456,NULL,'DUMMY',1456,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1457,NULL,'DUMMY',1457,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1458,NULL,'DUMMY',1458,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1459,NULL,'DUMMY',1459,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1460,NULL,'DUMMY',1460,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1461,NULL,'DUMMY',1461,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1462,NULL,'DUMMY',1462,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1463,NULL,'DUMMY',1463,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1464,NULL,'DUMMY',1464,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1465,NULL,'DUMMY',1465,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1466,NULL,'DUMMY',1466,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1467,NULL,'DUMMY',1467,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1468,NULL,'DUMMY',1468,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1469,NULL,'DUMMY',1469,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1470,NULL,'DUMMY',1470,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1471,NULL,'DUMMY',1471,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1472,NULL,'DUMMY',1472,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1473,NULL,'DUMMY',1473,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1474,NULL,'DUMMY',1474,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1475,NULL,'DUMMY',1475,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1476,NULL,'DUMMY',1476,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1477,NULL,'DUMMY',1477,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1478,NULL,'DUMMY',1478,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1479,NULL,'DUMMY',1479,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1480,NULL,'DUMMY',1480,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1481,NULL,'DUMMY',1481,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1482,NULL,'DUMMY',1482,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1483,NULL,'DUMMY',1483,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1484,NULL,'DUMMY',1484,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1485,NULL,'DUMMY',1485,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1486,NULL,'DUMMY',1486,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1487,NULL,'DUMMY',1487,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1488,NULL,'DUMMY',1488,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1489,NULL,'DUMMY',1489,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1490,NULL,'DUMMY',1490,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1491,NULL,'DUMMY',1491,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1492,NULL,'DUMMY',1492,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1493,NULL,'DUMMY',1493,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1494,NULL,'DUMMY',1494,1,'2025-02-13 02:34:29','2025-02-13 02:34:29'),(1495,NULL,'DUMMY',1495,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1496,NULL,'DUMMY',1496,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1497,NULL,'DUMMY',1497,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1498,NULL,'DUMMY',1498,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1499,NULL,'DUMMY',1499,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1500,NULL,'DUMMY',1500,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1501,NULL,'DUMMY',1501,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1502,NULL,'DUMMY',1502,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1503,NULL,'DUMMY',1503,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1504,NULL,'DUMMY',1504,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1505,NULL,'DUMMY',1505,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1506,NULL,'DUMMY',1506,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1507,NULL,'DUMMY',1507,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1508,NULL,'DUMMY',1508,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1509,NULL,'DUMMY',1509,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1510,NULL,'DUMMY',1510,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1511,NULL,'DUMMY',1511,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1512,NULL,'DUMMY',1512,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1513,NULL,'DUMMY',1513,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1514,NULL,'DUMMY',1514,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1515,NULL,'DUMMY',1515,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1516,NULL,'DUMMY',1516,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1517,NULL,'DUMMY',1517,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1518,NULL,'DUMMY',1518,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1519,NULL,'DUMMY',1519,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1520,NULL,'DUMMY',1520,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1521,NULL,'DUMMY',1521,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1522,NULL,'DUMMY',1522,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1523,NULL,'DUMMY',1523,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1524,NULL,'DUMMY',1524,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1525,NULL,'DUMMY',1525,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1526,NULL,'DUMMY',1526,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1527,NULL,'DUMMY',1527,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1528,NULL,'DUMMY',1528,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1529,NULL,'DUMMY',1529,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1530,NULL,'DUMMY',1530,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1531,NULL,'DUMMY',1531,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1532,NULL,'DUMMY',1532,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1533,NULL,'DUMMY',1533,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1534,NULL,'DUMMY',1534,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1535,NULL,'DUMMY',1535,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1536,NULL,'DUMMY',1536,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1537,NULL,'DUMMY',1537,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1538,NULL,'DUMMY',1538,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1539,NULL,'DUMMY',1539,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1540,NULL,'DUMMY',1540,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1541,NULL,'DUMMY',1541,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1542,NULL,'DUMMY',1542,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1543,NULL,'DUMMY',1543,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1544,NULL,'DUMMY',1544,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1545,NULL,'DUMMY',1545,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1546,NULL,'DUMMY',1546,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1547,NULL,'DUMMY',1547,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1548,NULL,'DUMMY',1548,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1549,NULL,'DUMMY',1549,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1550,NULL,'DUMMY',1550,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1551,NULL,'DUMMY',1551,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1552,NULL,'DUMMY',1552,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1553,NULL,'DUMMY',1553,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1554,NULL,'DUMMY',1554,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1555,NULL,'DUMMY',1555,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1556,NULL,'DUMMY',1556,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1557,NULL,'DUMMY',1557,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1558,NULL,'DUMMY',1558,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1559,NULL,'DUMMY',1559,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1560,NULL,'DUMMY',1560,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1561,NULL,'DUMMY',1561,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1562,NULL,'DUMMY',1562,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1563,NULL,'DUMMY',1563,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1564,NULL,'DUMMY',1564,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1565,NULL,'DUMMY',1565,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1566,NULL,'DUMMY',1566,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1567,NULL,'DUMMY',1567,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1568,NULL,'DUMMY',1568,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1569,NULL,'DUMMY',1569,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1570,NULL,'DUMMY',1570,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1571,NULL,'DUMMY',1571,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1572,NULL,'DUMMY',1572,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1573,NULL,'DUMMY',1573,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1574,NULL,'DUMMY',1574,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1575,NULL,'DUMMY',1575,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1576,NULL,'DUMMY',1576,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1577,NULL,'DUMMY',1577,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1578,NULL,'DUMMY',1578,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1579,NULL,'DUMMY',1579,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1580,NULL,'DUMMY',1580,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1581,NULL,'DUMMY',1581,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1582,NULL,'DUMMY',1582,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1583,NULL,'DUMMY',1583,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1584,NULL,'DUMMY',1584,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1585,NULL,'DUMMY',1585,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1586,NULL,'DUMMY',1586,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1587,NULL,'DUMMY',1587,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1588,NULL,'DUMMY',1588,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1589,NULL,'DUMMY',1589,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1590,NULL,'DUMMY',1590,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1591,NULL,'DUMMY',1591,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1592,NULL,'DUMMY',1592,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1593,NULL,'DUMMY',1593,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1594,NULL,'DUMMY',1594,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1595,NULL,'DUMMY',1595,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1596,NULL,'DUMMY',1596,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1597,NULL,'DUMMY',1597,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1598,NULL,'DUMMY',1598,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1599,NULL,'DUMMY',1599,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1600,NULL,'DUMMY',1600,1,'2025-02-13 02:34:30','2025-02-13 02:34:30'),(1601,NULL,'DUMMY',1601,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1602,NULL,'DUMMY',1602,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1603,NULL,'DUMMY',1603,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1604,NULL,'DUMMY',1604,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1605,NULL,'DUMMY',1605,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1606,NULL,'DUMMY',1606,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1607,NULL,'DUMMY',1607,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1608,NULL,'DUMMY',1608,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1609,NULL,'DUMMY',1609,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1610,NULL,'DUMMY',1610,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1611,NULL,'DUMMY',1611,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1612,NULL,'DUMMY',1612,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1613,NULL,'DUMMY',1613,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1614,NULL,'DUMMY',1614,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1615,NULL,'DUMMY',1615,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1616,NULL,'DUMMY',1616,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1617,NULL,'DUMMY',1617,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1618,NULL,'DUMMY',1618,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1619,NULL,'DUMMY',1619,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1620,NULL,'DUMMY',1620,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1621,NULL,'DUMMY',1621,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1622,NULL,'DUMMY',1622,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1623,NULL,'DUMMY',1623,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1624,NULL,'DUMMY',1624,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1625,NULL,'DUMMY',1625,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1626,NULL,'DUMMY',1626,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1627,NULL,'DUMMY',1627,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1628,NULL,'DUMMY',1628,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1629,NULL,'DUMMY',1629,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1630,NULL,'DUMMY',1630,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1631,NULL,'DUMMY',1631,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1632,NULL,'DUMMY',1632,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1633,NULL,'DUMMY',1633,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1634,NULL,'DUMMY',1634,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1635,NULL,'DUMMY',1635,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1636,NULL,'DUMMY',1636,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1637,NULL,'DUMMY',1637,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1638,NULL,'DUMMY',1638,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1639,NULL,'DUMMY',1639,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1640,NULL,'DUMMY',1640,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1641,NULL,'DUMMY',1641,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1642,NULL,'DUMMY',1642,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1643,NULL,'DUMMY',1643,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1644,NULL,'DUMMY',1644,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1645,NULL,'DUMMY',1645,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1646,NULL,'DUMMY',1646,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1647,NULL,'DUMMY',1647,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1648,NULL,'DUMMY',1648,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1649,NULL,'DUMMY',1649,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1650,NULL,'DUMMY',1650,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1651,NULL,'DUMMY',1651,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1652,NULL,'DUMMY',1652,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1653,NULL,'DUMMY',1653,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1654,NULL,'DUMMY',1654,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1655,NULL,'DUMMY',1655,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1656,NULL,'DUMMY',1656,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1657,NULL,'DUMMY',1657,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1658,NULL,'DUMMY',1658,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1659,NULL,'DUMMY',1659,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1660,NULL,'DUMMY',1660,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1661,NULL,'DUMMY',1661,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1662,NULL,'DUMMY',1662,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1663,NULL,'DUMMY',1663,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1664,NULL,'DUMMY',1664,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1665,NULL,'DUMMY',1665,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1666,NULL,'DUMMY',1666,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1667,NULL,'DUMMY',1667,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1668,NULL,'DUMMY',1668,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1669,NULL,'DUMMY',1669,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1670,NULL,'DUMMY',1670,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1671,NULL,'DUMMY',1671,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1672,NULL,'DUMMY',1672,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1673,NULL,'DUMMY',1673,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1674,NULL,'DUMMY',1674,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1675,NULL,'DUMMY',1675,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1676,NULL,'DUMMY',1676,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1677,NULL,'DUMMY',1677,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1678,NULL,'DUMMY',1678,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1679,NULL,'DUMMY',1679,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1680,NULL,'DUMMY',1680,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1681,NULL,'DUMMY',1681,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1682,NULL,'DUMMY',1682,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1683,NULL,'DUMMY',1683,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1684,NULL,'DUMMY',1684,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1685,NULL,'DUMMY',1685,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1686,NULL,'DUMMY',1686,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1687,NULL,'DUMMY',1687,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1688,NULL,'DUMMY',1688,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1689,NULL,'DUMMY',1689,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1690,NULL,'DUMMY',1690,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1691,NULL,'DUMMY',1691,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1692,NULL,'DUMMY',1692,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1693,NULL,'DUMMY',1693,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1694,NULL,'DUMMY',1694,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1695,NULL,'DUMMY',1695,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1696,NULL,'DUMMY',1696,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1697,NULL,'DUMMY',1697,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1698,NULL,'DUMMY',1698,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1699,NULL,'DUMMY',1699,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1700,NULL,'DUMMY',1700,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1701,NULL,'DUMMY',1701,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1702,NULL,'DUMMY',1702,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1703,NULL,'DUMMY',1703,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1704,NULL,'DUMMY',1704,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1705,NULL,'DUMMY',1705,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1706,NULL,'DUMMY',1706,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1707,NULL,'DUMMY',1707,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1708,NULL,'DUMMY',1708,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1709,NULL,'DUMMY',1709,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1710,NULL,'DUMMY',1710,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1711,NULL,'DUMMY',1711,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1712,NULL,'DUMMY',1712,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1713,NULL,'DUMMY',1713,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1714,NULL,'DUMMY',1714,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1715,NULL,'DUMMY',1715,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1716,NULL,'DUMMY',1716,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1717,NULL,'DUMMY',1717,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1718,NULL,'DUMMY',1718,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1719,NULL,'DUMMY',1719,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1720,NULL,'DUMMY',1720,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1721,NULL,'DUMMY',1721,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1722,NULL,'DUMMY',1722,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1723,NULL,'DUMMY',1723,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1724,NULL,'DUMMY',1724,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1725,NULL,'DUMMY',1725,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1726,NULL,'DUMMY',1726,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1727,NULL,'DUMMY',1727,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1728,NULL,'DUMMY',1728,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1729,NULL,'DUMMY',1729,1,'2025-02-13 02:34:31','2025-02-13 02:34:31'),(1730,NULL,'DUMMY',1730,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1731,NULL,'DUMMY',1731,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1732,NULL,'DUMMY',1732,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1733,NULL,'DUMMY',1733,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1734,NULL,'DUMMY',1734,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1735,NULL,'DUMMY',1735,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1736,NULL,'DUMMY',1736,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1737,NULL,'DUMMY',1737,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1738,NULL,'DUMMY',1738,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1739,NULL,'DUMMY',1739,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1740,NULL,'DUMMY',1740,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1741,NULL,'DUMMY',1741,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1742,NULL,'DUMMY',1742,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1743,NULL,'DUMMY',1743,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1744,NULL,'DUMMY',1744,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1745,NULL,'DUMMY',1745,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1746,NULL,'DUMMY',1746,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1747,NULL,'DUMMY',1747,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1748,NULL,'DUMMY',1748,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1749,NULL,'DUMMY',1749,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1750,NULL,'DUMMY',1750,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1751,NULL,'DUMMY',1751,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1752,NULL,'DUMMY',1752,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1753,NULL,'DUMMY',1753,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1754,NULL,'DUMMY',1754,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1755,NULL,'DUMMY',1755,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1756,NULL,'DUMMY',1756,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1757,NULL,'DUMMY',1757,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1758,NULL,'DUMMY',1758,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1759,NULL,'DUMMY',1759,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1760,NULL,'DUMMY',1760,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1761,NULL,'DUMMY',1761,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1762,NULL,'DUMMY',1762,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1763,NULL,'DUMMY',1763,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1764,NULL,'DUMMY',1764,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1765,NULL,'DUMMY',1765,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1766,NULL,'DUMMY',1766,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1767,NULL,'DUMMY',1767,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1768,NULL,'DUMMY',1768,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1769,NULL,'DUMMY',1769,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1770,NULL,'DUMMY',1770,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1771,NULL,'DUMMY',1771,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1772,NULL,'DUMMY',1772,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1773,NULL,'DUMMY',1773,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1774,NULL,'DUMMY',1774,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1775,NULL,'DUMMY',1775,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1776,NULL,'DUMMY',1776,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1777,NULL,'DUMMY',1777,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1778,NULL,'DUMMY',1778,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1779,NULL,'DUMMY',1779,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1780,NULL,'DUMMY',1780,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1781,NULL,'DUMMY',1781,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1782,NULL,'DUMMY',1782,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1783,NULL,'DUMMY',1783,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1784,NULL,'DUMMY',1784,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1785,NULL,'DUMMY',1785,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1786,NULL,'DUMMY',1786,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1787,NULL,'DUMMY',1787,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1788,NULL,'DUMMY',1788,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1789,NULL,'DUMMY',1789,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1790,NULL,'DUMMY',1790,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1791,NULL,'DUMMY',1791,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1792,NULL,'DUMMY',1792,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1793,NULL,'DUMMY',1793,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1794,NULL,'DUMMY',1794,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1795,NULL,'DUMMY',1795,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1796,NULL,'DUMMY',1796,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1797,NULL,'DUMMY',1797,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1798,NULL,'DUMMY',1798,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1799,NULL,'DUMMY',1799,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1800,NULL,'DUMMY',1800,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1801,NULL,'DUMMY',1801,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1802,NULL,'DUMMY',1802,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1803,NULL,'DUMMY',1803,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1804,NULL,'DUMMY',1804,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1805,NULL,'DUMMY',1805,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1806,NULL,'DUMMY',1806,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1807,NULL,'DUMMY',1807,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1808,NULL,'DUMMY',1808,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1809,NULL,'DUMMY',1809,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1810,NULL,'DUMMY',1810,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1811,NULL,'DUMMY',1811,1,'2025-02-13 02:34:32','2025-02-13 02:34:32'),(1812,NULL,'DUMMY',1812,1,'2025-02-14 13:22:21','2025-02-14 13:22:21'),(1813,NULL,'DUMMY',1813,1,'2025-02-15 05:54:05','2025-02-15 05:54:05'),(1814,NULL,'DUMMY',1814,1,'2025-02-16 04:49:26','2025-02-16 04:49:26'),(1815,NULL,'DUMMY',1815,1,'2025-02-16 04:57:55','2025-02-16 04:57:55'),(1816,NULL,'DUMMY',1816,1,'2025-02-16 05:01:11','2025-02-16 05:01:11'),(1817,NULL,'DUMMY',1817,1,'2025-02-16 05:10:39','2025-02-16 05:10:39'),(1818,NULL,'DUMMY',1818,1,'2025-02-16 05:12:17','2025-02-16 05:12:17'),(1819,NULL,'DUMMY',1819,1,'2025-02-16 05:20:15','2025-02-16 05:20:15'),(1851,NULL,'DUMMY',1851,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1852,NULL,'DUMMY',1852,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1853,NULL,'DUMMY',1853,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1854,NULL,'DUMMY',1854,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1855,NULL,'DUMMY',1855,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1856,NULL,'DUMMY',1856,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1857,NULL,'DUMMY',1857,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1858,NULL,'DUMMY',1858,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1859,NULL,'DUMMY',1859,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1860,NULL,'DUMMY',1860,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1861,NULL,'DUMMY',1861,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1862,NULL,'DUMMY',1862,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1863,NULL,'DUMMY',1863,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1864,NULL,'DUMMY',1864,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1865,NULL,'DUMMY',1865,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1866,NULL,'DUMMY',1866,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1867,NULL,'DUMMY',1867,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1868,NULL,'DUMMY',1868,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1869,NULL,'DUMMY',1869,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1870,NULL,'DUMMY',1870,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1871,NULL,'DUMMY',1871,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1872,NULL,'DUMMY',1872,1,'2025-02-25 09:19:31','2025-02-25 09:19:31'),(1873,NULL,'DUMMY',1873,1,'2025-02-25 09:19:32','2025-02-25 09:19:32'),(1874,NULL,'DUMMY',1874,1,'2025-02-25 09:19:32','2025-02-25 09:19:32'),(1875,NULL,'DUMMY',1875,1,'2025-02-25 09:19:32','2025-02-25 09:19:32'),(1876,NULL,'DUMMY',1876,1,'2025-02-25 09:19:32','2025-02-25 09:19:32'),(1877,NULL,'DUMMY',1877,1,'2025-02-25 09:19:32','2025-02-25 09:19:32'),(1878,NULL,'DUMMY',1878,1,'2025-02-25 09:19:32','2025-02-25 09:19:32'),(1879,NULL,'DUMMY',1879,1,'2025-02-25 09:19:32','2025-02-25 09:19:32'),(1880,NULL,'DUMMY',1880,1,'2025-02-25 09:19:32','2025-02-25 09:19:32'),(1918,NULL,'DUMMY',1918,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1919,NULL,'DUMMY',1919,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1920,NULL,'DUMMY',1920,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1921,NULL,'DUMMY',1921,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1922,NULL,'DUMMY',1922,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1923,NULL,'DUMMY',1923,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1924,NULL,'DUMMY',1924,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1925,NULL,'DUMMY',1925,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1926,NULL,'DUMMY',1926,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1927,NULL,'DUMMY',1927,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1928,NULL,'DUMMY',1928,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1929,NULL,'DUMMY',1929,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1930,NULL,'DUMMY',1930,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1931,NULL,'DUMMY',1931,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1932,NULL,'DUMMY',1932,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1933,NULL,'DUMMY',1933,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1934,NULL,'DUMMY',1934,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1935,NULL,'DUMMY',1935,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1936,NULL,'DUMMY',1936,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1937,NULL,'DUMMY',1937,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1938,NULL,'DUMMY',1938,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1939,NULL,'DUMMY',1939,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1940,NULL,'DUMMY',1940,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1941,NULL,'DUMMY',1941,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1942,NULL,'DUMMY',1942,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1943,NULL,'DUMMY',1943,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1944,NULL,'DUMMY',1944,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1945,NULL,'DUMMY',1945,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1946,NULL,'DUMMY',1946,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1947,NULL,'DUMMY',1947,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1948,NULL,'DUMMY',1948,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1949,NULL,'DUMMY',1949,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1950,NULL,'DUMMY',1950,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1951,NULL,'DUMMY',1951,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1952,NULL,'DUMMY',1952,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1953,NULL,'DUMMY',1953,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1954,NULL,'DUMMY',1954,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1955,NULL,'DUMMY',1955,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1956,NULL,'DUMMY',1956,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1957,NULL,'DUMMY',1957,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1958,NULL,'DUMMY',1958,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1959,NULL,'DUMMY',1959,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1960,NULL,'DUMMY',1960,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1961,NULL,'DUMMY',1961,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1962,NULL,'DUMMY',1962,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1963,NULL,'DUMMY',1963,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1964,NULL,'DUMMY',1964,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1965,NULL,'DUMMY',1965,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1966,NULL,'DUMMY',1966,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1967,NULL,'DUMMY',1967,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1968,NULL,'DUMMY',1968,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1969,NULL,'DUMMY',1969,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1970,NULL,'DUMMY',1970,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1971,NULL,'DUMMY',1971,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1972,NULL,'DUMMY',1972,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1973,NULL,'DUMMY',1973,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1974,NULL,'DUMMY',1974,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1975,NULL,'DUMMY',1975,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1976,NULL,'DUMMY',1976,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1977,NULL,'DUMMY',1977,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1978,NULL,'DUMMY',1978,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1979,NULL,'DUMMY',1979,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1980,NULL,'DUMMY',1980,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1981,NULL,'DUMMY',1981,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1982,NULL,'DUMMY',1982,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1983,NULL,'DUMMY',1983,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1984,NULL,'DUMMY',1984,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1985,NULL,'DUMMY',1985,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1986,NULL,'DUMMY',1986,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1987,NULL,'DUMMY',1987,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1988,NULL,'DUMMY',1988,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1989,NULL,'DUMMY',1989,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1990,NULL,'DUMMY',1990,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1991,NULL,'DUMMY',1991,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1992,NULL,'DUMMY',1992,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1993,NULL,'DUMMY',1993,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1994,NULL,'DUMMY',1994,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1995,NULL,'DUMMY',1995,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1996,NULL,'DUMMY',1996,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1997,NULL,'DUMMY',1997,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1998,NULL,'DUMMY',1998,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(1999,NULL,'DUMMY',1999,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2000,NULL,'DUMMY',2000,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2001,NULL,'DUMMY',2001,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2002,NULL,'DUMMY',2002,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2003,NULL,'DUMMY',2003,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2004,NULL,'DUMMY',2004,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2005,NULL,'DUMMY',2005,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2006,NULL,'DUMMY',2006,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2007,NULL,'DUMMY',2007,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2008,NULL,'DUMMY',2008,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2009,NULL,'DUMMY',2009,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2010,NULL,'DUMMY',2010,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2011,NULL,'DUMMY',2011,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2012,NULL,'DUMMY',2012,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2013,NULL,'DUMMY',2013,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2014,NULL,'DUMMY',2014,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2015,NULL,'DUMMY',2015,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2016,NULL,'DUMMY',2016,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2017,NULL,'DUMMY',2017,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2018,NULL,'DUMMY',2018,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2019,NULL,'DUMMY',2019,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2020,NULL,'DUMMY',2020,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2021,NULL,'DUMMY',2021,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2022,NULL,'DUMMY',2022,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2023,NULL,'DUMMY',2023,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2024,NULL,'DUMMY',2024,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2025,NULL,'DUMMY',2025,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2026,NULL,'DUMMY',2026,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2027,NULL,'DUMMY',2027,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2028,NULL,'DUMMY',2028,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2029,NULL,'DUMMY',2029,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2030,NULL,'DUMMY',2030,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2031,NULL,'DUMMY',2031,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2032,NULL,'DUMMY',2032,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2033,NULL,'DUMMY',2033,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2034,NULL,'DUMMY',2034,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2035,NULL,'DUMMY',2035,1,'2025-02-26 21:29:59','2025-02-26 21:29:59'),(2036,NULL,'DUMMY',2036,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2037,NULL,'DUMMY',2037,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2038,NULL,'DUMMY',2038,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2039,NULL,'DUMMY',2039,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2040,NULL,'DUMMY',2040,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2041,NULL,'DUMMY',2041,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2042,NULL,'DUMMY',2042,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2043,NULL,'DUMMY',2043,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2044,NULL,'DUMMY',2044,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2045,NULL,'DUMMY',2045,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2046,NULL,'DUMMY',2046,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2047,NULL,'DUMMY',2047,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2048,NULL,'DUMMY',2048,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2049,NULL,'DUMMY',2049,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2050,NULL,'DUMMY',2050,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2051,NULL,'DUMMY',2051,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2052,NULL,'DUMMY',2052,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2053,NULL,'DUMMY',2053,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2054,NULL,'DUMMY',2054,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2055,NULL,'DUMMY',2055,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2056,NULL,'DUMMY',2056,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2057,NULL,'DUMMY',2057,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2058,NULL,'DUMMY',2058,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2059,NULL,'DUMMY',2059,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2060,NULL,'DUMMY',2060,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2061,NULL,'DUMMY',2061,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2062,NULL,'DUMMY',2062,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2063,NULL,'DUMMY',2063,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2064,NULL,'DUMMY',2064,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2065,NULL,'DUMMY',2065,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2066,NULL,'DUMMY',2066,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2067,NULL,'DUMMY',2067,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2068,NULL,'DUMMY',2068,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2069,NULL,'DUMMY',2069,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2070,NULL,'DUMMY',2070,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2071,NULL,'DUMMY',2071,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2072,NULL,'DUMMY',2072,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2073,NULL,'DUMMY',2073,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2074,NULL,'DUMMY',2074,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2075,NULL,'DUMMY',2075,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2076,NULL,'DUMMY',2076,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2077,NULL,'DUMMY',2077,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2078,NULL,'DUMMY',2078,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2079,NULL,'DUMMY',2079,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2080,NULL,'DUMMY',2080,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2081,NULL,'DUMMY',2081,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2082,NULL,'DUMMY',2082,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2083,NULL,'DUMMY',2083,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2084,NULL,'DUMMY',2084,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2085,NULL,'DUMMY',2085,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2086,NULL,'DUMMY',2086,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2087,NULL,'DUMMY',2087,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2088,NULL,'DUMMY',2088,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2089,NULL,'DUMMY',2089,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2090,NULL,'DUMMY',2090,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2091,NULL,'DUMMY',2091,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2092,NULL,'DUMMY',2092,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2093,NULL,'DUMMY',2093,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2094,NULL,'DUMMY',2094,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2095,NULL,'DUMMY',2095,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2096,NULL,'DUMMY',2096,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2097,NULL,'DUMMY',2097,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2098,NULL,'DUMMY',2098,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2099,NULL,'DUMMY',2099,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2100,NULL,'DUMMY',2100,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2101,NULL,'DUMMY',2101,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2102,NULL,'DUMMY',2102,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2103,NULL,'DUMMY',2103,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2104,NULL,'DUMMY',2104,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2105,NULL,'DUMMY',2105,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2106,NULL,'DUMMY',2106,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2107,NULL,'DUMMY',2107,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2108,NULL,'DUMMY',2108,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2109,NULL,'DUMMY',2109,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2110,NULL,'DUMMY',2110,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2111,NULL,'DUMMY',2111,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2112,NULL,'DUMMY',2112,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2113,NULL,'DUMMY',2113,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2114,NULL,'DUMMY',2114,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2115,NULL,'DUMMY',2115,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2116,NULL,'DUMMY',2116,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2117,NULL,'DUMMY',2117,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2118,NULL,'DUMMY',2118,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2119,NULL,'DUMMY',2119,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2120,NULL,'DUMMY',2120,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2121,NULL,'DUMMY',2121,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2122,NULL,'DUMMY',2122,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2123,NULL,'DUMMY',2123,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2124,NULL,'DUMMY',2124,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2125,NULL,'DUMMY',2125,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2126,NULL,'DUMMY',2126,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2127,NULL,'DUMMY',2127,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2128,NULL,'DUMMY',2128,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2129,NULL,'DUMMY',2129,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2130,NULL,'DUMMY',2130,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2131,NULL,'DUMMY',2131,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2132,NULL,'DUMMY',2132,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2133,NULL,'DUMMY',2133,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2134,NULL,'DUMMY',2134,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2135,NULL,'DUMMY',2135,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2136,NULL,'DUMMY',2136,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2137,NULL,'DUMMY',2137,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2138,NULL,'DUMMY',2138,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2139,NULL,'DUMMY',2139,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2140,NULL,'DUMMY',2140,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2141,NULL,'DUMMY',2141,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2142,NULL,'DUMMY',2142,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2143,NULL,'DUMMY',2143,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2144,NULL,'DUMMY',2144,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2145,NULL,'DUMMY',2145,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2146,NULL,'DUMMY',2146,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2147,NULL,'DUMMY',2147,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2148,NULL,'DUMMY',2148,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2149,NULL,'DUMMY',2149,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2150,NULL,'DUMMY',2150,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2151,NULL,'DUMMY',2151,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2152,NULL,'DUMMY',2152,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2153,NULL,'DUMMY',2153,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2154,NULL,'DUMMY',2154,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2155,NULL,'DUMMY',2155,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2156,NULL,'DUMMY',2156,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2157,NULL,'DUMMY',2157,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2158,NULL,'DUMMY',2158,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2159,NULL,'DUMMY',2159,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2160,NULL,'DUMMY',2160,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2161,NULL,'DUMMY',2161,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2162,NULL,'DUMMY',2162,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2163,NULL,'DUMMY',2163,1,'2025-02-26 21:30:00','2025-02-26 21:30:00'),(2164,NULL,'DUMMY',2164,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2165,NULL,'DUMMY',2165,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2166,NULL,'DUMMY',2166,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2167,NULL,'DUMMY',2167,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2168,NULL,'DUMMY',2168,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2169,NULL,'DUMMY',2169,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2170,NULL,'DUMMY',2170,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2171,NULL,'DUMMY',2171,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2172,NULL,'DUMMY',2172,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2173,NULL,'DUMMY',2173,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2174,NULL,'DUMMY',2174,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2175,NULL,'DUMMY',2175,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2176,NULL,'DUMMY',2176,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2177,NULL,'DUMMY',2177,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2178,NULL,'DUMMY',2178,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2179,NULL,'DUMMY',2179,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2180,NULL,'DUMMY',2180,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2181,NULL,'DUMMY',2181,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2182,NULL,'DUMMY',2182,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2183,NULL,'DUMMY',2183,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2184,NULL,'DUMMY',2184,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2185,NULL,'DUMMY',2185,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2186,NULL,'DUMMY',2186,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2187,NULL,'DUMMY',2187,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2188,NULL,'DUMMY',2188,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2189,NULL,'DUMMY',2189,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2190,NULL,'DUMMY',2190,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2191,NULL,'DUMMY',2191,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2192,NULL,'DUMMY',2192,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2193,NULL,'DUMMY',2193,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2194,NULL,'DUMMY',2194,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2195,NULL,'DUMMY',2195,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2196,NULL,'DUMMY',2196,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2197,NULL,'DUMMY',2197,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2198,NULL,'DUMMY',2198,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2199,NULL,'DUMMY',2199,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2200,NULL,'DUMMY',2200,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2201,NULL,'DUMMY',2201,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2202,NULL,'DUMMY',2202,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2203,NULL,'DUMMY',2203,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2204,NULL,'DUMMY',2204,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2205,NULL,'DUMMY',2205,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2206,NULL,'DUMMY',2206,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2207,NULL,'DUMMY',2207,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2208,NULL,'DUMMY',2208,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2209,NULL,'DUMMY',2209,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2210,NULL,'DUMMY',2210,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2211,NULL,'DUMMY',2211,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2212,NULL,'DUMMY',2212,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2213,NULL,'DUMMY',2213,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2214,NULL,'DUMMY',2214,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2215,NULL,'DUMMY',2215,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2216,NULL,'DUMMY',2216,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2217,NULL,'DUMMY',2217,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2218,NULL,'DUMMY',2218,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2219,NULL,'DUMMY',2219,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2220,NULL,'DUMMY',2220,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2221,NULL,'DUMMY',2221,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2222,NULL,'DUMMY',2222,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2223,NULL,'DUMMY',2223,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2224,NULL,'DUMMY',2224,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2225,NULL,'DUMMY',2225,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2226,NULL,'DUMMY',2226,1,'2025-02-26 21:30:01','2025-02-26 21:30:01'),(2227,NULL,'DUMMY',2227,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2228,NULL,'DUMMY',2228,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2229,NULL,'DUMMY',2229,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2230,NULL,'DUMMY',2230,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2231,NULL,'DUMMY',2231,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2232,NULL,'DUMMY',2232,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2233,NULL,'DUMMY',2233,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2234,NULL,'DUMMY',2234,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2235,NULL,'DUMMY',2235,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2236,NULL,'DUMMY',2236,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2237,NULL,'DUMMY',2237,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2238,NULL,'DUMMY',2238,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2239,NULL,'DUMMY',2239,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2240,NULL,'DUMMY',2240,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2241,NULL,'DUMMY',2241,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2242,NULL,'DUMMY',2242,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2243,NULL,'DUMMY',2243,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2244,NULL,'DUMMY',2244,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2245,NULL,'DUMMY',2245,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2246,NULL,'DUMMY',2246,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2247,NULL,'DUMMY',2247,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2248,NULL,'DUMMY',2248,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2249,NULL,'DUMMY',2249,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2250,NULL,'DUMMY',2250,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2251,NULL,'DUMMY',2251,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2252,NULL,'DUMMY',2252,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2253,NULL,'DUMMY',2253,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2254,NULL,'DUMMY',2254,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2255,NULL,'DUMMY',2255,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2256,NULL,'DUMMY',2256,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2257,NULL,'DUMMY',2257,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2258,NULL,'DUMMY',2258,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2259,NULL,'DUMMY',2259,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2260,NULL,'DUMMY',2260,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2261,NULL,'DUMMY',2261,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2262,NULL,'DUMMY',2262,1,'2025-02-26 21:30:02','2025-02-26 21:30:02'),(2263,NULL,'DUMMY',2263,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2264,NULL,'DUMMY',2264,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2265,NULL,'DUMMY',2265,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2266,NULL,'DUMMY',2266,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2267,NULL,'DUMMY',2267,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2268,NULL,'DUMMY',2268,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2269,NULL,'DUMMY',2269,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2270,NULL,'DUMMY',2270,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2271,NULL,'DUMMY',2271,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2272,NULL,'DUMMY',2272,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2273,NULL,'DUMMY',2273,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2274,NULL,'DUMMY',2274,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2275,NULL,'DUMMY',2275,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2276,NULL,'DUMMY',2276,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2277,NULL,'DUMMY',2277,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2278,NULL,'DUMMY',2278,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2279,NULL,'DUMMY',2279,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2280,NULL,'DUMMY',2280,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2281,NULL,'DUMMY',2281,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2282,NULL,'DUMMY',2282,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2283,NULL,'DUMMY',2283,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2284,NULL,'DUMMY',2284,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2285,NULL,'DUMMY',2285,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2286,NULL,'DUMMY',2286,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2287,NULL,'DUMMY',2287,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2288,NULL,'DUMMY',2288,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2289,NULL,'DUMMY',2289,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2290,NULL,'DUMMY',2290,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2291,NULL,'DUMMY',2291,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2292,NULL,'DUMMY',2292,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2293,NULL,'DUMMY',2293,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2294,NULL,'DUMMY',2294,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2295,NULL,'DUMMY',2295,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2296,NULL,'DUMMY',2296,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2297,NULL,'DUMMY',2297,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2298,NULL,'DUMMY',2298,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2299,NULL,'DUMMY',2299,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2300,NULL,'DUMMY',2300,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2301,NULL,'DUMMY',2301,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2302,NULL,'DUMMY',2302,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2303,NULL,'DUMMY',2303,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2304,NULL,'DUMMY',2304,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2305,NULL,'DUMMY',2305,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2306,NULL,'DUMMY',2306,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2307,NULL,'DUMMY',2307,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2308,NULL,'DUMMY',2308,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2309,NULL,'DUMMY',2309,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2310,NULL,'DUMMY',2310,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2311,NULL,'DUMMY',2311,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2312,NULL,'DUMMY',2312,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2313,NULL,'DUMMY',2313,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2314,NULL,'DUMMY',2314,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2315,NULL,'DUMMY',2315,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2316,NULL,'DUMMY',2316,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2317,NULL,'DUMMY',2317,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2318,NULL,'DUMMY',2318,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2319,NULL,'DUMMY',2319,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2320,NULL,'DUMMY',2320,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2321,NULL,'DUMMY',2321,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2322,NULL,'DUMMY',2322,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2323,NULL,'DUMMY',2323,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2324,NULL,'DUMMY',2324,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2325,NULL,'DUMMY',2325,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2326,NULL,'DUMMY',2326,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2327,NULL,'DUMMY',2327,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2328,NULL,'DUMMY',2328,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2329,NULL,'DUMMY',2329,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2330,NULL,'DUMMY',2330,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2331,NULL,'DUMMY',2331,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2332,NULL,'DUMMY',2332,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2333,NULL,'DUMMY',2333,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2334,NULL,'DUMMY',2334,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2335,NULL,'DUMMY',2335,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2336,NULL,'DUMMY',2336,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2337,NULL,'DUMMY',2337,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2338,NULL,'DUMMY',2338,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2339,NULL,'DUMMY',2339,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2340,NULL,'DUMMY',2340,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2341,NULL,'DUMMY',2341,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2342,NULL,'DUMMY',2342,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2343,NULL,'DUMMY',2343,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2344,NULL,'DUMMY',2344,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2345,NULL,'DUMMY',2345,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2346,NULL,'DUMMY',2346,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2347,NULL,'DUMMY',2347,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2348,NULL,'DUMMY',2348,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2349,NULL,'DUMMY',2349,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2350,NULL,'DUMMY',2350,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2351,NULL,'DUMMY',2351,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2352,NULL,'DUMMY',2352,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2353,NULL,'DUMMY',2353,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2354,NULL,'DUMMY',2354,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2355,NULL,'DUMMY',2355,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2356,NULL,'DUMMY',2356,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2357,NULL,'DUMMY',2357,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2358,NULL,'DUMMY',2358,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2359,NULL,'DUMMY',2359,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2360,NULL,'DUMMY',2360,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2361,NULL,'DUMMY',2361,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2362,NULL,'DUMMY',2362,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2363,NULL,'DUMMY',2363,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2364,NULL,'DUMMY',2364,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2365,NULL,'DUMMY',2365,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2366,NULL,'DUMMY',2366,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2367,NULL,'DUMMY',2367,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2368,NULL,'DUMMY',2368,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2369,NULL,'DUMMY',2369,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2370,NULL,'DUMMY',2370,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2371,NULL,'DUMMY',2371,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2372,NULL,'DUMMY',2372,1,'2025-02-26 21:30:03','2025-02-26 21:30:03'),(2373,NULL,'DUMMY',2373,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2374,NULL,'DUMMY',2374,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2375,NULL,'DUMMY',2375,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2376,NULL,'DUMMY',2376,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2377,NULL,'DUMMY',2377,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2378,NULL,'DUMMY',2378,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2379,NULL,'DUMMY',2379,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2380,NULL,'DUMMY',2380,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2381,NULL,'DUMMY',2381,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2382,NULL,'DUMMY',2382,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2383,NULL,'DUMMY',2383,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2384,NULL,'DUMMY',2384,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2385,NULL,'DUMMY',2385,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2386,NULL,'DUMMY',2386,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2387,NULL,'DUMMY',2387,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2388,NULL,'DUMMY',2388,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2389,NULL,'DUMMY',2389,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2390,NULL,'DUMMY',2390,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2391,NULL,'DUMMY',2391,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2392,NULL,'DUMMY',2392,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2393,NULL,'DUMMY',2393,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2394,NULL,'DUMMY',2394,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2395,NULL,'DUMMY',2395,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2396,NULL,'DUMMY',2396,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2397,NULL,'DUMMY',2397,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2398,NULL,'DUMMY',2398,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2399,NULL,'DUMMY',2399,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2400,NULL,'DUMMY',2400,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2401,NULL,'DUMMY',2401,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2402,NULL,'DUMMY',2402,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2403,NULL,'DUMMY',2403,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2404,NULL,'DUMMY',2404,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2405,NULL,'DUMMY',2405,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2406,NULL,'DUMMY',2406,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2407,NULL,'DUMMY',2407,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2408,NULL,'DUMMY',2408,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2409,NULL,'DUMMY',2409,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2410,NULL,'DUMMY',2410,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2411,NULL,'DUMMY',2411,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2412,NULL,'DUMMY',2412,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2413,NULL,'DUMMY',2413,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2414,NULL,'DUMMY',2414,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2415,NULL,'DUMMY',2415,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2416,NULL,'DUMMY',2416,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2417,NULL,'DUMMY',2417,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2418,NULL,'DUMMY',2418,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2419,NULL,'DUMMY',2419,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2420,NULL,'DUMMY',2420,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2421,NULL,'DUMMY',2421,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2422,NULL,'DUMMY',2422,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2423,NULL,'DUMMY',2423,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2424,NULL,'DUMMY',2424,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2425,NULL,'DUMMY',2425,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2426,NULL,'DUMMY',2426,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2427,NULL,'DUMMY',2427,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2428,NULL,'DUMMY',2428,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2429,NULL,'DUMMY',2429,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2430,NULL,'DUMMY',2430,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2431,NULL,'DUMMY',2431,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2432,NULL,'DUMMY',2432,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2433,NULL,'DUMMY',2433,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2434,NULL,'DUMMY',2434,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2435,NULL,'DUMMY',2435,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2436,NULL,'DUMMY',2436,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2437,NULL,'DUMMY',2437,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2438,NULL,'DUMMY',2438,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2439,NULL,'DUMMY',2439,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2440,NULL,'DUMMY',2440,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2441,NULL,'DUMMY',2441,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2442,NULL,'DUMMY',2442,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2443,NULL,'DUMMY',2443,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2444,NULL,'DUMMY',2444,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2445,NULL,'DUMMY',2445,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2446,NULL,'DUMMY',2446,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2447,NULL,'DUMMY',2447,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2448,NULL,'DUMMY',2448,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2449,NULL,'DUMMY',2449,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2450,NULL,'DUMMY',2450,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2451,NULL,'DUMMY',2451,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2452,NULL,'DUMMY',2452,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2453,NULL,'DUMMY',2453,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2454,NULL,'DUMMY',2454,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2455,NULL,'DUMMY',2455,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2456,NULL,'DUMMY',2456,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2457,NULL,'DUMMY',2457,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2458,NULL,'DUMMY',2458,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2459,NULL,'DUMMY',2459,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2460,NULL,'DUMMY',2460,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2461,NULL,'DUMMY',2461,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2462,NULL,'DUMMY',2462,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2463,NULL,'DUMMY',2463,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2464,NULL,'DUMMY',2464,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2465,NULL,'DUMMY',2465,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2466,NULL,'DUMMY',2466,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2467,NULL,'DUMMY',2467,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2468,NULL,'DUMMY',2468,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2469,NULL,'DUMMY',2469,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2470,NULL,'DUMMY',2470,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2471,NULL,'DUMMY',2471,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2472,NULL,'DUMMY',2472,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2473,NULL,'DUMMY',2473,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2474,NULL,'DUMMY',2474,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2475,NULL,'DUMMY',2475,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2476,NULL,'DUMMY',2476,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2477,NULL,'DUMMY',2477,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2478,NULL,'DUMMY',2478,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2479,NULL,'DUMMY',2479,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2480,NULL,'DUMMY',2480,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2481,NULL,'DUMMY',2481,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2482,NULL,'DUMMY',2482,1,'2025-02-26 21:30:04','2025-02-26 21:30:04'),(2483,NULL,'DUMMY',2483,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2484,NULL,'DUMMY',2484,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2485,NULL,'DUMMY',2485,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2486,NULL,'DUMMY',2486,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2487,NULL,'DUMMY',2487,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2488,NULL,'DUMMY',2488,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2489,NULL,'DUMMY',2489,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2490,NULL,'DUMMY',2490,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2491,NULL,'DUMMY',2491,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2492,NULL,'DUMMY',2492,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2493,NULL,'DUMMY',2493,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2494,NULL,'DUMMY',2494,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2495,NULL,'DUMMY',2495,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2496,NULL,'DUMMY',2496,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2497,NULL,'DUMMY',2497,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2498,NULL,'DUMMY',2498,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2499,NULL,'DUMMY',2499,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2500,NULL,'DUMMY',2500,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2501,NULL,'DUMMY',2501,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2502,NULL,'DUMMY',2502,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2503,NULL,'DUMMY',2503,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2504,NULL,'DUMMY',2504,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2505,NULL,'DUMMY',2505,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2506,NULL,'DUMMY',2506,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2507,NULL,'DUMMY',2507,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2508,NULL,'DUMMY',2508,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2509,NULL,'DUMMY',2509,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2510,NULL,'DUMMY',2510,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2511,NULL,'DUMMY',2511,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2512,NULL,'DUMMY',2512,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2513,NULL,'DUMMY',2513,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2514,NULL,'DUMMY',2514,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2515,NULL,'DUMMY',2515,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2516,NULL,'DUMMY',2516,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2517,NULL,'DUMMY',2517,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2518,NULL,'DUMMY',2518,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2519,NULL,'DUMMY',2519,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2520,NULL,'DUMMY',2520,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2521,NULL,'DUMMY',2521,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2522,NULL,'DUMMY',2522,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2523,NULL,'DUMMY',2523,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2524,NULL,'DUMMY',2524,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2525,NULL,'DUMMY',2525,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2526,NULL,'DUMMY',2526,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2527,NULL,'DUMMY',2527,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2528,NULL,'DUMMY',2528,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2529,NULL,'DUMMY',2529,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2530,NULL,'DUMMY',2530,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2531,NULL,'DUMMY',2531,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2532,NULL,'DUMMY',2532,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2533,NULL,'DUMMY',2533,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2534,NULL,'DUMMY',2534,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2535,NULL,'DUMMY',2535,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2536,NULL,'DUMMY',2536,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2537,NULL,'DUMMY',2537,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2538,NULL,'DUMMY',2538,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2539,NULL,'DUMMY',2539,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2540,NULL,'DUMMY',2540,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2541,NULL,'DUMMY',2541,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2542,NULL,'DUMMY',2542,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2543,NULL,'DUMMY',2543,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2544,NULL,'DUMMY',2544,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2545,NULL,'DUMMY',2545,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2546,NULL,'DUMMY',2546,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2547,NULL,'DUMMY',2547,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2548,NULL,'DUMMY',2548,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2549,NULL,'DUMMY',2549,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2550,NULL,'DUMMY',2550,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2551,NULL,'DUMMY',2551,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2552,NULL,'DUMMY',2552,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2553,NULL,'DUMMY',2553,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2554,NULL,'DUMMY',2554,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2555,NULL,'DUMMY',2555,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2556,NULL,'DUMMY',2556,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2557,NULL,'DUMMY',2557,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2558,NULL,'DUMMY',2558,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2559,NULL,'DUMMY',2559,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2560,NULL,'DUMMY',2560,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2561,NULL,'DUMMY',2561,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2562,NULL,'DUMMY',2562,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2563,NULL,'DUMMY',2563,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2564,NULL,'DUMMY',2564,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2565,NULL,'DUMMY',2565,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2566,NULL,'DUMMY',2566,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2567,NULL,'DUMMY',2567,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2568,NULL,'DUMMY',2568,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2569,NULL,'DUMMY',2569,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2570,NULL,'DUMMY',2570,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2571,NULL,'DUMMY',2571,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2572,NULL,'DUMMY',2572,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2573,NULL,'DUMMY',2573,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2574,NULL,'DUMMY',2574,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2575,NULL,'DUMMY',2575,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2576,NULL,'DUMMY',2576,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2577,NULL,'DUMMY',2577,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2578,NULL,'DUMMY',2578,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2579,NULL,'DUMMY',2579,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2580,NULL,'DUMMY',2580,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2581,NULL,'DUMMY',2581,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2582,NULL,'DUMMY',2582,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2583,NULL,'DUMMY',2583,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2584,NULL,'DUMMY',2584,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2585,NULL,'DUMMY',2585,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2586,NULL,'DUMMY',2586,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2587,NULL,'DUMMY',2587,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2588,NULL,'DUMMY',2588,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2589,NULL,'DUMMY',2589,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2590,NULL,'DUMMY',2590,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2591,NULL,'DUMMY',2591,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2592,NULL,'DUMMY',2592,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2593,NULL,'DUMMY',2593,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2594,NULL,'DUMMY',2594,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2595,NULL,'DUMMY',2595,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2596,NULL,'DUMMY',2596,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2597,NULL,'DUMMY',2597,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2598,NULL,'DUMMY',2598,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2599,NULL,'DUMMY',2599,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2600,NULL,'DUMMY',2600,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2601,NULL,'DUMMY',2601,1,'2025-02-26 21:30:05','2025-02-26 21:30:05'),(2602,NULL,'DUMMY',2602,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2603,NULL,'DUMMY',2603,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2604,NULL,'DUMMY',2604,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2605,NULL,'DUMMY',2605,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2606,NULL,'DUMMY',2606,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2607,NULL,'DUMMY',2607,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2608,NULL,'DUMMY',2608,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2609,NULL,'DUMMY',2609,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2610,NULL,'DUMMY',2610,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2611,NULL,'DUMMY',2611,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2612,NULL,'DUMMY',2612,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2613,NULL,'DUMMY',2613,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2614,NULL,'DUMMY',2614,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2615,NULL,'DUMMY',2615,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2616,NULL,'DUMMY',2616,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2617,NULL,'DUMMY',2617,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2618,NULL,'DUMMY',2618,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2619,NULL,'DUMMY',2619,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2620,NULL,'DUMMY',2620,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2621,NULL,'DUMMY',2621,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2622,NULL,'DUMMY',2622,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2623,NULL,'DUMMY',2623,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2624,NULL,'DUMMY',2624,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2625,NULL,'DUMMY',2625,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2626,NULL,'DUMMY',2626,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2627,NULL,'DUMMY',2627,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2628,NULL,'DUMMY',2628,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2629,NULL,'DUMMY',2629,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2630,NULL,'DUMMY',2630,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2631,NULL,'DUMMY',2631,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2632,NULL,'DUMMY',2632,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2633,NULL,'DUMMY',2633,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2634,NULL,'DUMMY',2634,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2635,NULL,'DUMMY',2635,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2636,NULL,'DUMMY',2636,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2637,NULL,'DUMMY',2637,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2638,NULL,'DUMMY',2638,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2639,NULL,'DUMMY',2639,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2640,NULL,'DUMMY',2640,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2641,NULL,'DUMMY',2641,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2642,NULL,'DUMMY',2642,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2643,NULL,'DUMMY',2643,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2644,NULL,'DUMMY',2644,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2645,NULL,'DUMMY',2645,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2646,NULL,'DUMMY',2646,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2647,NULL,'DUMMY',2647,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2648,NULL,'DUMMY',2648,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2649,NULL,'DUMMY',2649,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2650,NULL,'DUMMY',2650,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2651,NULL,'DUMMY',2651,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2652,NULL,'DUMMY',2652,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2653,NULL,'DUMMY',2653,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2654,NULL,'DUMMY',2654,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2655,NULL,'DUMMY',2655,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2656,NULL,'DUMMY',2656,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2657,NULL,'DUMMY',2657,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2658,NULL,'DUMMY',2658,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2659,NULL,'DUMMY',2659,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2660,NULL,'DUMMY',2660,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2661,NULL,'DUMMY',2661,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2662,NULL,'DUMMY',2662,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2663,NULL,'DUMMY',2663,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2664,NULL,'DUMMY',2664,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2665,NULL,'DUMMY',2665,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2666,NULL,'DUMMY',2666,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2667,NULL,'DUMMY',2667,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2668,NULL,'DUMMY',2668,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2669,NULL,'DUMMY',2669,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2670,NULL,'DUMMY',2670,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2671,NULL,'DUMMY',2671,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2672,NULL,'DUMMY',2672,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2673,NULL,'DUMMY',2673,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2674,NULL,'DUMMY',2674,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2675,NULL,'DUMMY',2675,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2676,NULL,'DUMMY',2676,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2677,NULL,'DUMMY',2677,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2678,NULL,'DUMMY',2678,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2679,NULL,'DUMMY',2679,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2680,NULL,'DUMMY',2680,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2681,NULL,'DUMMY',2681,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2682,NULL,'DUMMY',2682,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2683,NULL,'DUMMY',2683,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2684,NULL,'DUMMY',2684,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2685,NULL,'DUMMY',2685,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2686,NULL,'DUMMY',2686,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2687,NULL,'DUMMY',2687,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2688,NULL,'DUMMY',2688,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2689,NULL,'DUMMY',2689,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2690,NULL,'DUMMY',2690,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2691,NULL,'DUMMY',2691,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2692,NULL,'DUMMY',2692,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2693,NULL,'DUMMY',2693,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2694,NULL,'DUMMY',2694,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2695,NULL,'DUMMY',2695,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2696,NULL,'DUMMY',2696,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2697,NULL,'DUMMY',2697,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2698,NULL,'DUMMY',2698,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2699,NULL,'DUMMY',2699,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2700,NULL,'DUMMY',2700,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2701,NULL,'DUMMY',2701,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2702,NULL,'DUMMY',2702,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2703,NULL,'DUMMY',2703,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2704,NULL,'DUMMY',2704,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2705,NULL,'DUMMY',2705,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2706,NULL,'DUMMY',2706,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2707,NULL,'DUMMY',2707,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2708,NULL,'DUMMY',2708,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2709,NULL,'DUMMY',2709,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2710,NULL,'DUMMY',2710,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2711,NULL,'DUMMY',2711,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2712,NULL,'DUMMY',2712,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2713,NULL,'DUMMY',2713,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2714,NULL,'DUMMY',2714,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2715,NULL,'DUMMY',2715,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2716,NULL,'DUMMY',2716,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2717,NULL,'DUMMY',2717,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2718,NULL,'DUMMY',2718,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2719,NULL,'DUMMY',2719,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2720,NULL,'DUMMY',2720,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2721,NULL,'DUMMY',2721,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2722,NULL,'DUMMY',2722,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2723,NULL,'DUMMY',2723,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2724,NULL,'DUMMY',2724,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2725,NULL,'DUMMY',2725,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2726,NULL,'DUMMY',2726,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2727,NULL,'DUMMY',2727,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2728,NULL,'DUMMY',2728,1,'2025-02-26 21:30:06','2025-02-26 21:30:06'),(2729,NULL,'DUMMY',2729,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2730,NULL,'DUMMY',2730,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2731,NULL,'DUMMY',2731,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2732,NULL,'DUMMY',2732,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2733,NULL,'DUMMY',2733,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2734,NULL,'DUMMY',2734,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2735,NULL,'DUMMY',2735,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2736,NULL,'DUMMY',2736,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2737,NULL,'DUMMY',2737,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2738,NULL,'DUMMY',2738,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2739,NULL,'DUMMY',2739,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2740,NULL,'DUMMY',2740,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2741,NULL,'DUMMY',2741,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2742,NULL,'DUMMY',2742,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2743,NULL,'DUMMY',2743,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2744,NULL,'DUMMY',2744,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2745,NULL,'DUMMY',2745,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2746,NULL,'DUMMY',2746,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2747,NULL,'DUMMY',2747,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2748,NULL,'DUMMY',2748,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2749,NULL,'DUMMY',2749,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2750,NULL,'DUMMY',2750,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2751,NULL,'DUMMY',2751,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2752,NULL,'DUMMY',2752,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2753,NULL,'DUMMY',2753,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2754,NULL,'DUMMY',2754,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2755,NULL,'DUMMY',2755,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2756,NULL,'DUMMY',2756,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2757,NULL,'DUMMY',2757,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2758,NULL,'DUMMY',2758,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2759,NULL,'DUMMY',2759,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2760,NULL,'DUMMY',2760,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2761,NULL,'DUMMY',2761,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2762,NULL,'DUMMY',2762,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2763,NULL,'DUMMY',2763,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2764,NULL,'DUMMY',2764,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2765,NULL,'DUMMY',2765,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2766,NULL,'DUMMY',2766,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2767,NULL,'DUMMY',2767,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2768,NULL,'DUMMY',2768,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2769,NULL,'DUMMY',2769,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2770,NULL,'DUMMY',2770,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2771,NULL,'DUMMY',2771,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2772,NULL,'DUMMY',2772,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2773,NULL,'DUMMY',2773,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2774,NULL,'DUMMY',2774,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2775,NULL,'DUMMY',2775,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2776,NULL,'DUMMY',2776,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2777,NULL,'DUMMY',2777,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2778,NULL,'DUMMY',2778,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2779,NULL,'DUMMY',2779,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2780,NULL,'DUMMY',2780,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2781,NULL,'DUMMY',2781,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2782,NULL,'DUMMY',2782,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2783,NULL,'DUMMY',2783,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2784,NULL,'DUMMY',2784,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2785,NULL,'DUMMY',2785,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2786,NULL,'DUMMY',2786,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2787,NULL,'DUMMY',2787,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2788,NULL,'DUMMY',2788,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2789,NULL,'DUMMY',2789,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2790,NULL,'DUMMY',2790,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2791,NULL,'DUMMY',2791,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2792,NULL,'DUMMY',2792,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2793,NULL,'DUMMY',2793,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2794,NULL,'DUMMY',2794,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2795,NULL,'DUMMY',2795,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2796,NULL,'DUMMY',2796,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2797,NULL,'DUMMY',2797,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2798,NULL,'DUMMY',2798,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2799,NULL,'DUMMY',2799,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2800,NULL,'DUMMY',2800,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2801,NULL,'DUMMY',2801,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2802,NULL,'DUMMY',2802,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2803,NULL,'DUMMY',2803,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2804,NULL,'DUMMY',2804,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2805,NULL,'DUMMY',2805,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2806,NULL,'DUMMY',2806,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2807,NULL,'DUMMY',2807,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2808,NULL,'DUMMY',2808,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2809,NULL,'DUMMY',2809,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2810,NULL,'DUMMY',2810,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2811,NULL,'DUMMY',2811,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2812,NULL,'DUMMY',2812,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2813,NULL,'DUMMY',2813,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2814,NULL,'DUMMY',2814,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2815,NULL,'DUMMY',2815,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2816,NULL,'DUMMY',2816,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2817,NULL,'DUMMY',2817,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2818,NULL,'DUMMY',2818,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2819,NULL,'DUMMY',2819,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2820,NULL,'DUMMY',2820,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2821,NULL,'DUMMY',2821,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2822,NULL,'DUMMY',2822,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2823,NULL,'DUMMY',2823,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2824,NULL,'DUMMY',2824,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2825,NULL,'DUMMY',2825,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2826,NULL,'DUMMY',2826,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2827,NULL,'DUMMY',2827,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2828,NULL,'DUMMY',2828,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2829,NULL,'DUMMY',2829,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2830,NULL,'DUMMY',2830,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2831,NULL,'DUMMY',2831,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2832,NULL,'DUMMY',2832,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2833,NULL,'DUMMY',2833,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2834,NULL,'DUMMY',2834,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2835,NULL,'DUMMY',2835,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2836,NULL,'DUMMY',2836,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2837,NULL,'DUMMY',2837,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2838,NULL,'DUMMY',2838,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2839,NULL,'DUMMY',2839,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2840,NULL,'DUMMY',2840,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2841,NULL,'DUMMY',2841,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2842,NULL,'DUMMY',2842,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2843,NULL,'DUMMY',2843,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2844,NULL,'DUMMY',2844,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2845,NULL,'DUMMY',2845,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2846,NULL,'DUMMY',2846,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2847,NULL,'DUMMY',2847,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2848,NULL,'DUMMY',2848,1,'2025-02-26 21:30:07','2025-02-26 21:30:07'),(2849,NULL,'DUMMY',2849,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2850,NULL,'DUMMY',2850,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2851,NULL,'DUMMY',2851,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2852,NULL,'DUMMY',2852,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2853,NULL,'DUMMY',2853,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2854,NULL,'DUMMY',2854,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2855,NULL,'DUMMY',2855,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2856,NULL,'DUMMY',2856,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2857,NULL,'DUMMY',2857,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2858,NULL,'DUMMY',2858,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2859,NULL,'DUMMY',2859,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2860,NULL,'DUMMY',2860,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2861,NULL,'DUMMY',2861,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2862,NULL,'DUMMY',2862,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2863,NULL,'DUMMY',2863,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2864,NULL,'DUMMY',2864,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2865,NULL,'DUMMY',2865,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2866,NULL,'DUMMY',2866,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2867,NULL,'DUMMY',2867,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2868,NULL,'DUMMY',2868,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2869,NULL,'DUMMY',2869,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2870,NULL,'DUMMY',2870,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2871,NULL,'DUMMY',2871,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2872,NULL,'DUMMY',2872,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2873,NULL,'DUMMY',2873,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2874,NULL,'DUMMY',2874,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2875,NULL,'DUMMY',2875,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2876,NULL,'DUMMY',2876,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2877,NULL,'DUMMY',2877,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2878,NULL,'DUMMY',2878,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2879,NULL,'DUMMY',2879,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2880,NULL,'DUMMY',2880,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2881,NULL,'DUMMY',2881,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2882,NULL,'DUMMY',2882,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2883,NULL,'DUMMY',2883,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2884,NULL,'DUMMY',2884,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2885,NULL,'DUMMY',2885,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2886,NULL,'DUMMY',2886,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2887,NULL,'DUMMY',2887,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2888,NULL,'DUMMY',2888,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2889,NULL,'DUMMY',2889,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2890,NULL,'DUMMY',2890,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2891,NULL,'DUMMY',2891,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2892,NULL,'DUMMY',2892,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2893,NULL,'DUMMY',2893,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2894,NULL,'DUMMY',2894,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2895,NULL,'DUMMY',2895,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2896,NULL,'DUMMY',2896,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2897,NULL,'DUMMY',2897,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2898,NULL,'DUMMY',2898,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2899,NULL,'DUMMY',2899,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2900,NULL,'DUMMY',2900,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2901,NULL,'DUMMY',2901,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2902,NULL,'DUMMY',2902,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2903,NULL,'DUMMY',2903,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2904,NULL,'DUMMY',2904,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2905,NULL,'DUMMY',2905,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2906,NULL,'DUMMY',2906,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2907,NULL,'DUMMY',2907,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2908,NULL,'DUMMY',2908,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2909,NULL,'DUMMY',2909,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2910,NULL,'DUMMY',2910,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2911,NULL,'DUMMY',2911,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2912,NULL,'DUMMY',2912,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2913,NULL,'DUMMY',2913,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2914,NULL,'DUMMY',2914,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2915,NULL,'DUMMY',2915,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2916,NULL,'DUMMY',2916,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2917,NULL,'DUMMY',2917,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2918,NULL,'DUMMY',2918,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2919,NULL,'DUMMY',2919,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2920,NULL,'DUMMY',2920,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2921,NULL,'DUMMY',2921,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2922,NULL,'DUMMY',2922,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2923,NULL,'DUMMY',2923,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2924,NULL,'DUMMY',2924,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2925,NULL,'DUMMY',2925,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2926,NULL,'DUMMY',2926,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2927,NULL,'DUMMY',2927,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2928,NULL,'DUMMY',2928,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2929,NULL,'DUMMY',2929,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2930,NULL,'DUMMY',2930,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2931,NULL,'DUMMY',2931,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2932,NULL,'DUMMY',2932,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2933,NULL,'DUMMY',2933,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2934,NULL,'DUMMY',2934,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2935,NULL,'DUMMY',2935,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2936,NULL,'DUMMY',2936,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2937,NULL,'DUMMY',2937,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2938,NULL,'DUMMY',2938,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2939,NULL,'DUMMY',2939,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2940,NULL,'DUMMY',2940,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2941,NULL,'DUMMY',2941,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2942,NULL,'DUMMY',2942,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2943,NULL,'DUMMY',2943,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2944,NULL,'DUMMY',2944,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2945,NULL,'DUMMY',2945,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2946,NULL,'DUMMY',2946,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2947,NULL,'DUMMY',2947,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2948,NULL,'DUMMY',2948,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2949,NULL,'DUMMY',2949,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2950,NULL,'DUMMY',2950,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2951,NULL,'DUMMY',2951,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2952,NULL,'DUMMY',2952,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2953,NULL,'DUMMY',2953,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2954,NULL,'DUMMY',2954,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2955,NULL,'DUMMY',2955,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2956,NULL,'DUMMY',2956,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2957,NULL,'DUMMY',2957,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2958,NULL,'DUMMY',2958,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2959,NULL,'DUMMY',2959,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2960,NULL,'DUMMY',2960,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2961,NULL,'DUMMY',2961,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2962,NULL,'DUMMY',2962,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2963,NULL,'DUMMY',2963,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2964,NULL,'DUMMY',2964,1,'2025-02-26 21:30:08','2025-02-26 21:30:08'),(2965,NULL,'DUMMY',2965,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2966,NULL,'DUMMY',2966,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2967,NULL,'DUMMY',2967,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2968,NULL,'DUMMY',2968,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2969,NULL,'DUMMY',2969,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2970,NULL,'DUMMY',2970,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2971,NULL,'DUMMY',2971,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2972,NULL,'DUMMY',2972,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2973,NULL,'DUMMY',2973,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2974,NULL,'DUMMY',2974,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2975,NULL,'DUMMY',2975,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2976,NULL,'DUMMY',2976,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2977,NULL,'DUMMY',2977,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2978,NULL,'DUMMY',2978,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2979,NULL,'DUMMY',2979,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2980,NULL,'DUMMY',2980,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2981,NULL,'DUMMY',2981,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2982,NULL,'DUMMY',2982,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2983,NULL,'DUMMY',2983,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2984,NULL,'DUMMY',2984,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2985,NULL,'DUMMY',2985,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2986,NULL,'DUMMY',2986,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2987,NULL,'DUMMY',2987,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2988,NULL,'DUMMY',2988,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2989,NULL,'DUMMY',2989,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2990,NULL,'DUMMY',2990,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2991,NULL,'DUMMY',2991,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2992,NULL,'DUMMY',2992,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2993,NULL,'DUMMY',2993,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2994,NULL,'DUMMY',2994,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2995,NULL,'DUMMY',2995,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2996,NULL,'DUMMY',2996,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2997,NULL,'DUMMY',2997,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2998,NULL,'DUMMY',2998,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(2999,NULL,'DUMMY',2999,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3000,NULL,'DUMMY',3000,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3001,NULL,'DUMMY',3001,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3002,NULL,'DUMMY',3002,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3003,NULL,'DUMMY',3003,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3004,NULL,'DUMMY',3004,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3005,NULL,'DUMMY',3005,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3006,NULL,'DUMMY',3006,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3007,NULL,'DUMMY',3007,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3008,NULL,'DUMMY',3008,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3009,NULL,'DUMMY',3009,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3010,NULL,'DUMMY',3010,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3011,NULL,'DUMMY',3011,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3012,NULL,'DUMMY',3012,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3013,NULL,'DUMMY',3013,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3014,NULL,'DUMMY',3014,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3015,NULL,'DUMMY',3015,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3016,NULL,'DUMMY',3016,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3017,NULL,'DUMMY',3017,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3018,NULL,'DUMMY',3018,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3019,NULL,'DUMMY',3019,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3020,NULL,'DUMMY',3020,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3021,NULL,'DUMMY',3021,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3022,NULL,'DUMMY',3022,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3023,NULL,'DUMMY',3023,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3024,NULL,'DUMMY',3024,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3025,NULL,'DUMMY',3025,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3026,NULL,'DUMMY',3026,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3027,NULL,'DUMMY',3027,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3028,NULL,'DUMMY',3028,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3029,NULL,'DUMMY',3029,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3030,NULL,'DUMMY',3030,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3031,NULL,'DUMMY',3031,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3032,NULL,'DUMMY',3032,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3033,NULL,'DUMMY',3033,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3034,NULL,'DUMMY',3034,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3035,NULL,'DUMMY',3035,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3036,NULL,'DUMMY',3036,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3037,NULL,'DUMMY',3037,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3038,NULL,'DUMMY',3038,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3039,NULL,'DUMMY',3039,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3040,NULL,'DUMMY',3040,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3041,NULL,'DUMMY',3041,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3042,NULL,'DUMMY',3042,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3043,NULL,'DUMMY',3043,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3044,NULL,'DUMMY',3044,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3045,NULL,'DUMMY',3045,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3046,NULL,'DUMMY',3046,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3047,NULL,'DUMMY',3047,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3048,NULL,'DUMMY',3048,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3049,NULL,'DUMMY',3049,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3050,NULL,'DUMMY',3050,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3051,NULL,'DUMMY',3051,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3052,NULL,'DUMMY',3052,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3053,NULL,'DUMMY',3053,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3054,NULL,'DUMMY',3054,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3055,NULL,'DUMMY',3055,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3056,NULL,'DUMMY',3056,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3057,NULL,'DUMMY',3057,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3058,NULL,'DUMMY',3058,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3059,NULL,'DUMMY',3059,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3060,NULL,'DUMMY',3060,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3061,NULL,'DUMMY',3061,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3062,NULL,'DUMMY',3062,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3063,NULL,'DUMMY',3063,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3064,NULL,'DUMMY',3064,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3065,NULL,'DUMMY',3065,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3066,NULL,'DUMMY',3066,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3067,NULL,'DUMMY',3067,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3068,NULL,'DUMMY',3068,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3069,NULL,'DUMMY',3069,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3070,NULL,'DUMMY',3070,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3071,NULL,'DUMMY',3071,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3072,NULL,'DUMMY',3072,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3073,NULL,'DUMMY',3073,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3074,NULL,'DUMMY',3074,1,'2025-02-26 21:30:09','2025-02-26 21:30:09'),(3075,NULL,'DUMMY',3075,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3076,NULL,'DUMMY',3076,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3077,NULL,'DUMMY',3077,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3078,NULL,'DUMMY',3078,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3079,NULL,'DUMMY',3079,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3080,NULL,'DUMMY',3080,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3081,NULL,'DUMMY',3081,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3082,NULL,'DUMMY',3082,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3083,NULL,'DUMMY',3083,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3084,NULL,'DUMMY',3084,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3085,NULL,'DUMMY',3085,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3086,NULL,'DUMMY',3086,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3087,NULL,'DUMMY',3087,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3088,NULL,'DUMMY',3088,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3089,NULL,'DUMMY',3089,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3090,NULL,'DUMMY',3090,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3091,NULL,'DUMMY',3091,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3092,NULL,'DUMMY',3092,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3093,NULL,'DUMMY',3093,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3094,NULL,'DUMMY',3094,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3095,NULL,'DUMMY',3095,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3096,NULL,'DUMMY',3096,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3097,NULL,'DUMMY',3097,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3098,NULL,'DUMMY',3098,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3099,NULL,'DUMMY',3099,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3100,NULL,'DUMMY',3100,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3101,NULL,'DUMMY',3101,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3102,NULL,'DUMMY',3102,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3103,NULL,'DUMMY',3103,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3104,NULL,'DUMMY',3104,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3105,NULL,'DUMMY',3105,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3106,NULL,'DUMMY',3106,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3107,NULL,'DUMMY',3107,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3108,NULL,'DUMMY',3108,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3109,NULL,'DUMMY',3109,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3110,NULL,'DUMMY',3110,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3111,NULL,'DUMMY',3111,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3112,NULL,'DUMMY',3112,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3113,NULL,'DUMMY',3113,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3114,NULL,'DUMMY',3114,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3115,NULL,'DUMMY',3115,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3116,NULL,'DUMMY',3116,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3117,NULL,'DUMMY',3117,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3118,NULL,'DUMMY',3118,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3119,NULL,'DUMMY',3119,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3120,NULL,'DUMMY',3120,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3121,NULL,'DUMMY',3121,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3122,NULL,'DUMMY',3122,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3123,NULL,'DUMMY',3123,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3124,NULL,'DUMMY',3124,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3125,NULL,'DUMMY',3125,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3126,NULL,'DUMMY',3126,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3127,NULL,'DUMMY',3127,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3128,NULL,'DUMMY',3128,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3129,NULL,'DUMMY',3129,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3130,NULL,'DUMMY',3130,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3131,NULL,'DUMMY',3131,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3132,NULL,'DUMMY',3132,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3133,NULL,'DUMMY',3133,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3134,NULL,'DUMMY',3134,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3135,NULL,'DUMMY',3135,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3136,NULL,'DUMMY',3136,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3137,NULL,'DUMMY',3137,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3138,NULL,'DUMMY',3138,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3139,NULL,'DUMMY',3139,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3140,NULL,'DUMMY',3140,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3141,NULL,'DUMMY',3141,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3142,NULL,'DUMMY',3142,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3143,NULL,'DUMMY',3143,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3144,NULL,'DUMMY',3144,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3145,NULL,'DUMMY',3145,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3146,NULL,'DUMMY',3146,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3147,NULL,'DUMMY',3147,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3148,NULL,'DUMMY',3148,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3149,NULL,'DUMMY',3149,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3150,NULL,'DUMMY',3150,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3151,NULL,'DUMMY',3151,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3152,NULL,'DUMMY',3152,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3153,NULL,'DUMMY',3153,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3154,NULL,'DUMMY',3154,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3155,NULL,'DUMMY',3155,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3156,NULL,'DUMMY',3156,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3157,NULL,'DUMMY',3157,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3158,NULL,'DUMMY',3158,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3159,NULL,'DUMMY',3159,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3160,NULL,'DUMMY',3160,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3161,NULL,'DUMMY',3161,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3162,NULL,'DUMMY',3162,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3163,NULL,'DUMMY',3163,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3164,NULL,'DUMMY',3164,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3165,NULL,'DUMMY',3165,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3166,NULL,'DUMMY',3166,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3167,NULL,'DUMMY',3167,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3168,NULL,'DUMMY',3168,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3169,NULL,'DUMMY',3169,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3170,NULL,'DUMMY',3170,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3171,NULL,'DUMMY',3171,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3172,NULL,'DUMMY',3172,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3173,NULL,'DUMMY',3173,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3174,NULL,'DUMMY',3174,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3175,NULL,'DUMMY',3175,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3176,NULL,'DUMMY',3176,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3177,NULL,'DUMMY',3177,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3178,NULL,'DUMMY',3178,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3179,NULL,'DUMMY',3179,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3180,NULL,'DUMMY',3180,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3181,NULL,'DUMMY',3181,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3182,NULL,'DUMMY',3182,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3183,NULL,'DUMMY',3183,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3184,NULL,'DUMMY',3184,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3185,NULL,'DUMMY',3185,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3186,NULL,'DUMMY',3186,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3187,NULL,'DUMMY',3187,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3188,NULL,'DUMMY',3188,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3189,NULL,'DUMMY',3189,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3190,NULL,'DUMMY',3190,1,'2025-02-26 21:30:10','2025-02-26 21:30:10'),(3191,NULL,'DUMMY',3191,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3192,NULL,'DUMMY',3192,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3193,NULL,'DUMMY',3193,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3194,NULL,'DUMMY',3194,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3195,NULL,'DUMMY',3195,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3196,NULL,'DUMMY',3196,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3197,NULL,'DUMMY',3197,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3198,NULL,'DUMMY',3198,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3199,NULL,'DUMMY',3199,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3200,NULL,'DUMMY',3200,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3201,NULL,'DUMMY',3201,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3202,NULL,'DUMMY',3202,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3203,NULL,'DUMMY',3203,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3204,NULL,'DUMMY',3204,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3205,NULL,'DUMMY',3205,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3206,NULL,'DUMMY',3206,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3207,NULL,'DUMMY',3207,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3208,NULL,'DUMMY',3208,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3209,NULL,'DUMMY',3209,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3210,NULL,'DUMMY',3210,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3211,NULL,'DUMMY',3211,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3212,NULL,'DUMMY',3212,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3213,NULL,'DUMMY',3213,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3214,NULL,'DUMMY',3214,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3215,NULL,'DUMMY',3215,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3216,NULL,'DUMMY',3216,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3217,NULL,'DUMMY',3217,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3218,NULL,'DUMMY',3218,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3219,NULL,'DUMMY',3219,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3220,NULL,'DUMMY',3220,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3221,NULL,'DUMMY',3221,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3222,NULL,'DUMMY',3222,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3223,NULL,'DUMMY',3223,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3224,NULL,'DUMMY',3224,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3225,NULL,'DUMMY',3225,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3226,NULL,'DUMMY',3226,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3227,NULL,'DUMMY',3227,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3228,NULL,'DUMMY',3228,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3229,NULL,'DUMMY',3229,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3230,NULL,'DUMMY',3230,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3231,NULL,'DUMMY',3231,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3232,NULL,'DUMMY',3232,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3233,NULL,'DUMMY',3233,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3234,NULL,'DUMMY',3234,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3235,NULL,'DUMMY',3235,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3236,NULL,'DUMMY',3236,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3237,NULL,'DUMMY',3237,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3238,NULL,'DUMMY',3238,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3239,NULL,'DUMMY',3239,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3240,NULL,'DUMMY',3240,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3241,NULL,'DUMMY',3241,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3242,NULL,'DUMMY',3242,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3243,NULL,'DUMMY',3243,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3244,NULL,'DUMMY',3244,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3245,NULL,'DUMMY',3245,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3246,NULL,'DUMMY',3246,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3247,NULL,'DUMMY',3247,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3248,NULL,'DUMMY',3248,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3249,NULL,'DUMMY',3249,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3250,NULL,'DUMMY',3250,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3251,NULL,'DUMMY',3251,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3252,NULL,'DUMMY',3252,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3253,NULL,'DUMMY',3253,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3254,NULL,'DUMMY',3254,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3255,NULL,'DUMMY',3255,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3256,NULL,'DUMMY',3256,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3257,NULL,'DUMMY',3257,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3258,NULL,'DUMMY',3258,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3259,NULL,'DUMMY',3259,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3260,NULL,'DUMMY',3260,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3261,NULL,'DUMMY',3261,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3262,NULL,'DUMMY',3262,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3263,NULL,'DUMMY',3263,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3264,NULL,'DUMMY',3264,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3265,NULL,'DUMMY',3265,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3266,NULL,'DUMMY',3266,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3267,NULL,'DUMMY',3267,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3268,NULL,'DUMMY',3268,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3269,NULL,'DUMMY',3269,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3270,NULL,'DUMMY',3270,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3271,NULL,'DUMMY',3271,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3272,NULL,'DUMMY',3272,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3273,NULL,'DUMMY',3273,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3274,NULL,'DUMMY',3274,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3275,NULL,'DUMMY',3275,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3276,NULL,'DUMMY',3276,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3277,NULL,'DUMMY',3277,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3278,NULL,'DUMMY',3278,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3279,NULL,'DUMMY',3279,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3280,NULL,'DUMMY',3280,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3281,NULL,'DUMMY',3281,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3282,NULL,'DUMMY',3282,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3283,NULL,'DUMMY',3283,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3284,NULL,'DUMMY',3284,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3285,NULL,'DUMMY',3285,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3286,NULL,'DUMMY',3286,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3287,NULL,'DUMMY',3287,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3288,NULL,'DUMMY',3288,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3289,NULL,'DUMMY',3289,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3290,NULL,'DUMMY',3290,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3291,NULL,'DUMMY',3291,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3292,NULL,'DUMMY',3292,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3293,NULL,'DUMMY',3293,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3294,NULL,'DUMMY',3294,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3295,NULL,'DUMMY',3295,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3296,NULL,'DUMMY',3296,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3297,NULL,'DUMMY',3297,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3298,NULL,'DUMMY',3298,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3299,NULL,'DUMMY',3299,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3300,NULL,'DUMMY',3300,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3301,NULL,'DUMMY',3301,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3302,NULL,'DUMMY',3302,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3303,NULL,'DUMMY',3303,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3304,NULL,'DUMMY',3304,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3305,NULL,'DUMMY',3305,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3306,NULL,'DUMMY',3306,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3307,NULL,'DUMMY',3307,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3308,NULL,'DUMMY',3308,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3309,NULL,'DUMMY',3309,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3310,NULL,'DUMMY',3310,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3311,NULL,'DUMMY',3311,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3312,NULL,'DUMMY',3312,1,'2025-02-26 21:30:11','2025-02-26 21:30:11'),(3313,NULL,'DUMMY',3313,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3314,NULL,'DUMMY',3314,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3315,NULL,'DUMMY',3315,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3316,NULL,'DUMMY',3316,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3317,NULL,'DUMMY',3317,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3318,NULL,'DUMMY',3318,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3319,NULL,'DUMMY',3319,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3320,NULL,'DUMMY',3320,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3321,NULL,'DUMMY',3321,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3322,NULL,'DUMMY',3322,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3323,NULL,'DUMMY',3323,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3324,NULL,'DUMMY',3324,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3325,NULL,'DUMMY',3325,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3326,NULL,'DUMMY',3326,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3327,NULL,'DUMMY',3327,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3328,NULL,'DUMMY',3328,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3329,NULL,'DUMMY',3329,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3330,NULL,'DUMMY',3330,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3331,NULL,'DUMMY',3331,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3332,NULL,'DUMMY',3332,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3333,NULL,'DUMMY',3333,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3334,NULL,'DUMMY',3334,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3335,NULL,'DUMMY',3335,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3336,NULL,'DUMMY',3336,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3337,NULL,'DUMMY',3337,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3338,NULL,'DUMMY',3338,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3339,NULL,'DUMMY',3339,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3340,NULL,'DUMMY',3340,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3341,NULL,'DUMMY',3341,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3342,NULL,'DUMMY',3342,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3343,NULL,'DUMMY',3343,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3344,NULL,'DUMMY',3344,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3345,NULL,'DUMMY',3345,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3346,NULL,'DUMMY',3346,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3347,NULL,'DUMMY',3347,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3348,NULL,'DUMMY',3348,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3349,NULL,'DUMMY',3349,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3350,NULL,'DUMMY',3350,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3351,NULL,'DUMMY',3351,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3352,NULL,'DUMMY',3352,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3353,NULL,'DUMMY',3353,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3354,NULL,'DUMMY',3354,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3355,NULL,'DUMMY',3355,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3356,NULL,'DUMMY',3356,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3357,NULL,'DUMMY',3357,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3358,NULL,'DUMMY',3358,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3359,NULL,'DUMMY',3359,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3360,NULL,'DUMMY',3360,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3361,NULL,'DUMMY',3361,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3362,NULL,'DUMMY',3362,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3363,NULL,'DUMMY',3363,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3364,NULL,'DUMMY',3364,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3365,NULL,'DUMMY',3365,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3366,NULL,'DUMMY',3366,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3367,NULL,'DUMMY',3367,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3368,NULL,'DUMMY',3368,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3369,NULL,'DUMMY',3369,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3370,NULL,'DUMMY',3370,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3371,NULL,'DUMMY',3371,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3372,NULL,'DUMMY',3372,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3373,NULL,'DUMMY',3373,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3374,NULL,'DUMMY',3374,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3375,NULL,'DUMMY',3375,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3376,NULL,'DUMMY',3376,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3377,NULL,'DUMMY',3377,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3378,NULL,'DUMMY',3378,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3379,NULL,'DUMMY',3379,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3380,NULL,'DUMMY',3380,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3381,NULL,'DUMMY',3381,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3382,NULL,'DUMMY',3382,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3383,NULL,'DUMMY',3383,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3384,NULL,'DUMMY',3384,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3385,NULL,'DUMMY',3385,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3386,NULL,'DUMMY',3386,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3387,NULL,'DUMMY',3387,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3388,NULL,'DUMMY',3388,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3389,NULL,'DUMMY',3389,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3390,NULL,'DUMMY',3390,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3391,NULL,'DUMMY',3391,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3392,NULL,'DUMMY',3392,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3393,NULL,'DUMMY',3393,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3394,NULL,'DUMMY',3394,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3395,NULL,'DUMMY',3395,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3396,NULL,'DUMMY',3396,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3397,NULL,'DUMMY',3397,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3398,NULL,'DUMMY',3398,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3399,NULL,'DUMMY',3399,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3400,NULL,'DUMMY',3400,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3401,NULL,'DUMMY',3401,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3402,NULL,'DUMMY',3402,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3403,NULL,'DUMMY',3403,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3404,NULL,'DUMMY',3404,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3405,NULL,'DUMMY',3405,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3406,NULL,'DUMMY',3406,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3407,NULL,'DUMMY',3407,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3408,NULL,'DUMMY',3408,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3409,NULL,'DUMMY',3409,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3410,NULL,'DUMMY',3410,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3411,NULL,'DUMMY',3411,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3412,NULL,'DUMMY',3412,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3413,NULL,'DUMMY',3413,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3414,NULL,'DUMMY',3414,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3415,NULL,'DUMMY',3415,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3416,NULL,'DUMMY',3416,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3417,NULL,'DUMMY',3417,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3418,NULL,'DUMMY',3418,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3419,NULL,'DUMMY',3419,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3420,NULL,'DUMMY',3420,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3421,NULL,'DUMMY',3421,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3422,NULL,'DUMMY',3422,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3423,NULL,'DUMMY',3423,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3424,NULL,'DUMMY',3424,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3425,NULL,'DUMMY',3425,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3426,NULL,'DUMMY',3426,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3427,NULL,'DUMMY',3427,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3428,NULL,'DUMMY',3428,1,'2025-02-26 21:30:12','2025-02-26 21:30:12'),(3429,NULL,'DUMMY',3429,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3430,NULL,'DUMMY',3430,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3431,NULL,'DUMMY',3431,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3432,NULL,'DUMMY',3432,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3433,NULL,'DUMMY',3433,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3434,NULL,'DUMMY',3434,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3435,NULL,'DUMMY',3435,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3436,NULL,'DUMMY',3436,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3437,NULL,'DUMMY',3437,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3438,NULL,'DUMMY',3438,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3439,NULL,'DUMMY',3439,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3440,NULL,'DUMMY',3440,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3441,NULL,'DUMMY',3441,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3442,NULL,'DUMMY',3442,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3443,NULL,'DUMMY',3443,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3444,NULL,'DUMMY',3444,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3445,NULL,'DUMMY',3445,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3446,NULL,'DUMMY',3446,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3447,NULL,'DUMMY',3447,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3448,NULL,'DUMMY',3448,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3449,NULL,'DUMMY',3449,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3450,NULL,'DUMMY',3450,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3451,NULL,'DUMMY',3451,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3452,NULL,'DUMMY',3452,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3453,NULL,'DUMMY',3453,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3454,NULL,'DUMMY',3454,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3455,NULL,'DUMMY',3455,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3456,NULL,'DUMMY',3456,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3457,NULL,'DUMMY',3457,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3458,NULL,'DUMMY',3458,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3459,NULL,'DUMMY',3459,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3460,NULL,'DUMMY',3460,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3461,NULL,'DUMMY',3461,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3462,NULL,'DUMMY',3462,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3463,NULL,'DUMMY',3463,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3464,NULL,'DUMMY',3464,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3465,NULL,'DUMMY',3465,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3466,NULL,'DUMMY',3466,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3467,NULL,'DUMMY',3467,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3468,NULL,'DUMMY',3468,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3469,NULL,'DUMMY',3469,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3470,NULL,'DUMMY',3470,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3471,NULL,'DUMMY',3471,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3472,NULL,'DUMMY',3472,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3473,NULL,'DUMMY',3473,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3474,NULL,'DUMMY',3474,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3475,NULL,'DUMMY',3475,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3476,NULL,'DUMMY',3476,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3477,NULL,'DUMMY',3477,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3478,NULL,'DUMMY',3478,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3479,NULL,'DUMMY',3479,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3480,NULL,'DUMMY',3480,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3481,NULL,'DUMMY',3481,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3482,NULL,'DUMMY',3482,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3483,NULL,'DUMMY',3483,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3484,NULL,'DUMMY',3484,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3485,NULL,'DUMMY',3485,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3486,NULL,'DUMMY',3486,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3487,NULL,'DUMMY',3487,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3488,NULL,'DUMMY',3488,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3489,NULL,'DUMMY',3489,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3490,NULL,'DUMMY',3490,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3491,NULL,'DUMMY',3491,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3492,NULL,'DUMMY',3492,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3493,NULL,'DUMMY',3493,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3494,NULL,'DUMMY',3494,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3495,NULL,'DUMMY',3495,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3496,NULL,'DUMMY',3496,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3497,NULL,'DUMMY',3497,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3498,NULL,'DUMMY',3498,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3499,NULL,'DUMMY',3499,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3500,NULL,'DUMMY',3500,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3501,NULL,'DUMMY',3501,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3502,NULL,'DUMMY',3502,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3503,NULL,'DUMMY',3503,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3504,NULL,'DUMMY',3504,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3505,NULL,'DUMMY',3505,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3506,NULL,'DUMMY',3506,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3507,NULL,'DUMMY',3507,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3508,NULL,'DUMMY',3508,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3509,NULL,'DUMMY',3509,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3510,NULL,'DUMMY',3510,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3511,NULL,'DUMMY',3511,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3512,NULL,'DUMMY',3512,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3513,NULL,'DUMMY',3513,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3514,NULL,'DUMMY',3514,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3515,NULL,'DUMMY',3515,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3516,NULL,'DUMMY',3516,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3517,NULL,'DUMMY',3517,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3518,NULL,'DUMMY',3518,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3519,NULL,'DUMMY',3519,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3520,NULL,'DUMMY',3520,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3521,NULL,'DUMMY',3521,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3522,NULL,'DUMMY',3522,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3523,NULL,'DUMMY',3523,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3524,NULL,'DUMMY',3524,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3525,NULL,'DUMMY',3525,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3526,NULL,'DUMMY',3526,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3527,NULL,'DUMMY',3527,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3528,NULL,'DUMMY',3528,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3529,NULL,'DUMMY',3529,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3530,NULL,'DUMMY',3530,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3531,NULL,'DUMMY',3531,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3532,NULL,'DUMMY',3532,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3533,NULL,'DUMMY',3533,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3534,NULL,'DUMMY',3534,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3535,NULL,'DUMMY',3535,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3536,NULL,'DUMMY',3536,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3537,NULL,'DUMMY',3537,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3538,NULL,'DUMMY',3538,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3539,NULL,'DUMMY',3539,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3540,NULL,'DUMMY',3540,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3541,NULL,'DUMMY',3541,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3542,NULL,'DUMMY',3542,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3543,NULL,'DUMMY',3543,1,'2025-02-26 21:30:13','2025-02-26 21:30:13'),(3544,NULL,'DUMMY',3544,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3545,NULL,'DUMMY',3545,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3546,NULL,'DUMMY',3546,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3547,NULL,'DUMMY',3547,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3548,NULL,'DUMMY',3548,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3549,NULL,'DUMMY',3549,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3550,NULL,'DUMMY',3550,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3551,NULL,'DUMMY',3551,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3552,NULL,'DUMMY',3552,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3553,NULL,'DUMMY',3553,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3554,NULL,'DUMMY',3554,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3555,NULL,'DUMMY',3555,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3556,NULL,'DUMMY',3556,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3557,NULL,'DUMMY',3557,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3558,NULL,'DUMMY',3558,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3559,NULL,'DUMMY',3559,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3560,NULL,'DUMMY',3560,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3561,NULL,'DUMMY',3561,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3562,NULL,'DUMMY',3562,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3563,NULL,'DUMMY',3563,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3564,NULL,'DUMMY',3564,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3565,NULL,'DUMMY',3565,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3566,NULL,'DUMMY',3566,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3567,NULL,'DUMMY',3567,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3568,NULL,'DUMMY',3568,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3569,NULL,'DUMMY',3569,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3570,NULL,'DUMMY',3570,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3571,NULL,'DUMMY',3571,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3572,NULL,'DUMMY',3572,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3573,NULL,'DUMMY',3573,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3574,NULL,'DUMMY',3574,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3575,NULL,'DUMMY',3575,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3576,NULL,'DUMMY',3576,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3577,NULL,'DUMMY',3577,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3578,NULL,'DUMMY',3578,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3579,NULL,'DUMMY',3579,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3580,NULL,'DUMMY',3580,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3581,NULL,'DUMMY',3581,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3582,NULL,'DUMMY',3582,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3583,NULL,'DUMMY',3583,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3584,NULL,'DUMMY',3584,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3585,NULL,'DUMMY',3585,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3586,NULL,'DUMMY',3586,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3587,NULL,'DUMMY',3587,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3588,NULL,'DUMMY',3588,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3589,NULL,'DUMMY',3589,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3590,NULL,'DUMMY',3590,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3591,NULL,'DUMMY',3591,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3592,NULL,'DUMMY',3592,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3593,NULL,'DUMMY',3593,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3594,NULL,'DUMMY',3594,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3595,NULL,'DUMMY',3595,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3596,NULL,'DUMMY',3596,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3597,NULL,'DUMMY',3597,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3598,NULL,'DUMMY',3598,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3599,NULL,'DUMMY',3599,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3600,NULL,'DUMMY',3600,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3601,NULL,'DUMMY',3601,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3602,NULL,'DUMMY',3602,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3603,NULL,'DUMMY',3603,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3604,NULL,'DUMMY',3604,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3605,NULL,'DUMMY',3605,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3606,NULL,'DUMMY',3606,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3607,NULL,'DUMMY',3607,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3608,NULL,'DUMMY',3608,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3609,NULL,'DUMMY',3609,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3610,NULL,'DUMMY',3610,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3611,NULL,'DUMMY',3611,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3612,NULL,'DUMMY',3612,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3613,NULL,'DUMMY',3613,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3614,NULL,'DUMMY',3614,1,'2025-02-26 21:30:14','2025-02-26 21:30:14'),(3615,NULL,'DUMMY',3615,1,'2025-03-02 03:21:05','2025-03-02 03:21:05'),(3616,NULL,'DUMMY',3616,1,'2025-03-02 06:26:37','2025-03-02 06:26:37');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') DEFAULT NULL,
  `unit_id` int(11) unsigned DEFAULT NULL,
  `secondary_unit_id` int(11) DEFAULT NULL,
  `sub_unit_ids` text DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT 0,
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT 0,
  `weight` varchar(191) DEFAULT NULL,
  `product_custom_field1` varchar(191) DEFAULT NULL,
  `product_custom_field2` varchar(191) DEFAULT NULL,
  `product_custom_field3` varchar(191) DEFAULT NULL,
  `product_custom_field4` varchar(191) DEFAULT NULL,
  `product_custom_field5` varchar(191) DEFAULT NULL,
  `product_custom_field6` varchar(191) DEFAULT NULL,
  `product_custom_field7` varchar(191) DEFAULT NULL,
  `product_custom_field8` varchar(191) DEFAULT NULL,
  `product_custom_field9` varchar(191) DEFAULT NULL,
  `product_custom_field10` varchar(191) DEFAULT NULL,
  `product_custom_field11` varchar(191) DEFAULT NULL,
  `product_custom_field12` varchar(191) DEFAULT NULL,
  `product_custom_field13` varchar(191) DEFAULT NULL,
  `product_custom_field14` varchar(191) DEFAULT NULL,
  `product_custom_field15` varchar(191) DEFAULT NULL,
  `product_custom_field16` varchar(191) DEFAULT NULL,
  `product_custom_field17` varchar(191) DEFAULT NULL,
  `product_custom_field18` varchar(191) DEFAULT NULL,
  `product_custom_field19` varchar(191) DEFAULT NULL,
  `product_custom_field20` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `woocommerce_media_id` int(11) DEFAULT NULL,
  `product_description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `woocommerce_product_id` int(11) DEFAULT NULL,
  `woocommerce_disable_sync` tinyint(1) NOT NULL DEFAULT 0,
  `preparation_time_in_minutes` int(11) DEFAULT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT 0,
  `repair_model_id` int(10) unsigned DEFAULT NULL,
  `not_for_selling` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  KEY `products_type_index` (`type`),
  KEY `products_tax_type_index` (`tax_type`),
  KEY `products_barcode_type_index` (`barcode_type`),
  KEY `products_secondary_unit_id_index` (`secondary_unit_id`),
  KEY `products_woocommerce_product_id_index` (`woocommerce_product_id`),
  KEY `products_woocommerce_media_id_index` (`woocommerce_media_id`),
  KEY `products_repair_model_id_index` (`repair_model_id`),
  CONSTRAINT `products_brand_id_foreign` FOREIGN KEY (`brand_id`) REFERENCES `brands` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_repair_model_id_foreign` FOREIGN KEY (`repair_model_id`) REFERENCES `repair_device_models` (`id`),
  CONSTRAINT `products_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `products_tax_foreign` FOREIGN KEY (`tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `products_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3617 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES (1,'test',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,2.0000,'1111','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2025-01-29 10:54:03','2025-01-29 10:54:03'),(2,'Nice',1,'single',1,NULL,NULL,1,NULL,NULL,NULL,'exclusive',1,3.0000,'8888101020101','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2025-01-29 11:32:15','2025-01-29 11:32:15'),(3,'Rice',3,'single',3,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'r','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-02 19:35:18','2025-02-02 19:35:18'),(4,'test',2,'single',2,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'1111','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,2,NULL,0,NULL,NULL,0,NULL,0,'2025-02-03 08:48:31','2025-02-03 08:48:31'),(5,'Signal 200g',1,'single',1,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'4792081029471','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2025-02-05 15:12:32','2025-02-05 15:12:32'),(6,'Sugar white',1,'single',4,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,10.0000,'0006','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2025-02-05 15:17:35','2025-02-05 15:17:35'),(7,'Close up (120g)',1,'single',5,NULL,NULL,2,NULL,NULL,NULL,'exclusive',1,NULL,'4792081016327','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2025-02-05 15:43:01','2025-02-05 15:43:01'),(9,'Calin',1,'single',1,NULL,NULL,3,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000523583','C128',NULL,NULL,0,'200',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,NULL,0,NULL,NULL,0,NULL,0,'2025-02-05 15:58:24','2025-02-05 15:58:24'),(10,'Haji Bedsheet',3,'single',3,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0010','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-06 08:25:50','2025-02-06 08:25:50'),(11,'panda baby',3,'single',3,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,20.0000,'0011','C128',NULL,NULL,0,'60g',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'<p>banda baby rathmal 5pack</p>',3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-06 10:59:16','2025-02-06 10:59:16'),(12,'MAKE-UP SPONCH SET 6 PCS',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'-1044','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:06','2025-02-07 06:08:06'),(13,'toy',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'*1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:06','2025-02-07 06:08:06'),(14,'I MATE CR 200PGS 245/=',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'$&96017021669','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:06','2025-02-07 06:08:06'),(15,'COLORING BOOK FOOD & FUN',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'000000001175','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(16,'COLOURING BOOK',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'000000001212','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(17,'COLOURING BOOK',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'000000001229','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(18,'Remote Control Car',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(19,'Polythin - Unit-M',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0002-1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(20,'Polythin - Unit-Kg',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0002-2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(21,'AKURA DALISA 2',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00020503','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(22,'AKURA DALISA 3',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00020510','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(23,'AKURA DALISA 4',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00020527','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(24,'AKURA DALISA 5',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00020534','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(25,'Dialog Reload',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(26,'HEENSARAYA S/ BOOK',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00067990-23','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(27,'KUMARODAYA 4',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00074879-29','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(28,'KUMARODAYA 1',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00078112-26','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(29,'KUMARODAYA GRADE 1',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00078112-29','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(30,'HATH PANA STORY BOOK',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00079895-27','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(31,'MAGUL- KAMA STORY BOOK',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00082155-24','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(32,'MAHADANAMUTHTHA STORY',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00083106-19','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(33,'APE GAMA',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00083326-273','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(34,'SAMANA;A DANUMA  KATTALAYA 1',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'001001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(35,'GUNASENA 4 BOOK',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'00138481-8','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(36,'CAR CHARGER 12 24 VOLT',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0086TOPCORE020HK708A','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(37,'P675 BATTRERY',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0104043752177374','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(38,'ALUMINUM FOIL 37.5SQ FEET',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'010900003759','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(39,'ALUMENIUM FOIL 37.5 SQ FEET',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'010900100878','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(40,'ALUMENIUM FOIL 25 SQ FEET',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'010900100887','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(41,'CHUTIBABA VIBAGA PURWA ANUMANA 5',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0200700004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(42,'test Item',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0271','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(43,'CHEDA HA PADYA',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0280','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(44,'CHEDA HA PDYA 3 MALPIYALI',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0281','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(45,'CHEDA HA PDYA 4 MALPIYALI L',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0282','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(46,'CHEDA HA PADYA 5',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0283','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(47,'GLASS BOTTLE JAM SMALL',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0306','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(48,'GLASS BOTTLE JAM LARGE',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0308','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(49,'PENAHARA STEEL MIDIUM',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0311','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(50,'PLASTIC PLATE WHITE',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0312','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(51,'PLASTIC BOWL WHITE',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0313','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(52,'FLOWER CONTAINER 3000',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0314','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(53,'R R CONTAINER 1500ML',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0316','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(54,'JILEBI MASTER CONTAINER',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0317','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(55,'CHEDA HA PDYA 4 MALPIYALI',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0335','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(56,'DUNLOP PORT ELITE TENNIS BALL',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'045566167668','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(57,'DUNLOP TOUR TENNIS BALL',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'045566167736','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(58,'DUNLOP TENNIS BALL ATP',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'045566167798','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(59,'BELLOSE KERATIN SHAMPOO 150ML',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'04706015290531','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(60,'GLASS SET 345',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'05082052MINGS','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(61,'SALED  BOWL SET 6PCS',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'07063015BAS','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(62,'MIHINDI GOLECHA CHERRY',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'075343879121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(63,'MINISTAR BLUTOOTH SEAKER MS-4209',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'07899576045101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(64,'OXFORD INSTRUMENT BOX',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'079252023594','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(65,'SD-40 ROCKIYA',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'079567600121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(66,'WD-40 DIMO100ML',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'079567850038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(67,'MOUSE WIRELESS M186',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'097855083487','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(68,'LAMA MUTHU QUICK PACK 5',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'09786245741144','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(69,'LAMA MUTHU QUICK PACK',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'09786245741168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(70,'SISIL RICE COOKER',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'0R01304','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(71,'OTHERS ITEM',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(72,'WATCH BATTREY P13',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1.0404375217741E+14','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(73,'OIL PAPER COLOUR',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(74,'DIALOG PHONE CARD 100',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(75,'PANADOOL',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1000','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(76,'RADIANT WAY FIRST STEP',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'100000012122','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(77,'PENCIL CASE 8111',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1000001181004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(78,'PENCIL CASE 9544',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1000001195445','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(79,'A4 GOLD FILM CARD WITH',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1000088678282','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(80,'4 G WI-FI ROUTER',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(81,'BLUETOOTH STEREO HEADSET VOYAGER',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(82,'IPHONE X CHARGER',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(83,'UDARATA UMBRELLA NO-UU2139',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'100400049','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(84,'PHONE ENLARGED SCREEN 3D',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1005','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(85,'GOREE FACE WASH ALOE',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1005025152016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(86,'BADDEGAMA',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10054809-0036','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(87,'BADDEGAMA BOOK',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10054809-0044','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(88,'BADDEGAMA BOOK',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10054809½0046','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(89,'MICROPHONE STANDS',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(90,'REMIX PHONE CHARGER',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1007','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(91,'NOKIA PHONE BATTRIES 5B',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10073','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(92,'MALALASEKARA DICTIONARY',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10073500-0080','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(93,'MALALASEKARA DICTIONARY',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10073500-0082','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(94,'KUMARODAYA 2',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10075287-0031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(95,'KUMARODAYA 3',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10075575-0029','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(96,'KUMARODAYA 1',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10078112-0031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(97,'SAMSUNG PHONE CHARGER MOXOM MX-HC143',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(98,'KUMARODAYA 5',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10082563-0027','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(99,'CHIP READER',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1009','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(100,'PHONICS ACTIVITY BOOK 3',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10098124-0106','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(101,'PHONICS READER  BOOK 3',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10098127-0112','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(102,'HUTCH INTERNET CARD 59',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(103,'BLUTOOTH SPEAKER  T5',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1010','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(104,'SADEEPA PASRUREN 3-4',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'10100089','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(105,'PRESCHOOL WORKBOOK',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'101001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(106,'SELFIE STICK MINI SIZE',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(107,'UDARATA UMBRELLA NO-UU2200  ( MUTHUKUDA )',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'101100001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(108,'TRIPOD TABLE TOP',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(109,'BLUTOOTH SPEAKER TABLEPRO MG2',3,'single',3,NULL,NULL,6,3,NULL,NULL,'inclusive',1,10.0000,'1013','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 06:08:07','2025-02-07 06:08:07'),(110,'Fried Rice',3,'single',3,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0110','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-07 16:27:31','2025-02-07 16:27:31'),(111,'test',4,'single',6,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0111','EAN8',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,6,NULL,0,NULL,NULL,0,NULL,0,'2025-02-10 12:18:36','2025-02-10 12:18:36'),(112,'Fish Bun',4,'single',6,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,NULL,'0112','C128',7.00,'days',0,NULL,'','','','','','','','','','','','','','','','','','','','',NULL,NULL,NULL,6,NULL,0,NULL,NULL,0,NULL,0,'2025-02-10 13:30:45','2025-02-10 13:45:30'),(113,'Oshan Mihira',3,'single',3,NULL,NULL,6,3,NULL,NULL,'exclusive',1,5.0000,'sc','C128',NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'1739391929_OL AL Accounting Books (9).png',NULL,NULL,3,NULL,0,NULL,NULL,0,NULL,0,'2025-02-12 20:25:30','2025-02-12 20:25:30'),(114,'පස් තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0114','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:19','2025-02-13 02:34:19'),(115,'අයිඩෙක්ස් 9g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792099011130','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:19','2025-02-13 02:34:19'),(116,'සිද්ධාලේප 15g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792172000044','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:19','2025-02-13 02:34:19'),(117,'අල (පකිස්ථාන්)',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0117','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(118,'සුව ඔසු පස්තෙල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0118','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(119,'පැගිරි තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0119','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(120,'අයිඩෙක්ස් 18g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792099011147','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(121,'අයිඩෙක්ස් හෙඩ්ෆාස්ට් 9g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792099010898','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(122,'අයිඩෙක්ස් හෙඩ්ෆාස්ට් 4g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792099010959','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(123,'සිද්ධාලේප 2.5g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792172000013','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(124,'සිද්ධාලේප 5g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792172000020','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(125,'සිද්ධාලේප 10g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792172000037','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(126,'මී පැණි 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0126','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(127,'අබ තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0127','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(128,'එඩරු තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0128','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(129,'මී තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0129','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(130,'කපුරු තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0130','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(131,'සුව ඔසු තල තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0131','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(132,'එලගි තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0132','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(133,'ඔලිව් තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0133','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(134,'සිද්ධාර්ථ තෛලය 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0134','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(135,'බටු තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0135','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(136,'වාත විදුරංග තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0136','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(137,'කොහොබ තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0137','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(138,'කෝකිල කොහොබ තෙල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0138','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(139,'සර්ව විෂාදි තෙල් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0139','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(140,'රෝස වතුර',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0140','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(141,'Isopropyl Alcohol 60ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0141','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(142,'Povidone Iodine solution 60ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8902541300712','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(143,'ප්ලාස්ටර් රෝල් 1/2',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0143','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(144,'ඩෙටෝල් ප්ලාස්ටර්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792037316044','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(145,'X- ඔයිල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149206011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(146,'සිද්ධාලේප ඔයිල් 7ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792172000105','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(147,'sp බාම් 3g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792022090102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(148,'sp බාම් 7g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792022090119','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(149,'Vicks බාම්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0149','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(150,'සිද්ධාලේප ඉන්හෙලර්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792172000082','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(151,'කාවඩි කපුරු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792140000014','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(152,'සන් නූල් බෝල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(153,'රොකට් නූල් බෝල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(154,'තුන් නූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0154','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(155,'ගිනිපෙට්ටි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0155','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(156,'Strepsils Tablet',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'9556108211332','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(157,'Strepsils 2 lozinger',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0157','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(158,'ග්ලූකෝස් 75g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796021040168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(159,'පහන්තිර ලොකු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0159','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(160,'පැනඩෝල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792099010805','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(161,'පැසිඩෝල් 500mg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0161','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(162,'Omeprazole Capsules 20mg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0162','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(163,'සමහන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792022090430','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(164,'ABZ 400mg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8902281000019','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(165,'ENO',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792099010607','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(166,'Povidone -Iodine 15g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8902541201910','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(167,'Allermine 4g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0167','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(168,'Domperidone Tablets 10mg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(169,'Mefcor 500mg tablet',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0169','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(170,'Amoxicillin capsules 500mg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0170','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(171,'Diclofenac Sodium 50mg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0171','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(172,'Surgical Bandage',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0172','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(173,'Cotton Wool',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0173','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(174,'Surgical Gauze',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0174','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(175,'KN95 Mask',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0175','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(176,'Baby Mask Colour',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0176','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(177,'Surgical Mask baby',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0177','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(178,'Surgical Mask',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0178','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(179,'Halley Lights',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0179','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(180,'රයින් බීඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0180','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(181,'සිගරට් (100)',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'47900028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(182,'සිගරට් (150)',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0182','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(183,'සිගරට් (ඩන්හිල්)',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0183','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(184,'ලක්ෂපාන රිමෝට් බැට්රි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791010001960','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(185,'පැනසොනික් AA බැට්රි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8887549037252','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(186,'බික් ලයිටර්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'3086120600051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(187,'ලයිටර්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4794444019693','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(188,'නෝ සුප් කැට',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005673245','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(189,'මැගී සුප් කැට',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0189','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(190,'9W බැට්රි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0190','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(191,'ඉටිපන්දම් (ලොකු)',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0191','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(192,'ඉටිපන්දම් (පොඩි)',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0192','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(193,'Vidyut බ්ලේඩ්තල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0193','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(194,'ෂුවර් පැච්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0194','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(195,'ඉදිකටු ලොකු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0195','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(196,'ඉදිකටු පොඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0196','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(197,'සාම්බ්‍රානි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'9780201379624','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(198,'බේබි ෂෙරමි පව්ඩර් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111100203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(199,'බේබි ෂෙරමි ක්‍රීම් 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111100005','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(200,'පෙයාස් බේබි ක්‍රීම් 200ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(201,'පෙයාස් බේබි ක්‍රීම් 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081019007','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(202,'පෙයාස් බේබි ක්‍රීම් 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081018925','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(203,'පෙයාස් බේබි පව්ඩර් 90g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081019212','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(204,'පැන්ඩා බේබි කොලෝන් 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0204','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(205,'පැන්ඩා බේබි කොලෝන් 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792054006294','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(206,'පැන්ඩා බේබි කොලෝන් 50ml බෝ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0206','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(207,'කොහොබ බේබි කොලෝන් බෝ 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792068521523','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(208,'පෙයාස් බේබි කොලොන් බෝ 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081019052','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(209,'බේබි ෂෙරමී කොලෝන් බෝ 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111141039|  4791111143019','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(210,'පෙයාස් බේබි ෂැම්පු 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081029938','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(211,'ස්වභා සිලෝන් ෂැම්පු 80ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796021240858','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(212,'කොහොබ බේබි ෂැම්පු 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792068361846','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(213,'චික් ෂැම්පු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8902979002882','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(214,'පෙයාස් බේබි ඔයිල් 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0214','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(215,'පැන්ඩා බේබි ෂැම්පු 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792054008922','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(216,'ලයිෆ්බෝයි ෂැම්පු 40ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081030651','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(217,'ලයිෆ්බෝයි ෂැම්පු 175ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081003518','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(218,'ලයිෆ්බෝයි ෂැම්පු 80ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081032662','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(219,'ලයිෆ්බෝයි ෂැම්පු 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081025190','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(220,'ඩවු ෂැම්පු 80ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081006090','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(221,'ඩවු කන්ඩිෂනර් 80ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081006052','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(222,'ඩවු ෂැම්පු 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081025213','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(223,'ක්ලියර් ෂැම්පු 80ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081035847','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(224,'සන්සිල්ක් කන්ඩිෂන් 80ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081024834','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(225,'සන්සිල්ක් ෂැමිපු 80 ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081035502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(226,'සන්සිල්ක් ෂැමිපු 180ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081034376','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(227,'සන්සිල්ක් ෂැම්පු 40ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796007616172','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(228,'නිවිසිස් ෂැමිපුු 80ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796025120415','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(229,'ඩැන්ඩෙක්ස් ෂැමිපු 175ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111107042','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(230,'ඩැන්ඩෙක්ස් ෂැමිපු 80ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111107028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(231,'ඩැන්ඩෙක්ස් ෂැමිපු 40ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111144085','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(232,'ජස්මින් සෙන්ටි 22ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8439627583351','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(233,'සෙන්ටි 9X 22ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8439627583160','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(234,'සෙන්ටි black knight 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792019393025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(235,'සෙන්ටි ගෝයා 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111109107','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(236,'කුමාරිකා තෙල් 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111106519','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(237,'කුමාරිකා තෙල් 200ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111106526','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(238,'නෙලුමි තෙල් 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796021040304','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(239,'4rever tea tree oil 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796001320501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(240,'4rever aloe lavender face wash 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796001325216','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(241,'නේච සීක්කටි 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792054000261','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(242,'biocos face wash 125ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'7979226082462','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(243,'ෆෙයාර් & ලවිලි ෆේෂ් වොෂ් 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081014774','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(244,'රෙක්ස්සෝනා ඩියෝඩිඩ්‍රන්ටි 25ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081032716','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(245,'evon deodorant 30ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000738703','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(246,'vaseline blueseal 50ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'60014399','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(247,'ගෝල්ඩ්  හෙයාර් ක්‍රීමි 25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111154107','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(248,'ගෝල්ඩි හෙයා ජෙල් 25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111154084','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(249,'ඇලෝවෙිරා ජෙල් 35ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792008297105','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(250,'සිලිකන් හෙයාර් 25ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000731476','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(251,'අමීන්ස් 10g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8904060000005','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(252,'10g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8906010540029','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(253,'රාවන් ෂැමිපු 21ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149602011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(254,'රාවන් කොහොඔ 10g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149200323','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:20','2025-02-13 02:34:20'),(255,'පැනඩෝල් ෂිරප් 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792099010201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(256,'පිරිටන් ෂිරප්  100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0256','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(257,'මොරිසන් 200ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792000016117','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(258,'මොරිසන් 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792000014113','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(259,'පාතිමා 10ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0259','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(260,'සුවඔසු පාවටිටා ෂිරප්  100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0260','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(261,'සුවඔසු ගැස්ටික් ෂිරප් 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0261','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(262,'නිවුදෝසා 100',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792019451930','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(263,'ඩෙටෝල් 210ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792037315214','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(264,'ඩෙටොල් 60ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792037315207','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(265,'ඩෙටෝල් 110ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792037315085','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(266,'පෑඩ්ලොක් 20mm',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0266','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(267,'පෑඩ්ලොක් 25mm',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0267','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(268,'පෑඩ්ලොක් 32mm',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0268','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(269,'පෑඩ්ලොක් 38mm',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0269','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(270,'තල දාන රේසර්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0270','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(271,'ටූත් පික්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0271','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(272,'ටෝච් AG539297',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0272','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(273,'ටෝච් AS- 542',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0273','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(274,'ටෝච් AG631609',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0274','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(275,'ටෝච් AG539286',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0275','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(276,'චන්දනාලේප 20g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4790014240054','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(277,'චන්දනාලේප 12g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796010930043','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(278,'පොන්ස් ක්‍රීමි 23g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081021925','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(279,'සැෆ්රෝන් ක්‍රීම් 12g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149360034','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(280,'ප්‍රෙෂ් & වයිටි බොඩිලෝෂන් 325ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'7896325148007','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(281,'ප්‍රෙෂ් & වයිටි ක්‍රීමි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'7896325147987','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(282,'ප්‍රෙෂ් & වයිටි සබන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0282','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(283,'වැක්ස්ලින් ක්‍රීම් 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081016273','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(284,'වැක්ස්ලින් ක්‍රීම් 40ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081016266','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(285,'වැක්ස්ලින් ක්‍රීම් 200ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081013661','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(286,'ආයුෂ් ක්‍රීමි 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081020850','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(287,'ෆෙයාර් & ලවිලි ක්‍රීම් මෙන් 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081014811','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(288,'ෆෙයාර් & ලවිලි ක්‍රීම් මෙන්25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081014804','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(289,'ෆෙයාර් & ලවිලි ක්‍රීම්  50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0289','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(290,'ෂෙලෝ ක්‍රීම් 5004792008212603',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792008212603','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(291,'ෂෙලෝ ක්‍රීම් 500ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792008215604','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(292,'ෂෙලෝ ක්‍රීම් 125ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792008213204','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(293,'ගෝල්ඩි ක්‍රීමි 30ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'5060068521577','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(294,'ෆෙෂ් & වයිටි සීරම් 30ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0294','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(295,'ලේඩි පව්ඩර් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792068218140','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(296,'බිලැක් නයිටි පවිඩර් 60g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792019400112','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(297,'පැරිස් පවුඩර් 85g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111110011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(298,'රානි පවුඩර් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792068212247','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(299,'පොන්ස් පවුඩර් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005675157','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(300,'කොහොඔ පවුඩර් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792068211745','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(301,'වෙල්වටි ක්‍රීම් 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111114729','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(302,'බිලැක් නයිටි ජෙල් 30ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792019405520','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(303,'කොට්න් බටන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4790015010281','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(304,'ඩාස්ලින් ටැල්කම් පව්ඩර් ලොකු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149210537','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(305,'ඩාස්ලින් ටැල්කම් පව්ඩර් පොඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149210520','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(306,'ෂෙරමි නැපි වොෂ් 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111143552','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(307,'ෂෙරමි බෙිබි ලික්විඩි 650ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111141206','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(308,'බ්‍රයිටෝල් එයා ෆෙෂ්න',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178000413','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(309,'TWO TONE SOCKS AGE 11-15',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796019448037','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(310,'KAP SOCKS AGE 11-15',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'ABC-abc-1234','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(311,'KAP SOCKS 6-10',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796019448040','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(312,'PENGUIN SOCKS 6-10',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0312','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(313,'PENGUIN SOCKS 3-5',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0313','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(314,'PENGUIN SOCKS 3-5',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0314','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(315,'PENGUING SOCKS 3-5',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0315','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(316,'ඊවා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792019419800','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(317,'ඇය',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111146126','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(318,'ෆෙම්ස් නිල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111136240','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(319,'ෆෙම්ස් දම්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111136226','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(320,'පැම්පස් S',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111193892','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(321,'පැම්පස් L',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111193915','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(322,'පැම්පස් XL',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111143347','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(323,'බේබි ෂෙරමි පැම්පස් S',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111141534','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(324,'පේපර් සර්වියට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0324','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(325,'සූදුරු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0325','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(326,'මහදුරු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0326','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(327,'කහකුඩු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0327','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(328,'අජිනමොටෝ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0328','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(329,'කුරුදුපොතු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0329','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(330,'උලුහාල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0330','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(331,'ගම්මිරිස් ඇට',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0331','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(332,'ගොරකා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0332','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(333,'කෑලි මිරිස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0333','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(334,'සව්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0334','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(335,'අබ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0335','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(336,'මිරිස් කුඩු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0336','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(337,'තේ කොල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0337','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(338,'කව්පි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0338','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(339,'තුනපහ කුඩු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0339','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(340,'ගම්මිරිස් කුඩු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0340','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(341,'ලූස් සෝයා චුට්ටි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0341','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(342,'ලූස් සෝයා දැල්ලෝ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0342','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(343,'බීම කුඩු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0343','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(344,'වියලි මිරිස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0344','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(345,'මුං ඇට',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0345','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(346,'වටානා පරිප්පු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0346','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(347,'හාල්පිටි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0347','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(348,'බැදපු මිරිස් කුඩු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0348','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(349,'මික්ෂර්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0349','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(350,'බෙිබි මුරැක්කු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0350','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(351,'රටකජු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0351','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(352,'ක්‍රිස්පි බයිට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796015211000','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(353,'ගංගා බයිටි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0353','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(354,'මඤ්ඤොක්කා පෙති',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0354','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(355,'සුදුළුනු බයිටි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0355','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(356,'කළු කඩල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0356','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(357,'සීනි මුරැක්කු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0357','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(358,'කිරි කඩල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0358','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(359,'හබල පෙති',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0359','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(360,'මල් පපඩම්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0360','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(361,'ඩසිකට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0361','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(362,'බිස්කට් කුඩු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0362','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(363,'ඉගුරු හකුරු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0363','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(364,'හකුරු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0364','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(365,'රැලං පිටි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0365','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(366,'EX අගල දික්රූල් පිටු 80',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796009868401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(367,'EX අගල් 1/2 දික්රූල් පිටු 80',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796009868425','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(368,'EX පස්රූල් පිටු 80',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792066624561','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(369,'EX අගල කොටු පිටු 80',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100040','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(370,'EX අගල් 1/2 කොටු පිටු 80',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100033','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(371,'EX ඩබල්රූල් පිටු 80',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100057','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(372,'EX බ්ලෑන්ක් බුක් පිටු 80',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100026','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(373,'EX කොටු පිටු 40',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796017021232','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(374,'EX දික්රූල් පිටු 40',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100156','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(375,'EX පිටු 80 කොටුරූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100187','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(376,'EX පිටු 80 දික්රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100163','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(377,'XLපිටු 120 දික්රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100194','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(378,'XL පිටු 120 කොටුරූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796017020136','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(379,'XL පිටු160 දික්රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796009868197','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(380,'XL පිටු 160 කොටුරූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100552','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(381,'XL පිටු 200 දික්රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100569','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(382,'XL 200 කොටුරූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100576','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(383,'B5 පිටු 80 දික්රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210131938','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(384,'B5 පිටු 80 කොටුරූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210134021','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(385,'B5 පිටු 120 දික්රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210130894','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(386,'B5 පිටු 120 කොටුරූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792066005278','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(387,'B5 පිටු 160 දික්රූල් රත්න',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796009869972','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(388,'B5 පිටු 160 කොටු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796017021942','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(389,'B5 පිටු 160 දික්රූල් ඇට්ලස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210130900','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(390,'B5 පිටු 80 ඩබල්රූල් රිචඩ්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792066004745','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(391,'B5 පිටු 80 1/2 කොටු රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796017022000','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(392,'B5 පිටු 80 පස්රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792066004752','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(393,'B5 පිටු 80 බ්ලැන්ක් බුක්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792066004738','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(394,'XL පොත්  ලැමිනේටින් කවර',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6971633349863','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(395,'CR පොත් ලැමිනේටින් කවර',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6971361500031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:21','2025-02-13 02:34:21'),(396,'කාබන් කොල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8901425009772','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(397,'ඇට්ලස් ෆයිල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0397','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(398,'මැනේජ්මන් ෆයිල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6972094331022','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(399,'ක්ලියර් බෑග්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0399','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(400,'ක්ලියර් බුක්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6935777696528','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(401,'ග්ලිටර් ෆෝම් ෂීට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(402,'රයිටින් පේපර් දික්රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210109135','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(403,'රයිටින් පේපර් කොටුරූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792066522898','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(404,'A4  ෂිට්  තද පාට',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0404','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(405,'A4  ෂීට් ලා පාට',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0405','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(406,'A4 ෂීට් සුදු පාට',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0406','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(407,'ලෝක සිතියම්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210109098','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(408,'ලංකා සිතියම්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792066005001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(409,'ප්‍රස්ථාර කොල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0409','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(410,'පෑන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210131426','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(411,'ජෙල් පෑන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0411','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(412,'ඇට්ලස් කහා පැන්සල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210102785','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(413,'ඉරි පැන්සල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0413','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(414,'සයින් පෑන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8907016020805','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(415,'ප්ලැටිග්නම්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0415','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(416,'ඇට්ලස් හයිලයිට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210107926','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(417,'හයිලයිට් ටෙන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796002051954','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(418,'ඇට්ලස් වයිට්බෝඩ් මාකර්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210125234','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(419,'ඇට්ලස් පර්මනෙටි මාකර්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210125258','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(420,'ටෙන් වයිට්බෝඩ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796002052838','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(421,'M S වයිට් බෝඩ්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6976441254859','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(422,'GXIN වයිඩ් බෝඩ්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6954941712130','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(423,'GXIN පර්මනෙට් මාකර්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0423','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(424,'පාට පෑන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0424','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(425,'ඇට්ලස් කතුරු පොඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0425','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(426,'හැඩ කපන කතුරු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0426','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(427,'සිනහා මුහුනු බැජ් ලොකු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0427','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(428,'සිනහා මුහුණු බැජ් පොඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0428','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(429,'කැරට් කටර්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0429','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(430,'ඇට්ලස් ටිපෙක්ස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210104284','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(431,'ටිපෙක්ස් බෝතල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0431','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(432,'ටිපෙක්ස් 12ml බෝතල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0432','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(433,'ග්ලූ ස්ටික්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0433','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(434,'ඇට්ලස් බයින්ඩර් ගම් 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210103454','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(435,'ඇට්ලස් බයින්ඩර් ගම් 40g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210130825','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(436,'ඇට්ලස් ලික්විඩ් ගම් 40ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210130832','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(437,'ස්කූල් ග්ලූ 200ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0437','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(438,'බිනාර වයිට් ගම්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0438','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(439,'ඇට්ලස් ලික්විඩ් ග්ලූ 20ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0439','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(440,'ඇට්ලස් මකන',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100781','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(441,'ඇට්ලස් මකන ලොකු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100774','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(442,'හෝස් මකන',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'7895526528328','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(443,'කපුරැ බෝල ලොකු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792140100035','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(444,'වෙල්කින් 919 ටෙනිස් බෝල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0444','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(445,'ස්ටෙප්ලර් කටු නො 10',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0445','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(446,'ස්ටෙප්ලර් කටු 3696938534001146',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6938534001146','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(447,'කතන්දර පොත් ළමා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0447','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(448,'සිග්නල්  160g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081029464','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(449,'සිග්නල් 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081029440','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(450,'සිග්නල් 40g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081029433','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(451,'ක්ලෝගාඩ් සෝල්ට් 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111149110','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(452,'ක්ලෝගාඩ් 120g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111102030','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(453,'ක්ලෝගාඩ් 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111102023','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(454,'ක්ලෝගාඩ් 40g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111102016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(455,'ක්ලෝසප් 120g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081013906','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(456,'ක්ලෝසප්  30g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081013876','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(457,'ආයුෂ් 120g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081004065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(458,'ආයුෂ් 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081004058','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(459,'ආයුෂ් 30g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081029259','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(460,'සුපිරිවිකි 110g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792172005643','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(461,'සුපිරිවිකි 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792172002031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(462,'සුපිරිවිකි 40g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792172005629','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(463,'සුදන්ත 120g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792022090249','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(464,'සුදන්ත 80g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792022090041','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(465,'සුදන්ත 45g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792022090058','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(466,'සෙන්සොඩයන් 40g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8901571004089','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(467,'වෙල්වට් 45g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111153278','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(468,'වෙල්වට් 95g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111153322','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(469,'ලක්ස් 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081027460','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(470,'චන්දනාලේප සබන් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796010930005','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(471,'මොටින් රීෆිල් 25ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792037130985','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(472,'නිල්දියර 275ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4793000714010','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(473,'2IN1 නිල් දියර 75ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0473','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(474,'ක්ලෝරස් 60ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0474','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(475,'නීමා ක්ලෝරස්  60ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0475','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(476,'ෂෙරමි බෙිබි  සබන්  70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111100302','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(477,'ෂෙරමි බෙිබි  සබන් 90g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111142173','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(478,'ෂෙරමි බෙිබි සබන්  5 පැක්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111100319','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(479,'වෙනිවැල් සබන් 75g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792125934839','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(480,'ඩෙල්මා ලයිට් 115g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000523002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(481,'පැන්ඩා රත්මල් බෙිබි 60g   5 පැක්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792054017023','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(482,'කැලින් සබන්  75g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000523804','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(483,'කැලින් සබන් 80g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000523613','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(484,'පෙයාර්ස් බෙිබි සබන් 90g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081019182','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(485,'කැකුලු සබන් 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792172002079','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(486,'කොහොඔ බෙිබි 80g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792068121600','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(487,'රත්මල් බෙිබි  60g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792054016736','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(488,'කොහොඹ  සබන් 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792068111137','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(489,'සමන් සබන් 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792083030352','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(490,'ලයිෆ්බෝයි 75g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081032907','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(491,'ලයිෆ්බෝයි 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081025978','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(492,'හැපීබෝයි 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000523118','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(493,'ලක්ස් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081036066','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(494,'වෙල්වටි 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111153193','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(495,'ඩෙටෝල් සබන් 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792037313241','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(496,'සන්ලයිට් 110g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081023493','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(497,'සුපර් ලයිට් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0497','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(498,'විම් ප්‍රමෝ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005657412','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(499,'විම් 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005650567','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(500,'විම් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005650550','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(501,'වොන්ඩලයිට් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081023578','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(502,'හාපික් 200ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792037107727','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(503,'බ්‍රයිටෝල් ටයිල් ග්‍රවුට් 500ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178002301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(504,'බ්‍රයිටෝල් ක්‍රීම් ක්ලෙනසර් 500ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178000635','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(505,'බ්‍රයිටෝල් දිෂ්වොෂ් 500ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178003520','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(506,'බ්‍රයිටෝල් දිෂ්වොෂ් 250ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178002745','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(507,'විම් දිෂ්වොෂ් 250ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005660030','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(508,'බ්‍රයිටෝල් කාර් ලික්විඩ් 500ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178000116','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(509,'විම් දිෂ්වොස් 500ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005660047','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(510,'සන්ලයිට් කෙයාර් 600ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005656835','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(511,'ලයිසෝල් 200ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792037610760','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(512,'කන්ෆර්ට් 90ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8901030879340','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(513,'ලයිෆ්බෝයි හැනඩ් වොෂ් 180ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081018031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(514,'කන්ෆර්ට් 210ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8901030930980','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(515,'අරෝමා කන්ෆර්ට් 100ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178002806','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(516,'බ්‍රයිටෝල් ටයිල් ලික්විඩ්  500ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4790015820569','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(517,'බ්‍රයිටෝල් එයාර් ෆේෂ්නර් 475ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178000321','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(518,'හාර්පික් 500ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792037107741','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(519,'සුපර් වයිට් ක්ලෝරස්ට් 250ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4793000121078','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(520,'මොටීන් මදුරැ කොයිල් පෙට්ටි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791010040037','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(521,'මොටීන් කොයිල් ඩබලක්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0521','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(522,'SHORTHAND NOT BOOK  80',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792006524357','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(523,'NOTE BOOK 120',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'9781234567897','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(524,'FIELD NOTE BOOK',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0524','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(525,'පෙයාර්ස් බෙිබි සබන් 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081030255','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(526,'ඩෙටෝල් සබන් 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0526','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(527,'ජම්බෝ පීනට් ලොකු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792190120489','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(528,'ගැන්ගෝ 20g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0528','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(529,'ගැන්ගෝ 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149010014','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(530,'නෙස්ටමෝල් 28g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024016193','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(531,'රස මුසු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024013239','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(532,'කිරි තේ 25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796010610365','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(533,'චොකෝග්රේන්ස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796002405009','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(534,'චීස් බ්ට්න්ස් 20g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101611262','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:22','2025-02-13 02:34:22'),(535,'නෙස්කැෆේ 18g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4192084013178','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(536,'නෙස් ටී 25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024008303','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(537,'මැලිබන් කිරි 60g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0537','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(538,'ලාඕජි 80g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'5063305003553','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(539,'රස කහට 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8720608620524','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(540,'සෙස්ටා  තේ කොල   45g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0540','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(541,'කහට පොරොන්දුව 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796021060289','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(542,'රස කහට 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8720608620517','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(543,'ලාඕජි 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8720608620449','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(544,'රන් කහට 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791052500407','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(545,'ලාඕජි  50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'5063305003546','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(546,'ඇන්කර් 75g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791085014186','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(547,'රත්ති කිරි තේ 25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0547','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(548,'සේවරි නට්ස් බිස්කට් 30g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101612269','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(549,'තලවාකැලේ 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791029065557','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(550,'තලවාකැලේ 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791029065564','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(551,'කහට පොරොන්දුව 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796021060296','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(552,'හෙන්ඩ්‍රික් තේ 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4793000028070','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(553,'ලාඕජි 16g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'5063305003539','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(554,'මයිලො 15g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024013277','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(555,'ඇස්ට්‍රා 18g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0555','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(556,'නිව්දෝශ 8ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792019451923','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(557,'නෙස්ප්‍රේ 18g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0557','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(558,'විජය තේ කුඩු 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173110001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(559,'ලිප්ටන් යෙලෝ තේ 45g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8720608621583','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(560,'ෆ්‍රීලන් කෑලි මිරිස් 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000300153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(561,'ෆ්‍රීලන් මිරිස් කුඩු 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000300085','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(562,'ෆ්‍රීලන් මිරිස් කුඩු 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000300092','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(563,'ෆ්‍රීලන් උම්බලකඩ 25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000301594','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(564,'විජය කෝපි කුඩු 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173090006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(565,'ෆ්‍රීලන් තුනපහ කුඩු 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000300238','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(566,'ෆ්‍රීලන් තුනපහ කුඩු 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000300245','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(567,'නෝ උම්බලකඩ පවුඩර් 8g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005673986','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(568,'විජය කෑලි මිරිස් 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173000005','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(569,'මැගී චිකන් ටිකිරි 49g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024015783','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(570,'ෆ්‍රීලන් බැදපු තුනපහ 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000301488','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(571,'විජය මිරිස් කුඩු 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173010004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(572,'විජය මිරිස් කුඩු 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173010011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(573,'විජය බැදපු තුනපහකුඩු 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173060016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(574,'ෆ්‍රීලන් ගම්මිරිස්කුඩු 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000300399','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(575,'විජය කෑලි මිරිස් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173000012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(576,'විජය මස්කරි තුනපහ  25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173681402','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(577,'ෆ්‍රීලන් ගම්මිරිස් කුඩු 25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000300382','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(578,'විජය කෝපි 10g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173680450','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(579,'විජය කහකුඩු 25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173680702','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(580,'ප්‍රීමා තක්කාලි සෝස් 15g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792018551075','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(581,'NTT තක්කාලි සෝස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792142853168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(582,'G.H.P. පරිප්පු කඩල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0582','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(583,'විජය තුනපහ 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173020003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(584,'විජය තුනපහ 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173020010','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(585,'ෆ්‍රීලන් බැදපුතුනපහ 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000301471','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(586,'ෆ්‍රීලන් ක්ලැසික් නූඩ්ල්ස් 500g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000302096','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(587,'ෆ්‍රීලන් එළවළු නූඩ්ල්ස් 350g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000302355','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(588,'විජය නූඩ්ලස් 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173100088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(589,'ප්‍රීමා ක්ෂනික නූඩ්ල්ස් 325g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792018233681','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(590,'මැගී ෆැම්ලි පැක් 335g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024019262','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(591,'රයිගම් දෙවනි 350g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149097107','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(592,'ප්‍රීමා ස්ටෙලා චිකන් 74g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792018234312','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(593,'ප්‍රීමා ටොප්ස් නූඩ්ල්ස් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792018233148','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(594,'ප්‍රීමා කොත්තුමී 80g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792018233131','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(595,'ප්‍රීමා කොත්තුමී නයි මිරිස් රසට 90g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792018244960','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(596,'මැගී චිකන් නූඩ්ල්ස් 73g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024019392','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(597,'විජය කුරක්කන් පිටි 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173130085','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(598,'විජය තෝසේ පිටි 400G',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173681389','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(599,'විජය උදු පිටි 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173140091','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(600,'ෆ්‍රීලන් උළුදු පිටි 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000301433','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(601,'ප්‍රීමා රුලං පිටි 500 g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796016600032','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(602,'ජයවර්ධන පාං කුඩු 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796025610114','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(603,'සේරා පොල්කිරි 180ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796002514008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(604,'රට ඉදි 250g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6291100197149','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(605,'ජයවර්ධන නුඩ්ල්ස් 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4196085610077','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(606,'ප්‍රීමා ටුවිට්ස් නුඩ්ල්ස් 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792018231045','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(607,'විජය මිරිස්කුඩු   250g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173010028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(608,'සුපෝස 700g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4797001036737','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(609,'සමපෝෂ 500g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792109000482','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(610,'නැනපෝෂ 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149080017','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(611,'සමපෝෂ 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792109000024','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(612,'මිලාන් පැස්ටා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792225001660','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(613,'රයිගම් පැස්ටා 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149170114','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(614,'ජයවර්ධන පැස්ටා 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796025610084','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(615,'රේඛා පපඩම් 60g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796020700063','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(616,'සෙවන පපඩම් 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796007120037','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(617,'ප්‍රීමා තිරිගුපිටි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796016600100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(618,'විජය ඉදිආප්ප පිටි 1Kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792173680573','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(619,'ෆ්‍රීලන් රතු හාල් පිටි 1Kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000300788','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(620,'ෆ්‍රීලන් ඉදිආප්ප පිටි 1Kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000300771','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(621,'ඇන්කර් 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791085011079','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(622,'සස්ටජන් චොක්ලට් 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8850024105241','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(623,'හෝර්ලික්ස් 350g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005677281','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(624,'මයිලෝ 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024013314','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(625,'රත්ති කිරි තේ 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791085292928','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(626,'කොත්මලේ ෆෙෂ් මිල්ක් 1L',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792090000546','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(627,'වීවා 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005684944','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(628,'හයිලන්ඩ් කිරිපිටි 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792094003093','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(629,'ඇන්ලීන් 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791085171070','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(630,'වීවා 300g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005684098','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(631,'රත්තී 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791085081072','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(632,'නෙස්ටමෝල් 450g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024019545','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(633,'මයිලෝ 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024013215','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(634,'නෙස්ටමෝල් 175g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024016216','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(635,'නෙස්ටමෝල් 300g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024018302','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(636,'නෙස්ටමෝල් 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024016131','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(637,'පියෝඩේලි කිරි තේ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796010610310','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(638,'සස්ටජන් වැනිලා 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8850024105258','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(639,'රතු පරිප්පු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0639','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(640,'පාංපිටි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0640','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(641,'සෙවන නුඩ්ල්ස්  kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0641','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(642,'සුදු සීනි',5,'single',10,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0642','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-15 03:56:25'),(643,'කොත්තමල්ලි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0643','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(644,'කරුංකා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0644','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(645,'ජම්බො කඩල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0645','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(646,'ගුරු සීනි',5,'single',10,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0646','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-15 03:52:28'),(647,'පොල්තෙල් බෝතල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0647','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(648,'සුපිරි සැමන් 425g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796017790046','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(649,'ඩයමන්ඩ් ජැක් මැකරල් සැමන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792225700235','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(650,'පර්ල් ටූනා ටින් මාළු 425g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4793001845003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(651,'SNJ ජැක් මැකරල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4797001166915','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(652,'සෝනා මැකරල් 425g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6935897622063','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(653,'ගොල්ඩි චිකන් මීට්බෝල් 280g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792047507869','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(654,'ඕෂන් ස්ටාර් ජැක් මැකරල් 155g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4797007087054','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(655,'රයිගම් විනාකිරි 350ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149050140','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(656,'රයිගම් විනාකිරි 750ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149050164','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(657,'පොල් පැණි 187.5ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4797001033767','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(658,'පොල් පැණි 375ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4797001033750','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(659,'MD සෝස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792098089031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(660,'සිතුම් අසමෝදගම් 375ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0660','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(661,'සිද්ධාලේප අසමෝදගම් 350ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792172004301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(662,'නීරෝගා අසමෝදගම් 385ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149200835','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(663,'ඩෙල්මේජ් එග් යෙලෝ වර්ණක',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792020301088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(664,'ටියානා වැනිලා එසන්ස් 28ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0664','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(665,'ඩෙල්මේජ් ඔරේන්ජ් ෆ්ලේවර්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792020311056','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(666,'මෝතා කෝන්ෆ්ලවර් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792551031010','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(667,'මෝතා වටලප්පන් මික්ස් 110g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792551010039','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(668,'මෝතා කොකෝ පව්ඩර් 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792551033014','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(669,'මෝතා ජෙලි 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792551000191','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(670,'මෝතා ෆලූඩා මික්ස් 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792551010213','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(671,'මෝතා කස්ටඩ් පව්ඩර් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792551010138','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(672,'මෝතා ෆලූඩා මික්ස් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792551010237','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(673,'උස්වත්ත ජොලි ජෙලි 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792135030514','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(674,'නෙස්ලේ මිල්ක්මෙිඩ් 390g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024011792','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(675,'එඩිම්බරෝ අඹ චට්නි  200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792212007873','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(676,'කේ වී සි තක්කාලි සෝස් 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796014110236','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(677,'ආර් එන් එස් උම්බලකඩ කැබලි 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796032000052','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(678,'ප්‍රීමා ජැම් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792018521108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(679,'ප්‍රීමා යෝයා යෝස් 350ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792018551235','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(680,'මාමයිට් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005673306','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(681,'මාමයිට් 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005673290','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(682,'ප්‍රීමා ජෑම් 225g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792018521092','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(683,'ප්‍රීමා ජෑම් 180g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792018521047','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(684,'ලක්මි තක්කාලි සෝස් 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796012130366','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:23','2025-02-13 02:34:23'),(685,'ෆ්‍රීලන් සූදුරු 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000303260','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(686,'ෆ්‍රීලන් උළුහාල්  50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000303284','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(687,'ෆ්‍රීලන් මාදුරැ  50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000302591','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(688,'රයිගම් කෝපි කුඩු 25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149040219','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(689,'රයිලම් කෝපි කුඩු 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149040318','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(690,'රයිගම් කෝපි කුඩු 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149040417','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(691,'මන්චි හවායන් කුකීස්  200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101080402','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(692,'මැලිබන් යෝයෝ බිස්කට් 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034070485','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(693,'මන්චි ටිකිරි මාරි 80g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101280208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(694,'මන්චි බ්‍රැන්ඩ් ක්‍රැකර් 240g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101132385','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(695,'මන්චි වෙිපර්ස් 220g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192848183','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(696,'මනචි වෙිපර්ස් 170g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192845663','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(697,'මන්චි වෙිපර්ස් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101500207','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(698,'මැලිබන් චෙකර්ස් කුකුස්  195g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034072502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(699,'මැලිබන් චොකලට් ක්‍රීම්  400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034070546','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(700,'මන්චි ‍චොකලට් ක්‍රීම් 210g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192845366','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(701,'ජයවර්ධන මිල්කි රක්ස්  200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796025610152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(702,'ජයවර්ධන බටර් රක්ස් 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796025610169','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(703,'මන්චි මිල්ක් ක්‍රීම්  220g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192848350','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(704,'මන්චි ලයිටි මාරි 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101287238','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(705,'මන්චි රින්ගො 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192822008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(706,'මැලිබන් චෙකර්ස් කොෆි කුකීස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034072274','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(707,'මන්චි චොක්ලට් ක්‍රීමි 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101270018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(708,'මන්චි ටිකිරි මාරි  230g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192845809','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(709,'මන්චි ටිකිරි මාරි  360g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101280109','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(710,'මන්චි චොක්ලට් පෆ්  200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101271404','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(711,'මන්චි චොකලට් මාරි  200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192845823','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(712,'මැලිබන් ක්‍රීම් ක්‍රැකර්   230g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034071604','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(713,'මන්චි නයිස්  400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101020101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(714,'මන්වි ලයිට් මාරි  250g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101282097','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(715,'මැලිබන් කස්ටඩ් ක්‍රීම්  100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034008112','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(716,'මන්චි නයිස්  100',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101020200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(717,'මැලිබන් ස්පයිසි ක්‍රැකර්  170g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034060110','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(718,'මැලිබන් ක්‍රීම් ක්‍රැකර්  85g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034070812','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(719,'මැලිබන් ක්‍රීම් ක්‍රැකර් 190g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034042116','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(720,'මැලිබන් කස්ටඩ් ක්‍රීම්  200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034072656','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(721,'මැලිබන් රවුන්ඩිස්  40g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034072885','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(722,'මන්චි ලෙමන් පෆ්  100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101090203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(723,'මන්චි චොකලට් මාරි   90g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101281205','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(724,'විස්කිරිඤ්ඤා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0724','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(725,'බටර් විස්කෝතු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0725','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(726,'සීනි විස්කිරිඤ්ඤා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0726','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(727,'ශාන්ත චොකලට් බනිස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4793002198085','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(728,'ශාන්ත ක්‍රීම් බනිස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0728','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(729,'කැන්ඩෝස් ප්‍රොමිසස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025150882','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(730,'කැන්ඩෝස් චොකෝ රවුන්ඩි  100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025151650|','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(731,'කැන්ඩෝස් චොකෝ රවුන්ඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025152114','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(732,'කැන්ඩොස් චොකෝ ෆින්ගර්ස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025151667','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(733,'ප්‍රීමා ජෑම් කප් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0733','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(734,'රයිගම් කෝපි කුඩු 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0734','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(735,'කේ එස් එස් චොකෝ ෆින්ගර්ස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025151681','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(736,'උස්වත්ත මාෂ්මෙලෝස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0736','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(737,'උස්වත්ත පලතුරු ජෙලි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792135000166','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(738,'දුමිදු CR පිටු 40 කොටු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796017020310','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(739,'ඇට්ලස් CR පිටු 80 කොටු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210101863','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(740,'ඇට්ලස් CR පිටු 80 දික්රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0740','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(741,'ඇට්ලස් CR පිටු 160 දික් රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100262','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(742,'දුමිදු CR පිටු 200 කොටු රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796017021218','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(743,'රිචඩ් සයන්ස් බුක් පිටු 80',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792066524496','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(744,'ඇට්ලස් CR පිටු 160 කොටු රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210101887','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(745,'ඇට්ලස්  පිටු 20 ඩ්රෝවින් බුක්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100651','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(746,'ඇට්ලස් පිටු 40 බ්ලැක් ඩ්රෝවින් බුක්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210106899','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(747,'ඇට්ලස් ඩ්රෝවින් බුක් පිටු 80',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210101412','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(748,'සන් හැට්ට කටු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0748','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(749,'ඇට්ලස් පැස්ටල් පාට 24',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210103492','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(750,'ඇට්ලස් අඩි 1/2',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210109265','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(751,'පෙන්ටියම් පැස්ටල් පාට 13',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796001620038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(752,'පීකොක් ප්ලාස්ටික් ක්ලේ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0752','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(753,'පෙන්ටියම් පැස්ටල් පාට 24',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796001620045','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(754,'ඇට්ලස් අඩි රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210112944','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(755,'දිය සායම් පාට 12',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0755','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(756,'අම්රිතා හදුන්කූරු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791010002547','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(757,'අව්රා හදුන්කූරූ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796010120147','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(758,'සික්ස් ඔ ක්ලොක් හදුන්කූරූ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4793000812129','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(759,'සප්තමී හදුන්කූරූ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796018000106','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(760,'බැති පූජා හදුන්කූරූ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4793000587775','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(761,'අම්රිතා මෝග්රා හදුන්කූරු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791010007207','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(762,'කුමාර දඩු හා කැට',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0762','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(763,'ඩී එල් ඔෆිස් පින්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6978021865165','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(764,'ට්‍රාන්ස්පේරන්ට් පොලිතින්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0764','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(765,'සුදු ජිල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0765','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(766,'ජිල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0766','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(767,'කුමාර මොඩෙල්ස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0767','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(768,'රත්න නාඩු සහල් 5kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0768','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(769,'රත්න නාඩු සහල්  10kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0769','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(770,'රයින් නාඩු සහල් 5kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0770','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(771,'රයින් කැකුලු සහල්  1kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0771','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(772,'නිවුඩු නාඩු සහල් 1kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0772','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(773,'නිවුඩු කැකුලු සහල් 1kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0773','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(774,'පොලොන්නරු රත්න සහල් 5kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0774','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(775,'හාල්මැස්සො තායි 2',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0775','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(776,'වන්න පරා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0776','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(777,'කුකුලා කරවල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0777','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(778,'ලින්නා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0778','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(779,'චීස් කීලං',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0779','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(780,'බෝට්ටු කරවල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0780','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(781,'ඇට්ලස් ඩ්‍රෝවින් පිටු 40',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210101405','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(782,'අංගුලු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0782','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(783,'කෙන්දා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0783','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(784,'මඩු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0784','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(785,'කුනිස්සෝ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0785','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(786,'කරඩි  ඉස්සෝ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0786','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(787,'කීරමින්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0787','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(788,'උම්බලකඩ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0788','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(789,'මෑ කරල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0789','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(790,'ලීක්ස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0790','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(791,'තක්කාලි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0791','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(792,'බීට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0792','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(793,'මුකුනුවැන්න මිටි 1',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0793','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(794,'කැරට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0794','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(795,'හාල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0795','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(796,'වම් බටු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0796','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(797,'මාළු මිරිස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0797','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(798,'බංඩක්කා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0798','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(799,'සලාද',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0799','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(800,'ගෝවා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0800','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(801,'අමුමිරිස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(802,'කැකිරි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(803,'වැටකොළු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0803','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(804,'එලබටු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0804','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(805,'නිවිති',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0805','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(806,'පතෝල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0806','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(807,'වට්ටක්කා රාජා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0807','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(808,'රාබු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0808','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(809,'බතල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0809','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(810,'තියබරා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0810','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(811,'නෝකෝල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0811','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(812,'ගෝවා මල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0812','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(813,'බිම්මල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0813','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(814,'වටවල 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791052500179','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(815,'වටවල 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791052500162','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(816,'ටියාරා චොක්ලට් ස්විස් රෝල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192060202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(817,'ටියාරා චොක්ලට් ලේයර් කේක්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192011211','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(818,'මියාමි ෂෝටීස් බිස්කට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0818','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(819,'නෙස්ලේ මයිලෝ බීම  180ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024011754','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(820,'ශාන්ත සැන්ඩ්විච් පාන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0820','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(821,'නෙස්කැෆේ අයිස් කොෆි 180ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792024014601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(822,'ශාන්ත සැන්විච් පාං 360g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0822','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(823,'‍කේ  සුපර් චොක්  95g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025151438','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(824,'කේ සුපර් ක්‍රීම් මිල්ක් චොකෝ  85g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025150165','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(825,'කේ සුපර් මිල්ක් චොකෝ  20g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025150479','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(826,'කේ සුපර් ස්වීට් ට්‍රීට් 24g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025150653','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(827,'කේ සුපර් ක්‍රිස්පි චොකෝ  40g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025151155','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(828,'කේ සුපර් ක්‍රන්ච් 25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025152299','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(829,'සන් ක්‍රෂ් 250ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796027480074','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(830,'රිස්බරි බබල්ස්  50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192434003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(831,'රිස්බරි බබල්ස්  100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192423007','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:24','2025-02-13 02:34:24'),(832,'කේ සුපර් මිල්ක්  65g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025150158','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(833,'කැන්ඩෝස් කැෂුනට්  100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025114112','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(834,'කේ සුපර් ක්‍රීම් චොකෝ 40g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025151148','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(835,'කේ සුපර් නට්  105g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025151315','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(836,'කේ සුපර් මිල්ක් චොකො 12g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791025150035','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(837,'මැලිබන් ගෝල්ඩ් මාරි  240g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034072465','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(838,'මැලිබන් ඉගුරැ බිස්කට්  240g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034070263','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(839,'මැලිබන් චික් බිට්ස්  30g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034004213','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(840,'මැලිබන් වේපස්  90g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034071666','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(841,'මැලිබන් චොක්ලට් මාරි 75g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034070294','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(842,'මැලිබන් ඉගුරු 80g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791034070232','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(843,'මැලිබන් වේෆර්ස් චොක්ලට් 90g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4191034077642','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(844,'මන්චි ලෙමන් පෆ් 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101090401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(845,'මන්චි  චොක්ලටි පෆ් 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101271206','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(846,'මන්ච් ක්‍රීම් ක්‍රැකර්  490g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101430108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(847,'මන්වි ක්‍රීම් ක්‍රැකර් 230g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101430399','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(848,'මන්චි සුපර් ක්‍රීම් ක්‍රැකර් 190g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101430337','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(849,'මන්චි සුුුපර් ක්‍රීම් ක්‍රැකර්  125g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101430153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(850,'මන්චි හැන්ඩි පැක්  25g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101430276','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(851,'මන්චි ටිෆින්  125g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0851','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(852,'මන්චි ස්ටික්  20g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192838009','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(853,'මන්චි මිල්ක්ෂෝට් කේක් 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101030407','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(854,'මන්චි මිල්ක්ෂෝට් කේක 85g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8888101030278','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(855,'මන්චි චොක්ලට් ක්‍රීම් 365g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792192851701','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(856,'බ්‍රයිටෝල් එයාර් ෆ්‍රෙෂ්නර්  150ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178002691','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(857,'බ්‍රයිටෝල් හයි පවර්  475ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178000253','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(858,'බ්‍රයිටෝල් ඩිෂ්වොෂ් ලික්විඩ් 450ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178003384','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(859,'බ්‍රයිටෝල්  කැල්සියම් රිමුව 500ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178003506','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(860,'අරෝමා  1kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178002356','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(861,'අරෝමා 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792178002370','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(862,'සන්ලයිට් කුඩු 1Kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005673153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(863,'යකඩ අඩිරූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0863','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(864,'රවීනා හදුන්කුරූ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000971155','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(865,'ඇට්ලස් පැස්ටල් පාට 12',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210103485','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(866,'ඇට්ලස් පාට පැන්සල් පාට 12',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210102808','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(867,'ඇට්ලස් පාට පැන්සල් පාට 24',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210106660','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(868,'රැබිට් පදමිකල මැටි   500g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4794444017804','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(869,'ඇට්ලස්  6  පාට පැන්සල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210102815','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(870,'පෙන්ටියම්  පාට 6 පැස්ටල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796001620618','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(871,'බොබී කුම්කුම්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0871','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(872,'පී සී මැග්නට් සෙට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6958463125645','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(873,'OFFFICE PINS',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6947860502319','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(874,'පංචින් මැෂීන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8901238105005','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(875,'ස්ටෙිපර් මැෂින් පොඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6921734902221','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(876,'ඇට්ලස් ස්ටෙිපර් මැෂින්  පොඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210103041','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(877,'ස්ටෙිපර් මැෂින් ලොකු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'6921734902245','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(878,'සයන්ස් සෙට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8531252340016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(879,'කවකටු  සෙට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8906055561683','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(880,'ඇට්ලස් ප්ලැටිග්නම් පාට 6',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210103263','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(881,'රත්න මැත් සෙට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796009866995','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(882,'නටරාජ කවකටු පෙට්ටි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0882','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(883,'ඇට්ලස් ප්ලැටිග්නම් පාට 12',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210104031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(884,'කැරම් සෙට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0884','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(885,'ෆැබ්රික් පේන්ට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796001620496','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(886,'නිය කටර් ලොකු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0886','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(887,'නිය කටර් පොඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0887','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(888,'කවකට්ට',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0888','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(889,'නිල්මා 75ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4793000714003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(890,'ෂූ පොලිෂ්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0890','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(891,'කාඩ් පැක්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'5999880017909','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(892,'අත්කාච ලොකු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0892','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(893,'අත්කාච පොඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0893','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(894,'වයිට්නර් ෂූ පොලිෂ්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4795001611114','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(895,'ලික්විඩ් ෂූ පොලිෂ්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796026930730','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(896,'ඉසි ලුනු කුඩු 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149060323','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(897,'රයිගම් ලුනු කැට 1kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149060675','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(898,'චිකන් සොයා 90g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0898','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(899,'චිකන් සෝයා ඩෙවල් 110g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149011424','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(900,'චයිනීස් ඩෙවල් චිකන් සෝයා 110g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149011431','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(901,'රයිගම් චිකන් සෝයා 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149014111','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(902,'ඇට්ලස් CR පිටු 200 දික්රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210101146','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(903,'ඇට්ලස් CR පිටු 200 කොටුරූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210101153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(904,'ඇට්ලස් CR පිටු 120 කොටුරූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210101870','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(905,'ඇට්ලස් CR පිටු 120 දික්රූල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792210100255','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(906,'දීවා 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111180045','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(907,'සන්ලයිට් පවුඩර් 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005669828','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(908,'රින් 1kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005686108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(909,'රින් 500g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005674556','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(910,'රින් 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005680311','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(911,'සන්ලයිට් පවුඩර් 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005669835','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(912,'රින් 40g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005678479','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(913,'දීවා 20g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111112329','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(914,'සිලෝන් ලුනු කැට 1kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4797001101800','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(915,'සිලෝන් ලුනු කුඩු 400g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4797001101855','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(916,'පහන්තිර පොඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0916','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(917,'ස්ප්‍රයිට් බීම 1050ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229206702','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(918,'ස්ප්‍රයිට් බීම 400ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229048739','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(919,'ෆැන්ටා ක්‍රීම් සෝඩා බීම 1500ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229036897','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(920,'ෆැන්ටා ඔරේන්ජ් බීම 1050ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229306709','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(921,'කොකාකෝලා බීම 1050ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229106705','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(922,'පෝටෙලෝ ග්‍රේප් බීම 1050ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229346705','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(923,'EGB බීම 1000ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791066101065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(924,'EGB බීම 500ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791066001648','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(925,'කොකාකෝලා බීම 250ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229105807','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(926,'කොකාකෝලා බීම 400ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229042430','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(927,'පෝටෙලෝ ග්‍රේප් බීම 250ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229345807','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(928,'නෙක්ටා මැන්ගෝ පලතුරු බීම 200ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'5012345678900','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(929,'ලයන් ජින්ගර් බියර් බීම 250ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229645808','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(930,'කොත්මලේ යෝගට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0930','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(931,'ෆැන්ටා ඔරේනජ් බීම 250ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229305801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(932,'ෆැන්ටා ඔරේන්ජ් බීම 400ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229064432','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(933,'ෆැන්ටා ක්‍රීම් සෝඩා 250ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229325809','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(934,'ෆැන්ටා ක්‍රීම් සෝඩා බීම 400ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229039430','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(935,'පෝටෙලෝ බීම ග්‍රේප් 400ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792229067334','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(936,'කොත්මලේ යෝගට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792090115004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(937,'හයිලන්ඩ් යෝගට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792094004014','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(938,'අයිලන්ඩ් ජෙලි යෝගට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4790014350678','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(939,'කල්කිරි බීම 250ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0939','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(940,'නෙක්ටා දිවුල් බීම 500ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0940','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(941,'කොත්මලේ වැනිලා බීම 180ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792085018280','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(942,'කොත්මලේ වැනිලා බීම 170ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792090120008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(943,'කොත්මලේ මුදවපු කිරි 900g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792085018129','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(944,'හයිලන්ඩ් චොක්ලට් කිරි 180ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792094001518','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(945,'ඇස්ට්‍රා 40g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796025380017','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(946,'හයිලන්ඩ් බටර් 10g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0946','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(947,'කොත්මලේ වීස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792090000577','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(948,'ඇස්ට්‍රා 100g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796025380024','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(949,'ඇස්ට්‍රා 250g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796025380031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(950,'වියලි මිදි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0950','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(951,'රට ඉදි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0951','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(952,'ඊස්ට්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0952','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(953,'සන්ලයිට් පව්ඩර් 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005677113','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(954,'2T පැකට් 40ml',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'500676ඞඨෑ','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(955,'බික් රේසර් 1',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'3086125705614','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(956,'බික් රේසර් ටිවින්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'3086126717098','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(957,'ගිලට් රේසර් බ්ලූ 2',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'8901358702436','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(958,'සෙන්සිටිව් රේසර් තල 3',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'3086126691565','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(959,'සිග්නල් ටූත් බ්‍රෂ්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792081021116','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(960,'ඩෙන්ටා ටූත් බ්‍රෂ් මීඩියම්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791010000260','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(961,'බික් රේසර්  2',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'3086127501122','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(962,'සුදන්ත ටූත් බ්‍රෂ් මීඩියම්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792022090539','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(963,'ක්ලෝගාඩ් ටූත් බ්‍රෂ් මීඩියම්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4791111102603','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(964,'සිග්නල් ටූත් බ්‍රෂ් ස්මෝල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796005684401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(965,'රයිගම් සෝයා මීට්g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149010113','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(966,'ලක්මී සෝයා 90g බ්ලැක් චිකන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796012130632','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(967,'රයිගම් සෝයා මීට් මුතු වරුසා 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149018027','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(968,'ලක්මී බඩී සෝයා 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796012130410','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:25','2025-02-13 02:34:25'),(969,'ලක්මී දඩයම් බට්ටා 70g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796012130021','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(970,'ජයවර්ධන සෝයා මීට් 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796025610107','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(971,'ෆ්‍රීලන් සෝයා මීට් 40g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796000306575','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(972,'රයිගම් සෝයා මීට් ෆිෂ් 105g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149012216','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(973,'ලංකා සෝයි  මාළු 90g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796002070313','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(974,'රයිගම් සෝයා මීට් බ්ලූ පැක් 50g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149014050','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(975,'රයිගම් සෝයා මීට් 90g ඉස්සෝ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792149010519','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(976,'කිතුල් පිටි 200g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4793001839002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(977,'හැපි කව් චීස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'9066085415284','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(978,'අචිනි කැකුලු සහල් 1kg',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0978','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(979,'නූඩ්ලස් ලූස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0979','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(980,'ලියාරා හදුන්කූරූ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0980','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(981,'මිහිදු හදුන්කූරූ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0981','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(982,'ඩයමන්ඩ් මැකරල් සැමන් 425g',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792225701058','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(983,'බොංචි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0983','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(984,'බන්ඩක්කා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0984','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(985,'බී ලූනූ ඉන්දියා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0985','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(986,'සුදුලූනූ',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0986','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(987,'බී ලූනූ පකිස්ථාන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0987','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(988,'රතුලූනූ ලංකා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0988','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(989,'බොම්බිලි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0989','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(990,'පියාමැස්සා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0990','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(991,'බිත්තර',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0991','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(992,'කලුබණ්ඩා නාඩු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0992','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(993,'ප්ලාස්ටික් කොසු ඩොල්ෆීන්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0993','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(994,'ප්ලාටික් කොසු පොඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0994','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(995,'කොහු කොස්ස',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0995','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(996,'මකුලුදැල් බ්‍රෂ්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0996','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(997,'ටොයිලට් බ්‍රෂ්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0997','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(998,'ප්ලාස්ටික් රේක්ක',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0998','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(999,'මොබ්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'0999','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1000,'වයිපර්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1000','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1001,'ඉදල්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1002,'හුලං විස්කෝතු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1003,'ඥානකතා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1004,'කාජා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1005,'එම් ඩී කේ ඉදිදිආප්ප',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792101000312','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1006,'අබා හෙනා ෂැම්පු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4796022660594','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1007,'9v බැට්රි zn- Mn Dry',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1007','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1008,'දුංකල කෑලි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1009,'දුංකල සරවානා',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1009','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1010,'දුංකල සිංහල',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1010','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1011,'පොඩි   බුලත්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1012,'හුනු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1013,'රට පුවක්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1013','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1014,'පොඩි පුවක්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1014','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1015,'උඩරට පස්පංගුව',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1015','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1016,'උඩරට පූජා සරක්කු ලොකු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1017,'උඩරට පූජා සරක්කු පොඩි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1017','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1018,'උඩරට එනසාල් 30',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1019,'උඩරට එනසාල් 60',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1019','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1020,'උඩරට එනසාල් 100',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1020','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1021,'උඩරට කරාබු නැටි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1021','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1022,'රන්තරු ගම්මිරිස්',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1022','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1023,'නීරෝගා පස්පංගුව',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1023','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1024,'ලින්ක් පස්පංගුව',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'4792022092007','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1025,'ෆොටෝකොපි',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1026,'Unknown',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1026','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1027,'චිප්ස් මුරුක්කු',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1027','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1028,'ටොෆී රු5',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34:26'),(1029,'ටොෆී රු 10',5,'single',8,NULL,NULL,NULL,NULL,NULL,NULL,'exclusive',1,1.0000,'1029','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,8,NULL,0,NULL,NULL,0,NULL,0,'2025-02-13 02:34:26','2025-02-13 02:34: