<div class="modal-dialog" role="document">
  <div class="modal-content">

    <?php echo Form::open(['url' => action([\App\Http\Controllers\DiscountController::class, 'update'], [$discount->id]), 'method' => 'put', 'id' => 'discount_form' ]); ?>


    <div class="modal-header">
      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
      <h4 class="modal-title"><?php echo app('translator')->get( 'sale.edit_discount' ); ?></h4>
    </div>

    <div class="modal-body">
      <div class="row">
        <div class="col-md-12">
          <div class="form-group">
            <?php echo Form::label('name', __( 'unit.name' ) . ':*'); ?>

              <?php echo Form::text('name', $discount->name, ['class' => 'form-control', 'required', 'placeholder' => __( 'unit.name' ) ]); ?>

          </div>
        </div>
        <div class="col-md-12">
          <div class="form-group">
            <?php echo Form::label('variation_ids', __('report.products') . ':'); ?>

              <?php echo Form::select('variation_ids[]', $variations, array_keys($variations), ['id' => "variation_ids", 'class' => 'form-control', 'multiple']); ?>

          </div>
        </div>
        <div class="col-md-6 <?php if(!empty($variations)): ?> hide <?php endif; ?>" id="brand_input">
          <div class="form-group">
            <?php echo Form::label('brand_id', __('product.brand') . ':'); ?>

              <?php echo Form::select('brand_id', $brands, $discount->brand_id, ['placeholder' => __('messages.please_select'), 'class' => 'form-control select2', 'style' => 'width: 100%;']); ?>

          </div>
        </div>
        <div class="col-sm-6 <?php if(!empty($variations)): ?> hide <?php endif; ?>" id="category_input">
          <div class="form-group">
            <?php echo Form::label('category_id', __('product.category') . ':'); ?>

              <?php echo Form::select('category_id', $categories, $discount->category_id, ['placeholder' => __('messages.please_select'), 'class' => 'form-control select2', 'style' => 'width: 100%;']); ?>

          </div>
        </div>
        <div class="col-sm-6">
          <div class="form-group">
            <?php echo Form::label('location_id', __('sale.location') . ':*'); ?>

              <?php echo Form::select('location_id', $locations, $discount->location_id, ['placeholder' => __('messages.please_select'), 'class' => 'form-control select2', 'required']); ?>

          </div>
        </div>
        <div class="col-md-6">
          <div class="form-group">
            <?php echo Form::label('priority', __( 'lang_v1.priority' ) . ':'); ?>

              <?php echo Form::text('priority', $discount->priority, ['class' => 'form-control input_number', 'required', 'placeholder' => __( 'lang_v1.priority' ) ]); ?>

          </div>
        </div>
         <div class="col-sm-6">
          <div class="form-group">
            <?php echo Form::label('discount_type', __('sale.discount_type') . ':*'); ?>

              <?php echo Form::select('discount_type', ['fixed' => __('lang_v1.fixed'), 'percentage' => __('lang_v1.percentage')], $discount->discount_type, ['placeholder' => __('messages.please_select'), 'class' => 'form-control select2', 'required']); ?>

          </div>
        </div>
        <div class="col-md-6">
          <div class="form-group">
            <?php echo Form::label('discount_amount', __( 'sale.discount_amount' ) . ':*'); ?>

              <?php echo Form::text('discount_amount', $discount->discount_amount, ['class' => 'form-control input_number', 'required', 'placeholder' => __( 'sale.discount_amount' ) ]); ?>

          </div>
        </div>
        <div class="col-md-6">
          <div class="form-group">
            <?php echo Form::label('starts_at', __( 'lang_v1.starts_at' ) . ':'); ?>

              <?php echo Form::text('starts_at', $starts_at, ['class' => 'form-control discount_date', 'required', 'placeholder' => __( 'lang_v1.starts_at' ), 'readonly' ]); ?>

          </div>
        </div>
        <div class="col-md-6">
          <div class="form-group">
            <?php echo Form::label('ends_at', __( 'lang_v1.ends_at' ) . ':'); ?>

              <?php echo Form::text('ends_at', $ends_at, ['class' => 'form-control discount_date', 'required', 'placeholder' => __( 'lang_v1.ends_at' ), 'readonly' ]); ?>

          </div>
        </div>

        <div class="clearfix"></div>
        <div class="col-sm-6">
          <div class="form-group">
            <?php echo Form::label('spg', __('lang_v1.selling_price_group') . ':'); ?>

            <select name="spg" class="form-control">
              <option value="" <?php if(is_null($discount->spg)): ?> selected <?php endif; ?>><?php echo app('translator')->get('lang_v1.all'); ?></option>
              <?php $__currentLoopData = $price_groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($k, false); ?>" <?php if($discount->spg === (string)$k): ?> selected <?php endif; ?>><?php echo e($v, false); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>
        </div>
        <div class="clearfix"></div>
        <div class="col-sm-6">
          <div class="form-group">
            <br>
            <label>
              <?php echo Form::checkbox('applicable_in_cg', 1, !empty($discount->applicable_in_cg), ['class' => 'input-icheck']); ?> <strong><?php echo app('translator')->get('lang_v1.applicable_in_cg'); ?></strong>
            </label>
          </div>
        </div>

        <div class="col-sm-6">
          <div class="form-group">
            <br>
            <label>
              <?php echo Form::checkbox('is_active', 1, !empty($discount->is_active), ['class' => 'input-icheck']); ?> <strong><?php echo app('translator')->get('lang_v1.is_active'); ?></strong>
            </label>
          </div>
        </div>

      </div>
    </div>

    <div class="modal-footer">
      <button type="submit" class="btn btn-primary"><?php echo app('translator')->get( 'messages.update' ); ?></button>
      <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo app('translator')->get( 'messages.close' ); ?></button>
    </div>

    <?php echo Form::close(); ?>


  </div><!-- /.modal-content -->
</div><!-- /.modal-dialog --><?php /**PATH /home/smartpo1/public_html/sr/resources/views/discount/edit.blade.php ENDPATH**/ ?>