

<?php $__env->startSection('title', __('crm::lang.crm')); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('crm::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <section class="content no-print">
        <div class="row">
            <div class="col-md-4">
                <?php if(auth()->user()->can('crm.access_all_schedule') || auth()->user()->can('crm.access_own_schedule')): ?>
                    <div class="col-md-12">
                        <?php $__env->startComponent('components.static', [
                            'svg_bg' => 'tw-bg-cyan-400',
                            'svg_text' => 'tw-text-white',
                            'svg' => '<svg  class="tw-w-6 tw-h-6"  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-calendar-check"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M11.5 21h-5.5a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6" /><path d="M16 3v4" /><path d="M8 3v4" /><path d="M4 11h16" /><path d="M15 19l2 2l4 -4" /></svg>',
                        ]); ?>
                            <p class="tw-text-sm tw-font-medium tw-text-gray-500 tw-truncate tw-whitespace-nowrap">
                                <?php echo e(__('crm::lang.todays_followups'), false); ?>

                            </p>
                            <p
                                class="tw-mt-0.5 tw-text-gray-900 tw-text-xl tw-truncate tw-font-semibold tw-tracking-tight tw-font-mono">
                                <?php echo e($todays_followups, false); ?>

                            </p>
                        <?php echo $__env->renderComponent(); ?>
                    </div>
                <?php endif; ?>
                <?php if(auth()->user()->can('crm.access_all_leads') || auth()->user()->can('crm.access_own_leads')): ?>
                    <div class="col-md-12">
                        <?php $__env->startComponent('components.static', [
                            'svg_bg' => 'tw-bg-cyan-400',
                            'svg_text' => 'tw-text-white',
                            'svg' => '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-user-check"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M8 7a4 4 0 1 0 8 0a4 4 0 0 0 -8 0" /><path d="M6 21v-2a4 4 0 0 1 4 -4h4" /><path d="M15 19l2 2l4 -4" /></svg>',
                        ]); ?>
                            <p class="tw-text-sm tw-font-medium tw-text-gray-500 tw-truncate tw-whitespace-nowrap">
                                <?php echo e(__('crm::lang.my_leads'), false); ?>

                            </p>
                            <p
                                class="tw-mt-0.5 tw-text-gray-900 tw-text-xl tw-truncate tw-font-semibold tw-tracking-tight tw-font-mono">
                                <?php echo e($my_leads, false); ?>

                            </p>
                        <?php echo $__env->renderComponent(); ?>
                    </div>
                <?php endif; ?>
                <div class="col-md-12">
                    <?php $__env->startComponent('components.static', [
                        'svg_bg' => 'tw-bg-cyan-400',
                            'svg_text' => 'tw-text-white',
                        'svg' => '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-arrows-exchange-2"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M17 10h-14l4 -4" /><path d="M7 14h14l-4 4" /></svg>',
                    ]); ?>
                        <p class="tw-text-sm tw-font-medium tw-text-gray-500 tw-truncate tw-whitespace-nowrap">
                            <?php echo e(__('crm::lang.my_leads_to_customer_conversion'), false); ?>

                        </p>
                        <p
                            class="tw-mt-0.5 tw-text-gray-900 tw-text-xl tw-truncate tw-font-semibold tw-tracking-tight tw-font-mono">
                            <?php echo e($my_conversion, false); ?>

                        </p>
                    <?php echo $__env->renderComponent(); ?>
                </div>
            </div>
            <?php if(auth()->user()->can('crm.access_all_schedule') || auth()->user()->can('crm.access_own_schedule')): ?>
                <div class="col-md-4">
                    <?php $__env->startComponent('components.widget', ['class' => 'box-solid', 'title' => __('crm::lang.my_followups')]); ?>
                        <table class="table no-margin">
                            <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <th><?php echo e($value, false); ?></th>
                                    <td>
                                        <?php if(isset($my_follow_ups_arr[$key])): ?>
                                            <?php echo e($my_follow_ups_arr[$key], false); ?>

                                        <?php else: ?>
                                            0
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if(isset($my_follow_ups_arr['__other'])): ?>
                                <tr>
                                    <th><?php echo app('translator')->get('lang_v1.others'); ?></th>
                                    <td>
                                        <?php echo e($my_follow_ups_arr['__other'], false); ?>

                                    </td>
                                </tr>
                            <?php endif; ?>
                        </table>
                    <?php echo $__env->renderComponent(); ?>
                </div>
            <?php endif; ?>
            <?php if(config('constants.enable_crm_call_log')): ?>
                <div class="col-md-4">
                    <?php $__env->startComponent('components.widget', ['class' => 'box-solid', 'title' => __('crm::lang.my_call_logs')]); ?>
                        <table class="table no-margin">
                            <tr>
                                <th><?php echo app('translator')->get('crm::lang.calls_today'); ?></th>
                                <td><?php echo e($my_call_logs->calls_today ?? 0, false); ?></td>
                            </tr>
                            <tr>
                                <th><?php echo app('translator')->get('crm::lang.calls_yesterday'); ?></th>
                                <td><?php echo e($my_call_logs->calls_yesterday ?? 0, false); ?></td>
                            </tr>
                            <tr>
                                <th><?php echo app('translator')->get('crm::lang.calls_this_month'); ?></th>
                                <td><?php echo e($my_call_logs->calls_this_month ?? 0, false); ?></td>
                            </tr>
                        </table>
                    <?php echo $__env->renderComponent(); ?>
                </div>
            <?php endif; ?>
        </div>

        <?php if($is_admin): ?>
            <hr>
            <div class="row">
                <div class="col-md-3 col-sm-6 col-xs-12">
                    <?php $__env->startComponent('components.static', [
                        'svg_bg' => 'tw-bg-cyan-400',
                        'svg_text' => 'tw-text-white',
                        'svg' => '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-users"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M9 7m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0" /><path d="M3 21v-2a4 4 0 0 1 4 -4h4a4 4 0 0 1 4 4v2" /><path d="M16 3.13a4 4 0 0 1 0 7.75" /><path d="M21 21v-2a4 4 0 0 0 -3 -3.85" /></svg>',
                    ]); ?>
                        <p class="tw-text-sm tw-font-medium tw-text-gray-500 tw-truncate tw-whitespace-nowrap">
                            <?php echo e(__('lang_v1.customers'), false); ?>

                        </p>
                        <p
                            class="tw-mt-0.5 tw-text-gray-900 tw-text-xl tw-truncate tw-font-semibold tw-tracking-tight tw-font-mono">
                            <?php echo e($total_customers, false); ?>

                        </p>
                    <?php echo $__env->renderComponent(); ?>
                    <!-- /.info-box -->
                </div>
                <!-- /.col -->
                <div class="col-md-3 col-sm-6 col-xs-12 ">
                    <?php $__env->startComponent('components.static',
                       [
                        'svg_bg' => 'tw-bg-cyan-400',
                        'svg_text' => 'tw-text-white',
                        'svg' => '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-user-check"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M8 7a4 4 0 1 0 8 0a4 4 0 0 0 -8 0" /><path d="M6 21v-2a4 4 0 0 1 4 -4h4" /><path d="M15 19l2 2l4 -4" /></svg>']
,
                    ); ?>
                        <p class="tw-text-sm tw-font-medium tw-text-gray-500 tw-truncate tw-whitespace-nowrap">
                            <?php echo e(__('crm::lang.leads'), false); ?>

                        </p>
                        <p
                            class="tw-mt-0.5 tw-text-gray-900 tw-text-xl tw-truncate tw-font-semibold tw-tracking-tight tw-font-mono">
                            <?php echo e($total_leads, false); ?>

                        </p>
                    <?php echo $__env->renderComponent(); ?>
                </div>
                <!-- /.col -->
                <div class="col-md-3 col-sm-6 col-xs-12 col-custom">
                    <?php $__env->startComponent('components.static', [
                        'svg_bg' => 'tw-bg-yellow-400',
                        'svg_text' => 'tw-text-white',
                        'svg' => '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-search"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M10 10m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0" /><path d="M21 21l-6 -6" /></svg>',
                    ]); ?>
                        <p class="tw-text-sm tw-font-medium tw-text-gray-500 tw-truncate tw-whitespace-nowrap">
                            <?php echo e(__('crm::lang.sources'), false); ?>

                        </p>
                        <p
                            class="tw-mt-0.5 tw-text-gray-900 tw-text-xl tw-truncate tw-font-semibold tw-tracking-tight tw-font-mono">
                            <?php echo e($total_sources, false); ?>

                        </p>
                    <?php echo $__env->renderComponent(); ?>
                    <!-- /.info-box -->
                </div>
                <!-- /.col -->

                <!-- fix for small devices only -->
                <!-- <div class="clearfix visible-sm-block"></div> -->
                <div class="col-md-3 col-sm-6 col-xs-12 col-custom">
                    <!-- /.info-box -->
                    <?php $__env->startComponent('components.static', [
                        'svg_bg' => 'tw-bg-yellow-400',
                            'svg_text' => 'tw-text-white',
                        'svg' => '<svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-live-photo"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0" /><path d="M12 12m-5 0a5 5 0 1 0 10 0a5 5 0 1 0 -10 0" /><path d="M15.9 20.11l0 .01" /><path d="M19.04 17.61l0 .01" /><path d="M20.77 14l0 .01" /><path d="M20.77 10l0 .01" /><path d="M19.04 6.39l0 .01" /><path d="M15.9 3.89l0 .01" /><path d="M12 3l0 .01" /><path d="M8.1 3.89l0 .01" /><path d="M4.96 6.39l0 .01" /><path d="M3.23 10l0 .01" /><path d="M3.23 14l0 .01" /><path d="M4.96 17.61l0 .01" /><path d="M8.1 20.11l0 .01" /><path d="M12 21l0 .01" /></svg>',
                    ]); ?>
                        <p class="tw-text-sm tw-font-medium tw-text-gray-500 tw-truncate tw-whitespace-nowrap">
                            <?php echo e(__('crm::lang.life_stages'), false); ?>

                        </p>
                        <p
                            class="tw-mt-0.5 tw-text-gray-900 tw-text-xl tw-truncate tw-font-semibold tw-tracking-tight tw-font-mono">
                            <?php echo e($total_life_stage, false); ?>

                        </p>
                    <?php echo $__env->renderComponent(); ?>
                </div>
                <!-- /.col -->
            </div>
            <div class="row">
                <div class="col-md-3">
                    <?php $__env->startComponent('components.widget', ['class' => 'box-solid']); ?>
                        <table class="table no-margin">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('crm::lang.sources'), false); ?></th>
                                    <th><?php echo e(__('sale.total'), false); ?></th>
                                    <th><?php echo e(__('crm::lang.conversion'), false); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $sources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($source->name, false); ?></td>
                                        <td>
                                            <?php if(!empty($leads_count_by_source[$source->id])): ?>
                                                <?php echo e($leads_count_by_source[$source->id]['count'], false); ?>

                                            <?php else: ?>
                                                0
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if(!empty($customers_count_by_source[$source->id]) && !empty($contacts_count_by_source[$source->id])): ?>
                                                <?php
                                                    $conversion =
                                                        ($customers_count_by_source[$source->id]['count'] /
                                                            $contacts_count_by_source[$source->id]['count']) *
                                                        100;
                                                ?>
                                                <?php echo e($conversion . '%', false); ?>

                                            <?php else: ?>
                                                <?php echo e('0 %', false); ?>

                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="2" class="text-center"><?php echo app('translator')->get('lang_v1.no_data'); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    <?php echo $__env->renderComponent(); ?>
                </div>
                <div class="col-md-3">
                    <?php $__env->startComponent('components.widget', ['class' => 'box-solid']); ?>
                        <table class="table no-margin">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('crm::lang.life_stages'), false); ?></th>
                                    <th><?php echo e(__('sale.total'), false); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $life_stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $life_stage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($life_stage->name, false); ?></td>
                                        <td>
                                            <?php if(!empty($leads_by_life_stage[$life_stage->id])): ?>
                                                <?php echo e(count($leads_by_life_stage[$life_stage->id]), false); ?>

                                            <?php else: ?>
                                                0
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="2" class="text-center"><?php echo app('translator')->get('lang_v1.no_data'); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    <?php echo $__env->renderComponent(); ?>
                </div>
                <div class="col-md-6">
                    <?php $__env->startComponent('components.widget', ['class' => 'box-solid']); ?>
                        <div class="box-header with-border">
                            <i class="fas fa fa-birthday-cake"></i>
                            <h3 class="box-title"><?php echo app('translator')->get('crm::lang.birthdays'); ?></h3>
                            <a data-href="<?php echo e(action([\Modules\Crm\Http\Controllers\CampaignController::class, 'create']), false); ?>"
                                class="tw-dw-btn tw-dw-btn-xs tw-dw-btn-outline  tw-dw-btn-accent" id="wish_birthday">
                                <i class="fas fa-paper-plane"></i>
                                <?php echo app('translator')->get('crm::lang.send_wishes'); ?>
                            </a>
                        </div>
                        <div class="box-body p-10">
                            <table class="table no-margin table-striped">
                                <caption><?php echo app('translator')->get('home.today'); ?></caption>
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo app('translator')->get('user.name'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $todays_birthdays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $birthday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>
                                                <input type="checkbox" class="contat_id" name="contat_id[]"
                                                    value="<?php echo e($birthday['id'], false); ?>" id="contat_id_<?php echo e($birthday['id'], false); ?>">
                                            </td>
                                            <td>
                                                <label for="contat_id_<?php echo e($birthday['id'], false); ?>" class="cursor-pointer fw-100">
                                                    <?php echo e($birthday['name'], false); ?>

                                                </label>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="2" class="text-center"><?php echo app('translator')->get('lang_v1.no_data'); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                            <?php if(!empty($upcoming_birthdays)): ?>
                                <hr class="m-2">
                            <?php endif; ?>
                            <table class="table no-margin table-striped">
                                <caption>
                                    <?php echo app('translator')->get('crm::lang.upcoming'); ?>
                                </caption>
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo app('translator')->get('user.name'); ?></th>
                                        <th><?php echo app('translator')->get('crm::lang.birthday_on'); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $upcoming_birthdays; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $birthday): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td>
                                                <input type="checkbox" class="contat_id" name="contat_id[]"
                                                    value="<?php echo e($birthday['id'], false); ?>" id="contat_id_<?php echo e($birthday['id'], false); ?>">
                                            </td>
                                            <td>
                                                <label for="contat_id_<?php echo e($birthday['id'], false); ?>" class="cursor-pointer fw-100">
                                                    <?php echo e($birthday['name'], false); ?>

                                                </label>
                                            </td>
                                            <td>
                                                <?php echo e(Carbon::createFromFormat('m-d', $birthday['dob'])->format('jS M'), false); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="3" class="text-center"><?php echo app('translator')->get('lang_v1.no_data'); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php echo $__env->renderComponent(); ?>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-md-12">
                    <?php $__env->startComponent('components.widget', ['class' => 'box-solid', 'title' => __('crm::lang.follow_ups_by_user')]); ?>
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <?php echo Form::label('follow_up_user_date_range', __('report.date_range') . ':'); ?>

                                    <?php echo Form::text('follow_up_user_date_range', null, [
                                        'placeholder' => __('lang_v1.select_a_date_range'),
                                        'class' => 'form-control',
                                        'readonly',
                                    ]); ?>

                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <?php echo Form::label('followup_category_id', __('crm::lang.followup_category') . ':*'); ?>

                                    <?php echo Form::select('followup_category_id', $followup_category, null, [
                                        'class' => 'form-control select2',
                                        'style' => 'width: 100%;',
                                        'placeholder' => __('messages.all'),
                                    ]); ?>

                                </div>
                            </div>
                            <br />
                        </div>

                        <table class="table table-bordered table-striped" id="follow_ups_by_user_table" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('role.user'); ?></th>
                                    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <th>
                                            <?php echo e($value, false); ?>

                                        </th>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <th>
                                        <?php echo app('translator')->get('lang_v1.none'); ?>
                                    </th>
                                    <th>
                                        <?php echo app('translator')->get('crm::lang.total_follow_ups'); ?>
                                    </th>
                                </tr>
                            </thead>
                        </table>
                    <?php echo $__env->renderComponent(); ?>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <?php $__env->startComponent('components.widget', ['class' => 'box-solid', 'title' => __('crm::lang.lead_to_customer_conversion')]); ?>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="lead_to_customer_conversion"
                                style="width: 100%;">
                                <thead>
                                    <tr>
                                        <th>&nbsp;</th>
                                        <th><?php echo app('translator')->get('crm::lang.converted_by'); ?></th>
                                        <th><?php echo app('translator')->get('sale.total'); ?></th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    <?php echo $__env->renderComponent(); ?>
                </div>

                <?php if(config('constants.enable_crm_call_log')): ?>
                    <div class="col-md-6">
                        <div class="box box-solid">
                            <div class="box-header with-border">
                                <h3 class="box-title"><?php echo app('translator')->get('crm::lang.all_users_call_log'); ?></h3>
                            </div>
                            <div class="box-body p-10">
                                <div class="table-responsive">
                                    <table class="table" id="all_users_call_log" style="width: 100%;">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <?php echo app('translator')->get('role.user'); ?>
                                                </th>
                                                <th>
                                                    <?php echo app('translator')->get('crm::lang.calls_today'); ?>
                                                </th>
                                                <th>
                                                    <?php echo app('translator')->get('crm::lang.calls_this_month'); ?>
                                                </th>
                                                <th>
                                                    <?php echo app('translator')->get('lang_v1.all'); ?>
                                                </th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <style type="text/css">
        .fw-100 {
            font-weight: 100;
        }
    </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script src="<?php echo e(asset('modules/crm/js/crm.js?v=' . $asset_v), false); ?>"></script>
    <?php echo $__env->make('crm::reports.report_javascripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <script type="text/javascript">
        $(document).ready(function() {

            $(document).on('click', '#wish_birthday', function() {
                var url = $(this).data('href');
                var contact_ids = [];
                $("input.contat_id").each(function() {
                    if ($(this).is(":checked")) {
                        contact_ids.push($(this).val());
                    }
                });

                if (_.isEmpty(contact_ids)) {
                    alert("<?php echo e(__('crm::lang.plz_select_user'), false); ?>");
                } else {
                    location.href = url + '?contact_ids=' + contact_ids;
                }
            });

            <?php if(config('constants.enable_crm_call_log')): ?>
                all_users_call_log = $("#all_users_call_log").DataTable({
                    processing: true,
                    serverSide: true,
                    scrollY: "75vh",
                    scrollX: true,
                    scrollCollapse: true,
                    fixedHeader: false,
                    'ajax': {
                        url: "<?php echo e(action([\Modules\Crm\Http\Controllers\CallLogController::class, 'allUsersCallLog']), false); ?>"
                    },
                    columns: [{
                            data: 'username',
                            name: 'u.username'
                        },
                        {
                            data: 'calls_today',
                            searchable: false
                        },
                        {
                            data: 'calls_yesterday',
                            searchable: false
                        },
                        {
                            data: 'all_calls',
                            searchable: false
                        }
                    ],
                });
            <?php endif; ?>
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/smartpo1/public_html/sr/Modules/Crm/Providers/../Resources/views/crm_dashboard/index.blade.php ENDPATH**/ ?>